/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.meggy;

import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.xmind.core.style.IStyle;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.handlers.MindMapHandlerUtil;
import org.xmind.ui.internal.meggy.Messages;
import org.xmind.ui.internal.meggy.ThemeExtractor;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.MindMapUI;

public class ExtractThemeHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final IEditorPart editor = MindMapHandlerUtil.findContributingEditor((ExecutionEvent)event);
        if (editor == null) {
            return null;
        }
        VerifyUI20141031.runAction20141031((String)"ExtractTheme", (String)Messages.ExtractThemeAction_name, (int)7, (Runnable)new Runnable(){

            public void run() {
                VerifyUI20141031.getUsageDataCollector().increase("ExtractThemeCount");
                final IMindMap mindmap = (IMindMap)MindMapUIPlugin.getAdapter((Object)editor, IMindMap.class);
                if (mindmap == null) {
                    return;
                }
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        IStyle theme = ThemeExtractor.extractThemeFrom(mindmap);
                        if (theme == null) {
                            return;
                        }
                        ExtractThemeHandler.editTheme(theme, editor.getSite().getPage());
                        MindMapUI.getResourceManager().getUserThemeSheet().removeStyle(theme);
                    }
                });
            }
        }, null);
        return null;
    }

    private static void editTheme(IStyle theme, IWorkbenchPage page) throws NotDefinedException, ExecutionException, NotEnabledException, NotHandledException {
        IHandlerService handlers = (IHandlerService)page.getWorkbenchWindow().getService(IHandlerService.class);
        ICommandService commands = (ICommandService)page.getWorkbenchWindow().getService(ICommandService.class);
        if (handlers == null || commands == null) {
            return;
        }
        Command command = commands.getCommand("org.xmind.ui.command.theme.edit");
        if (command == null || !command.isDefined()) {
            return;
        }
        IParameter param = command.getParameter("org.xmind.ui.resource.uri");
        if (param == null) {
            return;
        }
        ParameterizedCommand pc = new ParameterizedCommand(command, new Parameterization[]{new Parameterization(param, MindMapUI.getResourceManager().toResourceURI((Object)theme))});
        handlers.executeCommand(pc, null);
    }
}

