/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spelling;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.service.datalocation.Location;
import org.xmind.ui.internal.spelling.ISpellCheckerDescriptor;
import org.xmind.ui.internal.spelling.SpellCheckerAgent;
import org.xmind.ui.internal.spelling.SpellingPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellCheckerRegistry {
    private static SpellCheckerRegistry instance = null;
    private List<ISpellCheckerDescriptor> descriptors = null;

    public List<ISpellCheckerDescriptor> getDescriptors() {
        this.lazyLoad();
        return this.descriptors;
    }

    private void lazyLoad() {
        if (this.descriptors != null) {
            return;
        }
        this.doLazyLoad();
        if (this.descriptors == null) {
            this.descriptors = Collections.emptyList();
        }
    }

    private void doLazyLoad() {
        File[] dictFiles;
        File dir = SpellCheckerRegistry.getUserDictDir();
        if (!(dir.exists() && dir.isDirectory() && dir.canRead())) {
            return;
        }
        File[] fileArray = dictFiles = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return !name.startsWith(".");
            }
        });
        int n = dictFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File dictFile = fileArray[n2];
            if (dictFile.isFile() && dictFile.canRead()) {
                if (this.descriptors == null) {
                    this.descriptors = new ArrayList<ISpellCheckerDescriptor>();
                }
                this.descriptors.add(new FileSpellCheckerDescriptor(dictFile));
            }
            ++n2;
        }
    }

    private static File getUserDictDir() {
        return new File(SpellingPlugin.getBundleDataPath("user"));
    }

    public String getImportableDictFileName(File sourceDictFile, List<String> nameExclusions) {
        String suffix;
        String prefix;
        String name = sourceDictFile.getName();
        int sepIndex = name.lastIndexOf(46);
        if (sepIndex < 0) {
            prefix = name;
            suffix = "";
        } else {
            prefix = name.substring(0, sepIndex);
            suffix = name.substring(sepIndex);
        }
        File targetDictFile = this.createFile(SpellCheckerRegistry.getUserDictDir(), prefix, suffix, nameExclusions);
        FileSpellCheckerDescriptor descriptor = new FileSpellCheckerDescriptor(targetDictFile);
        return descriptor.getName();
    }

    public ISpellCheckerDescriptor importDictFile(File sourceDictFile, String name) throws IOException {
        String suffix;
        String prefix;
        int sepIndex;
        if (name == null) {
            name = sourceDictFile.getName();
        }
        if ((sepIndex = name.lastIndexOf(46)) < 0) {
            prefix = name;
            suffix = "";
        } else {
            prefix = name.substring(0, sepIndex);
            suffix = name.substring(sepIndex);
        }
        File targetDictFile = this.createFile(SpellCheckerRegistry.getUserDictDir(), prefix, suffix, null);
        if (targetDictFile.getParentFile() != null) {
            targetDictFile.getParentFile().mkdirs();
        }
        try {
            FileInputStream inp = new FileInputStream(sourceDictFile);
            try {
                FileOutputStream out = new FileOutputStream(targetDictFile);
                try {
                    int numRead;
                    byte[] buffer = new byte[4096];
                    while ((numRead = ((InputStream)inp).read(buffer)) > 0) {
                        ((OutputStream)out).write(buffer, 0, numRead);
                    }
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            finally {
                ((InputStream)inp).close();
            }
        }
        catch (IOException e) {
            SpellingPlugin.log(e, "Failed to copy dict file into workspace while importing it.");
        }
        if (this.descriptors == null || this.descriptors.isEmpty()) {
            this.descriptors = new ArrayList<ISpellCheckerDescriptor>();
        }
        FileSpellCheckerDescriptor descriptor = new FileSpellCheckerDescriptor(targetDictFile);
        descriptor.setEnabled(false);
        this.descriptors.add(descriptor);
        return descriptor;
    }

    private File createFile(File dir, String prefix, String suffix, List<String> nameExclusions) {
        int i = 1;
        File file = new File(dir, String.valueOf(prefix) + suffix);
        while (nameExclusions != null && nameExclusions.contains(file.getName())) {
            file = new File(dir, String.valueOf(prefix) + " (" + ++i + ")" + suffix);
        }
        return file;
    }

    public void removeDictionary(ISpellCheckerDescriptor descriptor) {
        FileSpellCheckerDescriptor fileDescriptor = (FileSpellCheckerDescriptor)descriptor;
        fileDescriptor.setEnabled(false);
        if (this.descriptors != null && !this.descriptors.isEmpty()) {
            this.descriptors.remove(descriptor);
        }
        File file = fileDescriptor.getFile();
        file.delete();
        SpellCheckerAgent.resetSpellChecker();
    }

    public static void migrateUserDictDir() {
        File newDir = SpellCheckerRegistry.getUserDictDir();
        if (newDir.exists() && newDir.isDirectory()) {
            return;
        }
        Location instanceLocation = Platform.getInstanceLocation();
        if (instanceLocation == null) {
            return;
        }
        URL instanceURL = instanceLocation.getURL();
        if (instanceURL == null) {
            return;
        }
        try {
            instanceURL = FileLocator.toFileURL((URL)instanceURL);
        }
        catch (IOException iOException) {}
        File instanceDir = new File(instanceURL.getFile());
        if (!instanceDir.exists()) {
            return;
        }
        File oldDir = new File(new File(instanceDir, ".xmind"), "spelling/user");
        if (oldDir.exists() && oldDir.isDirectory()) {
            SpellCheckerRegistry.moveUserDictDir(oldDir, newDir);
            return;
        }
        oldDir = new File(instanceDir, "spelling/user.dict");
        if (oldDir.exists() && oldDir.isDirectory()) {
            SpellCheckerRegistry.moveUserDictDir(oldDir, newDir);
            return;
        }
    }

    private static void moveUserDictDir(File oldDir, File newDir) {
        boolean moved;
        if (newDir.getParentFile() != null) {
            newDir.getParentFile().mkdirs();
        }
        if (!(moved = oldDir.renameTo(newDir))) {
            SpellingPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.xmind.ui.spelling", "Failed to migrate old user added dict directory: " + oldDir.getAbsolutePath()));
        }
    }

    public static SpellCheckerRegistry getInstance() {
        if (instance == null) {
            instance = new SpellCheckerRegistry();
        }
        return instance;
    }

    private static class FileSpellCheckerDescriptor
    implements ISpellCheckerDescriptor {
        private File file;

        public FileSpellCheckerDescriptor(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public String getName() {
            return this.file.getName();
        }

        public InputStream openStream() throws IOException {
            return new FileInputStream(this.file);
        }

        public void setEnabled(boolean enabled) {
            this.getPreferenceStore().setValue(this.getName(), enabled);
        }

        public boolean isEnabled() {
            return this.getPreferenceStore().getBoolean(this.getName());
        }

        private IPreferenceStore getPreferenceStore() {
            return SpellingPlugin.getDefault().getPreferenceStore();
        }
    }
}

