/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap.filtering;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.xmind.core.ILegend;
import org.xmind.core.ISheet;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.marker.IMarker;
import org.xmind.core.util.IMarkerRefCounter;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.ui.forms.WidgetFactory;
import org.xmind.ui.internal.mindmap.filtering.FilterSection;
import org.xmind.ui.internal.mindmap.filtering.FilterService;
import org.xmind.ui.internal.mindmap.filtering.Messages;
import org.xmind.ui.internal.mindmap.filtering.PropertyFilter;
import org.xmind.ui.internal.utils.E4Utils;
import org.xmind.ui.util.MarkerImageDescriptor;

public class MarkerFilterSection
extends FilterSection
implements ICoreEventListener {
    private static final int MARKER_HEIGHT = 16;
    private ICoreEventRegister register;
    private ImageRegistry imgReg;
    private int sectionStyle = -1;

    public MarkerFilterSection() {
        this.setTitle(Messages.MarkerFilterSection_title);
    }

    public MarkerFilterSection(int noItemPolicy) {
        super(noItemPolicy);
        this.setTitle(Messages.MarkerFilterSection_title);
    }

    protected PropertyFilter findFilter(IGraphicalViewer viewer) {
        FilterService filterService = (FilterService)viewer.getService(FilterService.class);
        if (filterService != null) {
            return filterService.getMarkerFilter();
        }
        return null;
    }

    protected Object[] getAllPropertyFilters(IGraphicalViewer viewer) {
        IMarkerRefCounter counter = null;
        ILegend legend = null;
        ISheet sheet = (ISheet)viewer.getAdapter(ISheet.class);
        if (sheet != null) {
            counter = (IMarkerRefCounter)sheet.getAdapter(IMarkerRefCounter.class);
            legend = sheet.getLegend();
        }
        if (this.register != null) {
            this.register.unregisterAll();
            this.register = null;
        }
        this.register = new CoreEventRegister((ICoreEventListener)this);
        if (counter != null) {
            this.register.setNextSourceFrom((Object)counter);
            this.register.register("resourceRefs");
        }
        if (legend != null) {
            this.register.setNextSourceFrom((Object)legend);
            this.register.register("markerDescription");
        }
        if (counter != null) {
            return counter.getCountedRefs().toArray();
        }
        return new Object[0];
    }

    protected void handleDispose() {
        if (this.imgReg != null) {
            this.imgReg.dispose();
            this.imgReg = null;
        }
        if (this.register != null) {
            this.register.unregisterAll();
            this.register = null;
        }
        super.handleDispose();
    }

    protected String getMessage() {
        return Messages.MarkerFilterSection_message;
    }

    protected void createMessagePart(Composite parent, WidgetFactory factory, String message, boolean html) {
        super.createMessagePart(parent, factory, message, true);
    }

    protected void handleMessageHyperlink(HyperlinkEvent e) {
        super.handleMessageHyperlink(e);
        if ("#MarkerView".equals(e.getHref())) {
            this.gotoMarkerView();
        }
    }

    private void gotoMarkerView() {
        IWorkbenchWindow window;
        if (PlatformUI.isWorkbenchRunning() && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            E4Utils.showPart((String)"org.xmind.ui.command.showModelPart", (IWorkbenchWindow)window, (String)"org.xmind.ui.modelPart.markers", null, (String)"org.xmind.ui.stack.right");
        }
    }

    public void handleCoreEvent(final CoreEvent event) {
        Control c = this.getControl();
        if (c == null || c.isDisposed()) {
            return;
        }
        c.getDisplay().syncExec(new Runnable(){

            public void run() {
                String type = event.getType();
                if ("resourceRefs".equals(type)) {
                    MarkerFilterSection.this.refresh();
                } else if ("markerDescription".equals(type)) {
                    MarkerFilterSection.this.getList().update(event.getTarget(), null);
                }
            }
        });
    }

    private Image getImage(String key, ImageDescriptor imageDescriptor) {
        if (key != null && imageDescriptor != null) {
            ImageDescriptor descriptor;
            if (this.imgReg == null) {
                this.imgReg = new ImageRegistry(Display.getCurrent());
            }
            if ((descriptor = this.imgReg.getDescriptor(key)) != null && descriptor.equals(imageDescriptor)) {
                return this.imgReg.get(key);
            }
            this.imgReg.put(key, imageDescriptor);
            return this.imgReg.get(key);
        }
        return null;
    }

    protected Image getPropertyFilterImage(Object element) {
        IMarker marker = this.findMarker(element);
        if (marker != null) {
            return this.getImage(marker.getId(), MarkerImageDescriptor.createFromMarker((IMarker)marker, (int)16, (int)16));
        }
        return super.getPropertyFilterImage(element);
    }

    protected String getPropertyFilterText(Object element) {
        String markerName = this.getMarkerName(element);
        if (markerName != null) {
            return markerName;
        }
        return super.getPropertyFilterText(element);
    }

    private IMarker findMarker(Object element) {
        if (element instanceof String) {
            ISheet sheet;
            String markerId = (String)element;
            if (this.getContributingViewer() != null && (sheet = (ISheet)this.getContributingViewer().getAdapter(ISheet.class)) != null) {
                return sheet.getOwnedWorkbook().getMarkerSheet().findMarker(markerId);
            }
        }
        return null;
    }

    private String getMarkerName(Object element) {
        if (element instanceof String) {
            ISheet sheet;
            String markerId = (String)element;
            if (this.getContributingViewer() != null && (sheet = (ISheet)this.getContributingViewer().getAdapter(ISheet.class)) != null) {
                return sheet.getLegend().getMarkerDescription(markerId);
            }
        }
        return null;
    }

    protected int getSectionStyle() {
        if (this.sectionStyle > 0) {
            return this.sectionStyle;
        }
        return super.getSectionStyle();
    }

    public void setSectionStyle(int sectionStyle) {
        this.sectionStyle = sectionStyle;
    }
}

