/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.command.remote.lan;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.xmind.core.command.remote.ICommandServerAdvertiser;
import org.xmind.core.command.remote.ICommandServiceDomain;
import org.xmind.core.command.remote.ICommandServiceInfo;
import org.xmind.core.command.remote.IRemoteCommandService;
import org.xmind.core.command.remote.IRemoteCommandServiceDiscoverer;
import org.xmind.core.command.remote.IRemoteCommandServiceListener;
import org.xmind.core.internal.command.remote.lan.LANRemoteCommandPlugin;

public class LANDiscoveryServiceAdapter
implements ICommandServerAdvertiser,
IRemoteCommandServiceDiscoverer {
    private static final IRemoteCommandService[] NO_SERVICES = new IRemoteCommandService[0];
    private ICommandServerAdvertiser advertiserImpl;
    private IRemoteCommandServiceDiscoverer discovererImpl;
    private IStatus fatalStatus = null;

    public LANDiscoveryServiceAdapter() {
        try {
            Class.forName("com.apple.dnssd.DNSSD");
        }
        catch (UnsatisfiedLinkError e) {
            this.fatalStatus = new Status(4, "org.xmind.core.command.remote.lan", 23333, "Bonjour installation is not found or damaged.", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            this.fatalStatus = new Status(4, "org.xmind.core.command.remote.lan", 23331, "DNSSD Java Client Library (com.apple.dnssd) is not found.", (Throwable)e);
        }
        catch (Throwable e) {
            this.fatalStatus = new Status(4, "org.xmind.core.command.remote.lan", 23332, "DNSSD Java Client Library (com.apple.dnssd) fails to be loaded: " + e.getMessage(), e);
        }
        Object impl = null;
        if (this.fatalStatus == null) {
            try {
                Class<?> implClass = Class.forName("org.xmind.core.internal.command.remote.lan.dnssd.DNSSDDiscoveryServiceAdapter");
                impl = implClass.newInstance();
            }
            catch (Throwable e) {
                LANRemoteCommandPlugin.log("LANDiscoveryService: Failed to load implementation class: org.xmind.core.internal.command.remote.lan.dnssd.DNSSDDiscoveryServiceAdapter", e);
            }
        }
        this.advertiserImpl = impl;
        this.discovererImpl = impl;
    }

    public void init(ICommandServiceDomain domain) {
        if (this.advertiserImpl != null) {
            this.advertiserImpl.init(domain);
        }
    }

    public IStatus activate(IProgressMonitor monitor) {
        if (this.fatalStatus != null) {
            return this.fatalStatus;
        }
        if (this.discovererImpl != null) {
            return this.discovererImpl.activate(monitor);
        }
        return Status.OK_STATUS;
    }

    public IStatus deactivate(IProgressMonitor monitor) {
        if (this.discovererImpl != null) {
            return this.discovererImpl.deactivate(monitor);
        }
        return Status.OK_STATUS;
    }

    public IRemoteCommandService[] getRemoteCommandServices() {
        if (this.discovererImpl != null) {
            return this.discovererImpl.getRemoteCommandServices();
        }
        return NO_SERVICES;
    }

    public IRemoteCommandService findRemoteCommandService(String serviceName) {
        if (this.discovererImpl != null) {
            return this.discovererImpl.findRemoteCommandService(serviceName);
        }
        return null;
    }

    public void addRemoteCommandServiceListener(IRemoteCommandServiceListener listener) {
        if (this.discovererImpl != null) {
            this.discovererImpl.addRemoteCommandServiceListener(listener);
        }
    }

    public void removeRemoteCommandServiceListener(IRemoteCommandServiceListener listener) {
        if (this.discovererImpl != null) {
            this.discovererImpl.removeRemoteCommandServiceListener(listener);
        }
    }

    public IStatus refresh(IProgressMonitor monitor) {
        if (this.fatalStatus != null) {
            return this.fatalStatus;
        }
        if (this.discovererImpl != null) {
            return this.discovererImpl.refresh(monitor);
        }
        return Status.OK_STATUS;
    }

    public ICommandServiceInfo getRegisteredInfo() {
        if (this.advertiserImpl != null) {
            return this.advertiserImpl.getRegisteredInfo();
        }
        return null;
    }

    public IStatus register(IProgressMonitor monitor) {
        if (this.fatalStatus != null) {
            return this.fatalStatus;
        }
        if (this.advertiserImpl != null) {
            return this.advertiserImpl.register(monitor);
        }
        return Status.OK_STATUS;
    }

    public void setRegisteringInfo(ICommandServiceInfo info) {
        if (this.advertiserImpl != null) {
            this.advertiserImpl.setRegisteringInfo(info);
        }
    }

    public IStatus unregister(IProgressMonitor monitor) {
        if (this.advertiserImpl != null) {
            return this.advertiserImpl.unregister(monitor);
        }
        return Status.OK_STATUS;
    }

    public Object getAdapter(Class adapter) {
        Object adapted = null;
        if (this.advertiserImpl != null) {
            adapted = this.advertiserImpl.getAdapter(adapter);
        }
        if (adapted != null) {
            return adapted;
        }
        if (this.discovererImpl != null) {
            adapted = this.discovererImpl.getAdapter(adapter);
        }
        return adapted;
    }
}

