// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/recommender/v1beta1/recommender_service.proto

package recommender

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request for the `ListRecommendations` method.
type ListRecommendationsRequest struct {
	// Required. The container resource on which to execute the request.
	// Acceptable formats:
	//
	// 1.
	// "projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]",
	//
	// LOCATION here refers to GCP Locations:
	// https://cloud.google.com/about/locations/
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of results to return from this request.  Non-positive
	// values are ignored. If not specified, the server will determine the number
	// of results to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. If present, retrieves the next batch of results from the preceding call to
	// this method. `page_token` must be the value of `next_page_token` from the
	// previous response. The values of other method parameters must be identical
	// to those in the previous call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filter expression to restrict the recommendations returned. Supported
	// filter fields: state_info.state
	// Eg: `state_info.state:"DISMISSED" or state_info.state:"FAILED"
	Filter               string   `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListRecommendationsRequest) Reset()         { *m = ListRecommendationsRequest{} }
func (m *ListRecommendationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListRecommendationsRequest) ProtoMessage()    {}
func (*ListRecommendationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ca265e4ecfbc6d8, []int{0}
}

func (m *ListRecommendationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListRecommendationsRequest.Unmarshal(m, b)
}
func (m *ListRecommendationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListRecommendationsRequest.Marshal(b, m, deterministic)
}
func (m *ListRecommendationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListRecommendationsRequest.Merge(m, src)
}
func (m *ListRecommendationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListRecommendationsRequest.Size(m)
}
func (m *ListRecommendationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListRecommendationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListRecommendationsRequest proto.InternalMessageInfo

func (m *ListRecommendationsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListRecommendationsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListRecommendationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListRecommendationsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// Response to the `ListRecommendations` method.
type ListRecommendationsResponse struct {
	// The set of recommendations for the `parent` resource.
	Recommendations []*Recommendation `protobuf:"bytes,1,rep,name=recommendations,proto3" json:"recommendations,omitempty"`
	// A token that can be used to request the next page of results. This field is
	// empty if there are no additional results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListRecommendationsResponse) Reset()         { *m = ListRecommendationsResponse{} }
func (m *ListRecommendationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListRecommendationsResponse) ProtoMessage()    {}
func (*ListRecommendationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ca265e4ecfbc6d8, []int{1}
}

func (m *ListRecommendationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListRecommendationsResponse.Unmarshal(m, b)
}
func (m *ListRecommendationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListRecommendationsResponse.Marshal(b, m, deterministic)
}
func (m *ListRecommendationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListRecommendationsResponse.Merge(m, src)
}
func (m *ListRecommendationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListRecommendationsResponse.Size(m)
}
func (m *ListRecommendationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListRecommendationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListRecommendationsResponse proto.InternalMessageInfo

func (m *ListRecommendationsResponse) GetRecommendations() []*Recommendation {
	if m != nil {
		return m.Recommendations
	}
	return nil
}

func (m *ListRecommendationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request to the `GetRecommendation` method.
type GetRecommendationRequest struct {
	// Required. Name of the recommendation.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetRecommendationRequest) Reset()         { *m = GetRecommendationRequest{} }
func (m *GetRecommendationRequest) String() string { return proto.CompactTextString(m) }
func (*GetRecommendationRequest) ProtoMessage()    {}
func (*GetRecommendationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ca265e4ecfbc6d8, []int{2}
}

func (m *GetRecommendationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetRecommendationRequest.Unmarshal(m, b)
}
func (m *GetRecommendationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetRecommendationRequest.Marshal(b, m, deterministic)
}
func (m *GetRecommendationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetRecommendationRequest.Merge(m, src)
}
func (m *GetRecommendationRequest) XXX_Size() int {
	return xxx_messageInfo_GetRecommendationRequest.Size(m)
}
func (m *GetRecommendationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetRecommendationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetRecommendationRequest proto.InternalMessageInfo

func (m *GetRecommendationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for the `MarkRecommendationClaimed` Method.
type MarkRecommendationClaimedRequest struct {
	// Required. Name of the recommendation.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// State properties to include with this state. Overwrites any existing
	// `state_metadata`.
	// Keys must match the regex /^[a-z0-9][a-z0-9_.-]{0,62}$/.
	// Values must match the regex /^[a-zA-Z0-9_./-]{0,255}$/.
	StateMetadata map[string]string `protobuf:"bytes,2,rep,name=state_metadata,json=stateMetadata,proto3" json:"state_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Fingerprint of the Recommendation. Provides optimistic locking.
	Etag                 string   `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MarkRecommendationClaimedRequest) Reset()         { *m = MarkRecommendationClaimedRequest{} }
func (m *MarkRecommendationClaimedRequest) String() string { return proto.CompactTextString(m) }
func (*MarkRecommendationClaimedRequest) ProtoMessage()    {}
func (*MarkRecommendationClaimedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ca265e4ecfbc6d8, []int{3}
}

func (m *MarkRecommendationClaimedRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MarkRecommendationClaimedRequest.Unmarshal(m, b)
}
func (m *MarkRecommendationClaimedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MarkRecommendationClaimedRequest.Marshal(b, m, deterministic)
}
func (m *MarkRecommendationClaimedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MarkRecommendationClaimedRequest.Merge(m, src)
}
func (m *MarkRecommendationClaimedRequest) XXX_Size() int {
	return xxx_messageInfo_MarkRecommendationClaimedRequest.Size(m)
}
func (m *MarkRecommendationClaimedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MarkRecommendationClaimedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MarkRecommendationClaimedRequest proto.InternalMessageInfo

func (m *MarkRecommendationClaimedRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MarkRecommendationClaimedRequest) GetStateMetadata() map[string]string {
	if m != nil {
		return m.StateMetadata
	}
	return nil
}

func (m *MarkRecommendationClaimedRequest) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

// Request for the `MarkRecommendationSucceeded` Method.
type MarkRecommendationSucceededRequest struct {
	// Required. Name of the recommendation.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// State properties to include with this state. Overwrites any existing
	// `state_metadata`.
	// Keys must match the regex /^[a-z0-9][a-z0-9_.-]{0,62}$/.
	// Values must match the regex /^[a-zA-Z0-9_./-]{0,255}$/.
	StateMetadata map[string]string `protobuf:"bytes,2,rep,name=state_metadata,json=stateMetadata,proto3" json:"state_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Fingerprint of the Recommendation. Provides optimistic locking.
	Etag                 string   `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MarkRecommendationSucceededRequest) Reset()         { *m = MarkRecommendationSucceededRequest{} }
func (m *MarkRecommendationSucceededRequest) String() string { return proto.CompactTextString(m) }
func (*MarkRecommendationSucceededRequest) ProtoMessage()    {}
func (*MarkRecommendationSucceededRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ca265e4ecfbc6d8, []int{4}
}

func (m *MarkRecommendationSucceededRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MarkRecommendationSucceededRequest.Unmarshal(m, b)
}
func (m *MarkRecommendationSucceededRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MarkRecommendationSucceededRequest.Marshal(b, m, deterministic)
}
func (m *MarkRecommendationSucceededRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MarkRecommendationSucceededRequest.Merge(m, src)
}
func (m *MarkRecommendationSucceededRequest) XXX_Size() int {
	return xxx_messageInfo_MarkRecommendationSucceededRequest.Size(m)
}
func (m *MarkRecommendationSucceededRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MarkRecommendationSucceededRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MarkRecommendationSucceededRequest proto.InternalMessageInfo

func (m *MarkRecommendationSucceededRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MarkRecommendationSucceededRequest) GetStateMetadata() map[string]string {
	if m != nil {
		return m.StateMetadata
	}
	return nil
}

func (m *MarkRecommendationSucceededRequest) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

// Request for the `MarkRecommendationFailed` Method.
type MarkRecommendationFailedRequest struct {
	// Required. Name of the recommendation.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// State properties to include with this state. Overwrites any existing
	// `state_metadata`.
	// Keys must match the regex /^[a-z0-9][a-z0-9_.-]{0,62}$/.
	// Values must match the regex /^[a-zA-Z0-9_./-]{0,255}$/.
	StateMetadata map[string]string `protobuf:"bytes,2,rep,name=state_metadata,json=stateMetadata,proto3" json:"state_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Fingerprint of the Recommendation. Provides optimistic locking.
	Etag                 string   `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MarkRecommendationFailedRequest) Reset()         { *m = MarkRecommendationFailedRequest{} }
func (m *MarkRecommendationFailedRequest) String() string { return proto.CompactTextString(m) }
func (*MarkRecommendationFailedRequest) ProtoMessage()    {}
func (*MarkRecommendationFailedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ca265e4ecfbc6d8, []int{5}
}

func (m *MarkRecommendationFailedRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MarkRecommendationFailedRequest.Unmarshal(m, b)
}
func (m *MarkRecommendationFailedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MarkRecommendationFailedRequest.Marshal(b, m, deterministic)
}
func (m *MarkRecommendationFailedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MarkRecommendationFailedRequest.Merge(m, src)
}
func (m *MarkRecommendationFailedRequest) XXX_Size() int {
	return xxx_messageInfo_MarkRecommendationFailedRequest.Size(m)
}
func (m *MarkRecommendationFailedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MarkRecommendationFailedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MarkRecommendationFailedRequest proto.InternalMessageInfo

func (m *MarkRecommendationFailedRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MarkRecommendationFailedRequest) GetStateMetadata() map[string]string {
	if m != nil {
		return m.StateMetadata
	}
	return nil
}

func (m *MarkRecommendationFailedRequest) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func init() {
	proto.RegisterType((*ListRecommendationsRequest)(nil), "google.cloud.recommender.v1beta1.ListRecommendationsRequest")
	proto.RegisterType((*ListRecommendationsResponse)(nil), "google.cloud.recommender.v1beta1.ListRecommendationsResponse")
	proto.RegisterType((*GetRecommendationRequest)(nil), "google.cloud.recommender.v1beta1.GetRecommendationRequest")
	proto.RegisterType((*MarkRecommendationClaimedRequest)(nil), "google.cloud.recommender.v1beta1.MarkRecommendationClaimedRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.recommender.v1beta1.MarkRecommendationClaimedRequest.StateMetadataEntry")
	proto.RegisterType((*MarkRecommendationSucceededRequest)(nil), "google.cloud.recommender.v1beta1.MarkRecommendationSucceededRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.recommender.v1beta1.MarkRecommendationSucceededRequest.StateMetadataEntry")
	proto.RegisterType((*MarkRecommendationFailedRequest)(nil), "google.cloud.recommender.v1beta1.MarkRecommendationFailedRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.recommender.v1beta1.MarkRecommendationFailedRequest.StateMetadataEntry")
}

func init() {
	proto.RegisterFile("google/cloud/recommender/v1beta1/recommender_service.proto", fileDescriptor_0ca265e4ecfbc6d8)
}

var fileDescriptor_0ca265e4ecfbc6d8 = []byte{
	// 866 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x56, 0xcf, 0x6f, 0xe3, 0x44,
	0x18, 0x95, 0x9d, 0xb6, 0x62, 0x67, 0x55, 0x76, 0x19, 0x10, 0xeb, 0xf5, 0x22, 0x6d, 0xb0, 0xd0,
	0x2a, 0x84, 0x62, 0x93, 0x45, 0x48, 0x28, 0xb0, 0x12, 0x4e, 0xe8, 0x56, 0x08, 0x16, 0x55, 0xce,
	0xee, 0x16, 0xf5, 0x12, 0x4d, 0x9d, 0xaf, 0xae, 0x89, 0xed, 0x31, 0x9e, 0x49, 0xfa, 0x8b, 0x72,
	0xe0, 0x86, 0xc4, 0x09, 0xfe, 0x02, 0x38, 0x72, 0xe4, 0x2f, 0x40, 0x3d, 0x70, 0xe0, 0x08, 0x27,
	0x7a, 0xa1, 0x07, 0xfe, 0x03, 0x6e, 0x9c, 0x90, 0x67, 0xdc, 0xd6, 0x49, 0x6a, 0xdc, 0x4d, 0x23,
	0xf5, 0x16, 0x7f, 0xdf, 0xbc, 0x6f, 0xde, 0x7b, 0x76, 0xde, 0x0c, 0x6a, 0x7a, 0x94, 0x7a, 0x01,
	0x58, 0x6e, 0x40, 0x07, 0x3d, 0x2b, 0x01, 0x97, 0x86, 0x21, 0x44, 0x3d, 0x48, 0xac, 0x61, 0x63,
	0x03, 0x38, 0x69, 0xe4, 0x6b, 0x5d, 0x06, 0xc9, 0xd0, 0x77, 0xc1, 0x8c, 0x13, 0xca, 0x29, 0xae,
	0x4a, 0xac, 0x29, 0xb0, 0x66, 0x6e, 0x9d, 0x99, 0x61, 0xf5, 0x57, 0xb2, 0xe9, 0x24, 0xf6, 0x2d,
	0x12, 0x45, 0x94, 0x13, 0xee, 0xd3, 0x88, 0x49, 0xbc, 0x7e, 0x2b, 0xd7, 0x75, 0x03, 0x1f, 0x22,
	0x9e, 0x35, 0xee, 0xe6, 0x1a, 0x9b, 0x3e, 0x04, 0xbd, 0xee, 0x06, 0x6c, 0x91, 0xa1, 0x4f, 0x93,
	0x6c, 0xc1, 0xed, 0xdc, 0x82, 0x04, 0x18, 0x1d, 0x24, 0x27, 0xa4, 0xf4, 0x77, 0x2e, 0x2e, 0x48,
	0x90, 0x91, 0x30, 0xe3, 0x50, 0x41, 0xfa, 0x27, 0x3e, 0xe3, 0xce, 0x48, 0x93, 0x39, 0xf0, 0xc5,
	0x00, 0x18, 0xc7, 0x0f, 0xd1, 0x42, 0x4c, 0x12, 0x88, 0xb8, 0xa6, 0x54, 0x95, 0xda, 0xb5, 0x96,
	0x79, 0x6c, 0xab, 0xff, 0xda, 0x35, 0x74, 0x2f, 0xaf, 0x5a, 0xee, 0x4c, 0x62, 0x9f, 0x99, 0x2e,
	0x0d, 0x2d, 0xe7, 0xac, 0xe5, 0x64, 0x68, 0x5c, 0x45, 0xd7, 0x62, 0xe2, 0x41, 0x97, 0xf9, 0x7b,
	0xa0, 0xa9, 0x55, 0xa5, 0x36, 0xdf, 0xaa, 0x1c, 0xdb, 0x8a, 0xf3, 0x5c, 0x5a, 0xed, 0xf8, 0x7b,
	0x80, 0x0d, 0x84, 0xc4, 0x0a, 0x4e, 0xfb, 0x10, 0x69, 0x15, 0xb1, 0x9b, 0x58, 0x22, 0x80, 0x8f,
	0xd3, 0x2a, 0x7e, 0x19, 0x2d, 0x6c, 0xfa, 0x01, 0x87, 0x44, 0x9b, 0x4f, 0xfb, 0x4e, 0xf6, 0x64,
	0xfc, 0xa0, 0xa0, 0x3b, 0xe7, 0x8a, 0x60, 0x31, 0x8d, 0x18, 0xe0, 0x75, 0x74, 0x63, 0x54, 0x3c,
	0xd3, 0x94, 0x6a, 0xa5, 0x76, 0xfd, 0xfe, 0x5b, 0x66, 0xd9, 0xab, 0x34, 0x47, 0x67, 0x3a, 0xe3,
	0x83, 0xf0, 0x3d, 0x74, 0x23, 0x82, 0x1d, 0xde, 0xcd, 0x91, 0x57, 0x05, 0xb9, 0xc5, 0xb4, 0xbc,
	0x7a, 0xc2, 0xdd, 0x20, 0x48, 0x5b, 0x81, 0x31, 0x86, 0x27, 0x2e, 0x2f, 0xa3, 0xb9, 0x88, 0x84,
	0x90, 0x79, 0xdc, 0x10, 0x1e, 0xbf, 0x81, 0x5e, 0xbf, 0x88, 0xc7, 0x72, 0x8e, 0x80, 0x1b, 0x87,
	0x2a, 0xaa, 0x3e, 0x22, 0x49, 0x7f, 0xb4, 0xd9, 0x0e, 0x88, 0x1f, 0x42, 0x6f, 0xb6, 0x7b, 0xe1,
	0x2f, 0xd1, 0xf3, 0x8c, 0x13, 0x0e, 0xdd, 0x10, 0x38, 0xe9, 0x11, 0x4e, 0x34, 0x55, 0x38, 0xfa,
	0xa4, 0xdc, 0xd1, 0x32, 0x8a, 0x66, 0x27, 0x1d, 0xfc, 0x28, 0x9b, 0xbb, 0x1c, 0xf1, 0x64, 0xd7,
	0x59, 0x64, 0xf9, 0x1a, 0xbe, 0x85, 0xe6, 0x80, 0x13, 0xef, 0xec, 0x33, 0x51, 0x1d, 0x51, 0xd0,
	0x3f, 0x40, 0x78, 0x12, 0x8d, 0x6f, 0xa2, 0x4a, 0x1f, 0x76, 0xa5, 0x64, 0x27, 0xfd, 0x89, 0x5f,
	0x42, 0xf3, 0x43, 0x12, 0x0c, 0x20, 0x7b, 0x57, 0xf2, 0xa1, 0xa9, 0xbe, 0xab, 0x18, 0xbf, 0xaa,
	0xc8, 0x98, 0x64, 0xd8, 0x19, 0xb8, 0x2e, 0x40, 0x6f, 0xe6, 0x36, 0x7e, 0x55, 0x60, 0xe3, 0xda,
	0x34, 0x36, 0x8e, 0x93, 0xbc, 0x5a, 0x23, 0x7f, 0x51, 0xd1, 0xdd, 0x49, 0x8e, 0x0f, 0x89, 0x1f,
	0xcc, 0xdc, 0xc5, 0xfd, 0x02, 0x17, 0x1f, 0x4f, 0xe3, 0xe2, 0x08, 0xc3, 0x2b, 0xb5, 0xf0, 0xfe,
	0x5f, 0x08, 0x5d, 0xcf, 0xa5, 0x29, 0xfe, 0x47, 0x41, 0x2f, 0x9e, 0x93, 0x73, 0xf8, 0xfd, 0x72,
	0x9d, 0xc5, 0x19, 0xaf, 0x3f, 0x98, 0x12, 0x2d, 0xc3, 0xd5, 0xe8, 0x1e, 0xd9, 0x8b, 0x32, 0xe5,
	0x97, 0x64, 0x1c, 0x7f, 0xfd, 0xc7, 0xdf, 0xdf, 0xab, 0x1f, 0xe1, 0x95, 0xd3, 0x83, 0x67, 0x5f,
	0xb6, 0x1f, 0xc4, 0x09, 0xfd, 0x1c, 0x5c, 0xce, 0xac, 0xba, 0x15, 0x50, 0x57, 0x8e, 0xb1, 0xea,
	0xf9, 0xb3, 0x8a, 0x59, 0xf5, 0x03, 0x6b, 0x3c, 0x61, 0xff, 0x54, 0xd0, 0x0b, 0x13, 0xd1, 0x89,
	0x9b, 0xe5, 0xac, 0x8b, 0xf2, 0x56, 0x7f, 0xe6, 0xd8, 0x37, 0x9e, 0x1e, 0xd9, 0xe2, 0x53, 0x9b,
	0xd4, 0x96, 0x56, 0x2f, 0xa6, 0x6c, 0x5c, 0x98, 0x55, 0x3f, 0xc0, 0xdf, 0xaa, 0xe8, 0x76, 0x61,
	0x1e, 0xe2, 0xd6, 0xe5, 0xc3, 0x74, 0x0a, 0xad, 0xbb, 0x47, 0xb6, 0x96, 0xaa, 0x5a, 0x1a, 0xfd,
	0x4f, 0x2d, 0xa5, 0x1f, 0xb5, 0xd0, 0xff, 0x99, 0xd1, 0x99, 0x91, 0xfe, 0x66, 0x48, 0x92, 0x7e,
	0x46, 0xb8, 0xa9, 0xd4, 0xf1, 0x77, 0x2a, 0xba, 0xf3, 0x3f, 0xb9, 0x86, 0x3f, 0x9c, 0x45, 0x2c,
	0x4e, 0x61, 0xc9, 0x7e, 0x99, 0x25, 0xeb, 0xc6, 0x93, 0x59, 0x5a, 0x72, 0x4a, 0x39, 0x35, 0xe5,
	0x1b, 0x15, 0x69, 0x45, 0x31, 0x85, 0xed, 0x4b, 0x47, 0xdc, 0x14, 0x76, 0xec, 0x94, 0xd9, 0xb1,
	0x66, 0x38, 0xb3, 0xb4, 0x43, 0xf2, 0x6d, 0x2a, 0x75, 0xfd, 0xd3, 0xdf, 0x6c, 0xbd, 0xf8, 0x74,
	0xf8, 0xdd, 0x36, 0xb7, 0x38, 0x8f, 0x59, 0xd3, 0xb2, 0xb6, 0xb7, 0xb7, 0xc7, 0x8f, 0x0e, 0x32,
	0xe0, 0x5b, 0xf2, 0x7a, 0xfc, 0x66, 0x1c, 0x10, 0xbe, 0x49, 0x93, 0xb0, 0xf5, 0xb3, 0x82, 0x5e,
	0x73, 0x69, 0x58, 0xea, 0x40, 0xeb, 0x66, 0x2e, 0x87, 0x57, 0xd3, 0x9b, 0xf3, 0xaa, 0xb2, 0xfe,
	0x71, 0x86, 0xf2, 0x68, 0x40, 0x22, 0xcf, 0xa4, 0x89, 0x67, 0x79, 0x10, 0x89, 0x7b, 0xb5, 0x75,
	0xb6, 0x77, 0xf1, 0x8d, 0xfc, 0xbd, 0x5c, 0xed, 0x47, 0x75, 0xae, 0xed, 0x2c, 0xb7, 0x7f, 0x52,
	0x5f, 0x5d, 0x91, 0x43, 0xdb, 0x82, 0x8a, 0xdc, 0x35, 0xe3, 0xf2, 0xb4, 0xd1, 0x4a, 0x61, 0x1b,
	0x0b, 0x62, 0x8b, 0xb7, 0xff, 0x0b, 0x00, 0x00, 0xff, 0xff, 0xe6, 0x40, 0xc7, 0xa9, 0xc4, 0x0c,
	0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// RecommenderClient is the client API for Recommender service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type RecommenderClient interface {
	// Lists recommendations for a Cloud project. Requires the recommender.*.list
	// IAM permission for the specified recommender.
	ListRecommendations(ctx context.Context, in *ListRecommendationsRequest, opts ...grpc.CallOption) (*ListRecommendationsResponse, error)
	// Gets the requested recommendation. Requires the recommender.*.get
	// IAM permission for the specified recommender.
	GetRecommendation(ctx context.Context, in *GetRecommendationRequest, opts ...grpc.CallOption) (*Recommendation, error)
	// Marks the Recommendation State as Claimed. Users can use this method to
	// indicate to the Recommender API that they are starting to apply the
	// recommendation themselves. This stops the recommendation content from being
	// updated. Associated insights are frozen and placed in the ACCEPTED state.
	//
	// MarkRecommendationClaimed can be applied to recommendations in CLAIMED or
	// ACTIVE state.
	//
	// Requires the recommender.*.update IAM permission for the specified
	// recommender.
	MarkRecommendationClaimed(ctx context.Context, in *MarkRecommendationClaimedRequest, opts ...grpc.CallOption) (*Recommendation, error)
	// Marks the Recommendation State as Succeeded. Users can use this method to
	// indicate to the Recommender API that they have applied the recommendation
	// themselves, and the operation was successful. This stops the recommendation
	// content from being updated. Associated insights are frozen and placed in
	// the ACCEPTED state.
	//
	// MarkRecommendationSucceeded can be applied to recommendations in ACTIVE,
	// CLAIMED, SUCCEEDED, or FAILED state.
	//
	// Requires the recommender.*.update IAM permission for the specified
	// recommender.
	MarkRecommendationSucceeded(ctx context.Context, in *MarkRecommendationSucceededRequest, opts ...grpc.CallOption) (*Recommendation, error)
	// Marks the Recommendation State as Failed. Users can use this method to
	// indicate to the Recommender API that they have applied the recommendation
	// themselves, and the operation failed. This stops the recommendation content
	// from being updated. Associated insights are frozen and placed in the
	// ACCEPTED state.
	//
	// MarkRecommendationFailed can be applied to recommendations in ACTIVE,
	// CLAIMED, SUCCEEDED, or FAILED state.
	//
	// Requires the recommender.*.update IAM permission for the specified
	// recommender.
	MarkRecommendationFailed(ctx context.Context, in *MarkRecommendationFailedRequest, opts ...grpc.CallOption) (*Recommendation, error)
}

type recommenderClient struct {
	cc *grpc.ClientConn
}

func NewRecommenderClient(cc *grpc.ClientConn) RecommenderClient {
	return &recommenderClient{cc}
}

func (c *recommenderClient) ListRecommendations(ctx context.Context, in *ListRecommendationsRequest, opts ...grpc.CallOption) (*ListRecommendationsResponse, error) {
	out := new(ListRecommendationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.recommender.v1beta1.Recommender/ListRecommendations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommenderClient) GetRecommendation(ctx context.Context, in *GetRecommendationRequest, opts ...grpc.CallOption) (*Recommendation, error) {
	out := new(Recommendation)
	err := c.cc.Invoke(ctx, "/google.cloud.recommender.v1beta1.Recommender/GetRecommendation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommenderClient) MarkRecommendationClaimed(ctx context.Context, in *MarkRecommendationClaimedRequest, opts ...grpc.CallOption) (*Recommendation, error) {
	out := new(Recommendation)
	err := c.cc.Invoke(ctx, "/google.cloud.recommender.v1beta1.Recommender/MarkRecommendationClaimed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommenderClient) MarkRecommendationSucceeded(ctx context.Context, in *MarkRecommendationSucceededRequest, opts ...grpc.CallOption) (*Recommendation, error) {
	out := new(Recommendation)
	err := c.cc.Invoke(ctx, "/google.cloud.recommender.v1beta1.Recommender/MarkRecommendationSucceeded", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommenderClient) MarkRecommendationFailed(ctx context.Context, in *MarkRecommendationFailedRequest, opts ...grpc.CallOption) (*Recommendation, error) {
	out := new(Recommendation)
	err := c.cc.Invoke(ctx, "/google.cloud.recommender.v1beta1.Recommender/MarkRecommendationFailed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RecommenderServer is the server API for Recommender service.
type RecommenderServer interface {
	// Lists recommendations for a Cloud project. Requires the recommender.*.list
	// IAM permission for the specified recommender.
	ListRecommendations(context.Context, *ListRecommendationsRequest) (*ListRecommendationsResponse, error)
	// Gets the requested recommendation. Requires the recommender.*.get
	// IAM permission for the specified recommender.
	GetRecommendation(context.Context, *GetRecommendationRequest) (*Recommendation, error)
	// Marks the Recommendation State as Claimed. Users can use this method to
	// indicate to the Recommender API that they are starting to apply the
	// recommendation themselves. This stops the recommendation content from being
	// updated. Associated insights are frozen and placed in the ACCEPTED state.
	//
	// MarkRecommendationClaimed can be applied to recommendations in CLAIMED or
	// ACTIVE state.
	//
	// Requires the recommender.*.update IAM permission for the specified
	// recommender.
	MarkRecommendationClaimed(context.Context, *MarkRecommendationClaimedRequest) (*Recommendation, error)
	// Marks the Recommendation State as Succeeded. Users can use this method to
	// indicate to the Recommender API that they have applied the recommendation
	// themselves, and the operation was successful. This stops the recommendation
	// content from being updated. Associated insights are frozen and placed in
	// the ACCEPTED state.
	//
	// MarkRecommendationSucceeded can be applied to recommendations in ACTIVE,
	// CLAIMED, SUCCEEDED, or FAILED state.
	//
	// Requires the recommender.*.update IAM permission for the specified
	// recommender.
	MarkRecommendationSucceeded(context.Context, *MarkRecommendationSucceededRequest) (*Recommendation, error)
	// Marks the Recommendation State as Failed. Users can use this method to
	// indicate to the Recommender API that they have applied the recommendation
	// themselves, and the operation failed. This stops the recommendation content
	// from being updated. Associated insights are frozen and placed in the
	// ACCEPTED state.
	//
	// MarkRecommendationFailed can be applied to recommendations in ACTIVE,
	// CLAIMED, SUCCEEDED, or FAILED state.
	//
	// Requires the recommender.*.update IAM permission for the specified
	// recommender.
	MarkRecommendationFailed(context.Context, *MarkRecommendationFailedRequest) (*Recommendation, error)
}

// UnimplementedRecommenderServer can be embedded to have forward compatible implementations.
type UnimplementedRecommenderServer struct {
}

func (*UnimplementedRecommenderServer) ListRecommendations(ctx context.Context, req *ListRecommendationsRequest) (*ListRecommendationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRecommendations not implemented")
}
func (*UnimplementedRecommenderServer) GetRecommendation(ctx context.Context, req *GetRecommendationRequest) (*Recommendation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRecommendation not implemented")
}
func (*UnimplementedRecommenderServer) MarkRecommendationClaimed(ctx context.Context, req *MarkRecommendationClaimedRequest) (*Recommendation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MarkRecommendationClaimed not implemented")
}
func (*UnimplementedRecommenderServer) MarkRecommendationSucceeded(ctx context.Context, req *MarkRecommendationSucceededRequest) (*Recommendation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MarkRecommendationSucceeded not implemented")
}
func (*UnimplementedRecommenderServer) MarkRecommendationFailed(ctx context.Context, req *MarkRecommendationFailedRequest) (*Recommendation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MarkRecommendationFailed not implemented")
}

func RegisterRecommenderServer(s *grpc.Server, srv RecommenderServer) {
	s.RegisterService(&_Recommender_serviceDesc, srv)
}

func _Recommender_ListRecommendations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRecommendationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).ListRecommendations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommender.v1beta1.Recommender/ListRecommendations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).ListRecommendations(ctx, req.(*ListRecommendationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Recommender_GetRecommendation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRecommendationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).GetRecommendation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommender.v1beta1.Recommender/GetRecommendation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).GetRecommendation(ctx, req.(*GetRecommendationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Recommender_MarkRecommendationClaimed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MarkRecommendationClaimedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).MarkRecommendationClaimed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommender.v1beta1.Recommender/MarkRecommendationClaimed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).MarkRecommendationClaimed(ctx, req.(*MarkRecommendationClaimedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Recommender_MarkRecommendationSucceeded_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MarkRecommendationSucceededRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).MarkRecommendationSucceeded(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommender.v1beta1.Recommender/MarkRecommendationSucceeded",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).MarkRecommendationSucceeded(ctx, req.(*MarkRecommendationSucceededRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Recommender_MarkRecommendationFailed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MarkRecommendationFailedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).MarkRecommendationFailed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommender.v1beta1.Recommender/MarkRecommendationFailed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).MarkRecommendationFailed(ctx, req.(*MarkRecommendationFailedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Recommender_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.recommender.v1beta1.Recommender",
	HandlerType: (*RecommenderServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListRecommendations",
			Handler:    _Recommender_ListRecommendations_Handler,
		},
		{
			MethodName: "GetRecommendation",
			Handler:    _Recommender_GetRecommendation_Handler,
		},
		{
			MethodName: "MarkRecommendationClaimed",
			Handler:    _Recommender_MarkRecommendationClaimed_Handler,
		},
		{
			MethodName: "MarkRecommendationSucceeded",
			Handler:    _Recommender_MarkRecommendationSucceeded_Handler,
		},
		{
			MethodName: "MarkRecommendationFailed",
			Handler:    _Recommender_MarkRecommendationFailed_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/recommender/v1beta1/recommender_service.proto",
}
