//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use objc2::__framework_prelude::*;

use crate::*;

extern "C" {
    pub static NSURLSessionTransferSizeUnknown: i64;
}

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSURLSession;

    unsafe impl ClassType for NSURLSession {
        type Super = NSObject;
        type Mutability = InteriorMutable;
    }
);

unsafe impl Send for NSURLSession {}

unsafe impl Sync for NSURLSession {}

unsafe impl NSObjectProtocol for NSURLSession {}

extern_methods!(
    unsafe impl NSURLSession {
        #[method_id(@__retain_semantics Other sharedSession)]
        pub unsafe fn sharedSession() -> Retained<NSURLSession>;

        #[method_id(@__retain_semantics Other sessionWithConfiguration:)]
        pub unsafe fn sessionWithConfiguration(
            configuration: &NSURLSessionConfiguration,
        ) -> Retained<NSURLSession>;

        #[cfg(feature = "NSOperation")]
        #[method_id(@__retain_semantics Other sessionWithConfiguration:delegate:delegateQueue:)]
        pub unsafe fn sessionWithConfiguration_delegate_delegateQueue(
            configuration: &NSURLSessionConfiguration,
            delegate: Option<&ProtocolObject<dyn NSURLSessionDelegate>>,
            queue: Option<&NSOperationQueue>,
        ) -> Retained<NSURLSession>;

        #[cfg(feature = "NSOperation")]
        #[method_id(@__retain_semantics Other delegateQueue)]
        pub unsafe fn delegateQueue(&self) -> Retained<NSOperationQueue>;

        #[method_id(@__retain_semantics Other delegate)]
        pub unsafe fn delegate(&self)
            -> Option<Retained<ProtocolObject<dyn NSURLSessionDelegate>>>;

        #[method_id(@__retain_semantics Other configuration)]
        pub unsafe fn configuration(&self) -> Retained<NSURLSessionConfiguration>;

        #[cfg(feature = "NSString")]
        #[method_id(@__retain_semantics Other sessionDescription)]
        pub unsafe fn sessionDescription(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[method(setSessionDescription:)]
        pub unsafe fn setSessionDescription(&self, session_description: Option<&NSString>);

        #[method(finishTasksAndInvalidate)]
        pub unsafe fn finishTasksAndInvalidate(&self);

        #[method(invalidateAndCancel)]
        pub unsafe fn invalidateAndCancel(&self);

        #[cfg(feature = "block2")]
        #[method(resetWithCompletionHandler:)]
        pub unsafe fn resetWithCompletionHandler(
            &self,
            completion_handler: &block2::Block<dyn Fn()>,
        );

        #[cfg(feature = "block2")]
        #[method(flushWithCompletionHandler:)]
        pub unsafe fn flushWithCompletionHandler(
            &self,
            completion_handler: &block2::Block<dyn Fn()>,
        );

        #[cfg(all(feature = "NSArray", feature = "block2"))]
        #[method(getTasksWithCompletionHandler:)]
        pub unsafe fn getTasksWithCompletionHandler(
            &self,
            completion_handler: &block2::Block<
                dyn Fn(
                    NonNull<NSArray<NSURLSessionDataTask>>,
                    NonNull<NSArray<NSURLSessionUploadTask>>,
                    NonNull<NSArray<NSURLSessionDownloadTask>>,
                ),
            >,
        );

        #[cfg(all(feature = "NSArray", feature = "block2"))]
        #[method(getAllTasksWithCompletionHandler:)]
        pub unsafe fn getAllTasksWithCompletionHandler(
            &self,
            completion_handler: &block2::Block<dyn Fn(NonNull<NSArray<NSURLSessionTask>>)>,
        );

        #[cfg(feature = "NSURLRequest")]
        #[method_id(@__retain_semantics Other dataTaskWithRequest:)]
        pub unsafe fn dataTaskWithRequest(
            &self,
            request: &NSURLRequest,
        ) -> Retained<NSURLSessionDataTask>;

        #[cfg(feature = "NSURL")]
        #[method_id(@__retain_semantics Other dataTaskWithURL:)]
        pub unsafe fn dataTaskWithURL(&self, url: &NSURL) -> Retained<NSURLSessionDataTask>;

        #[cfg(all(feature = "NSURL", feature = "NSURLRequest"))]
        #[method_id(@__retain_semantics Other uploadTaskWithRequest:fromFile:)]
        pub unsafe fn uploadTaskWithRequest_fromFile(
            &self,
            request: &NSURLRequest,
            file_url: &NSURL,
        ) -> Retained<NSURLSessionUploadTask>;

        #[cfg(all(feature = "NSData", feature = "NSURLRequest"))]
        #[method_id(@__retain_semantics Other uploadTaskWithRequest:fromData:)]
        pub unsafe fn uploadTaskWithRequest_fromData(
            &self,
            request: &NSURLRequest,
            body_data: &NSData,
        ) -> Retained<NSURLSessionUploadTask>;

        #[cfg(feature = "NSData")]
        #[method_id(@__retain_semantics Other uploadTaskWithResumeData:)]
        pub unsafe fn uploadTaskWithResumeData(
            &self,
            resume_data: &NSData,
        ) -> Retained<NSURLSessionUploadTask>;

        #[cfg(feature = "NSURLRequest")]
        #[method_id(@__retain_semantics Other uploadTaskWithStreamedRequest:)]
        pub unsafe fn uploadTaskWithStreamedRequest(
            &self,
            request: &NSURLRequest,
        ) -> Retained<NSURLSessionUploadTask>;

        #[cfg(feature = "NSURLRequest")]
        #[method_id(@__retain_semantics Other downloadTaskWithRequest:)]
        pub unsafe fn downloadTaskWithRequest(
            &self,
            request: &NSURLRequest,
        ) -> Retained<NSURLSessionDownloadTask>;

        #[cfg(feature = "NSURL")]
        #[method_id(@__retain_semantics Other downloadTaskWithURL:)]
        pub unsafe fn downloadTaskWithURL(&self, url: &NSURL)
            -> Retained<NSURLSessionDownloadTask>;

        #[cfg(feature = "NSData")]
        #[method_id(@__retain_semantics Other downloadTaskWithResumeData:)]
        pub unsafe fn downloadTaskWithResumeData(
            &self,
            resume_data: &NSData,
        ) -> Retained<NSURLSessionDownloadTask>;

        #[cfg(feature = "NSString")]
        #[method_id(@__retain_semantics Other streamTaskWithHostName:port:)]
        pub unsafe fn streamTaskWithHostName_port(
            &self,
            hostname: &NSString,
            port: NSInteger,
        ) -> Retained<NSURLSessionStreamTask>;

        #[cfg(feature = "NSNetServices")]
        #[deprecated = "Use nw_connection_t in Network framework instead"]
        #[method_id(@__retain_semantics Other streamTaskWithNetService:)]
        pub unsafe fn streamTaskWithNetService(
            &self,
            service: &NSNetService,
        ) -> Retained<NSURLSessionStreamTask>;

        #[cfg(feature = "NSURL")]
        #[method_id(@__retain_semantics Other webSocketTaskWithURL:)]
        pub unsafe fn webSocketTaskWithURL(
            &self,
            url: &NSURL,
        ) -> Retained<NSURLSessionWebSocketTask>;

        #[cfg(all(feature = "NSArray", feature = "NSString", feature = "NSURL"))]
        #[method_id(@__retain_semantics Other webSocketTaskWithURL:protocols:)]
        pub unsafe fn webSocketTaskWithURL_protocols(
            &self,
            url: &NSURL,
            protocols: &NSArray<NSString>,
        ) -> Retained<NSURLSessionWebSocketTask>;

        #[cfg(feature = "NSURLRequest")]
        #[method_id(@__retain_semantics Other webSocketTaskWithRequest:)]
        pub unsafe fn webSocketTaskWithRequest(
            &self,
            request: &NSURLRequest,
        ) -> Retained<NSURLSessionWebSocketTask>;

        #[deprecated = "Please use +[NSURLSession sessionWithConfiguration:] or other class methods to create instances"]
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[deprecated = "Please use +[NSURLSession sessionWithConfiguration:] or other class methods to create instances"]
        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

extern_methods!(
    /// NSURLSessionAsynchronousConvenience
    unsafe impl NSURLSession {
        #[cfg(all(
            feature = "NSData",
            feature = "NSError",
            feature = "NSURLRequest",
            feature = "NSURLResponse",
            feature = "block2"
        ))]
        #[method_id(@__retain_semantics Other dataTaskWithRequest:completionHandler:)]
        pub unsafe fn dataTaskWithRequest_completionHandler(
            &self,
            request: &NSURLRequest,
            completion_handler: &block2::Block<
                dyn Fn(*mut NSData, *mut NSURLResponse, *mut NSError),
            >,
        ) -> Retained<NSURLSessionDataTask>;

        #[cfg(all(
            feature = "NSData",
            feature = "NSError",
            feature = "NSURL",
            feature = "NSURLResponse",
            feature = "block2"
        ))]
        #[method_id(@__retain_semantics Other dataTaskWithURL:completionHandler:)]
        pub unsafe fn dataTaskWithURL_completionHandler(
            &self,
            url: &NSURL,
            completion_handler: &block2::Block<
                dyn Fn(*mut NSData, *mut NSURLResponse, *mut NSError),
            >,
        ) -> Retained<NSURLSessionDataTask>;

        #[cfg(all(
            feature = "NSData",
            feature = "NSError",
            feature = "NSURL",
            feature = "NSURLRequest",
            feature = "NSURLResponse",
            feature = "block2"
        ))]
        #[method_id(@__retain_semantics Other uploadTaskWithRequest:fromFile:completionHandler:)]
        pub unsafe fn uploadTaskWithRequest_fromFile_completionHandler(
            &self,
            request: &NSURLRequest,
            file_url: &NSURL,
            completion_handler: &block2::Block<
                dyn Fn(*mut NSData, *mut NSURLResponse, *mut NSError),
            >,
        ) -> Retained<NSURLSessionUploadTask>;

        #[cfg(all(
            feature = "NSData",
            feature = "NSError",
            feature = "NSURLRequest",
            feature = "NSURLResponse",
            feature = "block2"
        ))]
        #[method_id(@__retain_semantics Other uploadTaskWithRequest:fromData:completionHandler:)]
        pub unsafe fn uploadTaskWithRequest_fromData_completionHandler(
            &self,
            request: &NSURLRequest,
            body_data: Option<&NSData>,
            completion_handler: &block2::Block<
                dyn Fn(*mut NSData, *mut NSURLResponse, *mut NSError),
            >,
        ) -> Retained<NSURLSessionUploadTask>;

        #[cfg(all(
            feature = "NSData",
            feature = "NSError",
            feature = "NSURLResponse",
            feature = "block2"
        ))]
        #[method_id(@__retain_semantics Other uploadTaskWithResumeData:completionHandler:)]
        pub unsafe fn uploadTaskWithResumeData_completionHandler(
            &self,
            resume_data: &NSData,
            completion_handler: &block2::Block<
                dyn Fn(*mut NSData, *mut NSURLResponse, *mut NSError),
            >,
        ) -> Retained<NSURLSessionUploadTask>;

        #[cfg(all(
            feature = "NSError",
            feature = "NSURL",
            feature = "NSURLRequest",
            feature = "NSURLResponse",
            feature = "block2"
        ))]
        #[method_id(@__retain_semantics Other downloadTaskWithRequest:completionHandler:)]
        pub unsafe fn downloadTaskWithRequest_completionHandler(
            &self,
            request: &NSURLRequest,
            completion_handler: &block2::Block<
                dyn Fn(*mut NSURL, *mut NSURLResponse, *mut NSError),
            >,
        ) -> Retained<NSURLSessionDownloadTask>;

        #[cfg(all(
            feature = "NSError",
            feature = "NSURL",
            feature = "NSURLResponse",
            feature = "block2"
        ))]
        #[method_id(@__retain_semantics Other downloadTaskWithURL:completionHandler:)]
        pub unsafe fn downloadTaskWithURL_completionHandler(
            &self,
            url: &NSURL,
            completion_handler: &block2::Block<
                dyn Fn(*mut NSURL, *mut NSURLResponse, *mut NSError),
            >,
        ) -> Retained<NSURLSessionDownloadTask>;

        #[cfg(all(
            feature = "NSData",
            feature = "NSError",
            feature = "NSURL",
            feature = "NSURLResponse",
            feature = "block2"
        ))]
        #[method_id(@__retain_semantics Other downloadTaskWithResumeData:completionHandler:)]
        pub unsafe fn downloadTaskWithResumeData_completionHandler(
            &self,
            resume_data: &NSData,
            completion_handler: &block2::Block<
                dyn Fn(*mut NSURL, *mut NSURLResponse, *mut NSError),
            >,
        ) -> Retained<NSURLSessionDownloadTask>;
    }
);

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSURLSessionTaskState(pub NSInteger);
impl NSURLSessionTaskState {
    #[doc(alias = "NSURLSessionTaskStateRunning")]
    pub const Running: Self = Self(0);
    #[doc(alias = "NSURLSessionTaskStateSuspended")]
    pub const Suspended: Self = Self(1);
    #[doc(alias = "NSURLSessionTaskStateCanceling")]
    pub const Canceling: Self = Self(2);
    #[doc(alias = "NSURLSessionTaskStateCompleted")]
    pub const Completed: Self = Self(3);
}

unsafe impl Encode for NSURLSessionTaskState {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSURLSessionTaskState {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSURLSessionTask;

    unsafe impl ClassType for NSURLSessionTask {
        type Super = NSObject;
        type Mutability = InteriorMutable;
    }
);

unsafe impl Send for NSURLSessionTask {}

unsafe impl Sync for NSURLSessionTask {}

#[cfg(feature = "NSObject")]
unsafe impl NSCopying for NSURLSessionTask {}

unsafe impl NSObjectProtocol for NSURLSessionTask {}

#[cfg(feature = "NSProgress")]
unsafe impl NSProgressReporting for NSURLSessionTask {}

extern_methods!(
    unsafe impl NSURLSessionTask {
        #[method(taskIdentifier)]
        pub unsafe fn taskIdentifier(&self) -> NSUInteger;

        #[cfg(feature = "NSURLRequest")]
        #[method_id(@__retain_semantics Other originalRequest)]
        pub unsafe fn originalRequest(&self) -> Option<Retained<NSURLRequest>>;

        #[cfg(feature = "NSURLRequest")]
        #[method_id(@__retain_semantics Other currentRequest)]
        pub unsafe fn currentRequest(&self) -> Option<Retained<NSURLRequest>>;

        #[cfg(feature = "NSURLResponse")]
        #[method_id(@__retain_semantics Other response)]
        pub unsafe fn response(&self) -> Option<Retained<NSURLResponse>>;

        #[method_id(@__retain_semantics Other delegate)]
        pub unsafe fn delegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn NSURLSessionTaskDelegate>>>;

        #[method(setDelegate:)]
        pub unsafe fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn NSURLSessionTaskDelegate>>,
        );

        #[cfg(feature = "NSProgress")]
        #[method_id(@__retain_semantics Other progress)]
        pub unsafe fn progress(&self) -> Retained<NSProgress>;

        #[cfg(feature = "NSDate")]
        #[method_id(@__retain_semantics Other earliestBeginDate)]
        pub unsafe fn earliestBeginDate(&self) -> Option<Retained<NSDate>>;

        #[cfg(feature = "NSDate")]
        #[method(setEarliestBeginDate:)]
        pub unsafe fn setEarliestBeginDate(&self, earliest_begin_date: Option<&NSDate>);

        #[method(countOfBytesClientExpectsToSend)]
        pub unsafe fn countOfBytesClientExpectsToSend(&self) -> i64;

        #[method(setCountOfBytesClientExpectsToSend:)]
        pub unsafe fn setCountOfBytesClientExpectsToSend(
            &self,
            count_of_bytes_client_expects_to_send: i64,
        );

        #[method(countOfBytesClientExpectsToReceive)]
        pub unsafe fn countOfBytesClientExpectsToReceive(&self) -> i64;

        #[method(setCountOfBytesClientExpectsToReceive:)]
        pub unsafe fn setCountOfBytesClientExpectsToReceive(
            &self,
            count_of_bytes_client_expects_to_receive: i64,
        );

        #[method(countOfBytesSent)]
        pub unsafe fn countOfBytesSent(&self) -> i64;

        #[method(countOfBytesReceived)]
        pub unsafe fn countOfBytesReceived(&self) -> i64;

        #[method(countOfBytesExpectedToSend)]
        pub unsafe fn countOfBytesExpectedToSend(&self) -> i64;

        #[method(countOfBytesExpectedToReceive)]
        pub unsafe fn countOfBytesExpectedToReceive(&self) -> i64;

        #[cfg(feature = "NSString")]
        #[method_id(@__retain_semantics Other taskDescription)]
        pub unsafe fn taskDescription(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[method(setTaskDescription:)]
        pub unsafe fn setTaskDescription(&self, task_description: Option<&NSString>);

        #[method(cancel)]
        pub unsafe fn cancel(&self);

        #[method(state)]
        pub unsafe fn state(&self) -> NSURLSessionTaskState;

        #[cfg(feature = "NSError")]
        #[method_id(@__retain_semantics Other error)]
        pub unsafe fn error(&self) -> Option<Retained<NSError>>;

        #[method(suspend)]
        pub unsafe fn suspend(&self);

        #[method(resume)]
        pub unsafe fn resume(&self);

        #[method(priority)]
        pub unsafe fn priority(&self) -> c_float;

        #[method(setPriority:)]
        pub unsafe fn setPriority(&self, priority: c_float);

        #[method(prefersIncrementalDelivery)]
        pub unsafe fn prefersIncrementalDelivery(&self) -> bool;

        #[method(setPrefersIncrementalDelivery:)]
        pub unsafe fn setPrefersIncrementalDelivery(&self, prefers_incremental_delivery: bool);

        #[deprecated = "Not supported"]
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[deprecated = "Not supported"]
        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

extern "C" {
    pub static NSURLSessionTaskPriorityDefault: c_float;
}

extern "C" {
    pub static NSURLSessionTaskPriorityLow: c_float;
}

extern "C" {
    pub static NSURLSessionTaskPriorityHigh: c_float;
}

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSURLSessionDataTask;

    unsafe impl ClassType for NSURLSessionDataTask {
        #[inherits(NSObject)]
        type Super = NSURLSessionTask;
        type Mutability = InteriorMutable;
    }
);

unsafe impl Send for NSURLSessionDataTask {}

unsafe impl Sync for NSURLSessionDataTask {}

#[cfg(feature = "NSObject")]
unsafe impl NSCopying for NSURLSessionDataTask {}

unsafe impl NSObjectProtocol for NSURLSessionDataTask {}

#[cfg(feature = "NSProgress")]
unsafe impl NSProgressReporting for NSURLSessionDataTask {}

extern_methods!(
    unsafe impl NSURLSessionDataTask {
        #[deprecated = "Please use -[NSURLSession dataTaskWithRequest:] or other NSURLSession methods to create instances"]
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[deprecated = "Please use -[NSURLSession dataTaskWithRequest:] or other NSURLSession methods to create instances"]
        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSURLSessionUploadTask;

    unsafe impl ClassType for NSURLSessionUploadTask {
        #[inherits(NSURLSessionTask, NSObject)]
        type Super = NSURLSessionDataTask;
        type Mutability = InteriorMutable;
    }
);

unsafe impl Send for NSURLSessionUploadTask {}

unsafe impl Sync for NSURLSessionUploadTask {}

#[cfg(feature = "NSObject")]
unsafe impl NSCopying for NSURLSessionUploadTask {}

unsafe impl NSObjectProtocol for NSURLSessionUploadTask {}

#[cfg(feature = "NSProgress")]
unsafe impl NSProgressReporting for NSURLSessionUploadTask {}

extern_methods!(
    unsafe impl NSURLSessionUploadTask {
        #[deprecated = "Please use -[NSURLSession uploadTaskWithStreamedRequest:] or other NSURLSession methods to create instances"]
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[deprecated = "Please use -[NSURLSession uploadTaskWithStreamedRequest:] or other NSURLSession methods to create instances"]
        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;

        #[cfg(all(feature = "NSData", feature = "block2"))]
        #[method(cancelByProducingResumeData:)]
        pub unsafe fn cancelByProducingResumeData(
            &self,
            completion_handler: &block2::Block<dyn Fn(*mut NSData)>,
        );
    }
);

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSURLSessionDownloadTask;

    unsafe impl ClassType for NSURLSessionDownloadTask {
        #[inherits(NSObject)]
        type Super = NSURLSessionTask;
        type Mutability = InteriorMutable;
    }
);

unsafe impl Send for NSURLSessionDownloadTask {}

unsafe impl Sync for NSURLSessionDownloadTask {}

#[cfg(feature = "NSObject")]
unsafe impl NSCopying for NSURLSessionDownloadTask {}

unsafe impl NSObjectProtocol for NSURLSessionDownloadTask {}

#[cfg(feature = "NSProgress")]
unsafe impl NSProgressReporting for NSURLSessionDownloadTask {}

extern_methods!(
    unsafe impl NSURLSessionDownloadTask {
        #[cfg(all(feature = "NSData", feature = "block2"))]
        #[method(cancelByProducingResumeData:)]
        pub unsafe fn cancelByProducingResumeData(
            &self,
            completion_handler: &block2::Block<dyn Fn(*mut NSData)>,
        );

        #[deprecated = "Please use -[NSURLSession downloadTaskWithRequest:] or other NSURLSession methods to create instances"]
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[deprecated = "Please use -[NSURLSession downloadTaskWithRequest:] or other NSURLSession methods to create instances"]
        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSURLSessionStreamTask;

    unsafe impl ClassType for NSURLSessionStreamTask {
        #[inherits(NSObject)]
        type Super = NSURLSessionTask;
        type Mutability = InteriorMutable;
    }
);

unsafe impl Send for NSURLSessionStreamTask {}

unsafe impl Sync for NSURLSessionStreamTask {}

#[cfg(feature = "NSObject")]
unsafe impl NSCopying for NSURLSessionStreamTask {}

unsafe impl NSObjectProtocol for NSURLSessionStreamTask {}

#[cfg(feature = "NSProgress")]
unsafe impl NSProgressReporting for NSURLSessionStreamTask {}

extern_methods!(
    unsafe impl NSURLSessionStreamTask {
        #[cfg(all(
            feature = "NSData",
            feature = "NSDate",
            feature = "NSError",
            feature = "block2"
        ))]
        #[method(readDataOfMinLength:maxLength:timeout:completionHandler:)]
        pub unsafe fn readDataOfMinLength_maxLength_timeout_completionHandler(
            &self,
            min_bytes: NSUInteger,
            max_bytes: NSUInteger,
            timeout: NSTimeInterval,
            completion_handler: &block2::Block<dyn Fn(*mut NSData, Bool, *mut NSError)>,
        );

        #[cfg(all(
            feature = "NSData",
            feature = "NSDate",
            feature = "NSError",
            feature = "block2"
        ))]
        #[method(writeData:timeout:completionHandler:)]
        pub unsafe fn writeData_timeout_completionHandler(
            &self,
            data: &NSData,
            timeout: NSTimeInterval,
            completion_handler: &block2::Block<dyn Fn(*mut NSError)>,
        );

        #[method(captureStreams)]
        pub unsafe fn captureStreams(&self);

        #[method(closeWrite)]
        pub unsafe fn closeWrite(&self);

        #[method(closeRead)]
        pub unsafe fn closeRead(&self);

        #[method(startSecureConnection)]
        pub unsafe fn startSecureConnection(&self);

        #[deprecated = "TLS cannot be disabled once it is enabled"]
        #[method(stopSecureConnection)]
        pub unsafe fn stopSecureConnection(&self);

        #[deprecated = "Please use -[NSURLSession streamTaskWithHostName:port:] or other NSURLSession methods to create instances"]
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[deprecated = "Please use -[NSURLSession streamTaskWithHostName:port:] or other NSURLSession methods to create instances"]
        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSURLSessionWebSocketMessageType(pub NSInteger);
impl NSURLSessionWebSocketMessageType {
    #[doc(alias = "NSURLSessionWebSocketMessageTypeData")]
    pub const Data: Self = Self(0);
    #[doc(alias = "NSURLSessionWebSocketMessageTypeString")]
    pub const String: Self = Self(1);
}

unsafe impl Encode for NSURLSessionWebSocketMessageType {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSURLSessionWebSocketMessageType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSURLSessionWebSocketMessage;

    unsafe impl ClassType for NSURLSessionWebSocketMessage {
        type Super = NSObject;
        type Mutability = InteriorMutable;
    }
);

unsafe impl Send for NSURLSessionWebSocketMessage {}

unsafe impl Sync for NSURLSessionWebSocketMessage {}

unsafe impl NSObjectProtocol for NSURLSessionWebSocketMessage {}

extern_methods!(
    unsafe impl NSURLSessionWebSocketMessage {
        #[cfg(feature = "NSData")]
        #[method_id(@__retain_semantics Init initWithData:)]
        pub unsafe fn initWithData(this: Allocated<Self>, data: &NSData) -> Retained<Self>;

        #[cfg(feature = "NSString")]
        #[method_id(@__retain_semantics Init initWithString:)]
        pub unsafe fn initWithString(this: Allocated<Self>, string: &NSString) -> Retained<Self>;

        #[method(type)]
        pub unsafe fn r#type(&self) -> NSURLSessionWebSocketMessageType;

        #[cfg(feature = "NSData")]
        #[method_id(@__retain_semantics Other data)]
        pub unsafe fn data(&self) -> Option<Retained<NSData>>;

        #[cfg(feature = "NSString")]
        #[method_id(@__retain_semantics Other string)]
        pub unsafe fn string(&self) -> Option<Retained<NSString>>;

        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSURLSessionWebSocketCloseCode(pub NSInteger);
impl NSURLSessionWebSocketCloseCode {
    #[doc(alias = "NSURLSessionWebSocketCloseCodeInvalid")]
    pub const Invalid: Self = Self(0);
    #[doc(alias = "NSURLSessionWebSocketCloseCodeNormalClosure")]
    pub const NormalClosure: Self = Self(1000);
    #[doc(alias = "NSURLSessionWebSocketCloseCodeGoingAway")]
    pub const GoingAway: Self = Self(1001);
    #[doc(alias = "NSURLSessionWebSocketCloseCodeProtocolError")]
    pub const ProtocolError: Self = Self(1002);
    #[doc(alias = "NSURLSessionWebSocketCloseCodeUnsupportedData")]
    pub const UnsupportedData: Self = Self(1003);
    #[doc(alias = "NSURLSessionWebSocketCloseCodeNoStatusReceived")]
    pub const NoStatusReceived: Self = Self(1005);
    #[doc(alias = "NSURLSessionWebSocketCloseCodeAbnormalClosure")]
    pub const AbnormalClosure: Self = Self(1006);
    #[doc(alias = "NSURLSessionWebSocketCloseCodeInvalidFramePayloadData")]
    pub const InvalidFramePayloadData: Self = Self(1007);
    #[doc(alias = "NSURLSessionWebSocketCloseCodePolicyViolation")]
    pub const PolicyViolation: Self = Self(1008);
    #[doc(alias = "NSURLSessionWebSocketCloseCodeMessageTooBig")]
    pub const MessageTooBig: Self = Self(1009);
    #[doc(alias = "NSURLSessionWebSocketCloseCodeMandatoryExtensionMissing")]
    pub const MandatoryExtensionMissing: Self = Self(1010);
    #[doc(alias = "NSURLSessionWebSocketCloseCodeInternalServerError")]
    pub const InternalServerError: Self = Self(1011);
    #[doc(alias = "NSURLSessionWebSocketCloseCodeTLSHandshakeFailure")]
    pub const TLSHandshakeFailure: Self = Self(1015);
}

unsafe impl Encode for NSURLSessionWebSocketCloseCode {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSURLSessionWebSocketCloseCode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSURLSessionWebSocketTask;

    unsafe impl ClassType for NSURLSessionWebSocketTask {
        #[inherits(NSObject)]
        type Super = NSURLSessionTask;
        type Mutability = InteriorMutable;
    }
);

unsafe impl Send for NSURLSessionWebSocketTask {}

unsafe impl Sync for NSURLSessionWebSocketTask {}

#[cfg(feature = "NSObject")]
unsafe impl NSCopying for NSURLSessionWebSocketTask {}

unsafe impl NSObjectProtocol for NSURLSessionWebSocketTask {}

#[cfg(feature = "NSProgress")]
unsafe impl NSProgressReporting for NSURLSessionWebSocketTask {}

extern_methods!(
    unsafe impl NSURLSessionWebSocketTask {
        #[cfg(all(feature = "NSError", feature = "block2"))]
        #[method(sendMessage:completionHandler:)]
        pub unsafe fn sendMessage_completionHandler(
            &self,
            message: &NSURLSessionWebSocketMessage,
            completion_handler: &block2::Block<dyn Fn(*mut NSError)>,
        );

        #[cfg(all(feature = "NSError", feature = "block2"))]
        #[method(receiveMessageWithCompletionHandler:)]
        pub unsafe fn receiveMessageWithCompletionHandler(
            &self,
            completion_handler: &block2::Block<
                dyn Fn(*mut NSURLSessionWebSocketMessage, *mut NSError),
            >,
        );

        #[cfg(all(feature = "NSError", feature = "block2"))]
        #[method(sendPingWithPongReceiveHandler:)]
        pub unsafe fn sendPingWithPongReceiveHandler(
            &self,
            pong_receive_handler: &block2::Block<dyn Fn(*mut NSError)>,
        );

        #[cfg(feature = "NSData")]
        #[method(cancelWithCloseCode:reason:)]
        pub unsafe fn cancelWithCloseCode_reason(
            &self,
            close_code: NSURLSessionWebSocketCloseCode,
            reason: Option<&NSData>,
        );

        #[method(maximumMessageSize)]
        pub unsafe fn maximumMessageSize(&self) -> NSInteger;

        #[method(setMaximumMessageSize:)]
        pub unsafe fn setMaximumMessageSize(&self, maximum_message_size: NSInteger);

        #[method(closeCode)]
        pub unsafe fn closeCode(&self) -> NSURLSessionWebSocketCloseCode;

        #[cfg(feature = "NSData")]
        #[method_id(@__retain_semantics Other closeReason)]
        pub unsafe fn closeReason(&self) -> Option<Retained<NSData>>;

        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSURLSessionMultipathServiceType(pub NSInteger);
impl NSURLSessionMultipathServiceType {
    #[doc(alias = "NSURLSessionMultipathServiceTypeNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "NSURLSessionMultipathServiceTypeHandover")]
    pub const Handover: Self = Self(1);
    #[doc(alias = "NSURLSessionMultipathServiceTypeInteractive")]
    pub const Interactive: Self = Self(2);
    #[doc(alias = "NSURLSessionMultipathServiceTypeAggregate")]
    pub const Aggregate: Self = Self(3);
}

unsafe impl Encode for NSURLSessionMultipathServiceType {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSURLSessionMultipathServiceType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSURLSessionConfiguration;

    unsafe impl ClassType for NSURLSessionConfiguration {
        type Super = NSObject;
        type Mutability = InteriorMutable;
    }
);

unsafe impl Send for NSURLSessionConfiguration {}

unsafe impl Sync for NSURLSessionConfiguration {}

#[cfg(feature = "NSObject")]
unsafe impl NSCopying for NSURLSessionConfiguration {}

unsafe impl NSObjectProtocol for NSURLSessionConfiguration {}

extern_methods!(
    unsafe impl NSURLSessionConfiguration {
        #[method_id(@__retain_semantics Other defaultSessionConfiguration)]
        pub unsafe fn defaultSessionConfiguration() -> Retained<NSURLSessionConfiguration>;

        #[method_id(@__retain_semantics Other ephemeralSessionConfiguration)]
        pub unsafe fn ephemeralSessionConfiguration() -> Retained<NSURLSessionConfiguration>;

        #[cfg(feature = "NSString")]
        #[method_id(@__retain_semantics Other backgroundSessionConfigurationWithIdentifier:)]
        pub unsafe fn backgroundSessionConfigurationWithIdentifier(
            identifier: &NSString,
        ) -> Retained<NSURLSessionConfiguration>;

        #[cfg(feature = "NSString")]
        #[method_id(@__retain_semantics Other identifier)]
        pub unsafe fn identifier(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSURLRequest")]
        #[method(requestCachePolicy)]
        pub unsafe fn requestCachePolicy(&self) -> NSURLRequestCachePolicy;

        #[cfg(feature = "NSURLRequest")]
        #[method(setRequestCachePolicy:)]
        pub unsafe fn setRequestCachePolicy(&self, request_cache_policy: NSURLRequestCachePolicy);

        #[cfg(feature = "NSDate")]
        #[method(timeoutIntervalForRequest)]
        pub unsafe fn timeoutIntervalForRequest(&self) -> NSTimeInterval;

        #[cfg(feature = "NSDate")]
        #[method(setTimeoutIntervalForRequest:)]
        pub unsafe fn setTimeoutIntervalForRequest(
            &self,
            timeout_interval_for_request: NSTimeInterval,
        );

        #[cfg(feature = "NSDate")]
        #[method(timeoutIntervalForResource)]
        pub unsafe fn timeoutIntervalForResource(&self) -> NSTimeInterval;

        #[cfg(feature = "NSDate")]
        #[method(setTimeoutIntervalForResource:)]
        pub unsafe fn setTimeoutIntervalForResource(
            &self,
            timeout_interval_for_resource: NSTimeInterval,
        );

        #[cfg(feature = "NSURLRequest")]
        #[method(networkServiceType)]
        pub unsafe fn networkServiceType(&self) -> NSURLRequestNetworkServiceType;

        #[cfg(feature = "NSURLRequest")]
        #[method(setNetworkServiceType:)]
        pub unsafe fn setNetworkServiceType(
            &self,
            network_service_type: NSURLRequestNetworkServiceType,
        );

        #[method(allowsCellularAccess)]
        pub unsafe fn allowsCellularAccess(&self) -> bool;

        #[method(setAllowsCellularAccess:)]
        pub unsafe fn setAllowsCellularAccess(&self, allows_cellular_access: bool);

        #[method(allowsExpensiveNetworkAccess)]
        pub unsafe fn allowsExpensiveNetworkAccess(&self) -> bool;

        #[method(setAllowsExpensiveNetworkAccess:)]
        pub unsafe fn setAllowsExpensiveNetworkAccess(&self, allows_expensive_network_access: bool);

        #[method(allowsConstrainedNetworkAccess)]
        pub unsafe fn allowsConstrainedNetworkAccess(&self) -> bool;

        #[method(setAllowsConstrainedNetworkAccess:)]
        pub unsafe fn setAllowsConstrainedNetworkAccess(
            &self,
            allows_constrained_network_access: bool,
        );

        #[method(requiresDNSSECValidation)]
        pub unsafe fn requiresDNSSECValidation(&self) -> bool;

        #[method(setRequiresDNSSECValidation:)]
        pub unsafe fn setRequiresDNSSECValidation(&self, requires_dnssec_validation: bool);

        #[method(waitsForConnectivity)]
        pub unsafe fn waitsForConnectivity(&self) -> bool;

        #[method(setWaitsForConnectivity:)]
        pub unsafe fn setWaitsForConnectivity(&self, waits_for_connectivity: bool);

        #[method(isDiscretionary)]
        pub unsafe fn isDiscretionary(&self) -> bool;

        #[method(setDiscretionary:)]
        pub unsafe fn setDiscretionary(&self, discretionary: bool);

        #[cfg(feature = "NSString")]
        #[method_id(@__retain_semantics Other sharedContainerIdentifier)]
        pub unsafe fn sharedContainerIdentifier(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[method(setSharedContainerIdentifier:)]
        pub unsafe fn setSharedContainerIdentifier(
            &self,
            shared_container_identifier: Option<&NSString>,
        );

        #[method(sessionSendsLaunchEvents)]
        pub unsafe fn sessionSendsLaunchEvents(&self) -> bool;

        #[method(setSessionSendsLaunchEvents:)]
        pub unsafe fn setSessionSendsLaunchEvents(&self, session_sends_launch_events: bool);

        #[cfg(feature = "NSDictionary")]
        #[method_id(@__retain_semantics Other connectionProxyDictionary)]
        pub unsafe fn connectionProxyDictionary(&self) -> Option<Retained<NSDictionary>>;

        #[cfg(feature = "NSDictionary")]
        #[method(setConnectionProxyDictionary:)]
        pub unsafe fn setConnectionProxyDictionary(
            &self,
            connection_proxy_dictionary: Option<&NSDictionary>,
        );

        #[method(HTTPShouldUsePipelining)]
        pub unsafe fn HTTPShouldUsePipelining(&self) -> bool;

        #[method(setHTTPShouldUsePipelining:)]
        pub unsafe fn setHTTPShouldUsePipelining(&self, http_should_use_pipelining: bool);

        #[method(HTTPShouldSetCookies)]
        pub unsafe fn HTTPShouldSetCookies(&self) -> bool;

        #[method(setHTTPShouldSetCookies:)]
        pub unsafe fn setHTTPShouldSetCookies(&self, http_should_set_cookies: bool);

        #[cfg(feature = "NSHTTPCookieStorage")]
        #[method(HTTPCookieAcceptPolicy)]
        pub unsafe fn HTTPCookieAcceptPolicy(&self) -> NSHTTPCookieAcceptPolicy;

        #[cfg(feature = "NSHTTPCookieStorage")]
        #[method(setHTTPCookieAcceptPolicy:)]
        pub unsafe fn setHTTPCookieAcceptPolicy(
            &self,
            http_cookie_accept_policy: NSHTTPCookieAcceptPolicy,
        );

        #[cfg(feature = "NSDictionary")]
        #[method_id(@__retain_semantics Other HTTPAdditionalHeaders)]
        pub unsafe fn HTTPAdditionalHeaders(&self) -> Option<Retained<NSDictionary>>;

        #[cfg(feature = "NSDictionary")]
        #[method(setHTTPAdditionalHeaders:)]
        pub unsafe fn setHTTPAdditionalHeaders(
            &self,
            http_additional_headers: Option<&NSDictionary>,
        );

        #[method(HTTPMaximumConnectionsPerHost)]
        pub unsafe fn HTTPMaximumConnectionsPerHost(&self) -> NSInteger;

        #[method(setHTTPMaximumConnectionsPerHost:)]
        pub unsafe fn setHTTPMaximumConnectionsPerHost(
            &self,
            http_maximum_connections_per_host: NSInteger,
        );

        #[cfg(feature = "NSHTTPCookieStorage")]
        #[method_id(@__retain_semantics Other HTTPCookieStorage)]
        pub unsafe fn HTTPCookieStorage(&self) -> Option<Retained<NSHTTPCookieStorage>>;

        #[cfg(feature = "NSHTTPCookieStorage")]
        #[method(setHTTPCookieStorage:)]
        pub unsafe fn setHTTPCookieStorage(
            &self,
            http_cookie_storage: Option<&NSHTTPCookieStorage>,
        );

        #[cfg(feature = "NSURLCredentialStorage")]
        #[method_id(@__retain_semantics Other URLCredentialStorage)]
        pub unsafe fn URLCredentialStorage(&self) -> Option<Retained<NSURLCredentialStorage>>;

        #[cfg(feature = "NSURLCredentialStorage")]
        #[method(setURLCredentialStorage:)]
        pub unsafe fn setURLCredentialStorage(
            &self,
            url_credential_storage: Option<&NSURLCredentialStorage>,
        );

        #[cfg(feature = "NSURLCache")]
        #[method_id(@__retain_semantics Other URLCache)]
        pub unsafe fn URLCache(&self) -> Option<Retained<NSURLCache>>;

        #[cfg(feature = "NSURLCache")]
        #[method(setURLCache:)]
        pub unsafe fn setURLCache(&self, url_cache: Option<&NSURLCache>);

        #[method(shouldUseExtendedBackgroundIdleMode)]
        pub unsafe fn shouldUseExtendedBackgroundIdleMode(&self) -> bool;

        #[method(setShouldUseExtendedBackgroundIdleMode:)]
        pub unsafe fn setShouldUseExtendedBackgroundIdleMode(
            &self,
            should_use_extended_background_idle_mode: bool,
        );

        #[cfg(feature = "NSArray")]
        #[method_id(@__retain_semantics Other protocolClasses)]
        pub unsafe fn protocolClasses(&self) -> Option<Retained<NSArray<TodoClass>>>;

        #[cfg(feature = "NSArray")]
        #[method(setProtocolClasses:)]
        pub unsafe fn setProtocolClasses(&self, protocol_classes: Option<&NSArray<TodoClass>>);

        #[method(multipathServiceType)]
        pub unsafe fn multipathServiceType(&self) -> NSURLSessionMultipathServiceType;

        #[method(setMultipathServiceType:)]
        pub unsafe fn setMultipathServiceType(
            &self,
            multipath_service_type: NSURLSessionMultipathServiceType,
        );

        #[deprecated = "Please use NSURLSessionConfiguration.defaultSessionConfiguration or other class methods to create instances"]
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[deprecated = "Please use NSURLSessionConfiguration.defaultSessionConfiguration or other class methods to create instances"]
        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSURLSessionDelayedRequestDisposition(pub NSInteger);
impl NSURLSessionDelayedRequestDisposition {
    pub const NSURLSessionDelayedRequestContinueLoading: Self = Self(0);
    pub const NSURLSessionDelayedRequestUseNewRequest: Self = Self(1);
    pub const NSURLSessionDelayedRequestCancel: Self = Self(2);
}

unsafe impl Encode for NSURLSessionDelayedRequestDisposition {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSURLSessionDelayedRequestDisposition {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSURLSessionAuthChallengeDisposition(pub NSInteger);
impl NSURLSessionAuthChallengeDisposition {
    pub const NSURLSessionAuthChallengeUseCredential: Self = Self(0);
    pub const NSURLSessionAuthChallengePerformDefaultHandling: Self = Self(1);
    pub const NSURLSessionAuthChallengeCancelAuthenticationChallenge: Self = Self(2);
    pub const NSURLSessionAuthChallengeRejectProtectionSpace: Self = Self(3);
}

unsafe impl Encode for NSURLSessionAuthChallengeDisposition {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSURLSessionAuthChallengeDisposition {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSURLSessionResponseDisposition(pub NSInteger);
impl NSURLSessionResponseDisposition {
    pub const NSURLSessionResponseCancel: Self = Self(0);
    pub const NSURLSessionResponseAllow: Self = Self(1);
    pub const NSURLSessionResponseBecomeDownload: Self = Self(2);
    pub const NSURLSessionResponseBecomeStream: Self = Self(3);
}

unsafe impl Encode for NSURLSessionResponseDisposition {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSURLSessionResponseDisposition {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    pub unsafe trait NSURLSessionDelegate: NSObjectProtocol {
        #[cfg(feature = "NSError")]
        #[optional]
        #[method(URLSession:didBecomeInvalidWithError:)]
        unsafe fn URLSession_didBecomeInvalidWithError(
            &self,
            session: &NSURLSession,
            error: Option<&NSError>,
        );

        #[cfg(all(
            feature = "NSURLAuthenticationChallenge",
            feature = "NSURLCredential",
            feature = "block2"
        ))]
        #[optional]
        #[method(URLSession:didReceiveChallenge:completionHandler:)]
        unsafe fn URLSession_didReceiveChallenge_completionHandler(
            &self,
            session: &NSURLSession,
            challenge: &NSURLAuthenticationChallenge,
            completion_handler: &block2::Block<
                dyn Fn(NSURLSessionAuthChallengeDisposition, *mut NSURLCredential),
            >,
        );

        #[optional]
        #[method(URLSessionDidFinishEventsForBackgroundURLSession:)]
        unsafe fn URLSessionDidFinishEventsForBackgroundURLSession(&self, session: &NSURLSession);
    }

    unsafe impl ProtocolType for dyn NSURLSessionDelegate {}
);

extern_protocol!(
    pub unsafe trait NSURLSessionTaskDelegate: NSURLSessionDelegate {
        #[optional]
        #[method(URLSession:didCreateTask:)]
        unsafe fn URLSession_didCreateTask(&self, session: &NSURLSession, task: &NSURLSessionTask);

        #[cfg(all(feature = "NSURLRequest", feature = "block2"))]
        #[optional]
        #[method(URLSession:task:willBeginDelayedRequest:completionHandler:)]
        unsafe fn URLSession_task_willBeginDelayedRequest_completionHandler(
            &self,
            session: &NSURLSession,
            task: &NSURLSessionTask,
            request: &NSURLRequest,
            completion_handler: &block2::Block<
                dyn Fn(NSURLSessionDelayedRequestDisposition, *mut NSURLRequest),
            >,
        );

        #[optional]
        #[method(URLSession:taskIsWaitingForConnectivity:)]
        unsafe fn URLSession_taskIsWaitingForConnectivity(
            &self,
            session: &NSURLSession,
            task: &NSURLSessionTask,
        );

        #[cfg(all(
            feature = "NSURLRequest",
            feature = "NSURLResponse",
            feature = "block2"
        ))]
        #[optional]
        #[method(URLSession:task:willPerformHTTPRedirection:newRequest:completionHandler:)]
        unsafe fn URLSession_task_willPerformHTTPRedirection_newRequest_completionHandler(
            &self,
            session: &NSURLSession,
            task: &NSURLSessionTask,
            response: &NSHTTPURLResponse,
            request: &NSURLRequest,
            completion_handler: &block2::Block<dyn Fn(*mut NSURLRequest)>,
        );

        #[cfg(all(
            feature = "NSURLAuthenticationChallenge",
            feature = "NSURLCredential",
            feature = "block2"
        ))]
        #[optional]
        #[method(URLSession:task:didReceiveChallenge:completionHandler:)]
        unsafe fn URLSession_task_didReceiveChallenge_completionHandler(
            &self,
            session: &NSURLSession,
            task: &NSURLSessionTask,
            challenge: &NSURLAuthenticationChallenge,
            completion_handler: &block2::Block<
                dyn Fn(NSURLSessionAuthChallengeDisposition, *mut NSURLCredential),
            >,
        );

        #[cfg(all(feature = "NSStream", feature = "block2"))]
        #[optional]
        #[method(URLSession:task:needNewBodyStream:)]
        unsafe fn URLSession_task_needNewBodyStream(
            &self,
            session: &NSURLSession,
            task: &NSURLSessionTask,
            completion_handler: &block2::Block<dyn Fn(*mut NSInputStream)>,
        );

        #[cfg(all(feature = "NSStream", feature = "block2"))]
        #[optional]
        #[method(URLSession:task:needNewBodyStreamFromOffset:completionHandler:)]
        unsafe fn URLSession_task_needNewBodyStreamFromOffset_completionHandler(
            &self,
            session: &NSURLSession,
            task: &NSURLSessionTask,
            offset: i64,
            completion_handler: &block2::Block<dyn Fn(*mut NSInputStream)>,
        );

        #[optional]
        #[method(URLSession:task:didSendBodyData:totalBytesSent:totalBytesExpectedToSend:)]
        unsafe fn URLSession_task_didSendBodyData_totalBytesSent_totalBytesExpectedToSend(
            &self,
            session: &NSURLSession,
            task: &NSURLSessionTask,
            bytes_sent: i64,
            total_bytes_sent: i64,
            total_bytes_expected_to_send: i64,
        );

        #[cfg(feature = "NSURLResponse")]
        #[optional]
        #[method(URLSession:task:didReceiveInformationalResponse:)]
        unsafe fn URLSession_task_didReceiveInformationalResponse(
            &self,
            session: &NSURLSession,
            task: &NSURLSessionTask,
            response: &NSHTTPURLResponse,
        );

        #[optional]
        #[method(URLSession:task:didFinishCollectingMetrics:)]
        unsafe fn URLSession_task_didFinishCollectingMetrics(
            &self,
            session: &NSURLSession,
            task: &NSURLSessionTask,
            metrics: &NSURLSessionTaskMetrics,
        );

        #[cfg(feature = "NSError")]
        #[optional]
        #[method(URLSession:task:didCompleteWithError:)]
        unsafe fn URLSession_task_didCompleteWithError(
            &self,
            session: &NSURLSession,
            task: &NSURLSessionTask,
            error: Option<&NSError>,
        );
    }

    unsafe impl ProtocolType for dyn NSURLSessionTaskDelegate {}
);

extern_protocol!(
    pub unsafe trait NSURLSessionDataDelegate: NSURLSessionTaskDelegate {
        #[cfg(all(feature = "NSURLResponse", feature = "block2"))]
        #[optional]
        #[method(URLSession:dataTask:didReceiveResponse:completionHandler:)]
        unsafe fn URLSession_dataTask_didReceiveResponse_completionHandler(
            &self,
            session: &NSURLSession,
            data_task: &NSURLSessionDataTask,
            response: &NSURLResponse,
            completion_handler: &block2::Block<dyn Fn(NSURLSessionResponseDisposition)>,
        );

        #[optional]
        #[method(URLSession:dataTask:didBecomeDownloadTask:)]
        unsafe fn URLSession_dataTask_didBecomeDownloadTask(
            &self,
            session: &NSURLSession,
            data_task: &NSURLSessionDataTask,
            download_task: &NSURLSessionDownloadTask,
        );

        #[optional]
        #[method(URLSession:dataTask:didBecomeStreamTask:)]
        unsafe fn URLSession_dataTask_didBecomeStreamTask(
            &self,
            session: &NSURLSession,
            data_task: &NSURLSessionDataTask,
            stream_task: &NSURLSessionStreamTask,
        );

        #[cfg(feature = "NSData")]
        #[optional]
        #[method(URLSession:dataTask:didReceiveData:)]
        unsafe fn URLSession_dataTask_didReceiveData(
            &self,
            session: &NSURLSession,
            data_task: &NSURLSessionDataTask,
            data: &NSData,
        );

        #[cfg(all(feature = "NSURLCache", feature = "block2"))]
        #[optional]
        #[method(URLSession:dataTask:willCacheResponse:completionHandler:)]
        unsafe fn URLSession_dataTask_willCacheResponse_completionHandler(
            &self,
            session: &NSURLSession,
            data_task: &NSURLSessionDataTask,
            proposed_response: &NSCachedURLResponse,
            completion_handler: &block2::Block<dyn Fn(*mut NSCachedURLResponse)>,
        );
    }

    unsafe impl ProtocolType for dyn NSURLSessionDataDelegate {}
);

extern_protocol!(
    pub unsafe trait NSURLSessionDownloadDelegate: NSURLSessionTaskDelegate {
        #[cfg(feature = "NSURL")]
        #[method(URLSession:downloadTask:didFinishDownloadingToURL:)]
        unsafe fn URLSession_downloadTask_didFinishDownloadingToURL(
            &self,
            session: &NSURLSession,
            download_task: &NSURLSessionDownloadTask,
            location: &NSURL,
        );

        #[optional]
        #[method(URLSession:downloadTask:didWriteData:totalBytesWritten:totalBytesExpectedToWrite:)]
        unsafe fn URLSession_downloadTask_didWriteData_totalBytesWritten_totalBytesExpectedToWrite(
            &self,
            session: &NSURLSession,
            download_task: &NSURLSessionDownloadTask,
            bytes_written: i64,
            total_bytes_written: i64,
            total_bytes_expected_to_write: i64,
        );

        #[optional]
        #[method(URLSession:downloadTask:didResumeAtOffset:expectedTotalBytes:)]
        unsafe fn URLSession_downloadTask_didResumeAtOffset_expectedTotalBytes(
            &self,
            session: &NSURLSession,
            download_task: &NSURLSessionDownloadTask,
            file_offset: i64,
            expected_total_bytes: i64,
        );
    }

    unsafe impl ProtocolType for dyn NSURLSessionDownloadDelegate {}
);

extern_protocol!(
    pub unsafe trait NSURLSessionStreamDelegate: NSURLSessionTaskDelegate {
        #[optional]
        #[method(URLSession:readClosedForStreamTask:)]
        unsafe fn URLSession_readClosedForStreamTask(
            &self,
            session: &NSURLSession,
            stream_task: &NSURLSessionStreamTask,
        );

        #[optional]
        #[method(URLSession:writeClosedForStreamTask:)]
        unsafe fn URLSession_writeClosedForStreamTask(
            &self,
            session: &NSURLSession,
            stream_task: &NSURLSessionStreamTask,
        );

        #[optional]
        #[method(URLSession:betterRouteDiscoveredForStreamTask:)]
        unsafe fn URLSession_betterRouteDiscoveredForStreamTask(
            &self,
            session: &NSURLSession,
            stream_task: &NSURLSessionStreamTask,
        );

        #[cfg(feature = "NSStream")]
        #[optional]
        #[method(URLSession:streamTask:didBecomeInputStream:outputStream:)]
        unsafe fn URLSession_streamTask_didBecomeInputStream_outputStream(
            &self,
            session: &NSURLSession,
            stream_task: &NSURLSessionStreamTask,
            input_stream: &NSInputStream,
            output_stream: &NSOutputStream,
        );
    }

    unsafe impl ProtocolType for dyn NSURLSessionStreamDelegate {}
);

extern_protocol!(
    pub unsafe trait NSURLSessionWebSocketDelegate: NSURLSessionTaskDelegate {
        #[cfg(feature = "NSString")]
        #[optional]
        #[method(URLSession:webSocketTask:didOpenWithProtocol:)]
        unsafe fn URLSession_webSocketTask_didOpenWithProtocol(
            &self,
            session: &NSURLSession,
            web_socket_task: &NSURLSessionWebSocketTask,
            protocol: Option<&NSString>,
        );

        #[cfg(feature = "NSData")]
        #[optional]
        #[method(URLSession:webSocketTask:didCloseWithCode:reason:)]
        unsafe fn URLSession_webSocketTask_didCloseWithCode_reason(
            &self,
            session: &NSURLSession,
            web_socket_task: &NSURLSessionWebSocketTask,
            close_code: NSURLSessionWebSocketCloseCode,
            reason: Option<&NSData>,
        );
    }

    unsafe impl ProtocolType for dyn NSURLSessionWebSocketDelegate {}
);

extern "C" {
    #[cfg(feature = "NSString")]
    pub static NSURLSessionDownloadTaskResumeData: &'static NSString;
}

extern "C" {
    #[cfg(feature = "NSString")]
    pub static NSURLSessionUploadTaskResumeData: &'static NSString;
}

extern_methods!(
    /// NSURLSessionDeprecated
    unsafe impl NSURLSessionConfiguration {
        #[cfg(feature = "NSString")]
        #[deprecated]
        #[method_id(@__retain_semantics Other backgroundSessionConfiguration:)]
        pub unsafe fn backgroundSessionConfiguration(
            identifier: &NSString,
        ) -> Retained<NSURLSessionConfiguration>;
    }
);

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSURLSessionTaskMetricsResourceFetchType(pub NSInteger);
impl NSURLSessionTaskMetricsResourceFetchType {
    #[doc(alias = "NSURLSessionTaskMetricsResourceFetchTypeUnknown")]
    pub const Unknown: Self = Self(0);
    #[doc(alias = "NSURLSessionTaskMetricsResourceFetchTypeNetworkLoad")]
    pub const NetworkLoad: Self = Self(1);
    #[doc(alias = "NSURLSessionTaskMetricsResourceFetchTypeServerPush")]
    pub const ServerPush: Self = Self(2);
    #[doc(alias = "NSURLSessionTaskMetricsResourceFetchTypeLocalCache")]
    pub const LocalCache: Self = Self(3);
}

unsafe impl Encode for NSURLSessionTaskMetricsResourceFetchType {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSURLSessionTaskMetricsResourceFetchType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSURLSessionTaskMetricsDomainResolutionProtocol(pub NSInteger);
impl NSURLSessionTaskMetricsDomainResolutionProtocol {
    #[doc(alias = "NSURLSessionTaskMetricsDomainResolutionProtocolUnknown")]
    pub const Unknown: Self = Self(0);
    #[doc(alias = "NSURLSessionTaskMetricsDomainResolutionProtocolUDP")]
    pub const UDP: Self = Self(1);
    #[doc(alias = "NSURLSessionTaskMetricsDomainResolutionProtocolTCP")]
    pub const TCP: Self = Self(2);
    #[doc(alias = "NSURLSessionTaskMetricsDomainResolutionProtocolTLS")]
    pub const TLS: Self = Self(3);
    #[doc(alias = "NSURLSessionTaskMetricsDomainResolutionProtocolHTTPS")]
    pub const HTTPS: Self = Self(4);
}

unsafe impl Encode for NSURLSessionTaskMetricsDomainResolutionProtocol {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSURLSessionTaskMetricsDomainResolutionProtocol {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSURLSessionTaskTransactionMetrics;

    unsafe impl ClassType for NSURLSessionTaskTransactionMetrics {
        type Super = NSObject;
        type Mutability = InteriorMutable;
    }
);

unsafe impl Send for NSURLSessionTaskTransactionMetrics {}

unsafe impl Sync for NSURLSessionTaskTransactionMetrics {}

unsafe impl NSObjectProtocol for NSURLSessionTaskTransactionMetrics {}

extern_methods!(
    unsafe impl NSURLSessionTaskTransactionMetrics {
        #[cfg(feature = "NSURLRequest")]
        #[method_id(@__retain_semantics Other request)]
        pub unsafe fn request(&self) -> Retained<NSURLRequest>;

        #[cfg(feature = "NSURLResponse")]
        #[method_id(@__retain_semantics Other response)]
        pub unsafe fn response(&self) -> Option<Retained<NSURLResponse>>;

        #[cfg(feature = "NSDate")]
        #[method_id(@__retain_semantics Other fetchStartDate)]
        pub unsafe fn fetchStartDate(&self) -> Option<Retained<NSDate>>;

        #[cfg(feature = "NSDate")]
        #[method_id(@__retain_semantics Other domainLookupStartDate)]
        pub unsafe fn domainLookupStartDate(&self) -> Option<Retained<NSDate>>;

        #[cfg(feature = "NSDate")]
        #[method_id(@__retain_semantics Other domainLookupEndDate)]
        pub unsafe fn domainLookupEndDate(&self) -> Option<Retained<NSDate>>;

        #[cfg(feature = "NSDate")]
        #[method_id(@__retain_semantics Other connectStartDate)]
        pub unsafe fn connectStartDate(&self) -> Option<Retained<NSDate>>;

        #[cfg(feature = "NSDate")]
        #[method_id(@__retain_semantics Other secureConnectionStartDate)]
        pub unsafe fn secureConnectionStartDate(&self) -> Option<Retained<NSDate>>;

        #[cfg(feature = "NSDate")]
        #[method_id(@__retain_semantics Other secureConnectionEndDate)]
        pub unsafe fn secureConnectionEndDate(&self) -> Option<Retained<NSDate>>;

        #[cfg(feature = "NSDate")]
        #[method_id(@__retain_semantics Other connectEndDate)]
        pub unsafe fn connectEndDate(&self) -> Option<Retained<NSDate>>;

        #[cfg(feature = "NSDate")]
        #[method_id(@__retain_semantics Other requestStartDate)]
        pub unsafe fn requestStartDate(&self) -> Option<Retained<NSDate>>;

        #[cfg(feature = "NSDate")]
        #[method_id(@__retain_semantics Other requestEndDate)]
        pub unsafe fn requestEndDate(&self) -> Option<Retained<NSDate>>;

        #[cfg(feature = "NSDate")]
        #[method_id(@__retain_semantics Other responseStartDate)]
        pub unsafe fn responseStartDate(&self) -> Option<Retained<NSDate>>;

        #[cfg(feature = "NSDate")]
        #[method_id(@__retain_semantics Other responseEndDate)]
        pub unsafe fn responseEndDate(&self) -> Option<Retained<NSDate>>;

        #[cfg(feature = "NSString")]
        #[method_id(@__retain_semantics Other networkProtocolName)]
        pub unsafe fn networkProtocolName(&self) -> Option<Retained<NSString>>;

        #[method(isProxyConnection)]
        pub unsafe fn isProxyConnection(&self) -> bool;

        #[method(isReusedConnection)]
        pub unsafe fn isReusedConnection(&self) -> bool;

        #[method(resourceFetchType)]
        pub unsafe fn resourceFetchType(&self) -> NSURLSessionTaskMetricsResourceFetchType;

        #[method(countOfRequestHeaderBytesSent)]
        pub unsafe fn countOfRequestHeaderBytesSent(&self) -> i64;

        #[method(countOfRequestBodyBytesSent)]
        pub unsafe fn countOfRequestBodyBytesSent(&self) -> i64;

        #[method(countOfRequestBodyBytesBeforeEncoding)]
        pub unsafe fn countOfRequestBodyBytesBeforeEncoding(&self) -> i64;

        #[method(countOfResponseHeaderBytesReceived)]
        pub unsafe fn countOfResponseHeaderBytesReceived(&self) -> i64;

        #[method(countOfResponseBodyBytesReceived)]
        pub unsafe fn countOfResponseBodyBytesReceived(&self) -> i64;

        #[method(countOfResponseBodyBytesAfterDecoding)]
        pub unsafe fn countOfResponseBodyBytesAfterDecoding(&self) -> i64;

        #[cfg(feature = "NSString")]
        #[method_id(@__retain_semantics Other localAddress)]
        pub unsafe fn localAddress(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSValue")]
        #[method_id(@__retain_semantics Other localPort)]
        pub unsafe fn localPort(&self) -> Option<Retained<NSNumber>>;

        #[cfg(feature = "NSString")]
        #[method_id(@__retain_semantics Other remoteAddress)]
        pub unsafe fn remoteAddress(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSValue")]
        #[method_id(@__retain_semantics Other remotePort)]
        pub unsafe fn remotePort(&self) -> Option<Retained<NSNumber>>;

        #[cfg(feature = "NSValue")]
        #[method_id(@__retain_semantics Other negotiatedTLSProtocolVersion)]
        pub unsafe fn negotiatedTLSProtocolVersion(&self) -> Option<Retained<NSNumber>>;

        #[cfg(feature = "NSValue")]
        #[method_id(@__retain_semantics Other negotiatedTLSCipherSuite)]
        pub unsafe fn negotiatedTLSCipherSuite(&self) -> Option<Retained<NSNumber>>;

        #[method(isCellular)]
        pub unsafe fn isCellular(&self) -> bool;

        #[method(isExpensive)]
        pub unsafe fn isExpensive(&self) -> bool;

        #[method(isConstrained)]
        pub unsafe fn isConstrained(&self) -> bool;

        #[method(isMultipath)]
        pub unsafe fn isMultipath(&self) -> bool;

        #[method(domainResolutionProtocol)]
        pub unsafe fn domainResolutionProtocol(
            &self,
        ) -> NSURLSessionTaskMetricsDomainResolutionProtocol;

        #[deprecated = "Not supported"]
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[deprecated = "Not supported"]
        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSURLSessionTaskMetrics;

    unsafe impl ClassType for NSURLSessionTaskMetrics {
        type Super = NSObject;
        type Mutability = InteriorMutable;
    }
);

unsafe impl Send for NSURLSessionTaskMetrics {}

unsafe impl Sync for NSURLSessionTaskMetrics {}

unsafe impl NSObjectProtocol for NSURLSessionTaskMetrics {}

extern_methods!(
    unsafe impl NSURLSessionTaskMetrics {
        #[cfg(feature = "NSArray")]
        #[method_id(@__retain_semantics Other transactionMetrics)]
        pub unsafe fn transactionMetrics(
            &self,
        ) -> Retained<NSArray<NSURLSessionTaskTransactionMetrics>>;

        #[cfg(feature = "NSDateInterval")]
        #[method_id(@__retain_semantics Other taskInterval)]
        pub unsafe fn taskInterval(&self) -> Retained<NSDateInterval>;

        #[method(redirectCount)]
        pub unsafe fn redirectCount(&self) -> NSUInteger;

        #[deprecated = "Not supported"]
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[deprecated = "Not supported"]
        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);
