/*
	file automatically generated by make_test_files.pl
	Tue Apr 19 14:01:02 2011
*/

/*****************************************************************************
 *                                                                           *
 *          UNU.RAN -- Universal Non-Uniform Random number generator         *
 *                                                                           *
 *****************************************************************************/
    
/**
 ** Tests for HINV
 **/
    
/*---------------------------------------------------------------------------*/
#include "testunuran.h"

#ifdef UNUR_URNG_DEFAULT_RNGSTREAM
#include <RngStream.h>
#endif
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* global variables                                                          */

static FILE *TESTLOG;               /* test log file                         */
static FILE *UNURANLOG;             /* unuran log file                       */

static int test_ok = TRUE;          /* all tests ok (boolean)                */
static int fullcheck = FALSE;       /* whether all checks are performed      */ 

static TIMER watch;                 /* stop watch                            */

/*---------------------------------------------------------------------------*/

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par );

int unur_hinv_set_verify( UNUR_PAR *par, int verify);


/*---------------------------------------------------------------------------*/

void test_new (void);
void test_set (void);
void test_get (void);
void test_chg (void);
void test_init (void);
void test_reinit (void);
void test_sample (void);
void test_validate (void);
void test_special(void);

/*---------------------------------------------------------------------------*/



#include <methods/x_gen_source.h>

/* constants */

#define UERROR_SAMPLESIZE (10000)

#define COMPARE_SAMPLE_SIZE   (500)
#define VIOLATE_SAMPLE_SIZE   (20)

/* #define SEED   (298346) */

#ifndef M_PI
#define M_PI       3.14159265358979323846264338328      /* pi */
#endif

#define set_debug_flag(par) \
   do { \
      if (fullcheck) unur_set_debug((par),~0u); \
      else           unur_set_debug((par),1u); \
   } while (0);

/* prototypes */

double sin_cdf( double x, const UNUR_DISTR *distr );
double sin_pdf( double x, const UNUR_DISTR *distr );
double sin_dpdf( double x, const UNUR_DISTR *distr );

double sin0_cdf( double x, const UNUR_DISTR *distr );
double sin0_pdf( double x, const UNUR_DISTR *distr );
double sin0_dpdf( double x, const UNUR_DISTR *distr );


int hinv_error_experiment( UNUR_PAR *par, int samplesize );

int chg_domain_experiment( UNUR_PAR *par, int samplesize );

int hinv_error_gen_experiment( UNUR_GEN *gen, 
    			       double u_resolution, int order, int samplesize ); 




/*---------------------------------------------------------------------------*/

#ifndef CHI2_FAILURES_TOLERATED
#  define CHI2_FAILURES_TOLERATED DEFAULT_CHI2_FAILURES_TOLERATED
#endif

/*---------------------------------------------------------------------------*/
/* [verbatim] */



/*---------------------------------------------------------------------------*/
/* Example of  a distribution with f(x)=0 at x=-0.25 and x=0.75              */
/*                                                                           */
/*          /  (1 +sin(2 Pi x))/2  if |x| <= 1                               */
/*  f(x) = <                                                                 */
/*          \  0        otherwise                                            */
/*                                                                           */
double sin_pdf( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{
  if (fabs(x) > 1.)
    return 0.;
  else
    return (0.5*(1.+sin((2.*M_PI)*x)));
} /* end of sin_pdf() */

/* The derivative of the PDF of our distribution:                */
double sin_dpdf( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{
  if (fabs(x) > 1.)
    return 0.;
  else
    return (M_PI*cos((2.*M_PI)*x));
} /* end of sin_dpdf() */

/* The CDF of our distribution:                                  */
double sin_cdf( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{
  if (x < -1.)
    return 0.;
  else if(x<=1.)
    return (1.+2.*M_PI*(1+x)-cos((2.*M_PI)*x))/(4.*M_PI);
  else return 1.;
} /* end of sin_cdf() */

/*---------------------------------------------------------------------------*/

/* Example of  a distribution with f(x)=0 in (-0.5,0)                        */
/*                                                                           */
/*          /  Max(sin(2 Pi x)),0)Pi/2  if -1 < x <0.5                       */
/*  f(x) = <                                                                 */
/*          \  0        otherwise                                            */
/*                                                                           */
double sin0_pdf( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{
  if (x < -1.) return 0.;
  if (x <= -0.5) return sin((2.*M_PI)*x)*0.5*M_PI;
  if (x < 0.) return 0.;
  if (x <= 0.5) return sin((2.*M_PI)*x)*0.5*M_PI;
  return 0.;
} /* end of sin0_pdf() */

/* The derivative of the PDF of our distribution:                */
double sin0_dpdf( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{
  if (x < -1.) return 0.;
  if (x <= -0.5) return cos((2.*M_PI)*x)*M_PI*M_PI;
  if (x < 0.) return 0.;
  if (x <= 0.5) return cos((2.*M_PI)*x)*M_PI*M_PI;
  return 0.;
} /* end of sin0_dpdf() */

/* The CDF of our distribution:                                  */
double sin0_cdf( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{
  if (x < -1.) return 0.;
  if(x<= -0.5) return 0.25*(1-cos((2.*M_PI)*x));
  if (x < 0.) return 0.5;
  if (x <= 0.5) return 0.75-0.25*cos((2.*M_PI)*x);
  return 1.;
} /* end of sin0_cdf() */



/*****************************************************************************/
/* run unur_test_u_error for a particular generator object and print result  */

int
hinv_error_gen_experiment( UNUR_GEN *gen,       /* generator object */
			   double u_resolution, /* maximal tolerated u-error */
			   int order,           /* order of polynomial */
			   int samplesize )     /* sample size for error experiment */
     /* returns 0 if maxerror < u_resolution, errorcode otherwise */
{   
  int i, nfpar;
  const double *fpar;     
  const UNUR_DISTR *distr = unur_get_distr(gen);
  const char *genid = unur_get_genid(gen);
  double score;

  /* print data about distribution */
  fprintf(TESTLOG,"%s: %s distribution",genid,unur_distr_get_name(distr));
  nfpar = unur_distr_cont_get_pdfparams(distr,&fpar);
  if (nfpar) { 
     fprintf(TESTLOG," with parameters ");
     for(i=0;i<nfpar;i++) fprintf(TESTLOG," | %g",fpar[i]);
     fprintf(TESTLOG," |");
  }
  fprintf(TESTLOG,":\n");

  /* print chosen parameter for method HINV and for experiment */
  fprintf(TESTLOG,"%s:   setting: order = %d, u-error <= %g, samplesize = %d\n",
                  genid,order,u_resolution,samplesize);
  fprintf(TESTLOG,"%s:   #intervals = %d\n",genid,unur_hinv_get_n_intervals(gen));

  /* run test */
  score = run_validate_u_error( TESTLOG, gen, distr, u_resolution, samplesize );

  /* return score */
  return score;

} /* end of hinv_error_gen_experiment() */

/*****************************************************************************/
/* run experiment for a particular distribution object                       */

int
hinv_error_experiment( UNUR_PAR *par,     /* parameter object */
		       int samplesize )   /* samplesize for error experiment */
     /* returns 0 if maxerror < u_resolution, errorcode otherwise */
{ 
  UNUR_PAR *par_clone;  /* working copy of parameter object */
  UNUR_GEN *gen;        /* generator object */

  int order = 3;
  double u_resolution = 1.e-8;  /* (maximal) tolerated u-error */
  int errorsum = 0;

  /* check for invalid NULL pointer */
  if (par==NULL) {
     printf(" NULL! ");
     return 1000;
  }

  for ( u_resolution = 1.e-6; u_resolution > 1.e-13; u_resolution *= 0.01 ) {
     for ( order=(u_resolution<1.e-9 ? 3:1); order<=5; order+=2) {

       /* make a working copy */
       par_clone = _unur_par_clone(par);

       /* create generator object */
       unur_hinv_set_order(par_clone,order);
       unur_hinv_set_u_resolution(par_clone,u_resolution);
       set_debug_flag(par_clone);
       gen = unur_init(par_clone);

       /* run test */
       errorsum += hinv_error_gen_experiment(gen, u_resolution, order, samplesize);
       fprintf(TESTLOG,"\n");

       /* clear memory */
       unur_free(gen);
     }
  }

  unur_par_free(par);

  return errorsum;
} /* end of hinv_error_experiment() */

/*****************************************************************************/
/* run test with truncated distributions                                     */

int
chg_domain_experiment( UNUR_PAR *par,   /* generator object */
		       int samplesize ) /* sample size for experiment */
     /* returns 0 if maxerror < u_resolution, errorcode otherwise */
{ 
  int k;
  int result = 0;
  UNUR_GEN *gen;           /* generator object */
  double left, right;      /* border of userdefined original domain */
  double newleft, newright;

  double u_resolution = 1.e-10;  /* maximal tolerated u-error */
  int order = 3;           /* order of polynomial */

  unur_hinv_set_order(par,order);
  unur_hinv_set_u_resolution(par,u_resolution);
  gen = unur_init(par);

  unur_distr_cont_get_domain(unur_get_distr(gen), &left, &right );
  if (left <= UNUR_INFINITY) 
     left = unur_hinv_eval_approxinvcdf(gen, 1.e-10);
  if (right >= UNUR_INFINITY) 
     right = unur_hinv_eval_approxinvcdf(gen, 1-1.e-10);

  for(k=1; k<=10;k++){
    newleft = left + k*0.05*(right-left);
    newright = right - k*0.04*(right-left);
    unur_hinv_chg_truncated(gen, newleft, newright);
    result += hinv_error_gen_experiment(gen, u_resolution, order, samplesize/10);
  }

  unur_hinv_chg_truncated(gen, left, right);
  result += hinv_error_gen_experiment(gen, u_resolution, order, samplesize/10);

  unur_free(gen);
  
  return result;
} /* end of chg_domain_experiment() */

/*****************************************************************************/
/*---------------------------------------------------------------------------*/
/* [new] */

void test_new (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[new "); fflush(stdout);
	fprintf(TESTLOG,"\n[new]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_DISTR *distr = NULL;
   distr = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,60,(unur_hinv_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,60,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid distribution type */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_discr_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,66,(unur_hinv_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,66,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* data missing in distribution object */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_cont_new(); 


unur_reset_errno();
/* cdf */
n_tests_failed += (check_expected_NULL(TESTLOG,73,(unur_hinv_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,73,UNUR_ERR_DISTR_REQUIRED)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_new() */

/*---------------------------------------------------------------------------*/
/* [set] */

void test_set (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[set "); fflush(stdout);
	fprintf(TESTLOG,"\n[set]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_PAR   *par = NULL;
   double stp[] = {1.,2.,3.};
   par = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,84,(unur_hinv_set_order( par, 3 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,84,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,87,(unur_hinv_set_u_resolution( par, 1.e-8 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,87,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,90,(unur_hinv_set_cpoints(par,stp,3)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,90,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,93,(unur_hinv_set_boundary(par,1.,3.)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,93,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,96,(unur_hinv_set_guidefactor( par, 2. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,96,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,99,(unur_hinv_set_max_intervals(par,10000)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,99,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
}

{ /* invalid parameter object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   double fpar[2] = {0.,1.};
   double stp[] = {1.,2.,3.};
   distr = unur_distr_normal(fpar,2);
   par = unur_arou_new(distr); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,108,(unur_hinv_set_order( par, 3 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,108,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,111,(unur_hinv_set_u_resolution( par, 1.e-8 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,111,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,114,(unur_hinv_set_cpoints(par,stp,3)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,114,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,117,(unur_hinv_set_boundary(par,1.,3.)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,117,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,120,(unur_hinv_set_guidefactor( par, 2. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,120,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,123,(unur_hinv_set_max_intervals(par,10000)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,123,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;
unur_par_free(par);
unur_distr_free(distr);
}

{ /* invalid parameters */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   double fpar[2] = {0.,1.};
   double stp[] = {1.,2.,-3.};
   distr = unur_distr_normal(fpar,2);
   par = unur_hinv_new(distr); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,134,(unur_hinv_set_order( par, 30 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,134,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,137,(unur_hinv_set_u_resolution( par, 1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,137,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,140,(unur_hinv_set_cpoints(par,stp,3)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,140,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,143,(unur_hinv_set_boundary(par,1.,-3.)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,143,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,146,(unur_hinv_set_boundary(par,1.,UNUR_INFINITY)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,146,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,149,(unur_hinv_set_guidefactor( par, -2. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,149,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,152,(unur_hinv_set_max_intervals(par,0)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,152,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;
unur_par_free(par);
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_set() */

/*---------------------------------------------------------------------------*/
/* [get] */

void test_get (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[get "); fflush(stdout);
	fprintf(TESTLOG,"\n[get]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid generator object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = unur_distr_normal(NULL,0);
   par = unur_tdr_new(distr);
   gen = unur_init(par); 
abort_if_NULL(TESTLOG, 162,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_zero(TESTLOG,166,(unur_hinv_get_n_intervals(gen)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,166,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_get() */

/*---------------------------------------------------------------------------*/
/* [chg] */

void test_chg (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[chg "); fflush(stdout);
	fprintf(TESTLOG,"\n[chg]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid generator object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double fpar[2] = {0.,1.};
   distr = unur_distr_normal(fpar,2);
   unur_distr_cont_set_domain(distr,-1.,2.);
   par = unur_hinv_new(distr);
   unur_set_debug(par,0);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 178,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,182,(unur_hinv_chg_truncated( gen, 1., 0. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,182,UNUR_ERR_DISTR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_hinv_chg_truncated( gen, -2., 0. );
n_tests_failed += (check_errorcode(TESTLOG,185,UNUR_ERR_DISTR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_hinv_chg_truncated( gen, 0., 10. );
n_tests_failed += (check_errorcode(TESTLOG,188,UNUR_ERR_DISTR_SET)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_chg() */

/*---------------------------------------------------------------------------*/
/* [reinit] */

void test_reinit (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[reinit "); fflush(stdout);
	fprintf(TESTLOG,"\n[reinit]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* exists */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = unur_distr_normal(NULL,0);
   par = unur_hinv_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 201,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_reinit(TESTLOG,205,(unur_reinit( gen )))==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_reinit() */

/*---------------------------------------------------------------------------*/
/* [sample] */

void test_sample (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[sample "); fflush(stdout);
	fprintf(TESTLOG,"\n[sample]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_GEN   *gen = NULL;
   gen = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,215,(unur_hinv_eval_approxinvcdf(gen,0.5)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,215,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_free(gen);
}

{ /* invalid generator object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = unur_distr_normal(NULL,0);
   par = unur_tdr_new(distr);
   gen = unur_init(par); 
abort_if_NULL(TESTLOG, 221,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,225,(unur_hinv_eval_approxinvcdf(gen,0.5)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,225,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* invalid domain */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = unur_distr_normal(NULL,0);
   par = unur_hinv_new(distr);
   unur_set_debug(par,0);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 231,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,235,(unur_hinv_eval_approxinvcdf(gen,1.5)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,235,UNUR_ERR_DOMAIN)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_negINFINITY(TESTLOG,238,(unur_hinv_eval_approxinvcdf(gen,-0.5)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,238,UNUR_ERR_DOMAIN)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare clone */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   UNUR_GEN *clone;
   distr = unur_distr_normal(NULL,0); 
   par = NULL;
   gen = NULL; 


unur_reset_errno();
/* original generator object */
par = unur_hinv_new(distr);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,251,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,257,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare reinit */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = unur_distr_normal(NULL,0); 
   par = NULL;
   gen = NULL; 


unur_reset_errno();
/* original generator object */
par = unur_hinv_new(distr);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,269,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* reinit */
unur_reinit(gen);
n_tests_failed += (compare_sequence_gen(TESTLOG,273,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare stringparser */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double fpar[] = {3.,4.};
   distr = NULL;
   par = NULL;
   gen = NULL; 


unur_reset_errno();
distr = unur_distr_gamma(fpar,2);
unur_distr_cont_set_domain(distr,2.,UNUR_INFINITY);
par = unur_hinv_new(distr);
set_debug_flag(par);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,289,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "gamma(3.,4.); domain = 2,infinity & \
  method = hinv; debug = 0x1" );
n_tests_failed += (compare_sequence_gen(TESTLOG,295,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
distr = unur_distr_normal(NULL,0);
unur_distr_cont_set_domain(distr,2.,UNUR_INFINITY);
par = unur_hinv_new(distr);
unur_hinv_set_order(par,1);
unur_hinv_set_max_intervals(par,1000);
unur_hinv_set_u_resolution(par,0.001);
unur_hinv_set_boundary(par,2.,5.);
set_debug_flag(par);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,308,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "normal; domain = (2,inf) & \
         method = hinv; order = 1; max_intervals = 1000; u_resolution = 0.001; \
         boundary = (2,5); debug = 0x1" );
n_tests_failed += (compare_sequence_gen(TESTLOG,315,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_sample() */

/*---------------------------------------------------------------------------*/
/* [validate] */

/*---------------------------------------------------------------------------*/

/* [validate] */

void test_validate (void)
{
	UNUR_DISTR *distr[44];
	UNUR_PAR *par;
	UNUR_GEN *gen;
	int n_tests_failed;
	int rcode;
	double *darray;
	double fpm[10];

	rcode = 0;

	/* start test */
	printf("[validate "); fflush(stdout);
	fprintf(TESTLOG,"\n[validate]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);


/* distributions: 44 */
{
fpm[0] = 1.;
fpm[1] = 2.;
distr[0] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 1.;
fpm[1] = 5.;
distr[1] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 1.;
fpm[1] = 100.;
distr[2] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 3.;
fpm[1] = 4.;
distr[3] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 5.;
fpm[1] = 100.;
distr[4] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 500.;
fpm[1] = 300.;
distr[5] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 5.;
fpm[1] = 10.;
fpm[2] = -3.;
fpm[3] = 15.;
distr[6] = unur_distr_beta(fpm,4);
}

{
fpm[0] = 0.5;
fpm[1] = 3.;
distr[28] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 5.;
fpm[1] = 0.3;
distr[29] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 0.5;
fpm[1] = 0.4;
distr[30] = unur_distr_beta(fpm,2);
}

{
distr[7] = unur_distr_cauchy(NULL,0);
}

{
fpm[0] = 1.;
fpm[1] = 20.;
distr[8] = unur_distr_cauchy(fpm,2);
}

{
distr[24] = unur_distr_exponential(NULL,0);
}

{
fpm[0] = 30.;
fpm[1] = -5.;
distr[25] = unur_distr_exponential(fpm,2);
}

{
fpm[0] = 1.;
distr[9] = unur_distr_gamma(fpm,1);
}

{
fpm[0] = 2.;
distr[10] = unur_distr_gamma(fpm,1);
}

{
fpm[0] = 3.;
distr[11] = unur_distr_gamma(fpm,1);
}

{
fpm[0] = 10.;
distr[12] = unur_distr_gamma(fpm,1);
}

{
fpm[0] = 1000.;
distr[13] = unur_distr_gamma(fpm,1);
}

{
fpm[0] = 5.;
fpm[1] = 1000.;
distr[14] = unur_distr_gamma(fpm,2);
}

{
fpm[0] = 5.;
fpm[1] = 1.e-5;
distr[15] = unur_distr_gamma(fpm,2);
}

{
fpm[0] = 5.;
fpm[1] = 10.;
fpm[2] = 1000;
distr[16] = unur_distr_gamma(fpm,3);
}

{
fpm[0] = 0.5;
distr[31] = unur_distr_gamma(fpm,1);
}

{
fpm[0] = 0.2;
distr[32] = unur_distr_gamma(fpm,1);
}

{
distr[26] = unur_distr_laplace(NULL,0);
}

{
fpm[0] = -10.;
fpm[1] = 100.;
distr[27] = unur_distr_laplace(fpm,2);
}

{
distr[17] = unur_distr_normal(NULL,0);
}

{
fpm[0] = 1.;
fpm[1] = 1.e-5;
distr[18] = unur_distr_normal(fpm,2);
}

{
fpm[0] = 0.;
fpm[1] = 1.e+5;
distr[19] = unur_distr_normal(fpm,2);
}

{
distr[20] = unur_distr_uniform(NULL,0);
}

{
fpm[0] = 1.;
fpm[1] = 20.;
distr[21] = unur_distr_uniform(fpm,2);
}

{
fpm[0] = 1.;
fpm[1] = 10.;
distr[35] = unur_distr_F(fpm,2);
}

{
fpm[0] = 2.;
fpm[1] = 10.;
distr[36] = unur_distr_F(fpm,2);
}

{
fpm[0] = 4.;
fpm[1] = 10.;
distr[37] = unur_distr_F(fpm,2);
}

{
fpm[0] = 10.;
fpm[1] = 10.;
distr[38] = unur_distr_F(fpm,2);
}

{
fpm[0] = 10.;
fpm[1] = 1;
distr[40] = unur_distr_F(fpm,2);
}

{
fpm[0] = 0.1;
fpm[1] = 10.;
distr[43] = unur_distr_F(fpm,2);
}

{
distr[22] = unur_distr_cauchy(NULL,0);
unur_distr_cont_set_domain(distr[22],0.1,1.);
unur_distr_cont_upd_mode(distr[22]);
unur_distr_cont_upd_pdfarea(distr[22]);
}

{
fpm[0] = 3.;
fpm[1] = 4.;
distr[23] = unur_distr_beta(fpm,2);
unur_distr_cont_set_domain(distr[23],-2.,5.);
}

{
distr[33] = unur_distr_cont_new();
unur_distr_cont_set_cdf( distr[33], sin_cdf );
unur_distr_cont_set_pdf( distr[33], sin_pdf );
unur_distr_cont_set_dpdf( distr[33], sin_dpdf );
unur_distr_cont_set_domain( distr[33], -1., 1. );
}

{
distr[34] = unur_distr_cont_new();
unur_distr_cont_set_cdf( distr[34], sin0_cdf );
unur_distr_cont_set_pdf( distr[34], sin0_pdf );
unur_distr_cont_set_dpdf( distr[34], sin0_dpdf );
unur_distr_cont_set_domain( distr[34], -1., 1. );
}

{
distr[39] = unur_distr_cont_new();
unur_distr_cont_set_cdfstr(distr[39], "(x<=2)*(0.5-x+0.5*x*x)+(x>2)*(-3.5+3*x-0.5*x*x)");
unur_distr_cont_set_domain(distr[39],1.,3.);
unur_distr_set_name(distr[39],"triangular-string");
}

{
distr[41] = unur_distr_cont_new();
unur_distr_cont_set_cdfstr(distr[41], "(x<=2)*(0.5-x+0.5*x*x)+(x>2)*(-3.5+3*x-0.5*x*x)");
unur_distr_cont_set_domain(distr[41],1.,5.);
unur_distr_set_name(distr[41],"triangular-invalid-string");
}

{
distr[42] = unur_distr_cont_new();
unur_distr_cont_set_cdfstr(distr[42], "(x<=2)*(0.5-x+0.5*x*x)+(x>2)*(-3.5+3*x-0.5*x*x)");
unur_distr_cont_set_domain(distr[42],-1.,3.);
unur_distr_set_name(distr[42],"triangular-invalid-string");
}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>setup time = %.3f ms\n", stopwatch_lap(&watch));

	printf("\n(chi^2) "); fflush(stdout);

/* chi^2 tests: 396 */

	unur_set_default_debug(~UNUR_DEBUG_SAMPLE);
	fprintf( TESTLOG,"\nChi^2 Test:\n");

/* distribution [0] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [1] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [2] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [3] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [4] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [5] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [6] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [28] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [29] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [30] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [7] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [8] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [24] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [25] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [9] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [10] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [11] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [12] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [13] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [14] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [15] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [16] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [31] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[31]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[31],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[31]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[31],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[31]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[31],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[31]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[31],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[31]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[31],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[31]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[31],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[31]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[31],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[31]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[31],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[31]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[31],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [32] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[32]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[32],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[32]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[32],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[32]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[32],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[32]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[32],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[32]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[32],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[32]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[32],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[32]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[32],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[32]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[32],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [26] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [27] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [17] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [18] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [19] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [20] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [21] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'-');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [35] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[35]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[35],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[35]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[35],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[35]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[35],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[35]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[35],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[35]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[35],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[35]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[35],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[35]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[35],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[35]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[35],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[35]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[35],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [36] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[36]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[36],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[36]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[36],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[36]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[36],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[36]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[36],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[36]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[36],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[36]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[36],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[36]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[36],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[36]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[36],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[36]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[36],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [37] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[37]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[37],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[37]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[37],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[37]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[37],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[37]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[37],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[37]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[37],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[37]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[37],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[37]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[37],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[37]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[37],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[37]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[37],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [38] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[38]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[38],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[38]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[38],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[38]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[38],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[38]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[38],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[38]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[38],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[38]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[38],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[38]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[38],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[38]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[38],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[38]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[38],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [40] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[40]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[40],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[40]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[40],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[40]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[40],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[40]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[40],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[40]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[40],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[40]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[40],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[40]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[40],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[40]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[40],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[40]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[40],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [43] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[43]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[43],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[43]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[43],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[43]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[43],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[43]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[43],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[43]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[43],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[43]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[43],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[43]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[43],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[43]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[43],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[43]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
fpm[0] = 1.;
fpm[1] = 4.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[43],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [22] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [23] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [33] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[33]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[33],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[33]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[33],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[33]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[33],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[33]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[33],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[33]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[33],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[33]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.25;
fpm[2]=  0.25;
fpm[3]=  0.75;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[33],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[33]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[33],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [34] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[34]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[34],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[34]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[34],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[34]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[34],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[34]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	if (gen) {
unur_hinv_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[34],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[34]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-12);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[34],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[34]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
fpm[0]= -0.75;
fpm[1]= -0.5;
fpm[2]=  0.;
fpm[3]=  0.25;
unur_hinv_set_cpoints(par,fpm,4);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[34],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[34]);
{ UNUR_DISTR *dg =NULL;
par = unur_hinv_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_domain(dg,0.1,0.99);
unur_distr_cont_upd_pdfarea(dg);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[34],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [39] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[39]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[39],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[39]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[39],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[39]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[39],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [41] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[41]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[41],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[41]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[41],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[41]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[41],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [42] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[42]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,1);
unur_hinv_set_u_resolution(par,1.e-8);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[42],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[42]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,3);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[42],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[42]);
par = unur_hinv_new(distr_localcopy);
unur_hinv_set_order(par,5);
unur_hinv_set_u_resolution(par,1.e-10);
set_debug_flag(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[42],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.0f ms\n", stopwatch_lap(&watch));


/* free distributions */
	unur_distr_free(distr[0]);
	unur_distr_free(distr[1]);
	unur_distr_free(distr[2]);
	unur_distr_free(distr[3]);
	unur_distr_free(distr[4]);
	unur_distr_free(distr[5]);
	unur_distr_free(distr[6]);
	unur_distr_free(distr[7]);
	unur_distr_free(distr[8]);
	unur_distr_free(distr[9]);
	unur_distr_free(distr[10]);
	unur_distr_free(distr[11]);
	unur_distr_free(distr[12]);
	unur_distr_free(distr[13]);
	unur_distr_free(distr[14]);
	unur_distr_free(distr[15]);
	unur_distr_free(distr[16]);
	unur_distr_free(distr[17]);
	unur_distr_free(distr[18]);
	unur_distr_free(distr[19]);
	unur_distr_free(distr[20]);
	unur_distr_free(distr[21]);
	unur_distr_free(distr[22]);
	unur_distr_free(distr[23]);
	unur_distr_free(distr[24]);
	unur_distr_free(distr[25]);
	unur_distr_free(distr[26]);
	unur_distr_free(distr[27]);
	unur_distr_free(distr[28]);
	unur_distr_free(distr[29]);
	unur_distr_free(distr[30]);
	unur_distr_free(distr[31]);
	unur_distr_free(distr[32]);
	unur_distr_free(distr[33]);
	unur_distr_free(distr[34]);
	unur_distr_free(distr[35]);
	unur_distr_free(distr[36]);
	unur_distr_free(distr[37]);
	unur_distr_free(distr[38]);
	unur_distr_free(distr[39]);
	unur_distr_free(distr[40]);
	unur_distr_free(distr[41]);
	unur_distr_free(distr[42]);
	unur_distr_free(distr[43]);

	/* test finished */
	test_ok &= (n_tests_failed>CHI2_FAILURES_TOLERATED) ? 0 : 1;
	/* we accept CHI2_FAILURES_TOLERATED failures */
	(n_tests_failed>CHI2_FAILURES_TOLERATED) ? printf(" ==> failed] ") : printf(" ==> ok] ");

	/* prevent compiler from making useless annoying warnings */
	distr[0] = NULL;
	par = NULL;
	gen = NULL;
	darray = NULL;
	fpm[0] = 0.;

} /* end of test_validate */

/*---------------------------------------------------------------------------*/
/* [special] */

void test_special (void)
{
	/* set boolean to FALSE */
	int FAILED = 0;





  int samplesize = UERROR_SAMPLESIZE;
  int errorsum = 0;
  double fpar[4];
  double cpoints[10];     

  UNUR_DISTR *distr;
  UNUR_PAR   *par;

/* start test */
printf("[special "); fflush(stdout);
fprintf(TESTLOG,"\n[special]\n");

/* set stop watch */
stopwatch_lap(&watch);



  /* test for maximal u-error */
  printf("\ntest maximal u-error: "); 
  fprintf(TESTLOG,"\nTest maximal u-error:\n"); 

  distr = unur_distr_normal(NULL,0);
  par = unur_hinv_new(distr);
  errorsum += hinv_error_experiment(par,samplesize);
  unur_distr_free(distr);
	
  distr = unur_distr_cauchy(NULL,0);
  par = unur_hinv_new(distr);
  errorsum += hinv_error_experiment(par,samplesize);
  unur_distr_free(distr);
	
  distr = unur_distr_exponential(NULL,0);
  par = unur_hinv_new(distr);
  errorsum += hinv_error_experiment(par,samplesize);
  unur_distr_free(distr);
	
  fpar[0]= 5.; 
  distr = unur_distr_gamma(fpar,1);
  par = unur_hinv_new(distr);
  errorsum += hinv_error_experiment(par,samplesize);
  unur_distr_free(distr);
	
  fpar[0]= 0.5; 
  distr = unur_distr_gamma(fpar,1);
  par = unur_hinv_new(distr);
  errorsum += hinv_error_experiment(par,samplesize);
  unur_distr_free(distr);
	
  fpar[0]=2.; fpar[1]=2.;fpar[2]= 0.; fpar[3]=1.;
  distr = unur_distr_beta(fpar,4);
  par = unur_hinv_new(distr);
  errorsum += hinv_error_experiment(par,samplesize);
  unur_distr_free(distr);
	
  fpar[0]=0.3; fpar[1]=3.;fpar[2]= 0.; fpar[3]=1.;
  distr = unur_distr_beta(fpar,4);
  par = unur_hinv_new(distr);
  errorsum += hinv_error_experiment(par,samplesize);
  unur_distr_free(distr);

  distr = unur_distr_cont_new();
  unur_distr_set_name(distr,"sin-example");
  unur_distr_cont_set_cdf( distr, sin_cdf );
  unur_distr_cont_set_pdf( distr, sin_pdf );
  unur_distr_cont_set_dpdf( distr, sin_dpdf );
  unur_distr_cont_set_domain( distr, -1., 1. );
  cpoints[0]= -0.75;
  cpoints[1]= -0.25;
  cpoints[2]=  0.25;
  cpoints[3]=  0.75;
  par = unur_hinv_new(distr);
  unur_hinv_set_cpoints(par, cpoints, 4);
  errorsum += hinv_error_experiment(par,samplesize);
  unur_distr_free(distr);
	
  distr = unur_distr_cont_new();
  unur_distr_set_name(distr,"sin-0-example");
  unur_distr_cont_set_cdf( distr, sin0_cdf );
  unur_distr_cont_set_pdf( distr, sin0_pdf );
  unur_distr_cont_set_dpdf( distr, sin0_dpdf );
  unur_distr_cont_set_domain( distr, -1., 0.5 );
  cpoints[0]= -0.75;
  cpoints[1]= -0.5;
  cpoints[2]=  0.;
  cpoints[3]=  0.25;
  par = unur_hinv_new(distr);
  unur_hinv_set_cpoints(par, cpoints, 4);
  errorsum += hinv_error_experiment(par,samplesize);
  unur_distr_free(distr);

 
  /* extra test for changeing the domain of the generator object */

  printf("\ntest unur_chg_truncated(): "); 
  fprintf(TESTLOG,"\nTests unur_chg_truncated():\n\n"); 

  printf(" normal");
  
  distr = unur_distr_normal(NULL,0);
  par = unur_hinv_new(distr);
  
  errorsum += chg_domain_experiment(par,samplesize);

  unur_distr_free(distr);
  fprintf(TESTLOG,"\n");

  /****/

  printf(" sinus1");
  distr = unur_distr_cont_new();
  unur_distr_set_name(distr,"sin-example");
  unur_distr_cont_set_cdf( distr, sin_cdf );
  unur_distr_cont_set_pdf( distr, sin_pdf );
  unur_distr_cont_set_dpdf( distr, sin_dpdf );
  unur_distr_cont_set_domain( distr, -1., 1. );
  cpoints[0]= -0.75;
  cpoints[1]= -0.25;
  cpoints[2]=  0.25;
  cpoints[3]=  0.75;
  par = unur_hinv_new(distr);
  unur_hinv_set_cpoints(par, cpoints, 4);

  errorsum += chg_domain_experiment(par,samplesize);

  unur_distr_free(distr);
  fprintf(TESTLOG,"\n");

  /****/

  printf(" sinus2");
  distr = unur_distr_cont_new();
  unur_distr_set_name(distr,"sin-0-example");
  unur_distr_cont_set_cdf( distr, sin0_cdf );
  unur_distr_cont_set_pdf( distr, sin0_pdf );
  unur_distr_cont_set_dpdf( distr, sin0_dpdf );
  unur_distr_cont_set_domain( distr, -1., 0.5 );
  cpoints[0]= -0.75;
  cpoints[1]= -0.5;
  cpoints[2]=  0.;
  cpoints[3]=  0.25;
  par = unur_hinv_new(distr);
  unur_hinv_set_cpoints(par, cpoints, 4);

  errorsum += chg_domain_experiment(par,samplesize);

  unur_distr_free(distr);
  fprintf(TESTLOG,"\n");


  /* test finished */
  FAILED = (errorsum < 2) ? 0 : 1;




	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (FAILED) ? 0 : 1;
	(FAILED) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_special() */


/*---------------------------------------------------------------------------*/
/* run generator in verifying mode */

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par )
{
	UNUR_GEN *gen;
	int i;

	/* switch to verifying mode */
	unur_hinv_set_verify(par,1);

	/* initialize generator */
	gen = unur_init( par ); abort_if_NULL(LOG, line, gen);

	/* run generator */
	for (i=0; i<VIOLATE_SAMPLE_SIZE; i++)
		unur_sample_cont(gen);

	/* destroy generator */
	unur_free(gen); 

} /* end of run_verify_generator() */

int unur_hinv_set_verify(UNUR_PAR *par ATTRIBUTE__UNUSED, int verify ATTRIBUTE__UNUSED) {return 0;}

/*---------------------------------------------------------------------------*/

int main(void)
{ 
        unsigned long seed;
	char *str_seed, *str_tail;

	/* start stop watch */
	stopwatch_init();
	stopwatch_start(&watch);

        /* open log file for unuran and set output stream for unuran messages */
        UNURANLOG = fopen( "t_hinv_unuran.log","w" );
        abort_if_NULL( stderr,-1, UNURANLOG );
        unur_set_stream( UNURANLOG );

        /* open log file for testing */
	TESTLOG = fopen( "t_hinv_test.log","w" );
	abort_if_NULL( stderr,-1, TESTLOG );

        /* seed for uniform generators */

	/* seed set by environment */
	str_seed = getenv("SEED");

	if (str_seed != NULL) {
	    seed = strtol(str_seed, &str_tail, 10);
	    if (seed == 0u) 
		seed = 457673;
	}
	else {
#ifdef SEED
	    seed = SEED;
#else
	    seed = 457673;
#endif
	}

        /* seed build-in uniform generators */
        unur_urng_MRG31k3p_seed(NULL,seed);
        unur_urng_fish_seed(NULL,seed);
	unur_urng_mstd_seed(NULL,seed);

	/* seed uniform random number generator */
#ifdef UNUR_URNG_UNURAN
#  ifdef UNUR_URNG_DEFAULT_RNGSTREAM
	{
	        unsigned long sa[6];
	        int i;
	        for (i=0; i<6; i++) sa[i] = seed;
                RngStream_SetPackageSeed(sa);
        }
#  else
	if (unur_urng_seed(NULL,seed) != UNUR_SUCCESS) {
	        fprintf(stderr,"WARNING: Seed could not be set at random\n");
                seed = ~0u;
	}
#  endif  /* UNUR_URNG_DEFAULT_RNGSTREAM */
#endif  /* UNUR_URNG_UNURAN */
 
	/* set default debugging flag */
	unur_set_default_debug(UNUR_DEBUG_ALL);

        /* detect required check mode */
        fullcheck = (getenv("UNURANFULLCHECK")==NULL) ? FALSE : TRUE;

	/* write header into log file */
        print_test_log_header( TESTLOG, seed, fullcheck );

	/* set timer for sending SIGALRM signal */
	set_alarm(TESTLOG);

	/* start test */
	printf("hinv: ");

	/* run tests */
test_new();
test_set();
test_get();
test_chg();
test_reinit();
test_sample();
test_validate();
test_special();


	/* test finished */
	printf("\n");  fflush(stdout);

	/* close log files */
	fprintf(TESTLOG,"\n====================================================\n\n");
	if (test_ok)
		fprintf(TESTLOG,"All tests PASSED.\n");
	else
		fprintf(TESTLOG,"Test(s) FAILED.\n");

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>total time = %.0f ms\n\n", stopwatch_stop(&watch));

	fclose(UNURANLOG);
	fclose(TESTLOG);

	/* free memory */
	compare_free_memory();
	unur_urng_free(unur_get_default_urng());
	unur_urng_free(unur_get_default_urng_aux());

	/* exit */
	exit( (test_ok) ? EXIT_SUCCESS : EXIT_FAILURE );

} /* end of main */

