/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_rm extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arab";
        final String metaValue_hy = "armen";
        final String metaValue_ae = "avestic";
        final String metaValue_ban = "balinais";
        final String metaValue_zbl = "simbols da Bliss";
        final String metaValue_ccp = "chakma";
        final String metaValue_chr = "cherokee";
        final String metaValue_cop = "coptic";
        final String metaValue_ka = "georgian";
        final String metaValue_got = "gotic";
        final String metaValue_el = "grec";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "ebraic";
        final String metaValue_jv = "javanais";
        final String metaValue_ja = "giapunais";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "corean";
        final String metaValue_lo = "laot";
        final String metaValue_la = "latin";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongol";
        final String metaValue_nqo = "n’ko";
        final String metaValue_or = "oriya";
        final String metaValue_phn = "fenizian";
        final String metaValue_si = "singalais";
        final String metaValue_su = "sundanais";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telugu";
        final String metaValue_tl = "tagalog";
        final String metaValue_th = "tailandais";
        final String metaValue_bo = "tibetan";
        final String metaValue_uga = "ugaritic";
        final String metaValue_vai = "vai";
        final String metaValue_peo = "persian vegl";
        final Object[][] data = new Object[][] {
            { "001", "mund" },
            { "002", "Africa" },
            { "003", "America dal Nord" },
            { "005", "America dal Sid" },
            { "009", "Oceania" },
            { "011", "Africa dal Vest" },
            { "013", "America Centrala" },
            { "014", "Africa da l’Ost" },
            { "015", "Africa dal Nord" },
            { "017", "Africa Centrala" },
            { "018", "Africa Meridiunala" },
            { "019", "America" },
            { "021", "America dal nord" },
            { "029", "Caribica" },
            { "030", "Asia da l’Ost" },
            { "034", "Asia dal Sid" },
            { "035", "Asia dal Sidost" },
            { "039", "Europa dal Sid" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "057", "Regiun Micronesica" },
            { "061", "Polinesia" },
            { "142", "Asia" },
            { "143", "Asia Centrala" },
            { "145", "Asia dal Vest" },
            { "150", "Europa" },
            { "151", "Europa Orientala" },
            { "154", "Europa dal Nord" },
            { "155", "Europa dal Vest" },
            { "202", "Africa Subsaharica" },
            { "419", "America latina" },
            { "AC", "Insla da l’Ascensiun" },
            { "AD", "Andorra" },
            { "AE", "Emirats Arabs Unids" },
            { "AF", "Afganistan" },
            { "AG", "Antigua e Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antarctica" },
            { "AR", "Argentina" },
            { "AS", "Samoa Americana" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Inslas Aland" },
            { "AZ", "Aserbaidschan" },
            { "BA", "Bosnia ed Erzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesch" },
            { "BE", "Belgia" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Son Barthélemy" },
            { "BM", "Bermudas" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Pajais Bass caribics" },
            { "BR", "Brasilia" },
            { "BS", "Bahamas" },
            { "BT", "Butan" },
            { "BV", "Insla da Bouvet" },
            { "BW", "Botsuana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Canada" },
            { "CC", "Inslas Cocos" },
            { "CD", "Congo-Kinshasa" },
            { "CF", "Republica Centralafricana" },
            { "CG", "Congo-Brazzaville" },
            { "CH", "Svizra" },
            { "CI", "Costa d’Ivur" },
            { "CK", "Inslas Cook" },
            { "CL", "Chile" },
            { "CM", "Camerun" },
            { "CN", "China" },
            { "CO", "Columbia" },
            { "CP", "Insla Clipperton" },
            { "CQ", "Sark" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cap Verd" },
            { "CW", "Curaçao" },
            { "CX", "Insla da Nadal" },
            { "CY", "Cipra" },
            { "CZ", "Tschechia" },
            { "DE", "Germania" },
            { "DG", "Diego Garcia" },
            { "DJ", "Dschibuti" },
            { "DK", "Danemarc" },
            { "DM", "Dominica" },
            { "DO", "Republica Dominicana" },
            { "DZ", "Algeria" },
            { "EA", "Ceuta e Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonia" },
            { "EG", "Egipta" },
            { "EH", "Sahara Occidentala" },
            { "ER", "Eritrea" },
            { "ES", "Spagna" },
            { "ET", "Etiopia" },
            { "EU", "Uniun europeica" },
            { "EZ", "zona da l’euro" },
            { "FI", "Finlanda" },
            { "FJ", "Fidschi" },
            { "FK", "Inslas Falkland" },
            { "FM", "Micronesia" },
            { "FO", "Inslas Feroe" },
            { "FR", "Frantscha" },
            { "GA", "Gabun" },
            { "GB", "Reginavel Unì" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Guyana Franzosa" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Grönlanda" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadalupa" },
            { "GQ", "Guinea Equatoriala" },
            { "GR", "Grezia" },
            { "GS", "Georgia dal Sid e las Inslas Sandwich dal Sid" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Regiun d’administraziun speziala Hongkong, China" },
            { "HM", "Inslas da Heard e McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croazia" },
            { "HT", "Haiti" },
            { "HU", "Ungaria" },
            { "IC", "Inslas Canarias" },
            { "ID", "Indonesia" },
            { "IE", "Irlanda" },
            { "IL", "Israel" },
            { "IM", "Insla da Man" },
            { "IN", "India" },
            { "IO", "Territori Britannic da l’Ocean Indic" },
            { "IQ", "Irac" },
            { "IR", "Iran" },
            { "IS", "Islanda" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "JM", "Giamaica" },
            { "JO", "Jordania" },
            { "JP", "Giapun" },
            { "KE", "Kenia" },
            { "KG", "Kirghistan" },
            { "KH", "Cambodscha" },
            { "KI", "Kiribati" },
            { "KM", "Comoras" },
            { "KN", "Son Cristof e Nevis" },
            { "KP", "Corea dal Nord" },
            { "KR", "Corea dal Sid" },
            { "KW", "Kuwait" },
            { "KY", "Inslas Cayman" },
            { "KZ", "Kasachstan" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "Sontga Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lituania" },
            { "LU", "Luxemburg" },
            { "LV", "Lettonia" },
            { "LY", "Libia" },
            { "MA", "Maroc" },
            { "MC", "Monaco" },
            { "MD", "Moldavia" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagascar" },
            { "MH", "Inslas da Marshall" },
            { "MK", "Macedonia dal Nord" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "MO", "Regiun d’administraziun speziala Macao, China" },
            { "MP", "Inslas Mariannas dal Nord" },
            { "MQ", "Martinica" },
            { "MR", "Mauretania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maledivas" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "MY", "Malaisia" },
            { "MZ", "Mosambic" },
            { "NA", "Namibia" },
            { "NC", "Nova Caledonia" },
            { "NE", "Niger" },
            { "NF", "Insla Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Pajais Bass" },
            { "NO", "Norvegia" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nova Zelanda" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Polinesia Franzosa" },
            { "PG", "Papua Nova Guinea" },
            { "PH", "Filippinas" },
            { "PK", "Pakistan" },
            { "PL", "Pologna" },
            { "PM", "Saint Pierre e Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Territori Palestinais" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguai" },
            { "QA", "Qatar" },
            { "QO", "Oceania Periferica" },
            { "RE", "Réunion" },
            { "RO", "Rumenia" },
            { "RS", "Serbia" },
            { "RU", "Russia" },
            { "RW", "Ruanda" },
            { "SA", "Arabia Saudita" },
            { "SB", "Inslas da Salomon" },
            { "SC", "Seychellas" },
            { "SD", "Sudan" },
            { "SE", "Svezia" },
            { "SG", "Singapur" },
            { "SH", "Sontg’Elena" },
            { "SI", "Slovenia" },
            { "SJ", "Svalbard e Jan Mayen" },
            { "SK", "Slovachia" },
            { "SL", "Sierra Leone" },
            { "SM", "Son Marin" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Surinam" },
            { "SS", "Sudan dal Sid" },
            { "ST", "São Tomé e Príncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Siria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Inslas Turks e Caicos" },
            { "TD", "Tschad" },
            { "TF", "Territoris Franzos Meridiunals" },
            { "TG", "Togo" },
            { "TH", "Tailanda" },
            { "TJ", "Tadschikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor da l’Ost" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunesia" },
            { "TO", "Tonga" },
            { "TR", "Tirchia" },
            { "TT", "Trinidad e Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tansania" },
            { "UA", "Ucraina" },
            { "UG", "Uganda" },
            { "UM", "Inslas Pitschnas Perifericas dals Stadis Unids da l’America" },
            { "UN", "Naziuns unidas" },
            { "US", "Stadis Unids da l’America" },
            { "UY", "Uruguai" },
            { "UZ", "Usbekistan" },
            { "VA", "Citad dal Vatican" },
            { "VC", "Son Vincenz e las Grenadinas" },
            { "VE", "Venezuela" },
            { "VG", "Inslas Virginas Britannicas" },
            { "VI", "Inslas Virginas Americanas" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis e Futuna" },
            { "WS", "Samoa" },
            { "XA", "pseudo-accents" },
            { "XB", "pseudo-bidi" },
            { "XK", "Cosovo" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "Africa dal Sid" },
            { "ZM", "Sambia" },
            { "ZW", "Simbabwe" },
            { "ZZ", "regiun nunenconuschenta" },
            { "aa", "afar" },
            { "ab", "abchasian" },
            { "ae", metaValue_ae },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amaric" },
            { "an", "aragonais" },
            { "ar", metaValue_ar },
            { "as", "assami" },
            { "av", "avaric" },
            { "ay", "aymara" },
            { "az", "lingua aserbaidschana" },
            { "ba", "baschkir" },
            { "be", "lingua bielorussa" },
            { "bg", "bulgar" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "lingua bengala" },
            { "bo", metaValue_bo },
            { "br", "breton" },
            { "bs", "bosniac" },
            { "ca", "catalan" },
            { "ce", "tschetschen" },
            { "ch", "chamorro" },
            { "co", "cors" },
            { "cr", "cree" },
            { "cs", "tschec" },
            { "cu", "slav da baselgia" },
            { "cv", "tschuvasch" },
            { "cy", "valisic" },
            { "da", "danais" },
            { "de", "tudestg" },
            { "dv", "maledivic" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", metaValue_el },
            { "en", "englais" },
            { "eo", "esperanto" },
            { "es", "spagnol" },
            { "et", "eston" },
            { "eu", "basc" },
            { "fa", "persian" },
            { "ff", "fulah" },
            { "fi", "finlandais" },
            { "fj", "fidschian" },
            { "fo", "feroais" },
            { "fr", "franzos" },
            { "fy", "fris occidental" },
            { "ga", "irlandais" },
            { "gd", "gaelic scot" },
            { "gl", "galizian" },
            { "gn", "guarani" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "croat" },
            { "ht", "creol haitian" },
            { "hu", "ungarais" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonais" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "sichuan yi" },
            { "ik", "inupiak" },
            { "io", "ido" },
            { "is", "islandais" },
            { "it", "talian" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "kongo" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kasac" },
            { "kl", "grönlandais" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "kashmiri" },
            { "ku", "curd settentriunal" },
            { "kv", "komi" },
            { "kw", "cornic" },
            { "ky", "kirghis" },
            { "la", metaValue_la },
            { "lb", "luxemburgais" },
            { "lg", "ganda" },
            { "li", "limburgais" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "lituan" },
            { "lu", "luba-katanga" },
            { "lv", "letton" },
            { "mg", "malagassi" },
            { "mh", "marschallais" },
            { "mi", "māori" },
            { "mk", "macedon" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malaic" },
            { "mt", "maltais" },
            { "my", "birman" },
            { "na", "nauru" },
            { "nb", "norvegais bokmål" },
            { "nd", "ndebele dal nord" },
            { "ne", "nepalais" },
            { "ng", "ndonga" },
            { "nl", "neerlandais" },
            { "nn", "norvegiais nynorsk" },
            { "no", "norvegiais" },
            { "nr", "ndebele dal sid" },
            { "nv", "navajo" },
            { "ny", "nyanja" },
            { "oc", "occitan" },
            { "oj", "ojibwa" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "ossetic" },
            { "pa", "punjabi" },
            { "pi", "pali" },
            { "pl", "polac" },
            { "ps", "paschto" },
            { "pt", "portugais" },
            { "qu", "quechua" },
            { "rm", "rumantsch" },
            { "rn", "rundi" },
            { "ro", "rumen" },
            { "ru", "russ" },
            { "rw", "kinyarwanda" },
            { "sa", "sanscrit" },
            { "sc", "sard" },
            { "sd", "sindhi" },
            { "se", "sami dal nord" },
            { "sg", "sango" },
            { "sh", "serbo-croat" },
            { "si", metaValue_si },
            { "sk", "slovac" },
            { "sl", "sloven" },
            { "sm", "samoan" },
            { "sn", "shona" },
            { "so", "somali" },
            { "sq", "albanais" },
            { "sr", "serb" },
            { "ss", "swazi" },
            { "st", "sotho dal sid" },
            { "su", metaValue_su },
            { "sv", "svedais" },
            { "sw", "suaheli" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tadschic" },
            { "th", metaValue_th },
            { "ti", "tigrinya" },
            { "tk", "turkmen" },
            { "tl", metaValue_tl },
            { "tn", "tswana" },
            { "to", "tonga" },
            { "tr", "tirc" },
            { "ts", "tsonga" },
            { "tt", "tatar" },
            { "tw", "twi" },
            { "ty", "tahitian" },
            { "ug", "uiguric" },
            { "uk", "ucranais" },
            { "ur", "urdu" },
            { "uz", "usbec" },
            { "ve", "venda" },
            { "vi", "vietnamais" },
            { "vo", "volapuk" },
            { "wa", "vallon" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "jiddic" },
            { "yo", "yoruba" },
            { "za", "zhuang" },
            { "zh", "chinais" },
            { "zu", "zulu" },
            { "ace", "aceh" },
            { "ach", "acoli" },
            { "ada", "andangme" },
            { "ady", "adygai" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ainu" },
            { "akk", "accadic" },
            { "ale", "aleutic" },
            { "alt", "altaic dal sid" },
            { "ang", "englais vegl" },
            { "anp", "angika" },
            { "arc", "arameic" },
            { "arn", "araucanic" },
            { "arp", "arapaho" },
            { "arw", "arawak" },
            { "asa", "asu" },
            { "ast", "asturian" },
            { "awa", "awadhi" },
            { "bal", "belutschi" },
            { "ban", metaValue_ban },
            { "bas", "basaa" },
            { "bej", "bedscha" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bgc", "haryanvi" },
            { "bho", "bhojpuri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bla", "siksika" },
            { "blo", "anii" },
            { "bra", "braj" },
            { "brx", "bodo" },
            { "bua", "buriat" },
            { "bug", "bugi" },
            { "byn", "blin" },
            { "cad", "caddo" },
            { "car", "caribic" },
            { "cch", "atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "cebuano" },
            { "cgg", "chiga" },
            { "chb", "chibcha" },
            { "chg", "tschagataic" },
            { "chk", "chuukais" },
            { "chm", "mari" },
            { "chn", "patuà chinook" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "cheyenne" },
            { "ckb", "curd central" },
            { "cop", metaValue_cop },
            { "crh", "tirc crimean" },
            { "csb", "kaschubic" },
            { "csw", "swampy cree" },
            { "dak", "dakota" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "del", "delaware" },
            { "den", "slavey" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "bass sorb" },
            { "dua", "duala" },
            { "dum", "ollandais mesaun" },
            { "dyo", "jola-fonyi" },
            { "dyu", "diula" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egy", "egipzian vegl" },
            { "eka", "ekajuk" },
            { "elx", "elamitic" },
            { "enm", "englais mesaun" },
            { "ewo", "ewondo" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filippino" },
            { "fon", "fon" },
            { "frm", "franzos mesaun" },
            { "fro", "franzos vegl" },
            { "frr", "fris dal nord" },
            { "frs", "fris da l’ost" },
            { "fur", "friulan" },
            { "gaa", "ga" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gez", "geez" },
            { "gil", "gilbertais" },
            { "gmh", "tudestg mesaun" },
            { "goh", "vegl tudestg da scrittira" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "grb", "grebo" },
            { "grc", "grec vegl" },
            { "gsw", "tudestg svizzer" },
            { "guz", "gusii" },
            { "gwi", "gwichʼin" },
            { "hai", "haida" },
            { "haw", "hawaian" },
            { "hil", "hiligaynon" },
            { "hit", "ettitic" },
            { "hmn", "hmong" },
            { "hsb", "aut sorb" },
            { "hup", "hupa" },
            { "iba", "iban" },
            { "ilo", "ilocano" },
            { "inh", "ingush" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "jpr", "giudaic-persian" },
            { "jrb", "giudaic-arab" },
            { "kaa", "karakalpak" },
            { "kab", "kabyle" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", "kawi" },
            { "kbd", "kabardic" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "creol dal Cap Verd" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "khasi" },
            { "kho", "khotanais" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "kok", "konkani" },
            { "kos", "kosraean" },
            { "kpe", "kpelle" },
            { "krc", "karachay-balkar" },
            { "krl", "carelian" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "colognais" },
            { "kum", "kumuk" },
            { "kut", "kutenai" },
            { "kxv", "kuvi" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezghian" },
            { "lij", "ligur" },
            { "lkt", "lakota" },
            { "lmo", "lumbard" },
            { "lol", "lomongo" },
            { "loz", "lozi" },
            { "lrc", "luri dal nord" },
            { "lua", "luba-lulua" },
            { "lui", "luiseno" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "lushai" },
            { "luy", "luyia" },
            { "mad", "madurais" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makassar" },
            { "man", "mandingo" },
            { "mas", "masai" },
            { "mdf", "moksha" },
            { "mdr", "mandar" },
            { "men", "mende" },
            { "mer", "meru" },
            { "mfe", "morisyen" },
            { "mga", "irlandais mesaun" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta’" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mnc", "manchu" },
            { "mni", "meitei" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mua", "mundang" },
            { "mul", "pluriling" },
            { "mus", "creek" },
            { "mwl", "mirandais" },
            { "mwr", "marwari" },
            { "myv", "erzya" },
            { "mzn", "mazanderani" },
            { "nap", "neapolitan" },
            { "naq", "nama" },
            { "nds", "bass tudestg" },
            { "new", "newari" },
            { "nia", "nias" },
            { "niu", "niue" },
            { "nmg", "kwasio" },
            { "nnh", "ngienboon" },
            { "nog", "nogai" },
            { "non", "nordic vegl" },
            { "nqo", metaValue_nqo },
            { "nso", "sotho dal nord" },
            { "nus", "nuer" },
            { "nwc", "newari classic" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzima" },
            { "osa", "osage" },
            { "ota", "tirc ottoman" },
            { "pag", "pangasinan" },
            { "pal", "pahlavi" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palau" },
            { "pcm", "pidgin nigerian" },
            { "peo", metaValue_peo },
            { "phn", metaValue_phn },
            { "pon", "ponapean" },
            { "prg", "prussian" },
            { "pro", "provenzal vegl" },
            { "raj", "rajasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotonga" },
            { "rof", "rombo" },
            { "rom", "romani" },
            { "rup", "aromunic" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "jakut" },
            { "sam", "arameic samaritan" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "sbp", "sangu" },
            { "scn", "sicilian" },
            { "sco", "scot" },
            { "seh", "sena" },
            { "sel", "selkup" },
            { "ses", "koyraboro senni" },
            { "sga", "irlandais vegl" },
            { "shi", "tachelit" },
            { "shn", "shan" },
            { "sid", "sidamo" },
            { "sma", "sami dal sid" },
            { "smj", "sami lule" },
            { "smn", "sami inari" },
            { "sms", "sami skolt" },
            { "snk", "soninke" },
            { "sog", "sogdian" },
            { "srn", "sranan tongo" },
            { "srr", "serer" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumeric" },
            { "syc", "siric classic" },
            { "syr", "sirian" },
            { "szl", "silesian" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "tetum" },
            { "tig", "tigre" },
            { "tiv", "tiv" },
            { "tkl", "tokelau" },
            { "tlh", "klingonic" },
            { "tli", "tlingit" },
            { "tmh", "tamasheq" },
            { "tog", "lingua tsonga" },
            { "tpi", "tok pisin" },
            { "tsi", "tsimshian" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu" },
            { "twq", "tasawaq" },
            { "tyv", "tuvinian" },
            { "tzm", "tamazight" },
            { "udm", "udmurt" },
            { "uga", metaValue_uga },
            { "umb", "mbundu" },
            { "und", "lingua nunenconuschenta" },
            { "vai", metaValue_vai },
            { "vec", "venetic" },
            { "vmw", "makhuwa" },
            { "vot", "votic" },
            { "vun", "vunjo" },
            { "wae", "gualser" },
            { "wal", "walamo" },
            { "war", "waray" },
            { "was", "washo" },
            { "xal", "kalmuk" },
            { "xnr", "kangri" },
            { "xog", "soga" },
            { "yao", "yao" },
            { "yap", "yapais" },
            { "yav", "yangben" },
            { "yrl", "nheengatu" },
            { "yue", "cantonais" },
            { "zap", "zapotec" },
            { "zbl", metaValue_zbl },
            { "zen", "zenaga" },
            { "zgh", "marocan tamazight standardisà" },
            { "zun", "zuni" },
            { "zxx", "nagin cuntegn linguistic" },
            { "zza", "zaza" },
            { "Adlm", "adlam" },
            { "Aghb", "albanais dal Caucasus" },
            { "Ahom", "ahom" },
            { "Arab", metaValue_ar },
            { "Aran", "nastaliq" },
            { "Armi", "arameic imperial" },
            { "Armn", metaValue_hy },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Batk", "batak" },
            { "Beng", "bengal" },
            { "Blis", metaValue_zbl },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "Braille" },
            { "Bugi", "buginais" },
            { "Buhd", "buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "simbols da silbas unifitgads da la populaziun autoctona canadaisa" },
            { "Cari", "carian" },
            { "Cham", "cham" },
            { "Cher", metaValue_chr },
            { "Cirt", "cirth" },
            { "Copt", metaValue_cop },
            { "Cprt", "cipriot" },
            { "Cyrl", "cirillic" },
            { "Cyrs", "slav da baselgia vegl" },
            { "Deva", "devanagari" },
            { "Dsrt", "deseret" },
            { "Egyd", "egipzian demotic" },
            { "Egyh", "egipzian ieratic" },
            { "Egyp", "ieroglifas egipzianas" },
            { "Ethi", "etiopic" },
            { "Geok", "kutsuri" },
            { "Geor", metaValue_ka },
            { "Glag", "glagolitic" },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhi" },
            { "Hanb", "han cun bopomofo" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanunoo" },
            { "Hans", "simplifitgà" },
            { "Hant", "tradiziunal" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hmng", "pahawn hmong" },
            { "Hrkt", "scrittiras da silbas giapunaisas" },
            { "Hung", "ungarais vegl" },
            { "Inds", "indus" },
            { "Ital", "italic vegl" },
            { "Jamo", "jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Khar", "kharoshthi" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kthi", "kaithi" },
            { "Lana", "lanna" },
            { "Laoo", metaValue_lo },
            { "Latf", "latin (scrittira gotica)" },
            { "Latg", "latin (scrittira gaelica)" },
            { "Latn", metaValue_la },
            { "Lepc", "lepcha" },
            { "Limb", "limbu" },
            { "Lina", "linear A" },
            { "Linb", "linear B" },
            { "Lyci", "lichic" },
            { "Lydi", "lidic" },
            { "Mand", "mandaic" },
            { "Mani", "manicheic" },
            { "Maya", "ieroglifas maya" },
            { "Mero", "meroitic" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "moon" },
            { "Mtei", "meitei mayek" },
            { "Mymr", "burmais" },
            { "Narb", "arab vegl dal nord" },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "ogham" },
            { "Olck", "ol chiki" },
            { "Orkh", "orkhon" },
            { "Orya", metaValue_or },
            { "Osma", "osman" },
            { "Perm", "permic vegl" },
            { "Phag", "phags-pa" },
            { "Phli", "pahlavi dad inscripziuns" },
            { "Phlp", "pahlavi da psalms" },
            { "Phlv", "pahlavi da cudeschs" },
            { "Phnx", metaValue_phn },
            { "Plrd", "fonetica da Pollard" },
            { "Prti", "partic dad inscripziuns" },
            { "Rjng", "rejang" },
            { "Rohg", "hanifi" },
            { "Roro", "rongorongo" },
            { "Runr", "runic" },
            { "Samr", "samaritan" },
            { "Sara", "sarati" },
            { "Sarb", "arab vegl dal sid" },
            { "Saur", "saurashtra" },
            { "Sgnw", "lingua da segns" },
            { "Shaw", "shavian" },
            { "Shrd", "sharada" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Sylo", "syloti nagri" },
            { "Syrc", "siric" },
            { "Syre", "siric estrangelo" },
            { "Syrj", "siric dal vest" },
            { "Syrn", "siric da l’ost" },
            { "Tagb", "tagbanwa" },
            { "Tale", "tai le" },
            { "Talu", "tai lue" },
            { "Taml", metaValue_ta },
            { "Tavt", "tai viet" },
            { "Telu", metaValue_te },
            { "Teng", "tengwar" },
            { "Tfng", "tifinagh" },
            { "Tglg", metaValue_tl },
            { "Thaa", "thaana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", metaValue_uga },
            { "Vaii", metaValue_vai },
            { "Visp", "alfabet visibel" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "scrittira a cugn sumeric-accadica" },
            { "Yiii", "yi" },
            { "Zinh", "ertà" },
            { "Zmth", "notaziun matematica" },
            { "Zsye", "emoji" },
            { "Zsym", "simbols" },
            { "Zxxx", "betg scrit" },
            { "Zyyy", "betg determinà" },
            { "Zzzz", "scrittira nunenconuschenta" },
            { "de_AT", "tudestg austriac" },
            { "de_CH", "tudestg da scrittira svizzer" },
            { "en_AU", "englais australian" },
            { "en_CA", "englais canadais" },
            { "en_GB", "englais britannic" },
            { "en_US", "englais american" },
            { "es_ES", "spagnol europeic" },
            { "es_MX", "spagnol mexican" },
            { "fa_AF", "dari" },
            { "fr_CA", "franzos canadais" },
            { "fr_CH", "franzos svizzer" },
            { "nl_BE", "flam" },
            { "pt_BR", "portugais brasilian" },
            { "pt_PT", "portugais europeic" },
            { "ro_MD", "moldav" },
            { "%%1901", "ortografia tudestga tradiziunala" },
            { "%%1994", "ortografia standardisada da Resia" },
            { "%%1996", "nova ortografia tudestga" },
            { "ar_001", "arab standardisà modern" },
            { "es_419", "spagnol latinamerican" },
            { "key.ca", "chalender" },
            { "key.cf", "format da valuta" },
            { "key.co", "zavrada" },
            { "key.cu", "valuta" },
            { "key.em", "visualisaziun dals emojis" },
            { "key.hc", "ciclus da las uras (12 u 24h)" },
            { "key.lb", "stil da sigl da lingia" },
            { "key.lw", "sigls da lingia entaifer pleds" },
            { "key.ms", "sistem da mesira" },
            { "key.nu", "dumbers" },
            { "key.ss", "Interrupziun da la frasa suenter ina abreviaziun" },
            { "%%BISKE", "dialect da San Giorgio" },
            { "%%BOONT", "dialect boontling" },
            { "%%LIPAW", "dialect lipovaz da Resia" },
            { "%%NEDIS", "dialect da Natisone" },
            { "%%NJIVA", "dialect da Gniva" },
            { "%%OSOJS", "dialect da Oscacco" },
            { "%%POSIX", "computer" },
            { "%%ROZAJ", "dialect da Resia" },
            { "%%SAAHO", "Saho" },
            { "%%SOLBA", "dialect da Stolvizza" },
            { "zh_Hans", "chinais simplifitgà" },
            { "zh_Hant", "chinais tradiziunal" },
            { "%%FONIPA", "alfabet fonetic internaziunal (IPA)" },
            { "%%FONUPA", "alfabet fonetic da l’Ural (UPA)" },
            { "%%SCOUSE", "dialect scouse" },
            { "%%TARASK", "ortografia taraskievica" },
            { "%%AREVELA", "armen oriental" },
            { "%%AREVMDA", "armen occidental" },
            { "%%MONOTON", "monotonic" },
            { "%%POLYTON", "politonic" },
            { "%%REVISED", "ortografia revedida" },
            { "%%1606NICT", "franzos mesaun tardiv (fin 1606)" },
            { "%%1694ACAD", "franzos modern tempriv (a partir da 1694)" },
            { "%%BAKU1926", "alfabet tirc unifitgà" },
            { "%%SCOTLAND", "englais da standard scot" },
            { "%%VALENCIA", "valencian" },
            { "type.ca.roc", "chalender minguo" },
            { "type.hc.h11", "sistem da 12 uras (0–11)" },
            { "type.hc.h12", "sistem da 12 uras (1–12)" },
            { "type.hc.h23", "sistem da 24 uras (0–23)" },
            { "type.hc.h24", "sistem da 24 uras (1–24)" },
            { "type.nu.arab", "cifras indic-arabas" },
            { "type.nu.armn", "dumbers armens" },
            { "type.nu.beng", "cifras bengalas" },
            { "type.nu.cakm", "cifras chakma" },
            { "type.nu.deva", "cifras devanagari" },
            { "type.nu.ethi", "cifras etiopicas" },
            { "type.nu.geor", "dumbers georgians" },
            { "type.nu.grek", "dumbers grecs" },
            { "type.nu.gujr", "cifras gujarati" },
            { "type.nu.guru", "cifras gurmukhi" },
            { "type.nu.hans", "dumbers en chinais simplifitgà" },
            { "type.nu.hant", "dumbers en chinais tradiziunal" },
            { "type.nu.hebr", "dumbers ebraics" },
            { "type.nu.java", "cifras javanaisas" },
            { "type.nu.jpan", "dumbers giapunais" },
            { "type.nu.khmr", "cifras khmer" },
            { "type.nu.knda", "cifras kannada" },
            { "type.nu.laoo", "cifras laotas" },
            { "type.nu.latn", "cifras occidentalas" },
            { "type.nu.mlym", "cifras malayalam" },
            { "type.nu.mtei", "cifras meetei mayek" },
            { "type.nu.mymr", "cifras dal Myanmar" },
            { "type.nu.olck", "cifras ol chiki" },
            { "type.nu.orya", "cifras oriya" },
            { "type.nu.taml", "dumbers tamil tradiziunal" },
            { "type.nu.telu", "cifras telugu" },
            { "type.nu.thai", "cifras en thai" },
            { "type.nu.tibt", "cifras tibetanas" },
            { "type.nu.vaii", "cifras vai" },
            { "type.ca.dangi", "chalender dangi" },
            { "type.co.ducet", "zavrada unicode standard" },
            { "type.lb.loose", "stil da sigl da lingia liber" },
            { "type.nu.roman", "dumbers romans" },
            { "type.ca.coptic", "chalender coptic" },
            { "type.ca.hebrew", "chalender ebraic" },
            { "type.ca.indian", "chalender naziunal indic" },
            { "type.co.pinyin", "Pinyin" },
            { "type.co.search", "tschertga generala" },
            { "type.co.stroke", "urden dals stritgs" },
            { "type.lb.normal", "stil da sigl da lingia normal" },
            { "type.lb.strict", "stil da sigl da lingia strict" },
            { "type.ms.metric", "sistem metric" },
            { "type.ca.chinese", "chalender chinais" },
            { "type.ca.islamic", "chalender hijri" },
            { "type.ca.iso8601", "chalender gregorian (cun l’onn al cumenzament)" },
            { "type.ca.persian", "chalender persian" },
            { "type.cf.account", "format da valuta per la contabilitad" },
            { "type.nu.arabext", "cifras indic-arabas extendidas" },
            { "type.nu.armnlow", "dumbers armens en minusclas" },
            { "type.nu.greklow", "dumbers grecs en minusclas" },
            { "type.nu.hanidec", "dumbers chinais decimals" },
            { "type.nu.hansfin", "dumbers finanziars en chinais simplifitgà" },
            { "type.nu.hantfin", "dumbers finanziars en chinais tradiziunal" },
            { "type.nu.jpanfin", "dumbers finanziars giapunais" },
            { "type.nu.tamldec", "cifras tamilas" },
            { "type.ca.buddhist", "chalender budistic" },
            { "type.ca.ethiopic", "chalender etiopic" },
            { "type.ca.japanese", "chalender giapunais" },
            { "type.cf.standard", "format da valuta da standard" },
            { "type.co.standard", "zavrada da standard" },
            { "type.ms.uksystem", "sistem imperial britannic" },
            { "type.ms.ussystem", "sistem da mesira USA" },
            { "type.nu.fullwide", "cifras da ladezza cumplaina" },
            { "type.nu.romanlow", "dumbers romans en minusclas" },
            { "type.ca.gregorian", "chalender gregorian" },
            { "type.co.phonebook", "cudesch da telefon" },
            { "type.co.traditional", "reglas tradiziunalas" },
            { "type.ca.islamic-civil", "chalender hijri (tabellar, epoca civila)" },
            { "type.ca.islamic-umalqura", "chalender hijri (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "chalender etiopic amete alem" },
        };
        return data;
    }
}
