"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.subdomainOverride = exports.fullDomainOverride = exports.domainMap = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _index = require("./index");
/**
 * Creates a mapping from perimeter to environment to domain, allowing simply substitutions
 * to minimize the amount of data we have to ship to the browser.
 */
var domainMap = exports.domainMap = (0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)({}, _index.COMMERCIAL, (0, _defineProperty2.default)((0, _defineProperty2.default)({}, _index.STAGING, 'stg.atlassian.com'), _index.PRODUCTION, 'atlassian.com')), _index.FEDRAMP_FEDEX, (0, _defineProperty2.default)({}, _index.STAGING, 'atlassian-fex.com')), _index.FEDRAMP_MODERATE, (0, _defineProperty2.default)((0, _defineProperty2.default)({}, _index.STAGING, 'stg.atlassian-us-gov-mod.com'), _index.PRODUCTION, 'atlassian-us-gov-mod.com'));

// Contains overrides for subdomains where the DomainKey is different from the subdomain
var subdomainOverride = exports.subdomainOverride = {};

/**
 * Contains overrides for domains where the pattern of subdomain only doesn't work.
 * Useful in situations where this is a global domain that won't vary per environment.
 * Priority is exact match > fallback to commercial production
 *
 * IF YOU ADD SOMETHING HERE YOU MUST EXPLICITLY ADD EVERY PERIMETER AND EVERY ENVIRONMENT
 * ANYTHING NOT SET EXPLICITLY WILL DEFEAULT TO COMMERCIAL/PRODUCTION
 */
var fullDomainOverride = exports.fullDomainOverride = {
  analytics: (0, _defineProperty2.default)({}, _index.COMMERCIAL, (0, _defineProperty2.default)({}, _index.PRODUCTION, 'analytics.atlassian.com')),
  // Marketing site
  confluence: (0, _defineProperty2.default)({}, _index.COMMERCIAL, (0, _defineProperty2.default)({}, _index.PRODUCTION, 'confluence.atlassian.com')),
  // Atlassian design system documentation
  design: (0, _defineProperty2.default)({}, _index.COMMERCIAL, (0, _defineProperty2.default)({}, _index.PRODUCTION, 'design.atlassian.com')),
  // Old staff intranet (now hello.atlassian.net)
  extranet: (0, _defineProperty2.default)({}, _index.COMMERCIAL, (0, _defineProperty2.default)({}, _index.PRODUCTION, 'extranet.atlassian.com')),
  // Go links
  go: (0, _defineProperty2.default)({}, _index.COMMERCIAL, (0, _defineProperty2.default)({}, _index.PRODUCTION, 'go.atlassian.com')),
  my: (0, _defineProperty2.default)({}, _index.COMMERCIAL, (0, _defineProperty2.default)({}, _index.PRODUCTION, 'my.atlassian.com')),
  schema: (0, _defineProperty2.default)({}, _index.COMMERCIAL, (0, _defineProperty2.default)({}, _index.PRODUCTION, 'schema.atlassian.com')),
  start: (0, _defineProperty2.default)((0, _defineProperty2.default)({}, _index.COMMERCIAL, (0, _defineProperty2.default)((0, _defineProperty2.default)({}, _index.PRODUCTION, 'start.atlassian.com'), _index.STAGING, 'start.stg.atlassian.com')), _index.FEDRAMP_MODERATE, (0, _defineProperty2.default)((0, _defineProperty2.default)({}, _index.PRODUCTION, 'start.atlassian-us-gov-mod.com'), _index.STAGING, 'start.stg.atlassian-us-gov-mod.com')),
  surveys: (0, _defineProperty2.default)({}, _index.COMMERCIAL, (0, _defineProperty2.default)({}, _index.PRODUCTION, 'surveys.atlassian.com')),
  'wac-cdn': (0, _defineProperty2.default)({}, _index.COMMERCIAL, (0, _defineProperty2.default)({}, _index.PRODUCTION, 'wac-cdn.atlassian.com')),
  integrations: (0, _defineProperty2.default)({}, _index.COMMERCIAL, (0, _defineProperty2.default)({}, _index.PRODUCTION, 'integrations.atlassian.com')),
  permalink: (0, _defineProperty2.default)({}, _index.COMMERCIAL, (0, _defineProperty2.default)({}, _index.PRODUCTION, 'permalink.atlassian.com')),
  id: (0, _defineProperty2.default)((0, _defineProperty2.default)({}, _index.COMMERCIAL, (0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)({}, _index.PRODUCTION, 'id.atlassian.com'), _index.STAGING, 'id.stg.internal.atlassian.com'), _index.DEV, 'id.dev.internal.atlassian.com')), _index.FEDRAMP_MODERATE, (0, _defineProperty2.default)((0, _defineProperty2.default)({}, _index.PRODUCTION, 'id.atlassian-us-gov-mod.com'), _index.STAGING, 'id.stg.atlassian-us-gov-mod.com')),
  support: (0, _defineProperty2.default)({}, _index.COMMERCIAL, (0, _defineProperty2.default)({}, _index.PRODUCTION, 'support.atlassian.com'))
};