set -e
usage() {
    echo "usage: $0 FILENAME"
    exit 1
}

test $# -eq 1 || usage
filename=$1

tls=$( head -n 1 conf-tls )
if [ $tls = auto ]
then
    # Detect a TLS library using pkg-config
    if pkg-config gnutls
    then
        tls=gnutls
    else
        tls=none
    fi
fi

case $filename in
    starttls.c)
        rm -f $filename
        {
            echo "/* Auto-generated by $0 */"
            cat starttls-${tls}.c
        } > $filename
        ;;
    tls.lib)
        {
            test $tls = none || pkg-config $tls --libs
        } > $filename
        ;;
    *)
        usage
        ;;
esac
