/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.function.Failable;
import org.apache.commons.lang3.function.FailableBiConsumer;
import org.apache.commons.lang3.function.FailableBiFunction;
import org.apache.commons.lang3.function.FailableBiPredicate;
import org.apache.commons.lang3.function.FailableBooleanSupplier;
import org.apache.commons.lang3.function.FailableCallable;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableDoubleBinaryOperator;
import org.apache.commons.lang3.function.FailableDoubleConsumer;
import org.apache.commons.lang3.function.FailableDoubleFunction;
import org.apache.commons.lang3.function.FailableDoublePredicate;
import org.apache.commons.lang3.function.FailableDoubleSupplier;
import org.apache.commons.lang3.function.FailableDoubleToIntFunction;
import org.apache.commons.lang3.function.FailableDoubleToLongFunction;
import org.apache.commons.lang3.function.FailableDoubleUnaryOperator;
import org.apache.commons.lang3.function.FailableFunction;
import org.apache.commons.lang3.function.FailableIntBinaryOperator;
import org.apache.commons.lang3.function.FailableIntConsumer;
import org.apache.commons.lang3.function.FailableIntFunction;
import org.apache.commons.lang3.function.FailableIntPredicate;
import org.apache.commons.lang3.function.FailableIntSupplier;
import org.apache.commons.lang3.function.FailableIntToDoubleFunction;
import org.apache.commons.lang3.function.FailableIntToLongFunction;
import org.apache.commons.lang3.function.FailableIntUnaryOperator;
import org.apache.commons.lang3.function.FailableLongBinaryOperator;
import org.apache.commons.lang3.function.FailableLongConsumer;
import org.apache.commons.lang3.function.FailableLongFunction;
import org.apache.commons.lang3.function.FailableLongPredicate;
import org.apache.commons.lang3.function.FailableLongSupplier;
import org.apache.commons.lang3.function.FailableLongToDoubleFunction;
import org.apache.commons.lang3.function.FailableLongToIntFunction;
import org.apache.commons.lang3.function.FailableLongUnaryOperator;
import org.apache.commons.lang3.function.FailableObjDoubleConsumer;
import org.apache.commons.lang3.function.FailableObjIntConsumer;
import org.apache.commons.lang3.function.FailableObjLongConsumer;
import org.apache.commons.lang3.function.FailablePredicate;
import org.apache.commons.lang3.function.FailableRunnable;
import org.apache.commons.lang3.function.FailableShortSupplier;
import org.apache.commons.lang3.function.FailableSupplier;
import org.apache.commons.lang3.function.FailableToDoubleBiFunction;
import org.apache.commons.lang3.function.FailableToDoubleFunction;
import org.apache.commons.lang3.function.FailableToIntBiFunction;
import org.apache.commons.lang3.function.FailableToIntFunction;
import org.apache.commons.lang3.function.FailableToLongBiFunction;
import org.apache.commons.lang3.function.FailableToLongFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class FailableFunctionsTest
extends AbstractLangTest {
    private static final OutOfMemoryError ERROR = new OutOfMemoryError();
    private static final IllegalStateException ILLEGAL_STATE_EXCEPTION = new IllegalStateException();

    @Test
    public void testAcceptBiConsumer() {
        Testable testable = new Testable(null);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.accept(Testable::test, (Object)testable, (Object)ILLEGAL_STATE_EXCEPTION));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.accept(Testable::test, (Object)testable, (Object)ERROR));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.accept(Testable::test, (Object)testable, (Object)ioe));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        Failable.accept(Testable::test, testable, (Object)null);
    }

    @Test
    public void testAcceptConsumer() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.accept(Testable::test, (Object)testable));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.accept(Testable::test, (Object)testable));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.accept(Testable::test, (Object)testable));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        Failable.accept(Testable::test, testable);
    }

    @Test
    public void testAcceptDoubleConsumer() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.accept(testable::testDouble, (double)1.0));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.accept(testable::testDouble, (double)1.0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.accept(testable::testDouble, (double)1.0));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(null);
        Failable.accept(testable::testDouble, (double)1.0);
        Assertions.assertEquals((double)1.0, (Double)((Double)testable.getAcceptedPrimitiveObject1()));
    }

    @Test
    public void testAcceptIntConsumer() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.accept(testable::testInt, (int)1));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.accept(testable::testInt, (int)1));
        Assertions.assertSame((Object)ERROR, (Object)e);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.accept(testable::testInt, (int)1));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(null);
        Failable.accept(testable::testInt, (int)1);
        Assertions.assertEquals((int)1, (Integer)((Integer)testable.getAcceptedPrimitiveObject1()));
    }

    @Test
    public void testAcceptLongConsumer() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.accept(testable::testLong, (long)1L));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.accept(testable::testLong, (long)1L));
        Assertions.assertSame((Object)ERROR, (Object)e);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.accept(testable::testLong, (long)1L));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(null);
        Failable.accept(testable::testLong, (long)1L);
        Assertions.assertEquals((long)1L, (Long)((Long)testable.getAcceptedPrimitiveObject1()));
    }

    @Test
    public void testAcceptObjDoubleConsumer() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.accept(testable::testObjDouble, (Object)"X", (Object)1.0));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.accept(testable::testObjDouble, (Object)"X", (Object)1.0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.accept(testable::testObjDouble, (Object)"X", (Object)1.0));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(null);
        Failable.accept(testable::testObjDouble, (Object)"X", (Object)1.0);
        Assertions.assertEquals((Object)"X", testable.getAcceptedObject());
        Assertions.assertEquals((double)1.0, (Double)((Double)testable.getAcceptedPrimitiveObject1()));
    }

    @Test
    public void testAcceptObjIntConsumer() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.accept(testable::testObjInt, (Object)"X", (Object)1));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.accept(testable::testObjInt, (Object)"X", (Object)1));
        Assertions.assertSame((Object)ERROR, (Object)e);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.accept(testable::testObjInt, (Object)"X", (Object)1));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(null);
        Failable.accept(testable::testObjInt, (Object)"X", (Object)1);
        Assertions.assertEquals((Object)"X", testable.getAcceptedObject());
        Assertions.assertEquals((int)1, (Integer)((Integer)testable.getAcceptedPrimitiveObject1()));
    }

    @Test
    public void testAcceptObjLongConsumer() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.accept(testable::testObjLong, (Object)"X", (Object)1L));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.accept(testable::testObjLong, (Object)"X", (Object)1L));
        Assertions.assertSame((Object)ERROR, (Object)e);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.accept(testable::testObjLong, (Object)"X", (Object)1L));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(null);
        Failable.accept(testable::testObjLong, (Object)"X", (Object)1L);
        Assertions.assertEquals((Object)"X", testable.getAcceptedObject());
        Assertions.assertEquals((long)1L, (Long)((Long)testable.getAcceptedPrimitiveObject1()));
    }

    @Test
    public void testApplyBiFunction() {
        Testable testable = new Testable(null);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.apply(Testable::testAsInteger, (Object)testable, (Object)ILLEGAL_STATE_EXCEPTION));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.apply(Testable::testAsInteger, (Object)testable, (Object)ERROR));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.apply(Testable::testAsInteger, (Object)testable, (Object)ioe));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        Integer i = (Integer)Failable.apply(Testable::testAsInteger, testable, (Object)null);
        Assertions.assertNotNull((Object)i);
        Assertions.assertEquals((int)0, (int)i);
    }

    @Test
    public void testApplyDoubleBinaryOperator() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.applyAsDouble(testable::testDoubleDouble, (double)1.0, (double)2.0));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        Testable testable2 = new Testable(null);
        double i = Failable.applyAsDouble(testable2::testDoubleDouble, (double)1.0, (double)2.0);
        Assertions.assertEquals((double)3.0, (double)i);
    }

    @Test
    public void testApplyFunction() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.apply(Testable::testAsInteger, (Object)testable));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.apply(Testable::testAsInteger, (Object)testable));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.apply(Testable::testAsInteger, (Object)testable));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        Integer i = (Integer)Failable.apply(Testable::testAsInteger, testable);
        Assertions.assertNotNull((Object)i);
        Assertions.assertEquals((int)0, (int)i);
    }

    @Test
    public void testAsCallable() {
        FailureOnOddInvocations instance;
        FailureOnOddInvocations.invocations = 0;
        FailableCallable failableCallable = FailureOnOddInvocations::new;
        Callable callable = Failable.asCallable((FailableCallable)failableCallable);
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, callable::call);
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertTrue((boolean)(cause instanceof SomeException));
        Assertions.assertEquals((Object)"Odd Invocation: 1", (Object)cause.getMessage());
        try {
            instance = (FailureOnOddInvocations)callable.call();
        }
        catch (Exception ex) {
            throw Failable.rethrow((Throwable)ex);
        }
        Assertions.assertNotNull((Object)instance);
    }

    @Test
    public void testAsConsumer() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Consumer consumer = Failable.asConsumer(Testable::test);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> consumer.accept(testable));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> consumer.accept(testable));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> consumer.accept(testable));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        Failable.accept(Testable::test, testable);
    }

    @Test
    public void testAsRunnable() {
        FailureOnOddInvocations.invocations = 0;
        Runnable runnable = Failable.asRunnable(FailureOnOddInvocations::new);
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, runnable::run);
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertTrue((boolean)(cause instanceof SomeException));
        Assertions.assertEquals((Object)"Odd Invocation: 1", (Object)cause.getMessage());
        runnable.run();
    }

    @Test
    public void testAsSupplier() {
        FailureOnOddInvocations.invocations = 0;
        FailableSupplier failableSupplier = FailureOnOddInvocations::new;
        Supplier supplier = Failable.asSupplier((FailableSupplier)failableSupplier);
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, ((Supplier)supplier)::get);
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertTrue((boolean)(cause instanceof SomeException));
        Assertions.assertEquals((Object)"Odd Invocation: 1", (Object)cause.getMessage());
        Assertions.assertNotNull(supplier.get());
    }

    @Test
    public void testBiConsumer() throws Throwable {
        Testable testable = new Testable(null);
        FailableBiConsumer failableBiConsumer = (t, th) -> {
            t.setThrowable((Throwable)th);
            t.test();
        };
        BiConsumer consumer = Failable.asBiConsumer((FailableBiConsumer)failableBiConsumer);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> consumer.accept(testable, ILLEGAL_STATE_EXCEPTION));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> consumer.accept(testable, ERROR));
        Assertions.assertSame((Object)ERROR, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> failableBiConsumer.accept((Object)testable, (Object)ERROR));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> consumer.accept(testable, ioe));
        Throwable t2 = e.getCause();
        Assertions.assertNotNull((Object)t2);
        Assertions.assertSame((Object)ioe, (Object)t2);
        consumer.accept(testable, null);
    }

    @Test
    public void testBiConsumerAndThen() throws Throwable {
        Testable testable = new Testable(null);
        FailableBiConsumer failing = (t, th) -> {
            t.setThrowable((Throwable)th);
            t.test();
        };
        FailableBiConsumer nop = FailableBiConsumer.nop();
        Throwable e = Assertions.assertThrows(OutOfMemoryError.class, () -> nop.andThen(failing).accept((Object)testable, (Object)ERROR));
        Assertions.assertSame((Object)ERROR, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> failing.andThen(nop).accept((Object)testable, (Object)ERROR));
        Assertions.assertSame((Object)ERROR, (Object)e);
        nop.andThen(nop);
        Assertions.assertThrows(NullPointerException.class, () -> failing.andThen(null));
    }

    @Test
    public void testBiFunction() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        FailableBiFunction failableBiFunction = (t, th) -> {
            t.setThrowable((Throwable)th);
            return t.testAsInteger();
        };
        BiFunction biFunction = Failable.asBiFunction((FailableBiFunction)failableBiFunction);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> biFunction.apply(testable, ILLEGAL_STATE_EXCEPTION));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> biFunction.apply(testable, ERROR));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> biFunction.apply(testable, ioe));
        Throwable t2 = e.getCause();
        Assertions.assertNotNull((Object)t2);
        Assertions.assertSame((Object)ioe, (Object)t2);
        Assertions.assertEquals((int)0, (int)((Integer)biFunction.apply(testable, null)));
    }

    @Test
    public void testBiFunctionAndThen() throws IOException {
        BiFunction<Object, Integer, Integer> nopBiFunction = (t, u) -> null;
        Function<Object, Integer> nopFunction = t -> null;
        nopBiFunction.andThen(nopFunction);
        FailableBiFunction failingBiFunctionTest = (t, u) -> {
            throw new IOException();
        };
        FailableFunction failingFunction = t -> {
            throw new IOException();
        };
        FailableBiFunction nopFailableBiFunction = FailableBiFunction.nop();
        FailableFunction nopFailableFunction = FailableFunction.nop();
        Assertions.assertThrows(IOException.class, () -> failingBiFunctionTest.andThen(failingFunction).apply(null, null));
        Assertions.assertThrows(IOException.class, () -> failingBiFunctionTest.andThen(nopFailableFunction).apply(null, null));
        Assertions.assertThrows(IOException.class, () -> nopFailableBiFunction.andThen(failingFunction).apply(null, null));
        nopFailableBiFunction.andThen(nopFailableFunction).apply(null, null);
        Assertions.assertThrows(NullPointerException.class, () -> failingBiFunctionTest.andThen(null));
    }

    @Test
    @DisplayName(value="Test that asPredicate(FailableBiPredicate) is converted to -> BiPredicate ")
    public void testBiPredicate() {
        FailureOnOddInvocations.invocations = 0;
        FailableBiPredicate failableBiPredicate = (t1, t2) -> FailureOnOddInvocations.failingBool();
        BiPredicate predicate = Failable.asBiPredicate((FailableBiPredicate)failableBiPredicate);
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, () -> predicate.test(null, null));
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertTrue((boolean)(cause instanceof SomeException));
        Assertions.assertEquals((Object)"Odd Invocation: 1", (Object)cause.getMessage());
        Assertions.assertTrue((boolean)predicate.test(null, null));
    }

    @Test
    public void testBiPredicateAnd() throws Throwable {
        Assertions.assertTrue((boolean)FailableBiPredicate.TRUE.and(FailableBiPredicate.TRUE).test(null, null));
        Assertions.assertFalse((boolean)FailableBiPredicate.TRUE.and(FailableBiPredicate.FALSE).test(null, null));
        Assertions.assertFalse((boolean)FailableBiPredicate.FALSE.and(FailableBiPredicate.TRUE).test(null, null));
        Assertions.assertFalse((boolean)FailableBiPredicate.FALSE.and(FailableBiPredicate.FALSE).test(null, null));
        Assertions.assertThrows(NullPointerException.class, () -> Assertions.assertFalse((boolean)FailableBiPredicate.falsePredicate().and(null).test(null, null)));
        Assertions.assertThrows(NullPointerException.class, () -> Assertions.assertTrue((boolean)FailableBiPredicate.truePredicate().and(null).test(null, null)));
    }

    @Test
    public void testBiPredicateNegate() throws Throwable {
        Assertions.assertFalse((boolean)FailableBiPredicate.TRUE.negate().test(null, null));
        Assertions.assertFalse((boolean)FailableBiPredicate.truePredicate().negate().test(null, null));
        Assertions.assertTrue((boolean)FailableBiPredicate.FALSE.negate().test(null, null));
        Assertions.assertTrue((boolean)FailableBiPredicate.falsePredicate().negate().test(null, null));
    }

    @Test
    public void testBiPredicateOr() throws Throwable {
        Assertions.assertTrue((boolean)FailableBiPredicate.TRUE.or(FailableBiPredicate.TRUE).test(null, null));
        Assertions.assertTrue((boolean)FailableBiPredicate.TRUE.or(FailableBiPredicate.FALSE).test(null, null));
        Assertions.assertTrue((boolean)FailableBiPredicate.FALSE.or(FailableBiPredicate.TRUE).test(null, null));
        Assertions.assertFalse((boolean)FailableBiPredicate.FALSE.or(FailableBiPredicate.FALSE).test(null, null));
        Assertions.assertThrows(NullPointerException.class, () -> Assertions.assertFalse((boolean)FailableBiPredicate.falsePredicate().or(null).test(null, null)));
        Assertions.assertThrows(NullPointerException.class, () -> Assertions.assertTrue((boolean)FailableBiPredicate.truePredicate().or(null).test(null, null)));
    }

    @Test
    public void testCallable() {
        FailureOnOddInvocations.invocations = 0;
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, () -> Failable.run(FailureOnOddInvocations::new));
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertTrue((boolean)(cause instanceof SomeException));
        Assertions.assertEquals((Object)"Odd Invocation: 1", (Object)cause.getMessage());
        FailureOnOddInvocations instance = (FailureOnOddInvocations)Failable.call(FailureOnOddInvocations::new);
        Assertions.assertNotNull((Object)instance);
    }

    @Test
    public void testConsumerAndThen() throws Throwable {
        Testable testable = new Testable(null);
        FailableConsumer failableConsumer = th -> {
            testable.setThrowable((Throwable)th);
            testable.test();
        };
        FailableConsumer nop = FailableConsumer.nop();
        Throwable e = Assertions.assertThrows(OutOfMemoryError.class, () -> nop.andThen(failableConsumer).accept((Object)ERROR));
        Assertions.assertSame((Object)ERROR, (Object)e);
        nop.andThen(nop);
        Assertions.assertThrows(NullPointerException.class, () -> failableConsumer.andThen(null));
    }

    @Test
    public void testDoubleConsumerAndThen() throws Throwable {
        Testable testable = new Testable(null);
        FailableDoubleConsumer failing = t -> {
            testable.setThrowable(ERROR);
            testable.test();
        };
        FailableDoubleConsumer nop = FailableDoubleConsumer.nop();
        Throwable e = Assertions.assertThrows(OutOfMemoryError.class, () -> nop.andThen(failing).accept(0.0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> failing.andThen(nop).accept(0.0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        nop.andThen(nop);
        Assertions.assertThrows(NullPointerException.class, () -> failing.andThen(null));
    }

    @Test
    public void testDoublePredicate() throws Throwable {
        FailureOnOddInvocations.invocations = 0;
        FailableDoublePredicate failablePredicate = FailureOnOddInvocations::testDouble;
        Assertions.assertThrows(SomeException.class, () -> failablePredicate.test(1.0));
        failablePredicate.test(1.0);
    }

    @Test
    public void testDoublePredicateAnd() throws Throwable {
        Assertions.assertTrue((boolean)FailableDoublePredicate.TRUE.and(FailableDoublePredicate.TRUE).test(0.0));
        Assertions.assertFalse((boolean)FailableDoublePredicate.TRUE.and(FailableDoublePredicate.FALSE).test(0.0));
        Assertions.assertFalse((boolean)FailableDoublePredicate.FALSE.and(FailableDoublePredicate.TRUE).test(0.0));
        Assertions.assertFalse((boolean)FailableDoublePredicate.FALSE.and(FailableDoublePredicate.FALSE).test(0.0));
        Assertions.assertThrows(NullPointerException.class, () -> Assertions.assertFalse((boolean)FailableDoublePredicate.falsePredicate().and(null).test(0.0)));
        Assertions.assertThrows(NullPointerException.class, () -> Assertions.assertTrue((boolean)FailableDoublePredicate.truePredicate().and(null).test(0.0)));
    }

    @Test
    public void testDoublePredicateNegate() throws Throwable {
        Assertions.assertFalse((boolean)FailableDoublePredicate.TRUE.negate().test(0.0));
        Assertions.assertFalse((boolean)FailableDoublePredicate.truePredicate().negate().test(0.0));
        Assertions.assertTrue((boolean)FailableDoublePredicate.FALSE.negate().test(0.0));
        Assertions.assertTrue((boolean)FailableDoublePredicate.falsePredicate().negate().test(0.0));
    }

    @Test
    public void testDoublePredicateOr() throws Throwable {
        Assertions.assertTrue((boolean)FailableDoublePredicate.TRUE.or(FailableDoublePredicate.TRUE).test(0.0));
        Assertions.assertTrue((boolean)FailableDoublePredicate.TRUE.or(FailableDoublePredicate.FALSE).test(0.0));
        Assertions.assertTrue((boolean)FailableDoublePredicate.FALSE.or(FailableDoublePredicate.TRUE).test(0.0));
        Assertions.assertFalse((boolean)FailableDoublePredicate.FALSE.or(FailableDoublePredicate.FALSE).test(0.0));
        Assertions.assertThrows(NullPointerException.class, () -> Assertions.assertFalse((boolean)FailableDoublePredicate.falsePredicate().or(null).test(0.0)));
        Assertions.assertThrows(NullPointerException.class, () -> Assertions.assertTrue((boolean)FailableDoublePredicate.truePredicate().or(null).test(0.0)));
    }

    @Test
    public void testDoubleUnaryOperatorAndThen() throws Throwable {
        Testable testable = new Testable(null);
        FailableDoubleUnaryOperator failing = t -> {
            testable.setThrowable(ERROR);
            testable.test();
            return 0.0;
        };
        FailableDoubleUnaryOperator nop = FailableDoubleUnaryOperator.nop();
        Throwable e = Assertions.assertThrows(OutOfMemoryError.class, () -> nop.andThen(failing).applyAsDouble(0.0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> failing.andThen(nop).applyAsDouble(0.0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        nop.andThen(nop);
        Assertions.assertThrows(NullPointerException.class, () -> failing.andThen(null));
    }

    @Test
    public void testDoubleUnaryOperatorCompose() throws Throwable {
        Testable testable = new Testable(null);
        FailableDoubleUnaryOperator failing = t -> {
            testable.setThrowable(ERROR);
            testable.test();
            return 0.0;
        };
        FailableDoubleUnaryOperator nop = FailableDoubleUnaryOperator.nop();
        Throwable e = Assertions.assertThrows(OutOfMemoryError.class, () -> nop.compose(failing).applyAsDouble(0.0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> failing.compose(nop).applyAsDouble(0.0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        nop.compose(nop);
        Assertions.assertThrows(NullPointerException.class, () -> failing.compose(null));
    }

    @Test
    public void testDoubleUnaryOperatorIdentity() throws Throwable {
        FailableDoubleUnaryOperator nop = FailableDoubleUnaryOperator.identity();
        nop.compose(nop);
        Assertions.assertThrows(NullPointerException.class, () -> nop.compose(null));
    }

    @Test
    public void testFailableBiFunctionNop() throws Throwable {
        Assertions.assertNull((Object)FailableBiFunction.nop().apply((Object)"Foo", (Object)"Bar"), (String)"Expect NOP to return null");
    }

    @Test
    public void testFailableConsumerNop() throws Throwable {
        FailableConsumer.nop().accept((Object)"Foo");
    }

    @Test
    public void testFailableDoubleFunctionNop() throws Throwable {
        Assertions.assertNull((Object)FailableDoubleFunction.nop().apply(Double.MAX_VALUE), (String)"Expect NOP to return null");
    }

    @Test
    public void testFailableDoubleToIntFunctionNop() throws Throwable {
        Assertions.assertEquals((int)0, (int)FailableDoubleToIntFunction.nop().applyAsInt(Double.MAX_VALUE), (String)"Expect NOP to return 0");
    }

    @Test
    public void testFailableDoubleToLongFunctionNop() throws Throwable {
        Assertions.assertEquals((int)0, (int)FailableDoubleToLongFunction.nop().applyAsLong(Double.MAX_VALUE), (String)"Expect NOP to return 0");
    }

    @Test
    public void testFailableIntFunctionNop() throws Throwable {
        Assertions.assertNull((Object)FailableIntFunction.nop().apply(Integer.MAX_VALUE), (String)"Expect NOP to return null");
    }

    @Test
    public void testFailableIntToDoubleFunctionNop() throws Throwable {
        Assertions.assertEquals((double)0.0, (double)FailableIntToDoubleFunction.nop().applyAsDouble(Integer.MAX_VALUE), (String)"Expect NOP to return 0");
    }

    @Test
    public void testFailableIntToLongFunctionNop() throws Throwable {
        Assertions.assertEquals((long)0L, (long)FailableIntToLongFunction.nop().applyAsLong(Integer.MAX_VALUE), (String)"Expect NOP to return 0");
    }

    @Test
    public void testFailableLongFunctionNop() throws Throwable {
        Assertions.assertNull((Object)FailableLongFunction.nop().apply(Long.MAX_VALUE), (String)"Expect NOP to return null");
    }

    @Test
    public void testFailableLongToDoubleFunctionNop() throws Throwable {
        Assertions.assertEquals((double)0.0, (double)FailableLongToDoubleFunction.nop().applyAsDouble(Long.MAX_VALUE), (String)"Expect NOP to return 0");
    }

    @Test
    public void testFailableLongToIntFunctionNop() throws Throwable {
        Assertions.assertEquals((int)0, (int)FailableLongToIntFunction.nop().applyAsInt(Long.MAX_VALUE), (String)"Expect NOP to return 0");
    }

    @Test
    public void testFailableObjDoubleConsumerNop() throws Throwable {
        FailableObjDoubleConsumer.nop().accept((Object)"Foo", Double.MAX_VALUE);
    }

    @Test
    public void testFailableObjIntConsumerNop() throws Throwable {
        FailableObjIntConsumer.nop().accept((Object)"Foo", Integer.MAX_VALUE);
    }

    @Test
    public void testFailableObjLongConsumerNop() throws Throwable {
        FailableObjLongConsumer.nop().accept((Object)"Foo", Long.MAX_VALUE);
    }

    @Test
    public void testFailableToDoubleBiFunctionNop() throws Throwable {
        Assertions.assertEquals((double)0.0, (double)FailableToDoubleBiFunction.nop().applyAsDouble((Object)"Foo", (Object)"Bar"), (String)"Expect NOP to return 0");
    }

    @Test
    public void testFailableToDoubleFunctionNop() throws Throwable {
        Assertions.assertEquals((double)0.0, (double)FailableToDoubleFunction.nop().applyAsDouble((Object)"Foo"), (String)"Expect NOP to return 0");
    }

    @Test
    public void testFailableToIntBiFunctionNop() throws Throwable {
        Assertions.assertEquals((int)0, (int)FailableToIntBiFunction.nop().applyAsInt((Object)"Foo", (Object)"Bar"), (String)"Expect NOP to return 0");
    }

    @Test
    public void testFailableToIntFunctionNop() throws Throwable {
        Assertions.assertEquals((int)0, (int)FailableToIntFunction.nop().applyAsInt((Object)"Foo"), (String)"Expect NOP to return 0");
    }

    @Test
    public void testFailableToLongBiFunctionNop() throws Throwable {
        Assertions.assertEquals((long)0L, (long)FailableToLongBiFunction.nop().applyAsLong((Object)"Foo", (Object)"Bar"), (String)"Expect NOP to return 0");
    }

    @Test
    public void testFailableToLongFunctionNop() throws Throwable {
        Assertions.assertEquals((long)0L, (long)FailableToLongFunction.nop().applyAsLong((Object)"Foo"), (String)"Expect NOP to return 0");
    }

    @Test
    public void testFunction() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        FailableFunction failableFunction = th -> {
            testable.setThrowable((Throwable)th);
            return testable.testAsInteger();
        };
        Function function = Failable.asFunction((FailableFunction)failableFunction);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> function.apply(ILLEGAL_STATE_EXCEPTION));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> function.apply(ERROR));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> function.apply(ioe));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        Assertions.assertEquals((int)0, (int)((Integer)function.apply(null)));
    }

    @Test
    public void testFunctionAndThen() throws IOException {
        Function<Object, Integer> nopFunction = t -> null;
        nopFunction.andThen(nopFunction);
        FailableFunction failingFunction = t -> {
            throw new IOException();
        };
        FailableFunction nopFailableFunction = FailableFunction.nop();
        Assertions.assertThrows(IOException.class, () -> failingFunction.andThen(failingFunction).apply(null));
        Assertions.assertThrows(IOException.class, () -> failingFunction.andThen(nopFailableFunction).apply(null));
        Assertions.assertThrows(IOException.class, () -> nopFailableFunction.andThen(failingFunction).apply(null));
        nopFailableFunction.andThen(nopFailableFunction).apply(null);
        Assertions.assertThrows(NullPointerException.class, () -> failingFunction.andThen(null));
    }

    @Test
    public void testFunctionCompose() throws Throwable {
        Testable testable = new Testable(null);
        FailableFunction failing = t -> {
            testable.setThrowable(ERROR);
            testable.test();
            return 0;
        };
        FailableFunction nop = FailableFunction.nop();
        Throwable e = Assertions.assertThrows(OutOfMemoryError.class, () -> nop.compose(failing).apply((Object)0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> failing.compose(nop).apply((Object)0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        nop.compose(nop);
        Assertions.assertThrows(NullPointerException.class, () -> failing.compose(null));
    }

    @Test
    public void testFunctionFunction() throws Exception {
        Assertions.assertEquals((Object)"foo", (Object)FailableFunction.function(this::throwingFunction).andThen(this::throwingFunction).apply((Object)"foo"));
    }

    @Test
    public void testFunctionIdentity() throws Throwable {
        FailableFunction nop = FailableFunction.identity();
        nop.compose(nop);
        Assertions.assertThrows(NullPointerException.class, () -> nop.compose(null));
    }

    @Test
    public void testGetAsBooleanSupplier() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.getAsBoolean(testable::testAsBooleanPrimitive));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.getAsBoolean(testable::testAsBooleanPrimitive));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.getAsBoolean(testable::testAsBooleanPrimitive));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        Assertions.assertFalse((boolean)Failable.getAsBoolean(testable::testAsBooleanPrimitive));
    }

    @Test
    public void testGetAsDoubleSupplier() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.getAsDouble(testable::testAsDoublePrimitive));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.getAsDouble(testable::testAsDoublePrimitive));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.getAsDouble(testable::testAsDoublePrimitive));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        Assertions.assertEquals((double)0.0, (double)Failable.getAsDouble(testable::testAsDoublePrimitive));
    }

    @Test
    public void testGetAsIntSupplier() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.getAsInt(testable::testAsIntPrimitive));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.getAsInt(testable::testAsIntPrimitive));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.getAsInt(testable::testAsIntPrimitive));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        int i = Failable.getAsInt(testable::testAsInteger);
        Assertions.assertEquals((int)0, (int)i);
    }

    @Test
    public void testGetAsLongSupplier() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.getAsLong(testable::testAsLongPrimitive));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.getAsLong(testable::testAsLongPrimitive));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.getAsLong(testable::testAsLongPrimitive));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        long i = Failable.getAsLong(testable::testAsLongPrimitive);
        Assertions.assertEquals((long)0L, (long)i);
    }

    @Test
    public void testGetAsShortSupplier() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.getAsShort(testable::testAsShortPrimitive));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.getAsShort(testable::testAsShortPrimitive));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.getAsShort(testable::testAsShortPrimitive));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        short i = Failable.getAsShort(testable::testAsShortPrimitive);
        Assertions.assertEquals((int)0, (int)i);
    }

    @Test
    public void testGetFromSupplier() {
        FailureOnOddInvocations.invocations = 0;
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, () -> Failable.run(FailureOnOddInvocations::new));
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertTrue((boolean)(cause instanceof SomeException));
        Assertions.assertEquals((Object)"Odd Invocation: 1", (Object)cause.getMessage());
        FailureOnOddInvocations instance = (FailureOnOddInvocations)Failable.call(FailureOnOddInvocations::new);
        Assertions.assertNotNull((Object)instance);
    }

    @Test
    public void testGetSupplier() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.get(testable::testAsInteger));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.get(testable::testAsInteger));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.get(testable::testAsInteger));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        Integer i = (Integer)Failable.apply(Testable::testAsInteger, testable);
        Assertions.assertNotNull((Object)i);
        Assertions.assertEquals((int)0, (int)i);
    }

    @Test
    public void testIntConsumerAndThen() throws Throwable {
        Testable testable = new Testable(null);
        FailableIntConsumer failing = t -> {
            testable.setThrowable(ERROR);
            testable.test();
        };
        FailableIntConsumer nop = FailableIntConsumer.nop();
        Throwable e = Assertions.assertThrows(OutOfMemoryError.class, () -> nop.andThen(failing).accept(0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> failing.andThen(nop).accept(0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        nop.andThen(nop);
        Assertions.assertThrows(NullPointerException.class, () -> failing.andThen(null));
    }

    @Test
    public void testIntPredicate() throws Throwable {
        FailureOnOddInvocations.invocations = 0;
        FailableIntPredicate failablePredicate = FailureOnOddInvocations::testInt;
        Assertions.assertThrows(SomeException.class, () -> failablePredicate.test(1));
        failablePredicate.test(1);
    }

    @Test
    public void testIntPredicateAnd() throws Throwable {
        Assertions.assertTrue((boolean)FailableIntPredicate.TRUE.and(FailableIntPredicate.TRUE).test(0));
        Assertions.assertFalse((boolean)FailableIntPredicate.TRUE.and(FailableIntPredicate.FALSE).test(0));
        Assertions.assertFalse((boolean)FailableIntPredicate.FALSE.and(FailableIntPredicate.TRUE).test(0));
        Assertions.assertFalse((boolean)FailableIntPredicate.FALSE.and(FailableIntPredicate.FALSE).test(0));
        Assertions.assertThrows(NullPointerException.class, () -> Assertions.assertFalse((boolean)FailableIntPredicate.falsePredicate().and(null).test(0)));
        Assertions.assertThrows(NullPointerException.class, () -> Assertions.assertTrue((boolean)FailableIntPredicate.truePredicate().and(null).test(0)));
    }

    @Test
    public void testIntPredicateNegate() throws Throwable {
        Assertions.assertFalse((boolean)FailableIntPredicate.TRUE.negate().test(0));
        Assertions.assertFalse((boolean)FailableIntPredicate.truePredicate().negate().test(0));
        Assertions.assertTrue((boolean)FailableIntPredicate.FALSE.negate().test(0));
        Assertions.assertTrue((boolean)FailableIntPredicate.falsePredicate().negate().test(0));
    }

    @Test
    public void testIntPredicateOr() throws Throwable {
        Assertions.assertTrue((boolean)FailableIntPredicate.TRUE.or(FailableIntPredicate.TRUE).test(0));
        Assertions.assertTrue((boolean)FailableIntPredicate.TRUE.or(FailableIntPredicate.FALSE).test(0));
        Assertions.assertTrue((boolean)FailableIntPredicate.FALSE.or(FailableIntPredicate.TRUE).test(0));
        Assertions.assertFalse((boolean)FailableIntPredicate.FALSE.or(FailableIntPredicate.FALSE).test(0));
        Assertions.assertThrows(NullPointerException.class, () -> Assertions.assertFalse((boolean)FailableIntPredicate.falsePredicate().or(null).test(0)));
        Assertions.assertThrows(NullPointerException.class, () -> Assertions.assertTrue((boolean)FailableIntPredicate.truePredicate().or(null).test(0)));
    }

    @Test
    public void testIntUnaryOperatorAndThen() throws Throwable {
        Testable testable = new Testable(null);
        FailableIntUnaryOperator failing = t -> {
            testable.setThrowable(ERROR);
            testable.test();
            return 0;
        };
        FailableIntUnaryOperator nop = FailableIntUnaryOperator.nop();
        Throwable e = Assertions.assertThrows(OutOfMemoryError.class, () -> nop.andThen(failing).applyAsInt(0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> failing.andThen(nop).applyAsInt(0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        nop.andThen(nop);
        Assertions.assertThrows(NullPointerException.class, () -> failing.andThen(null));
    }

    @Test
    public void testIntUnaryOperatorCompose() throws Throwable {
        Testable testable = new Testable(null);
        FailableIntUnaryOperator failing = t -> {
            testable.setThrowable(ERROR);
            testable.test();
            return 0;
        };
        FailableIntUnaryOperator nop = FailableIntUnaryOperator.nop();
        Throwable e = Assertions.assertThrows(OutOfMemoryError.class, () -> nop.compose(failing).applyAsInt(0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> failing.compose(nop).applyAsInt(0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        nop.compose(nop);
        Assertions.assertThrows(NullPointerException.class, () -> failing.compose(null));
    }

    @Test
    public void testIntUnaryOperatorIdentity() throws Throwable {
        FailableIntUnaryOperator nop = FailableIntUnaryOperator.identity();
        nop.compose(nop);
        Assertions.assertThrows(NullPointerException.class, () -> nop.compose(null));
    }

    @Test
    public void testLongConsumerAndThen() throws Throwable {
        Testable testable = new Testable(null);
        FailableLongConsumer failing = t -> {
            testable.setThrowable(ERROR);
            testable.test();
        };
        FailableLongConsumer nop = FailableLongConsumer.nop();
        Throwable e = Assertions.assertThrows(OutOfMemoryError.class, () -> nop.andThen(failing).accept(0L));
        Assertions.assertSame((Object)ERROR, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> failing.andThen(nop).accept(0L));
        Assertions.assertSame((Object)ERROR, (Object)e);
        nop.andThen(nop);
        Assertions.assertThrows(NullPointerException.class, () -> failing.andThen(null));
    }

    @Test
    public void testLongPredicate() throws Throwable {
        FailureOnOddInvocations.invocations = 0;
        FailableLongPredicate failablePredicate = FailureOnOddInvocations::testLong;
        Assertions.assertThrows(SomeException.class, () -> failablePredicate.test(1L));
        failablePredicate.test(1L);
    }

    @Test
    public void testLongPredicateAnd() throws Throwable {
        Assertions.assertTrue((boolean)FailableLongPredicate.TRUE.and(FailableLongPredicate.TRUE).test(0L));
        Assertions.assertFalse((boolean)FailableLongPredicate.TRUE.and(FailableLongPredicate.FALSE).test(0L));
        Assertions.assertFalse((boolean)FailableLongPredicate.FALSE.and(FailableLongPredicate.TRUE).test(0L));
        Assertions.assertFalse((boolean)FailableLongPredicate.FALSE.and(FailableLongPredicate.FALSE).test(0L));
        Assertions.assertThrows(NullPointerException.class, () -> Assertions.assertFalse((boolean)FailableLongPredicate.falsePredicate().and(null).test(0L)));
        Assertions.assertThrows(NullPointerException.class, () -> Assertions.assertTrue((boolean)FailableLongPredicate.truePredicate().and(null).test(0L)));
    }

    @Test
    public void testLongPredicateNegate() throws Throwable {
        Assertions.assertFalse((boolean)FailableLongPredicate.TRUE.negate().test(0L));
        Assertions.assertFalse((boolean)FailableLongPredicate.truePredicate().negate().test(0L));
        Assertions.assertTrue((boolean)FailableLongPredicate.FALSE.negate().test(0L));
        Assertions.assertTrue((boolean)FailableLongPredicate.falsePredicate().negate().test(0L));
    }

    @Test
    public void testLongPredicateOr() throws Throwable {
        Assertions.assertTrue((boolean)FailableLongPredicate.TRUE.or(FailableLongPredicate.TRUE).test(0L));
        Assertions.assertTrue((boolean)FailableLongPredicate.TRUE.or(FailableLongPredicate.FALSE).test(0L));
        Assertions.assertTrue((boolean)FailableLongPredicate.FALSE.or(FailableLongPredicate.TRUE).test(0L));
        Assertions.assertFalse((boolean)FailableLongPredicate.FALSE.or(FailableLongPredicate.FALSE).test(0L));
        Assertions.assertThrows(NullPointerException.class, () -> Assertions.assertFalse((boolean)FailableLongPredicate.falsePredicate().or(null).test(0L)));
        Assertions.assertThrows(NullPointerException.class, () -> Assertions.assertTrue((boolean)FailableLongPredicate.truePredicate().or(null).test(0L)));
    }

    @Test
    public void testLongUnaryOperatorAndThen() throws Throwable {
        Testable testable = new Testable(null);
        FailableLongUnaryOperator failing = t -> {
            testable.setThrowable(ERROR);
            testable.test();
            return 0L;
        };
        FailableLongUnaryOperator nop = FailableLongUnaryOperator.nop();
        Throwable e = Assertions.assertThrows(OutOfMemoryError.class, () -> nop.andThen(failing).applyAsLong(0L));
        Assertions.assertSame((Object)ERROR, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> failing.andThen(nop).applyAsLong(0L));
        Assertions.assertSame((Object)ERROR, (Object)e);
        nop.andThen(nop);
        Assertions.assertThrows(NullPointerException.class, () -> failing.andThen(null));
    }

    @Test
    public void testLongUnaryOperatorCompose() throws Throwable {
        Testable testable = new Testable(null);
        FailableLongUnaryOperator failing = t -> {
            testable.setThrowable(ERROR);
            testable.test();
            return 0L;
        };
        FailableLongUnaryOperator nop = FailableLongUnaryOperator.nop();
        Throwable e = Assertions.assertThrows(OutOfMemoryError.class, () -> nop.compose(failing).applyAsLong(0L));
        Assertions.assertSame((Object)ERROR, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> failing.compose(nop).applyAsLong(0L));
        Assertions.assertSame((Object)ERROR, (Object)e);
        nop.compose(nop);
        Assertions.assertThrows(NullPointerException.class, () -> failing.compose(null));
    }

    @Test
    public void testLongUnaryOperatorIdentity() throws Throwable {
        FailableLongUnaryOperator nop = FailableLongUnaryOperator.identity();
        nop.compose(nop);
        Assertions.assertThrows(NullPointerException.class, () -> nop.compose(null));
    }

    @Test
    @DisplayName(value="Test that asPredicate(FailablePredicate) is converted to -> Predicate ")
    public void testPredicate() {
        FailureOnOddInvocations.invocations = 0;
        FailablePredicate failablePredicate = t -> FailureOnOddInvocations.failingBool();
        Predicate predicate = Failable.asPredicate((FailablePredicate)failablePredicate);
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, () -> predicate.test(null));
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertTrue((boolean)(cause instanceof SomeException));
        Assertions.assertEquals((Object)"Odd Invocation: 1", (Object)cause.getMessage());
        boolean instance = predicate.test(null);
        Assertions.assertNotNull((Object)instance);
    }

    @Test
    public void testPredicateAnd() throws Throwable {
        Assertions.assertTrue((boolean)FailablePredicate.TRUE.and(FailablePredicate.TRUE).test(null));
        Assertions.assertFalse((boolean)FailablePredicate.TRUE.and(FailablePredicate.FALSE).test(null));
        Assertions.assertFalse((boolean)FailablePredicate.FALSE.and(FailablePredicate.TRUE).test(null));
        Assertions.assertFalse((boolean)FailablePredicate.FALSE.and(FailablePredicate.FALSE).test(null));
        Assertions.assertThrows(NullPointerException.class, () -> Assertions.assertFalse((boolean)FailablePredicate.FALSE.and(null).test(null)));
        Assertions.assertThrows(NullPointerException.class, () -> Assertions.assertTrue((boolean)FailablePredicate.TRUE.and(null).test(null)));
    }

    @Test
    public void testPredicateNegate() throws Throwable {
        Assertions.assertFalse((boolean)FailablePredicate.TRUE.negate().test(null));
        Assertions.assertFalse((boolean)FailablePredicate.truePredicate().negate().test(null));
        Assertions.assertTrue((boolean)FailablePredicate.FALSE.negate().test(null));
        Assertions.assertTrue((boolean)FailablePredicate.falsePredicate().negate().test(null));
    }

    @Test
    public void testPredicateOr() throws Throwable {
        Assertions.assertTrue((boolean)FailablePredicate.TRUE.or(FailablePredicate.TRUE).test(null));
        Assertions.assertTrue((boolean)FailablePredicate.TRUE.or(FailablePredicate.FALSE).test(null));
        Assertions.assertTrue((boolean)FailablePredicate.FALSE.or(FailablePredicate.TRUE).test(null));
        Assertions.assertFalse((boolean)FailablePredicate.FALSE.or(FailablePredicate.FALSE).test(null));
        Assertions.assertThrows(NullPointerException.class, () -> Assertions.assertFalse((boolean)FailablePredicate.FALSE.or(null).test(null)));
        Assertions.assertThrows(NullPointerException.class, () -> Assertions.assertTrue((boolean)FailablePredicate.TRUE.or(null).test(null)));
    }

    @Test
    public void testRunnable() {
        FailureOnOddInvocations.invocations = 0;
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, () -> Failable.run(FailureOnOddInvocations::new));
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertTrue((boolean)(cause instanceof SomeException));
        Assertions.assertEquals((Object)"Odd Invocation: 1", (Object)cause.getMessage());
        Failable.run(FailureOnOddInvocations::new);
    }

    @Test
    public void testThrows_FailableBiConsumer_Object_Throwable() {
        new FailableBiConsumer<Object, Object, Throwable>(){

            public void accept(Object object1, Object object2) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableBiConsumer_String_IOException() {
        new FailableBiConsumer<String, String, IOException>(){

            public void accept(String object1, String object2) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableBiFunction_Object_Throwable() {
        new FailableBiFunction<Object, Object, Object, Throwable>(){

            public Object apply(Object input1, Object input2) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableBiFunction_String_IOException() {
        new FailableBiFunction<String, String, String, IOException>(){

            public String apply(String input1, String input2) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableBiPredicate_Object_Throwable() {
        new FailableBiPredicate<Object, Object, Throwable>(){

            public boolean test(Object object1, Object object2) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableBiPredicate_String_IOException() {
        new FailableBiPredicate<String, String, IOException>(){

            public boolean test(String object1, String object2) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableBooleanSupplier_IOException() {
        new FailableBooleanSupplier<IOException>(){

            public boolean getAsBoolean() throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableBooleanSupplier_Throwable() {
        new FailableBooleanSupplier<Throwable>(){

            public boolean getAsBoolean() throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableCallable_Object_Throwable() {
        new FailableCallable<Object, Throwable>(){

            public Object call() throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableCallable_String_IOException() {
        new FailableCallable<String, IOException>(){

            public String call() throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableConsumer_Object_Throwable() {
        new FailableConsumer<Object, Throwable>(){

            public void accept(Object object) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableConsumer_String_IOException() {
        new FailableConsumer<String, IOException>(){

            public void accept(String object) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableDoubleBinaryOperator_IOException() {
        new FailableDoubleBinaryOperator<IOException>(){

            public double applyAsDouble(double left, double right) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableDoubleBinaryOperator_Throwable() {
        new FailableDoubleBinaryOperator<Throwable>(){

            public double applyAsDouble(double left, double right) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableDoubleConsumer_IOException() {
        new FailableDoubleConsumer<IOException>(){

            public void accept(double value) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableDoubleConsumer_Throwable() {
        new FailableDoubleConsumer<Throwable>(){

            public void accept(double value) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableDoubleFunction_IOException() {
        new FailableDoubleFunction<String, IOException>(){

            public String apply(double input) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableDoubleFunction_Throwable() {
        new FailableDoubleFunction<Object, Throwable>(){

            public Object apply(double input) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableDoubleSupplier_IOException() {
        new FailableDoubleSupplier<IOException>(){

            public double getAsDouble() throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableDoubleSupplier_Throwable() {
        new FailableDoubleSupplier<Throwable>(){

            public double getAsDouble() throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableDoubleToIntFunction_IOException() {
        new FailableDoubleToIntFunction<IOException>(){

            public int applyAsInt(double value) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableDoubleToIntFunction_Throwable() {
        new FailableDoubleToIntFunction<Throwable>(){

            public int applyAsInt(double value) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableDoubleToLongFunction_IOException() {
        new FailableDoubleToLongFunction<IOException>(){

            public int applyAsLong(double value) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableDoubleToLongFunction_Throwable() {
        new FailableDoubleToLongFunction<Throwable>(){

            public int applyAsLong(double value) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableFunction_Object_Throwable() {
        new FailableFunction<Object, Object, Throwable>(){

            public Object apply(Object input) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableFunction_String_IOException() {
        new FailableFunction<String, String, IOException>(){

            public String apply(String input) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableIntBinaryOperator_IOException() {
        new FailableIntBinaryOperator<IOException>(){

            public int applyAsInt(int left, int right) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableIntBinaryOperator_Throwable() {
        new FailableIntBinaryOperator<Throwable>(){

            public int applyAsInt(int left, int right) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableIntConsumer_IOException() {
        new FailableIntConsumer<IOException>(){

            public void accept(int value) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableIntConsumer_Throwable() {
        new FailableIntConsumer<Throwable>(){

            public void accept(int value) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableIntFunction_Object_Throwable() {
        new FailableIntFunction<Object, Throwable>(){

            public Object apply(int input) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableIntFunction_String_IOException() {
        new FailableIntFunction<String, IOException>(){

            public String apply(int input) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableIntSupplier_IOException() {
        new FailableIntSupplier<IOException>(){

            public int getAsInt() throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableIntSupplier_Throwable() {
        new FailableIntSupplier<Throwable>(){

            public int getAsInt() throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableIntToDoubleFunction_IOException() {
        new FailableIntToDoubleFunction<IOException>(){

            public double applyAsDouble(int value) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableIntToDoubleFunction_Throwable() {
        new FailableIntToDoubleFunction<Throwable>(){

            public double applyAsDouble(int value) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableIntToLongFunction_IOException() {
        new FailableIntToLongFunction<IOException>(){

            public long applyAsLong(int value) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableIntToLongFunction_Throwable() {
        new FailableIntToLongFunction<Throwable>(){

            public long applyAsLong(int value) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableLongBinaryOperator_IOException() {
        new FailableLongBinaryOperator<IOException>(){

            public long applyAsLong(long left, long right) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableLongBinaryOperator_Throwable() {
        new FailableLongBinaryOperator<Throwable>(){

            public long applyAsLong(long left, long right) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableLongConsumer_IOException() {
        new FailableLongConsumer<IOException>(){

            public void accept(long object) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableLongConsumer_Throwable() {
        new FailableLongConsumer<Throwable>(){

            public void accept(long object) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableLongFunction_IOException() {
        new FailableLongFunction<String, IOException>(){

            public String apply(long input) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableLongFunction_Throwable() {
        new FailableLongFunction<Object, Throwable>(){

            public Object apply(long input) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableLongSupplier_IOException() {
        new FailableLongSupplier<IOException>(){

            public long getAsLong() throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableLongSupplier_Throwable() {
        new FailableLongSupplier<Throwable>(){

            public long getAsLong() throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableLongToDoubleFunction_IOException() {
        new FailableLongToDoubleFunction<IOException>(){

            public double applyAsDouble(long value) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableLongToDoubleFunction_Throwable() {
        new FailableLongToDoubleFunction<Throwable>(){

            public double applyAsDouble(long value) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableLongToIntFunction_IOException() {
        new FailableLongToIntFunction<IOException>(){

            public int applyAsInt(long value) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableLongToIntFunction_Throwable() {
        new FailableLongToIntFunction<Throwable>(){

            public int applyAsInt(long value) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableObjDoubleConsumer_Object_Throwable() {
        new FailableObjDoubleConsumer<Object, Throwable>(){

            public void accept(Object object, double value) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableObjDoubleConsumer_String_IOException() {
        new FailableObjDoubleConsumer<String, IOException>(){

            public void accept(String object, double value) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableObjIntConsumer_Object_Throwable() {
        new FailableObjIntConsumer<Object, Throwable>(){

            public void accept(Object object, int value) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableObjIntConsumer_String_IOException() {
        new FailableObjIntConsumer<String, IOException>(){

            public void accept(String object, int value) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableObjLongConsumer_Object_Throwable() {
        new FailableObjLongConsumer<Object, Throwable>(){

            public void accept(Object object, long value) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableObjLongConsumer_String_IOException() {
        new FailableObjLongConsumer<String, IOException>(){

            public void accept(String object, long value) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailablePredicate_Object_Throwable() {
        new FailablePredicate<Object, Throwable>(){

            public boolean test(Object object) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailablePredicate_String_IOException() {
        new FailablePredicate<String, IOException>(){

            public boolean test(String object) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableRunnable_IOException() {
        new FailableRunnable<IOException>(){

            public void run() throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableRunnable_Throwable() {
        new FailableRunnable<Throwable>(){

            public void run() throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableShortSupplier_IOException() {
        new FailableShortSupplier<IOException>(){

            public short getAsShort() throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableShortSupplier_Throwable() {
        new FailableShortSupplier<Throwable>(){

            public short getAsShort() throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableSupplier_Object_Throwable() {
        new FailableSupplier<Object, Throwable>(){

            public Object get() throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableSupplier_String_IOException() {
        new FailableSupplier<String, IOException>(){

            public String get() throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableToDoubleBiFunction_Object_Throwable() {
        new FailableToDoubleBiFunction<Object, Object, Throwable>(){

            public double applyAsDouble(Object t, Object u) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableToDoubleBiFunction_String_IOException() {
        new FailableToDoubleBiFunction<String, String, IOException>(){

            public double applyAsDouble(String t, String u) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableToDoubleFunction_Object_Throwable() {
        new FailableToDoubleFunction<Object, Throwable>(){

            public double applyAsDouble(Object t) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableToDoubleFunction_String_IOException() {
        new FailableToDoubleFunction<String, IOException>(){

            public double applyAsDouble(String t) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableToIntBiFunction_Object_Throwable() {
        new FailableToIntBiFunction<Object, Object, Throwable>(){

            public int applyAsInt(Object t, Object u) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableToIntBiFunction_String_IOException() {
        new FailableToIntBiFunction<String, String, IOException>(){

            public int applyAsInt(String t, String u) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableToIntFunction_Object_Throwable() {
        new FailableToIntFunction<Object, Throwable>(){

            public int applyAsInt(Object t) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableToIntFunction_String_IOException() {
        new FailableToIntFunction<String, IOException>(){

            public int applyAsInt(String t) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableToLongBiFunction_Object_Throwable() {
        new FailableToLongBiFunction<Object, Object, Throwable>(){

            public long applyAsLong(Object t, Object u) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableToLongBiFunction_String_IOException() {
        new FailableToLongBiFunction<String, String, IOException>(){

            public long applyAsLong(String t, String u) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableToLongFunction_Object_Throwable() {
        new FailableToLongFunction<Object, Throwable>(){

            public long applyAsLong(Object t) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableToLongFunction_String_IOException() {
        new FailableToLongFunction<String, IOException>(){

            public long applyAsLong(String t) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testTryWithResources() {
        CloseableObject closeable = new CloseableObject();
        FailableConsumer consumer = closeable::run;
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> {
            FailableRunnable[] failableRunnableArray = new FailableRunnable[1];
            failableRunnableArray[0] = closeable::close;
            Failable.tryWithResources(() -> consumer.accept((Object)ILLEGAL_STATE_EXCEPTION), (FailableRunnable[])failableRunnableArray);
        });
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        Assertions.assertTrue((boolean)closeable.isClosed());
        closeable.reset();
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> {
            FailableRunnable[] failableRunnableArray = new FailableRunnable[1];
            failableRunnableArray[0] = closeable::close;
            Failable.tryWithResources(() -> consumer.accept((Object)ERROR), (FailableRunnable[])failableRunnableArray);
        });
        Assertions.assertSame((Object)ERROR, (Object)e);
        Assertions.assertTrue((boolean)closeable.isClosed());
        closeable.reset();
        IOException ioe = new IOException("Unknown I/O error");
        UncheckedIOException uioe = (UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> {
            FailableRunnable[] failableRunnableArray = new FailableRunnable[1];
            failableRunnableArray[0] = closeable::close;
            Failable.tryWithResources(() -> consumer.accept((Object)ioe), (FailableRunnable[])failableRunnableArray);
        });
        IOException cause = uioe.getCause();
        Assertions.assertSame((Object)ioe, (Object)cause);
        Assertions.assertTrue((boolean)closeable.isClosed());
        closeable.reset();
        FailableRunnable[] failableRunnableArray = new FailableRunnable[1];
        failableRunnableArray[0] = closeable::close;
        Failable.tryWithResources(() -> consumer.accept(null), (FailableRunnable[])failableRunnableArray);
        Assertions.assertTrue((boolean)closeable.isClosed());
    }

    private String throwingFunction(String input) throws Exception {
        return input;
    }

    public static class Testable<T, P> {
        private T acceptedObject;
        private P acceptedPrimitiveObject1;
        private P acceptedPrimitiveObject2;
        private Throwable throwable;

        Testable(Throwable throwable) {
            this.throwable = throwable;
        }

        public T getAcceptedObject() {
            return this.acceptedObject;
        }

        public P getAcceptedPrimitiveObject1() {
            return this.acceptedPrimitiveObject1;
        }

        public P getAcceptedPrimitiveObject2() {
            return this.acceptedPrimitiveObject2;
        }

        public void setThrowable(Throwable throwable) {
            this.throwable = throwable;
        }

        public void test() throws Throwable {
            this.test(this.throwable);
        }

        public Object test(Object input1, Object input2) throws Throwable {
            this.test(this.throwable);
            return this.acceptedObject;
        }

        public void test(Throwable throwable) throws Throwable {
            if (throwable != null) {
                throw throwable;
            }
        }

        public boolean testAsBooleanPrimitive() throws Throwable {
            return this.testAsBooleanPrimitive(this.throwable);
        }

        public boolean testAsBooleanPrimitive(Throwable throwable) throws Throwable {
            if (throwable != null) {
                throw throwable;
            }
            return false;
        }

        public double testAsDoublePrimitive() throws Throwable {
            return this.testAsDoublePrimitive(this.throwable);
        }

        public double testAsDoublePrimitive(Throwable throwable) throws Throwable {
            if (throwable != null) {
                throw throwable;
            }
            return 0.0;
        }

        public Integer testAsInteger() throws Throwable {
            return this.testAsInteger(this.throwable);
        }

        public Integer testAsInteger(Throwable throwable) throws Throwable {
            if (throwable != null) {
                throw throwable;
            }
            return 0;
        }

        public int testAsIntPrimitive() throws Throwable {
            return this.testAsIntPrimitive(this.throwable);
        }

        public int testAsIntPrimitive(Throwable throwable) throws Throwable {
            if (throwable != null) {
                throw throwable;
            }
            return 0;
        }

        public long testAsLongPrimitive() throws Throwable {
            return this.testAsLongPrimitive(this.throwable);
        }

        public long testAsLongPrimitive(Throwable throwable) throws Throwable {
            if (throwable != null) {
                throw throwable;
            }
            return 0L;
        }

        public short testAsShortPrimitive() throws Throwable {
            return this.testAsShortPrimitive(this.throwable);
        }

        public short testAsShortPrimitive(Throwable throwable) throws Throwable {
            if (throwable != null) {
                throw throwable;
            }
            return 0;
        }

        public void testDouble(double i) throws Throwable {
            this.test(this.throwable);
            this.acceptedPrimitiveObject1 = i;
        }

        public double testDoubleDouble(double i, double j) throws Throwable {
            this.test(this.throwable);
            this.acceptedPrimitiveObject1 = i;
            this.acceptedPrimitiveObject2 = j;
            return 3.0;
        }

        public void testInt(int i) throws Throwable {
            this.test(this.throwable);
            this.acceptedPrimitiveObject1 = i;
        }

        public void testLong(long i) throws Throwable {
            this.test(this.throwable);
            this.acceptedPrimitiveObject1 = i;
        }

        public void testObjDouble(T object, double i) throws Throwable {
            this.test(this.throwable);
            this.acceptedObject = object;
            this.acceptedPrimitiveObject1 = i;
        }

        public void testObjInt(T object, int i) throws Throwable {
            this.test(this.throwable);
            this.acceptedObject = object;
            this.acceptedPrimitiveObject1 = i;
        }

        public void testObjLong(T object, long i) throws Throwable {
            this.test(this.throwable);
            this.acceptedObject = object;
            this.acceptedPrimitiveObject1 = i;
        }
    }

    public static class FailureOnOddInvocations {
        private static int invocations;

        static boolean failingBool() throws SomeException {
            FailureOnOddInvocations.throwOnOdd();
            return true;
        }

        static boolean testDouble(double value) throws SomeException {
            FailureOnOddInvocations.throwOnOdd();
            return true;
        }

        static boolean testInt(int value) throws SomeException {
            FailureOnOddInvocations.throwOnOdd();
            return true;
        }

        static boolean testLong(long value) throws SomeException {
            FailureOnOddInvocations.throwOnOdd();
            return true;
        }

        private static void throwOnOdd() throws SomeException {
            int i;
            if ((i = ++invocations) % 2 == 1) {
                throw new SomeException("Odd Invocation: " + i);
            }
        }

        FailureOnOddInvocations() throws SomeException {
            FailureOnOddInvocations.throwOnOdd();
        }

        boolean getAsBoolean() throws SomeException {
            FailureOnOddInvocations.throwOnOdd();
            return true;
        }
    }

    public static class SomeException
    extends Exception {
        private static final long serialVersionUID = -4965704778119283411L;
        private Throwable t;

        SomeException(String message) {
            super(message);
        }

        public void setThrowable(Throwable throwable) {
            this.t = throwable;
        }

        public void test() throws Throwable {
            if (this.t != null) {
                throw this.t;
            }
        }
    }

    public static class CloseableObject {
        private boolean closed;

        public void close() {
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public void reset() {
            this.closed = false;
        }

        public void run(Throwable pTh) throws Throwable {
            if (pTh != null) {
                throw pTh;
            }
        }
    }
}

