/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ArraySorter;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.time.FastDateParser;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junitpioneer.jupiter.DefaultLocale;
import org.junitpioneer.jupiter.DefaultTimeZone;
import org.junitpioneer.jupiter.ReadsDefaultLocale;
import org.junitpioneer.jupiter.ReadsDefaultTimeZone;

@DefaultLocale(language="en")
@DefaultTimeZone(value="GMT")
@ReadsDefaultLocale
@ReadsDefaultTimeZone
public class FastDateParser_TimeZoneStrategyTest
extends AbstractLangTest {
    private static final List<Locale> Java11Failures = new ArrayList<Locale>();
    private static final List<Locale> Java17Failures = new ArrayList<Locale>();

    @AfterAll
    public static void afterAll() {
        if (!Java17Failures.isEmpty()) {
            System.err.printf("Actual failures on Java 17: %,d%n%s%n", Java17Failures.size(), Java17Failures);
        }
        if (!Java11Failures.isEmpty()) {
            System.err.printf("Actual failures on Java 11: %,d%n%s%n", Java11Failures.size(), Java11Failures);
        }
    }

    public static Locale[] getAvailableLocalesSorted() {
        return (Locale[])ArraySorter.sort((Object[])Locale.getAvailableLocales(), Comparator.comparing(Locale::toString));
    }

    @Test
    public void testLang1219() throws ParseException {
        FastDateParser parser = new FastDateParser("dd.MM.yyyy HH:mm:ss z", TimeZone.getDefault(), Locale.GERMAN);
        Date summer = parser.parse("26.10.2014 02:00:00 MESZ");
        Date standard = parser.parse("26.10.2014 02:00:00 MEZ");
        Assertions.assertNotEquals((long)summer.getTime(), (long)standard.getTime());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.lang3.time.FastDateParser_TimeZoneStrategyTest#getAvailableLocalesSorted"})
    public void testTimeZoneStrategy_DateFormatSymbols(Locale locale) {
        this.testTimeZoneStrategyPattern_DateFormatSymbols_getZoneStrings(locale);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.lang3.time.FastDateParser_TimeZoneStrategyTest#getAvailableLocalesSorted"})
    public void testTimeZoneStrategy_TimeZone(Locale locale) {
        this.testTimeZoneStrategyPattern_TimeZone_getAvailableIDs(locale);
    }

    private void testTimeZoneStrategyPattern(String languageTag, String source) throws ParseException {
        Locale locale = Locale.forLanguageTag(languageTag);
        Assumptions.assumeFalse((boolean)LocaleUtils.isLanguageUndetermined((Locale)locale), () -> this.toFailureMessage(locale, languageTag));
        Assumptions.assumeTrue((boolean)LocaleUtils.isAvailableLocale((Locale)locale), () -> this.toFailureMessage(locale, languageTag));
        TimeZone tzDefault = TimeZone.getTimeZone("Etc/UTC");
        FastDateParser parser = new FastDateParser("z", tzDefault, locale);
        parser.parse(source);
        this.testTimeZoneStrategyPattern_TimeZone_getAvailableIDs(locale);
    }

    private void testTimeZoneStrategyPattern_DateFormatSymbols_getZoneStrings(Locale locale) {
        String[][] zones;
        Objects.requireNonNull(locale, "locale");
        Assumptions.assumeFalse((boolean)LocaleUtils.isLanguageUndetermined((Locale)locale), () -> this.toFailureMessage(locale, null));
        Assumptions.assumeTrue((boolean)LocaleUtils.isAvailableLocale((Locale)locale), () -> this.toFailureMessage(locale, null));
        for (String[] zone : zones = (String[][])ArraySorter.sort((Object[])DateFormatSymbols.getInstance(locale).getZoneStrings(), Comparator.comparing(array -> array[0]))) {
            String tzDisplay;
            for (int zIndex = 1; zIndex < zone.length && (tzDisplay = zone[zIndex]) != null; ++zIndex) {
                TimeZone timeZone = TimeZone.getDefault();
                FastDateParser parser = new FastDateParser("z", timeZone, locale);
                try {
                    parser.parse(tzDisplay);
                    continue;
                }
                catch (ParseException e) {
                    String localeStr = locale.toString();
                    if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17) && (localeStr.contains("_") || "Coordinated Universal Time".equals(tzDisplay) || "sommartid \u2013 Atyrau".equals(tzDisplay))) {
                        Java17Failures.add(locale);
                        System.err.printf("Java %s - Mark as an assumption failure instead of a hard fail: locale = '%s', parse = '%s'%n", SystemUtils.JAVA_VERSION, localeStr, tzDisplay);
                        Assumptions.assumeTrue((boolean)false, (String)localeStr);
                        continue;
                    }
                    if (SystemUtils.IS_JAVA_11 && (localeStr.contains("_") || "Coordinated Universal Time".equals(tzDisplay))) {
                        Java11Failures.add(locale);
                        System.err.printf("Java %s %s - Mark as an assumption failure instead of a hard fail: locale = '%s', parse = '%s'%n", SystemUtils.JAVA_VENDOR, SystemUtils.JAVA_VERSION, localeStr, tzDisplay);
                        Assumptions.assumeTrue((boolean)false, (String)localeStr);
                        continue;
                    }
                    Assertions.fail((String)String.format("%s: with locale = %s, zIndex = %,d, tzDisplay = '%s', parser = '%s'", e, localeStr, zIndex, tzDisplay, parser.toString()), (Throwable)e);
                }
            }
        }
    }

    private void testTimeZoneStrategyPattern_TimeZone_getAvailableIDs(Locale locale) {
        Objects.requireNonNull(locale, "locale");
        Assumptions.assumeFalse((boolean)LocaleUtils.isLanguageUndetermined((Locale)locale), () -> this.toFailureMessage(locale, null));
        Assumptions.assumeTrue((boolean)LocaleUtils.isAvailableLocale((Locale)locale), () -> this.toFailureMessage(locale, null));
        for (String id : (String[])ArraySorter.sort((Object[])TimeZone.getAvailableIDs())) {
            TimeZone timeZone = TimeZone.getTimeZone(id);
            FastDateParser parser = new FastDateParser("z", timeZone, locale);
            String displayName = timeZone.getDisplayName(locale);
            try {
                parser.parse(displayName);
            }
            catch (ParseException e) {
                Assertions.fail((String)String.format("%s: with locale = %s, id = '%s', timeZone = %s, displayName = '%s', parser = '%s'", e, locale, id, timeZone, displayName, parser.toStringAll()), (Throwable)e);
            }
        }
    }

    @Test
    public void testTimeZoneStrategyPatternPortugal() throws ParseException {
        this.testTimeZoneStrategyPattern("pt_PT", "Hor\u00e1rio do Meridiano de Greenwich");
    }

    @Test
    public void testTimeZoneStrategyPatternSuriname() throws ParseException {
        this.testTimeZoneStrategyPattern("sr_ME_#Cyrl", "Srednje vreme po Grini\u010du");
    }

    private String toFailureMessage(Locale locale, String languageTag) {
        return String.format("locale = %s, languageTag = '%s', isAvailableLocale = %s, isLanguageUndetermined = %s", languageTag, locale, LocaleUtils.isAvailableLocale((Locale)locale), LocaleUtils.isLanguageUndetermined((Locale)locale));
    }
}

