/*

Copyright (C) 2001  Gopal Narayanan <gopal@astro.umass.edu>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

*/

/* 
 * microstrip.c - Puts up window for microstrip and 
 * performs the associated calculations
 */


#include <stdio.h>
#include <gtk/gtk.h>
#include <string.h>
#include <math.h>

#include "transcalc.h"
#include "body.h"

short length_unit, freq_unit, res_unit, ang_unit;

gchar *length_unit_name[] = { "mil",
			      "cm",
			      "mm",
			      "m",
			      "um",
			      "in",
			      "ft"
};

gchar *freq_unit_name[] = { "GHz",
			    "Hz",
			    "kHz",
			    "MHz"
};

gchar *res_unit_name[] = { "Ohm",
			   "kOhm"
};

gchar *ang_unit_name[] = { "deg",
			   "rad"
};



/*
 * set_nounit_combo
 */
void 
set_nounit_combo (GtkWidget *combo)
{
  GList *glist = NULL;
  
  gtk_widget_set_usize (GTK_WIDGET (combo), 20, -1);
  
  glist = g_list_append(glist, "NA");
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo)->entry), "NA");
  gtk_combo_set_popdown_strings (GTK_COMBO (combo), glist);
  g_list_free (glist);
  gtk_widget_set_sensitive ( GTK_WIDGET (combo), FALSE); 
}

/*
 * set_lengthunit_combo
 */
void 
set_lengthunit_combo (GtkWidget *combo)
{
  GList *glist = NULL;
  
  gtk_widget_set_usize (GTK_WIDGET (combo), 20, -1);
  
  glist = g_list_append(glist, "mil");
  glist = g_list_append(glist, "cm");
  glist = g_list_append(glist, "mm");
  glist = g_list_append(glist, "m");
  glist = g_list_append(glist, "um");  
  glist = g_list_append(glist, "in");
  glist = g_list_append(glist, "ft");

  gtk_combo_set_popdown_strings (GTK_COMBO (combo), glist);
  g_list_free (glist);
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo)->entry), length_unit_name[length_unit]);

  gtk_widget_set_sensitive ( GTK_WIDGET (combo), TRUE);
  /* make the combo entry box uneditable*/
  gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (combo)->entry), FALSE);
}

/* 
 * set_frequnit_combo
 */
void set_frequnit_combo (GtkWidget *combo)
{
  GList *glist = NULL;
  
  gtk_widget_set_usize (GTK_WIDGET (combo), 20, -1);
  
  glist = g_list_append(glist, "GHz");
  glist = g_list_append(glist, "Hz");
  glist = g_list_append(glist, "kHz");
  glist = g_list_append(glist, "MHz");

  gtk_combo_set_popdown_strings (GTK_COMBO (combo), glist);
  g_list_free (glist);

  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo)->entry), freq_unit_name[freq_unit]);

  gtk_widget_set_sensitive ( GTK_WIDGET (combo), TRUE);
  /* make the combo entry box uneditable*/
  gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (combo)->entry), FALSE);
}

/* 
 * set_resunit_combo
 */
void 
set_resunit_combo (GtkWidget *combo)
{
  GList *glist = NULL;
  
  gtk_widget_set_usize (GTK_WIDGET (combo), 20, -1);
  
  glist = g_list_append(glist, "Ohm");
  glist = g_list_append(glist, "kOhm");

  gtk_combo_set_popdown_strings (GTK_COMBO (combo), glist);
  g_list_free (glist);

  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo)->entry), res_unit_name[res_unit]);

  gtk_widget_set_sensitive ( GTK_WIDGET (combo), TRUE);
  /* make the combo entry box uneditable*/
  gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (combo)->entry), FALSE);
}

/* 
 * set_angunit_combo
 */
void set_angunit_combo (GtkWidget *combo)
{
  GList *glist = NULL;
  
  gtk_widget_set_usize (GTK_WIDGET (combo), 20, -1);
  
  glist = g_list_append(glist, "Deg");
  glist = g_list_append(glist, "Rad");

  gtk_combo_set_popdown_strings (GTK_COMBO (combo), glist);
  g_list_free (glist);

  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo)->entry), ang_unit_name[ang_unit]);

  gtk_widget_set_sensitive ( GTK_WIDGET (combo), TRUE);
  /* make the combo entry box uneditable*/
  gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (combo)->entry), FALSE);
}


/*
 * sets up the combo widget for units and such
 */

/* type = 0 substrate param
   type = 1 component param
   type = 2 physical param
   type = 3 electrical param
*/

GtkWidget *
setup_combo_widget (short type, short rownum)
{
/*   GList *glist = NULL; */
  GtkWidget *combo;
  /*  short trans_type;*/

  /*  trans_type = transtype_int();*/

  switch(current_transtype) {
  case MICROSTRIP :
    switch (type) {
    case SUBPARAMTYPE :
      /* substrate parameters */
      
      switch(rownum) {
	
      case 0 :
      case 1 :
      case 5 :
      case 6 :
      case 8 :
	/* Er */
	/* Mur */
	/* Tand */
	/* Cond */
	/* blank */
	combo = gtk_combo_new ();
	set_nounit_combo (combo);
	return combo;
	break;
	
      case 2 :
      case 3 :
      case 4 :
      case 7 :
	/* H */
	/* H_t */
	/* T */
	/* Rough */
	combo = gtk_combo_new ();
	set_lengthunit_combo (combo);
	return combo;
	break;      
      }
    case COMPPARAMTYPE :
      switch (rownum) {
      case 0 :
	/* freq */
	combo = gtk_combo_new ();
	set_frequnit_combo (combo);
	return combo;
	break;
      default:
	/* nothing */
	combo = gtk_combo_new ();
	set_nounit_combo (combo);
	return combo;
	break;      
      }
      
    case PHYSPARAMTYPE :
      switch (rownum) {
      case 0 : 
      case 1 :
	/* width */
	/* length */
	combo = gtk_combo_new ();
	set_lengthunit_combo (combo);
	return combo;
	break;      
      default: 
	/*nothing*/
	combo = gtk_combo_new ();
	set_nounit_combo (combo);
	return combo;
	break;      
      }
      
    case ELECPARAMTYPE :
      switch(rownum) {
      case 0 :
	/* Z0 */
	combo = gtk_combo_new ();
	set_resunit_combo (combo);
	return combo;
	break;
      case 1 :
	/* e_eff -electrical length */
	combo = gtk_combo_new ();
	set_angunit_combo (combo);
	return combo;
	break;
      default:
	combo = gtk_combo_new ();
	set_nounit_combo (combo);
	return combo;
	break;
      }
    }
    break;
    /* end microstrip */

  case RECTWAVEGUIDE :
    switch (type) {
    case SUBPARAMTYPE :
      /* substrate parameters */
      /* all substrate parameters for rect waveguide
	 are unit less */
      combo = gtk_combo_new ();
      set_nounit_combo (combo);
      return combo;
      break;
    case COMPPARAMTYPE :
      switch (rownum) {
      case 0 :
	/* freq */
	combo = gtk_combo_new ();
	set_frequnit_combo (combo);
	return combo;
	break;
      default:
	/* nothing */
	combo = gtk_combo_new ();
	set_nounit_combo (combo);
	return combo;
	break;      
      }
    case PHYSPARAMTYPE :
      switch (rownum) {
      case 0 : 
      case 1 : 
      case 2 :
	/* width */
	/* height */
	/* length */
	combo = gtk_combo_new ();
	set_lengthunit_combo (combo);
	return combo;
	break;      
      default: 
	/*nothing*/
	combo = gtk_combo_new ();
	set_nounit_combo (combo);
	return combo;
	break;      
      }

    case ELECPARAMTYPE :
      switch(rownum) {
      case 0 :
	/* Z0 */
	combo = gtk_combo_new ();
	set_resunit_combo (combo);
	return combo;
	break;
      case 1 :
	/* e_eff -electrical length */
	combo = gtk_combo_new ();
	set_angunit_combo (combo);
	return combo;
	break;
      default:
	combo = gtk_combo_new ();
	set_nounit_combo (combo);
	return combo;
	break;
      }      
    
    }
    break; 
    /* end rectwaveguide */

  case COAX :
    switch (type) {
    case SUBPARAMTYPE :
      /* substrate parameters */
      /* all substrate parameters for coax
	 are unit less */
      combo = gtk_combo_new ();
      set_nounit_combo (combo);
      return combo;
      break;
    case COMPPARAMTYPE :
      switch (rownum) {
      case 0 :
	/* freq */
	combo = gtk_combo_new ();
	set_frequnit_combo (combo);
	return combo;
	break;
      default:
	/* nothing */
	combo = gtk_combo_new ();
	set_nounit_combo (combo);
	return combo;
	break;      
      }
    case PHYSPARAMTYPE :
      switch (rownum) {
      case 0 : 
      case 1 : 
      case 2 :
	/* din */
	/* dout */
	/* length */
	combo = gtk_combo_new ();
	set_lengthunit_combo (combo);
	return combo;
	break;      
      default: 
	/*nothing*/
	combo = gtk_combo_new ();
	set_nounit_combo (combo);
	return combo;
	break;      
      }

    case ELECPARAMTYPE :
      switch(rownum) {
      case 0 :
	/* Z0 */
	combo = gtk_combo_new ();
	set_resunit_combo (combo);
	return combo;
	break;
      case 1 :
	/* e_eff -electrical length */
	combo = gtk_combo_new ();
	set_angunit_combo (combo);
	return combo;
	break;
      default:
	combo = gtk_combo_new ();
	set_nounit_combo (combo);
	return combo;
	break;
      }
    }
    break;
    /* end coax */
  case C_MICROSTRIP :
    switch (type) {
    case SUBPARAMTYPE :
      /* substrate parameters */
      
      switch(rownum) {
	
      case 0 :
      case 1 :
      case 5 :
      case 6 :
      case 8 :
	/* Er */
	/* Mur */
	/* Tand */
	/* Cond */
	/* blank */
	combo = gtk_combo_new ();
	set_nounit_combo (combo);
	return combo;
	break;
	
      case 2 :
      case 3 :
      case 4 :
      case 7 :
	/* H */
	/* H_t */
	/* T */
	/* Rough */
	combo = gtk_combo_new ();
	set_lengthunit_combo (combo);
	return combo;
	break;      
      }
    case COMPPARAMTYPE :
      switch (rownum) {
      case 0 :
	/* freq */
	combo = gtk_combo_new ();
	set_frequnit_combo (combo);
	return combo;
	break;
      default:
	/* nothing */
	combo = gtk_combo_new ();
	set_nounit_combo (combo);
	return combo;
	break;      
      }
      
    case PHYSPARAMTYPE :
      switch (rownum) {
      case 0 : 	/* width */
      case 1 :	/* length */
      case 2 :  /* spacing */
	combo = gtk_combo_new ();
	set_lengthunit_combo (combo);
	return combo;
	break;      
      default: 
	/*nothing*/
	combo = gtk_combo_new ();
	set_nounit_combo (combo);
	return combo;
	break;      
      }
      
    case ELECPARAMTYPE :
      switch(rownum) {
      case 0 :	/* Z0e */
      case 1 :	/* Z0o */
	combo = gtk_combo_new ();
	set_resunit_combo (combo);
	return combo;
	break;
      case 2 :
	/* e_eff -electrical length */
	combo = gtk_combo_new ();
	set_angunit_combo (combo);
	return combo;
	break;
      default:
	combo = gtk_combo_new ();
	set_nounit_combo (combo);
	return combo;
	break;
      }
    }
    break;
    /* end coupled microstrip */
  default:
    fprintf(stderr, "setup_combo_widget: unknown transmission line type!\n");
  }
  /* error */
  return NULL;
}


/*
 * getunit - returns integer unit code
 */

gint 
getunit (gchar *text)
{
  if ((strcmp(text,"mil")) == 0) return LENGTH_MIL;
  if ((strcmp(text,"cm")) == 0) return LENGTH_CM;
  if ((strcmp(text,"mm")) == 0) return LENGTH_MM;
  if ((strcmp(text,"m")) == 0) return LENGTH_M;
  if ((strcmp(text,"um")) == 0) return LENGTH_UM;
  if ((strcmp(text,"in")) == 0) return LENGTH_IN;
  if ((strcmp(text,"ft")) == 0) return LENGTH_FT;

  if ((strcmp(text,"GHz")) == 0) return FREQ_GHZ;
  if ((strcmp(text,"Hz")) == 0) return FREQ_HZ;
  if ((strcmp(text,"kHz")) == 0) return FREQ_KHZ;
  if ((strcmp(text,"MHz")) == 0) return FREQ_MHZ;

  if ((strcmp(text,"Ohm")) == 0) return RES_OHM;
  if ((strcmp(text,"kOhm")) == 0) return RES_KOHM;

  if ((strcmp(text,"Deg")) == 0) return ANG_DEG;
  if ((strcmp(text,"Rad")) == 0) return ANG_RAD;
  /* error */
  return (-1);
}
  

/*
 * length_unit_text - returns character string for length unit
 * kludgy!
 */
gchar *
length_unit_text (short unitint)
{
  switch(unitint) {
  case LENGTH_MIL:
    return "mil";
    break;
  case LENGTH_CM:
    return "cm";
    break;
  case LENGTH_MM:
    return "mm";
    break;
  case LENGTH_M:
    return "m";
    break;
  case LENGTH_UM:
    return "um";
    break;
  case LENGTH_IN:
    return "in";
    break;
  case LENGTH_FT:
    return "ft";
    break;
  default:
    fprintf(stderr, "length_unit_text: unknown unit!\n");
  }
  /* error */
  return NULL;
}    

