/* AMD bd4 gmp-mparam.h -- Compiler/machine parameter header file.

Copyright 2019 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of either:

  * the GNU Lesser General Public License as published by the Free
    Software Foundation; either version 3 of the License, or (at your
    option) any later version.

or

  * the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any
    later version.

or both in parallel, as here.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received copies of the GNU General Public License and the
GNU Lesser General Public License along with the GNU MP Library.  If not,
see https://www.gnu.org/licenses/.  */

#define GMP_LIMB_BITS 32
#define GMP_LIMB_BYTES 4

/* 3800-4200 MHz Excavator/Bristol Ridge  */
/* FFT tuning limit = 67,000,000 */
/* Generated by tuneup.c, 2019-10-23, gcc 8.3 */

#define MOD_1_NORM_THRESHOLD                 0  /* always */
#define MOD_1_UNNORM_THRESHOLD               0  /* always */
#define MOD_1N_TO_MOD_1_1_THRESHOLD          8
#define MOD_1U_TO_MOD_1_1_THRESHOLD          6
#define MOD_1_1_TO_MOD_1_2_THRESHOLD        27
#define MOD_1_2_TO_MOD_1_4_THRESHOLD        50
#define PREINV_MOD_1_TO_MOD_1_THRESHOLD     13
#define USE_PREINV_DIVREM_1                  1  /* native */
#define DIV_QR_1N_PI1_METHOD                 1  /* 28.45% faster than 2 */
#define DIV_QR_1_NORM_THRESHOLD              4
#define DIV_QR_1_UNNORM_THRESHOLD        MP_SIZE_T_MAX  /* never */
#define DIV_QR_2_PI2_THRESHOLD              13
#define DIVEXACT_1_THRESHOLD                 0  /* always (native) */
#define BMOD_1_TO_MOD_1_THRESHOLD           28

#define DIV_1_VS_MUL_1_PERCENT             314

#define MUL_TOOM22_THRESHOLD                32
#define MUL_TOOM33_THRESHOLD                73
#define MUL_TOOM44_THRESHOLD               166
#define MUL_TOOM6H_THRESHOLD               270
#define MUL_TOOM8H_THRESHOLD               357

#define MUL_TOOM32_TO_TOOM43_THRESHOLD      69
#define MUL_TOOM32_TO_TOOM53_THRESHOLD     114
#define MUL_TOOM42_TO_TOOM53_THRESHOLD     103
#define MUL_TOOM42_TO_TOOM63_THRESHOLD     121
#define MUL_TOOM43_TO_TOOM54_THRESHOLD     154

#define SQR_BASECASE_THRESHOLD               0  /* always (native) */
#define SQR_TOOM2_THRESHOLD                 42
#define SQR_TOOM3_THRESHOLD                 89
#define SQR_TOOM4_THRESHOLD                208
#define SQR_TOOM6_THRESHOLD                306
#define SQR_TOOM8_THRESHOLD                454

#define MULMID_TOOM42_THRESHOLD             68

#define MULMOD_BNM1_THRESHOLD               19
#define SQRMOD_BNM1_THRESHOLD               18

#define MUL_FFT_MODF_THRESHOLD             570  /* k = 5 */
#define MUL_FFT_TABLE3                                      \
  { {    570, 5}, {     25, 6}, {     13, 5}, {     27, 6}, \
    {     25, 7}, {     13, 6}, {     27, 7}, {     15, 6}, \
    {     32, 7}, {     17, 6}, {     35, 7}, {     19, 6}, \
    {     39, 7}, {     27, 8}, {     15, 7}, {     35, 8}, \
    {     19, 7}, {     41, 8}, {     23, 7}, {     47, 8}, \
    {     27, 9}, {     15, 8}, {     31, 7}, {     63, 8}, \
    {     39, 9}, {     23, 8}, {     51,10}, {     15, 9}, \
    {     31, 8}, {     67, 9}, {     39, 8}, {     79, 9}, \
    {     47, 8}, {     95,10}, {     31, 9}, {     79,10}, \
    {     47, 9}, {     95,11}, {     31,10}, {     63, 9}, \
    {    135,10}, {     79, 9}, {    159,10}, {     95, 9}, \
    {    191,11}, {     63,10}, {    143, 6}, {   2303, 5}, \
    {   4735, 4}, {   9471, 5}, {   4863, 7}, {   1279, 9}, \
    {    335, 8}, {    671, 9}, {    351, 8}, {    703,10}, \
    {    191,12}, {     63,11}, {    127,10}, {    255, 9}, \
    {    511,10}, {    271, 9}, {    543,11}, {    159,10}, \
    {    319, 9}, {    639,10}, {    335, 9}, {    671, 8}, \
    {   1343,10}, {    351, 9}, {    703,10}, {    367, 9}, \
    {    735,11}, {    191,10}, {    383, 9}, {    767,10}, \
    {    399, 9}, {    799, 8}, {   1599,10}, {    415,11}, \
    {    223,12}, {    127,11}, {    255,10}, {    543, 9}, \
    {   1087,11}, {    287,10}, {    607, 9}, {   1215,11}, \
    {    319,10}, {    671, 9}, {   1343,11}, {    351,12}, \
    {    191,11}, {    383,10}, {    799,11}, {    415,10}, \
    {    863,13}, {    127,12}, {    255,11}, {    543,10}, \
    {   1087,11}, {    607,10}, {   1215, 9}, {   2431,12}, \
    {    319,11}, {    671,10}, {   1343,11}, {    735,10}, \
    {   1471, 9}, {   2943,12}, {    383,11}, {    799,10}, \
    {   1599,11}, {    863,10}, {   1727,12}, {    447,11}, \
    {    959,10}, {   1919,13}, {    255,12}, {    511,11}, \
    {   1087,12}, {    575,11}, {   1215,10}, {   2431,12}, \
    {    639,11}, {   1343,12}, {    703,11}, {   1471,10}, \
    {   2943,13}, {    383,12}, {    767,11}, {   1599,12}, \
    {    831,11}, {   1727,10}, {   3455,12}, {    959,11}, \
    {   1919,10}, {   3839,13}, {    511,12}, {   1087,11}, \
    {   2239,12}, {   1215,11}, {   2431,13}, {    639,12}, \
    {   1471,11}, {   2943,10}, {   5887,13}, {    767,12}, \
    {   1727,11}, {   3455,13}, {    895,12}, {   1919,11}, \
    {   3839,14}, {    511,13}, {   1023,12}, {   2239,13}, \
    {   1151,12}, {   2431,13}, {   1279,12}, {   2559,13}, \
    {   1407,12}, {   2943,11}, {   5887,14}, {    767,13}, \
    {   1663,12}, {   3455,13}, {   1919,12}, {   3839,15}, \
    {    511,14}, {   1023,13}, {   2175,12}, {   4479,13}, \
    {   2431,14}, {   1279,13}, {   2943,12}, {   5887,14}, \
    {   1535,13}, {   3455,14}, {   1791,13}, {   3967,12}, \
    {   7935,15}, {   1023,14}, {   2047,13}, {   4479,14}, \
    {   2303,13}, {   4991,12}, {   9983,14}, {   2815,13}, \
    {   5887,15}, {   1535,14}, {   3839,13}, {   7935,16} }
#define MUL_FFT_TABLE3_SIZE 192
#define MUL_FFT_THRESHOLD                 5760

#define SQR_FFT_MODF_THRESHOLD             476  /* k = 5 */
#define SQR_FFT_TABLE3                                      \
  { {    476, 5}, {     28, 6}, {     15, 5}, {     31, 6}, \
    {     16, 5}, {     33, 6}, {     29, 7}, {     15, 6}, \
    {     33, 7}, {     17, 6}, {     36, 7}, {     19, 6}, \
    {     39, 7}, {     29, 8}, {     15, 7}, {     35, 8}, \
    {     19, 7}, {     41, 8}, {     23, 7}, {     47, 8}, \
    {     27, 9}, {     15, 8}, {     39, 9}, {     23, 8}, \
    {     51, 9}, {     31, 8}, {     67, 9}, {     39, 8}, \
    {     79, 9}, {     47, 8}, {     95,10}, {     31, 9}, \
    {     79,10}, {     47, 9}, {     95,11}, {     31,10}, \
    {     63, 9}, {    135,10}, {     95, 9}, {    191,10}, \
    {    111,11}, {     63,10}, {    127, 9}, {    255,10}, \
    {    143, 9}, {    287, 8}, {    575,10}, {    159,11}, \
    {     95,10}, {    191,12}, {     63,10}, {    255, 9}, \
    {    511,10}, {    271, 9}, {    543,10}, {    287, 9}, \
    {    575,11}, {    159,10}, {    319, 9}, {    639,10}, \
    {    335, 9}, {    671,10}, {    351, 9}, {    735,11}, \
    {    191,10}, {    383, 9}, {    767,10}, {    399, 9}, \
    {    799,10}, {    415, 9}, {    863,12}, {    127,11}, \
    {    255,10}, {    511, 9}, {   1023,10}, {    543,11}, \
    {    287,10}, {    607, 9}, {   1215,11}, {    319,10}, \
    {    671, 9}, {   1343,11}, {    351,10}, {    735,12}, \
    {    191,11}, {    383,10}, {    799,11}, {    415,10}, \
    {    863,13}, {    127,12}, {    255,11}, {    511,10}, \
    {   1055,11}, {    543,10}, {   1087,11}, {    607,10}, \
    {   1215,12}, {    319,11}, {    671,10}, {   1343,11}, \
    {    735,10}, {   1471,12}, {    383,11}, {    799,10}, \
    {   1599,11}, {    863,10}, {   1727,12}, {    447,11}, \
    {    959,13}, {    255,12}, {    511,11}, {   1087,12}, \
    {    575,11}, {   1215,12}, {    639,11}, {   1343,12}, \
    {    703,11}, {   1471,13}, {    383,12}, {    767,11}, \
    {   1599,12}, {    831,11}, {   1727,12}, {    959,11}, \
    {   1919,14}, {    255,13}, {    511,12}, {   1023,11}, \
    {   2047,12}, {   1087,11}, {   2239,12}, {   1215,11}, \
    {   2431,13}, {    639,12}, {   1471,11}, {   2943,13}, \
    {    767,12}, {   1727,13}, {    895,12}, {   1983,14}, \
    {    511,13}, {   1023,12}, {   2239,13}, {   1151,12}, \
    {   2431,13}, {   1279,12}, {   2559,13}, {   1407,12}, \
    {   2943,14}, {    767,13}, {   1663,12}, {   3455,13}, \
    {   1919,12}, {   3839,15}, {    511,14}, {   1023,13}, \
    {   2175,12}, {   4479,13}, {   2431,14}, {   1279,13}, \
    {   2943,12}, {   5887,14}, {   1535,13}, {   3455,14}, \
    {   1791,13}, {   3967,15}, {   1023,14}, {   2047,13}, \
    {   4479,14}, {   2303,13}, {   4991,12}, {   9983,14}, \
    {   2815,13}, {   5887,15}, {   1535,14}, {   3839,16} }
#define SQR_FFT_TABLE3_SIZE 176
#define SQR_FFT_THRESHOLD                 4736

#define MULLO_BASECASE_THRESHOLD             3
#define MULLO_DC_THRESHOLD                  54
#define MULLO_MUL_N_THRESHOLD            10950
#define SQRLO_BASECASE_THRESHOLD            10
#define SQRLO_DC_THRESHOLD                  77
#define SQRLO_SQR_THRESHOLD               9449

#define DC_DIV_QR_THRESHOLD                 84
#define DC_DIVAPPR_Q_THRESHOLD             252
#define DC_BDIV_QR_THRESHOLD                79
#define DC_BDIV_Q_THRESHOLD                 80

#define INV_MULMOD_BNM1_THRESHOLD           71
#define INV_NEWTON_THRESHOLD               254
#define INV_APPR_THRESHOLD                 266

#define BINV_NEWTON_THRESHOLD              294
#define REDC_1_TO_REDC_N_THRESHOLD          79

#define MU_DIV_QR_THRESHOLD               1652
#define MU_DIVAPPR_Q_THRESHOLD            1528
#define MUPI_DIV_QR_THRESHOLD              122
#define MU_BDIV_QR_THRESHOLD              1387
#define MU_BDIV_Q_THRESHOLD               1528

#define POWM_SEC_TABLE  1,16,96,480,960

#define GET_STR_DC_THRESHOLD                12
#define GET_STR_PRECOMPUTE_THRESHOLD        19
#define SET_STR_DC_THRESHOLD               264
#define SET_STR_PRECOMPUTE_THRESHOLD       542

#define FAC_DSC_THRESHOLD                   91
#define FAC_ODD_THRESHOLD                   29

#define MATRIX22_STRASSEN_THRESHOLD         19
#define HGCD2_DIV1_METHOD                    1  /* 9.73% faster than 3 */
#define HGCD_THRESHOLD                      55
#define HGCD_APPR_THRESHOLD                 50
#define HGCD_REDUCE_THRESHOLD             3389
#define GCD_DC_THRESHOLD                   562
#define GCDEXT_DC_THRESHOLD                416
#define JACOBI_BASE_METHOD                   4  /* 16.50% faster than 1 */

/* Tuneup completed successfully, took 49179 seconds */
