/* $Id: funcs.c,v 1.8 2005/09/15 08:38:56 cegger Exp $
******************************************************************************

   LibGGIMisc implementation for "X" target -- API functions.

   Copyright (c) 2001 Brian S. Julin	 bri@calyx.com
   Copyright (c) 1999 Marcus Sundberg    marcus@ggi-project.org
   Copyright (c) 1998 Andreas Beck       becka@ggi-project.org
   Copyright (c) 1998 Steve Cheng        steve@ggi-project.org
   
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   The above copyright notice applies to all files in this package, unless 
   explicitly stated otherwise in the file itself or in a file named COPYING 
   in the same directory as the file.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


******************************************************************************
*/

#include <stdio.h>
#include "xggimisc.h"


/* _All_ non-local (ie not declared 'static') functions and variables _must_
   be prefixed with the extension name, and for sublibs also with a unique
   sublib identifier. This is to keep the namespace clean on systems where
   all symbols are exported by default.
*/

/*-* API Implementation */

#ifdef NOTDEFINED
/* These are not (yet?) implemented. */
int GGIMISC_X_WaitRayPos(ggi_visual *vis, int32_t *x, int32_t *y)
{
	printf("Function GGIMISC_X_WaitRayPos(ggi_visual *vis, int32_t *x, int32_t *y) called.\n");
	return(0);
}	/* GGIMISC_X_WaitRayPos */


int GGIMISC_X_GetRayPos(ggi_visual *vis, int32_t *x, int32_t *y)
{
	printf("Function GGIMISC_X_GetRayPos(ggi_visual *vis, int32_t *x, int32_t *y) called.\n");
	return(0);
}	/* GGIMISC_X_GetRayPos */
#endif

int GGIMISC_X_SetSplitline(ggi_visual *vis, int y)
{
        ggi_x_priv *priv;

	DPRINT("X setting splitline %d !\n", y);

	if (y < 0 || y > LIBGGI_Y(vis)) return GGI_ENOSPACE;

	priv = LIBGGI_PRIVATE(vis);

	if (priv->yoff > LIBGGI_VIRTY(vis) - y) {
		priv->yoff = LIBGGI_VIRTY(vis) - y;
	}	/* if */

	priv->ysplit = y;

	return(0);
}	/* GGIMISC_X_SetSplitline */
