# This file has been autogenerated by the pywayland scanner

# Copyright 2022 Simon Ser
# Copyright 2022 Red Hat, Inc.
# Copyright 2022 Collabora, Ltd.
# Copyright 2022-2025 Red Hat, Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)


class WpColorRepresentationSurfaceV1(Interface):
    """Color representation extension to a surface

    A :class:`WpColorRepresentationSurfaceV1` allows the client to set the
    color representation metadata of a surface.

    By default, a surface does not have any color representation metadata set.
    The reconstruction of R, G, B signals on such surfaces is compositor
    implementation defined. The alpha mode is assumed to be
    premultiplied_electrical when the alpha mode is unset.

    If the :class:`~pywayland.protocol.wayland.WlSurface` associated with the
    :class:`WpColorRepresentationSurfaceV1` is destroyed, the
    :class:`WpColorRepresentationSurfaceV1` object becomes inert.
    """

    name = "wp_color_representation_surface_v1"
    version = 1

    class error(enum.IntEnum):
        alpha_mode = 1
        coefficients = 2
        pixel_format = 3
        inert = 4

    class alpha_mode(enum.IntEnum):
        premultiplied_electrical = 0
        premultiplied_optical = 1
        straight = 2

    class coefficients(enum.IntEnum):
        identity = 1
        bt709 = 2
        fcc = 3
        bt601 = 4
        smpte240 = 5
        bt2020 = 6
        bt2020_cl = 7
        ictcp = 8

    class range(enum.IntEnum):
        full = 1
        limited = 2

    class chroma_location(enum.IntEnum):
        type_0 = 1
        type_1 = 2
        type_2 = 3
        type_3 = 4
        type_4 = 5
        type_5 = 6


class WpColorRepresentationSurfaceV1Proxy(Proxy[WpColorRepresentationSurfaceV1]):
    interface = WpColorRepresentationSurfaceV1

    @WpColorRepresentationSurfaceV1.request()
    def destroy(self) -> None:
        """Destroy the color representation

        Destroy the :class:`WpColorRepresentationSurfaceV1` object.

        Destroying this object unsets all the color representation metadata
        from the surface. See the :class:`WpColorRepresentationSurfaceV1`
        interface description for how a compositor handles a surface without
        color representation metadata. Unsetting is double-buffered state, see
        :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>`.
        """
        self._marshal(0)
        self._destroy()

    @WpColorRepresentationSurfaceV1.request(
        Argument(ArgumentType.Uint),
    )
    def set_alpha_mode(self, alpha_mode: int) -> None:
        """Set the surface alpha mode

        If this protocol object is inert, the protocol error inert is raised.

        Assuming an alpha channel exists, it is always linear. The alpha mode
        determines whether and how the color channels include pre-multiplied
        alpha. Using straight alpha might have performance benefits.

        Only alpha modes advertised by the compositor are allowed to be used as
        argument for this request. The "alpha_mode" protocol error is raised
        otherwise.

        Alpha mode is double buffered, see :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>`.

        :param alpha_mode:
            alpha mode
        :type alpha_mode:
            `ArgumentType.Uint`
        """
        self._marshal(1, alpha_mode)

    @WpColorRepresentationSurfaceV1.request(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def set_coefficients_and_range(self, coefficients: int, range: int) -> None:
        """Set the matrix coefficients and range

        If this protocol object is inert, the protocol error inert is raised.

        Set the matrix coefficients and video range which defines the formula
        and the related constants used to derive red, green and blue signals.
        Usually coefficients correspond to MatrixCoefficients code points in
        H.273.

        Only combinations advertised by the compositor are allowed to be used
        as argument for this request. The "coefficients" protocol error is
        raised otherwise.

        A call to :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>` verifies that the pixel
        format and the coefficients-range combination in the committed surface
        contents are compatible, if contents exist. The "pixel_format" protocol
        error is raised otherwise.

        A pixel format is compatible with the coefficients-range combination if
        the related equations and conventions as defined in H.273 can produce
        the color channels (RGB or YCbCr) of the pixel format.

        For the definition of the supported combination, see the
        :class:`WpColorRepresentationSurfaceV1`::coefficients and
        :class:`WpColorRepresentationSurfaceV1`::range enums.

        The coefficients-range combination is double-buffered, see
        :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>`.

        :param coefficients:
            matrix coefficients
        :type coefficients:
            `ArgumentType.Uint`
        :param range:
            range
        :type range:
            `ArgumentType.Uint`
        """
        self._marshal(2, coefficients, range)

    @WpColorRepresentationSurfaceV1.request(
        Argument(ArgumentType.Uint),
    )
    def set_chroma_location(self, chroma_location: int) -> None:
        """Set the chroma location

        If this protocol object is inert, the protocol error inert is raised.

        Set the chroma location type which defines the position of downsampled
        chroma samples, corresponding to Chroma420SampleLocType code points in
        H.273.

        A call to :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>` verifies that the pixel
        format and chroma location type in the committed surface contents are
        compatible, if contents exist. The "pixel_format" protocol error is
        raised otherwise.

        For the definition of the supported chroma location types, see the
        :class:`WpColorRepresentationSurfaceV1`::chroma_location enum.

        The chroma location type is double-buffered, see
        :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>`.

        :param chroma_location:
            chroma sample location
        :type chroma_location:
            `ArgumentType.Uint`
        """
        self._marshal(3, chroma_location)


class WpColorRepresentationSurfaceV1Resource(Resource):
    interface = WpColorRepresentationSurfaceV1


class WpColorRepresentationSurfaceV1Global(Global):
    interface = WpColorRepresentationSurfaceV1


WpColorRepresentationSurfaceV1._gen_c()
WpColorRepresentationSurfaceV1.proxy_class = WpColorRepresentationSurfaceV1Proxy
WpColorRepresentationSurfaceV1.resource_class = WpColorRepresentationSurfaceV1Resource
WpColorRepresentationSurfaceV1.global_class = WpColorRepresentationSurfaceV1Global
