# This file has been autogenerated by the pywayland scanner

# Copyright 2014 © Stephen "Lyude" Chandler Paul
# Copyright 2015-2024 © Red Hat, Inc.
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice (including the
# next paragraph) shall be included in all copies or substantial
# portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)


class ZwpTabletPadDialV2(Interface):
    """Pad dial

    A rotary control, e.g. a dial or a wheel.

    Events on a dial are logically grouped by the wl_tablet_pad_dial.frame
    event.
    """

    name = "zwp_tablet_pad_dial_v2"
    version = 2


class ZwpTabletPadDialV2Proxy(Proxy[ZwpTabletPadDialV2]):
    interface = ZwpTabletPadDialV2

    @ZwpTabletPadDialV2.request(
        Argument(ArgumentType.String),
        Argument(ArgumentType.Uint),
    )
    def set_feedback(self, description: str, serial: int) -> None:
        """Set compositor feedback

        Requests the compositor to use the provided feedback string associated
        with this dial. This request should be issued immediately after a
        wp_tablet_pad_group.mode_switch event from the corresponding group is
        received, or whenever the dial is mapped to a different action. See
        wp_tablet_pad_group.mode_switch for more details.

        Clients are encouraged to provide context-aware descriptions for the
        actions associated with the dial, and compositors may use this
        information to offer visual feedback about the button layout (eg. on-
        screen displays).

        The provided string 'description' is a UTF-8 encoded string to be
        associated with this ring, and is considered user-visible; general
        internationalization rules apply.

        The serial argument will be that of the last
        wp_tablet_pad_group.mode_switch event received for the group of this
        dial. Requests providing other serials than the most recent one will be
        ignored.

        :param description:
            dial description
        :type description:
            `ArgumentType.String`
        :param serial:
            serial of the mode switch event
        :type serial:
            `ArgumentType.Uint`
        """
        self._marshal(0, description, serial)

    @ZwpTabletPadDialV2.request()
    def destroy(self) -> None:
        """Destroy the dial object

        This destroys the client's resource for this dial object.
        """
        self._marshal(1)
        self._destroy()


class ZwpTabletPadDialV2Resource(Resource):
    interface = ZwpTabletPadDialV2

    @ZwpTabletPadDialV2.event(
        Argument(ArgumentType.Int),
    )
    def delta(self, value120: int) -> None:
        """Delta movement

        Sent whenever the position on a dial changes.

        This event carries the wheel delta as multiples or fractions of 120
        with each multiple of 120 representing one logical wheel detent. For
        example, an axis_value120 of 30 is one quarter of a logical wheel step
        in the positive direction, a value120 of -240 are two logical wheel
        steps in the negative direction within the same hardware event. See the
        :class:`~pywayland.protocol.wayland.WlPointer`.axis_value120 for more
        details.

        The value120 must not be zero.

        :param value120:
            rotation distance as fraction of 120
        :type value120:
            `ArgumentType.Int`
        """
        self._post_event(0, value120)

    @ZwpTabletPadDialV2.event(
        Argument(ArgumentType.Uint),
    )
    def frame(self, time: int) -> None:
        """End of a dial event sequence

        Indicates the end of a set of events that represent one logical
        hardware dial event. A client is expected to accumulate the data in all
        events within the frame before proceeding.

        All wp_tablet_pad_dial events before a wp_tablet_pad_dial.frame event
        belong logically together.

        A wp_tablet_pad_dial.frame event is sent for every logical event group,
        even if the group only contains a single wp_tablet_pad_dial event.
        Specifically, a client may get a sequence: delta, frame, delta, frame,
        etc.

        :param time:
            timestamp with millisecond granularity
        :type time:
            `ArgumentType.Uint`
        """
        self._post_event(1, time)


class ZwpTabletPadDialV2Global(Global):
    interface = ZwpTabletPadDialV2


ZwpTabletPadDialV2._gen_c()
ZwpTabletPadDialV2.proxy_class = ZwpTabletPadDialV2Proxy
ZwpTabletPadDialV2.resource_class = ZwpTabletPadDialV2Resource
ZwpTabletPadDialV2.global_class = ZwpTabletPadDialV2Global
