/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import groovy.lang.Closure;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.freeplane.api.ConditionalStyles;
import org.freeplane.api.MindMap;
import org.freeplane.api.NodeChangeListener;
import org.freeplane.api.NodeCondition;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.ConditionalStyleModel;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.mindmapmode.MLogicalStyleController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.url.mindmapmode.MFileManager;
import org.freeplane.plugin.script.FormulaUtils;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.AbstractProxy;
import org.freeplane.plugin.script.proxy.MapConditionalStylesProxy;
import org.freeplane.plugin.script.proxy.NodeChangeListeners;
import org.freeplane.plugin.script.proxy.NodeProxy;
import org.freeplane.plugin.script.proxy.NodeStyleProxy;
import org.freeplane.plugin.script.proxy.PropertiesProxy;
import org.freeplane.plugin.script.proxy.Proxy;
import org.freeplane.plugin.script.proxy.ProxyUtils;

public class MapProxy
extends AbstractProxy<MapModel>
implements Proxy.MindMap,
Proxy.Map {
    public MapProxy(MapModel map, ScriptContext scriptContext) {
        super(map, scriptContext);
    }

    public Proxy.Node node(String id) {
        NodeModel node = ((MapModel)this.getDelegate()).getNodeForID(id);
        return node != null ? new NodeProxy(node, this.getScriptContext()) : null;
    }

    public Proxy.Node getRoot() {
        NodeModel rootNode = ((MapModel)this.getDelegate()).getRootNode();
        return new NodeProxy(rootNode, this.getScriptContext());
    }

    @Deprecated
    public Proxy.Node getRootNode() {
        return this.getRoot();
    }

    public File getFile() {
        return ((MapModel)this.getDelegate()).getFile();
    }

    public String getName() {
        return ((MapModel)this.getDelegate()).getTitle();
    }

    public boolean isSaved() {
        return ((MapModel)this.getDelegate()).isSaved();
    }

    public Color getBackgroundColor() {
        MapStyle mapStyle = (MapStyle)Controller.getCurrentModeController().getExtension(MapStyle.class);
        MapStyleModel model = (MapStyleModel)mapStyle.getMapHook((MapModel)this.getDelegate());
        if (model != null) {
            return model.getBackgroundColor();
        }
        String colorPropertyString = ResourceController.getResourceController().getProperty("standardbackgroundcolor");
        Color defaultBgColor = ColorUtils.stringToColor((String)colorPropertyString);
        return defaultBgColor;
    }

    public String getBackgroundColorCode() {
        return ColorUtils.colorToString((Color)this.getBackgroundColor());
    }

    public ConditionalStyles getConditionalStyles() {
        return new MapConditionalStylesProxy((MapModel)this.getDelegate(), this.getScriptContext());
    }

    public List<String> getUserDefinedStylesNames() {
        MapModel styleMap;
        MapStyleModel styleModel = MapStyleModel.getExtension((MapModel)((MapModel)this.getDelegate()));
        NodeModel styleNodeGroup = styleModel.getStyleNodeGroup(styleMap = styleModel.getStyleMap(), "styles.user-defined");
        List nodes = styleNodeGroup.getChildren();
        int size = nodes.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(size);
        for (NodeModel node : nodes) {
            list.add(node.getText());
        }
        return Collections.unmodifiableList(list);
    }

    public boolean close(boolean force, boolean allowInteraction) {
        if (!(((MapModel)this.getDelegate()).isSaved() || force || allowInteraction)) {
            throw new RuntimeException("will not close an unsaved map without being told so");
        }
        IMapViewManager mapViewManager = this.getMapViewManager();
        this.changeToThisMap(mapViewManager);
        if (force) {
            mapViewManager.closeWithoutSaving();
            return true;
        }
        return mapViewManager.close();
    }

    private void changeToThisMap(IMapViewManager mapViewManager) {
        if (!GraphicsEnvironment.isHeadless()) {
            String mapKey = this.findMapViewKey(mapViewManager);
            if (mapKey == null) {
                throw new RuntimeException("map " + this.getDelegate() + " does not seem to be opened");
            }
            mapViewManager.changeToMapView(mapKey);
        }
    }

    private IMapViewManager getMapViewManager() {
        return this.getModeController().getController().getMapViewManager();
    }

    private String findMapViewKey(IMapViewManager mapViewManager) {
        for (Map.Entry entry : mapViewManager.getMaps().entrySet()) {
            if (!((MapModel)entry.getValue()).equals(this.getDelegate())) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public boolean save(boolean allowInteraction) {
        if (!((MapModel)this.getDelegate()).isSaved() && ((MapModel)this.getDelegate()).getURL() == null && !allowInteraction) {
            throw new RuntimeException("no url set for map " + this.getDelegate());
        }
        this.changeToThisMap(this.getMapViewManager());
        return this.getModeController().save();
    }

    public boolean saveAs(File file) {
        this.changeToThisMap(this.getMapViewManager());
        return MFileManager.getController((ModeController)this.getModeController()).save((MapModel)this.getDelegate(), file);
    }

    public void setName(String title) {
        this.changeToThisMap(this.getMapViewManager());
        Controller.getCurrentController().getMapViewManager().getMapViewComponent().setName(title);
    }

    public void setSaved(boolean isSaved) {
        Controller.getCurrentModeController().getMapController().mapSaved((MapModel)this.getDelegate(), isSaved);
    }

    public void setBackgroundColor(Color color) {
        MapStyle mapStyle = (MapStyle)Controller.getCurrentModeController().getExtension(MapStyle.class);
        MapStyleModel model = (MapStyleModel)mapStyle.getMapHook((MapModel)this.getDelegate());
        mapStyle.setBackgroundColor(model, color);
    }

    public void setBackgroundColorCode(String rgbString) {
        this.setBackgroundColor(ColorUtils.stringToColor((String)rgbString));
    }

    public void setFilter(Closure<Boolean> closure) {
        this.setFilter(false, false, closure);
    }

    public void filter(Closure<Boolean> closure) {
        this.setFilter(closure);
    }

    public void filter(NodeCondition condition) {
        this.setFilter(condition);
    }

    public void setFilter(NodeCondition condition) {
        this.setFilter(false, false, condition);
    }

    public void filter(boolean showAncestors, boolean showDescendants, NodeCondition condition) {
        this.setFilter(showAncestors, showDescendants, condition);
    }

    public void setFilter(boolean showAncestors, boolean showDescendants, NodeCondition nc) {
        ICondition condition = ProxyUtils.createCondition(nc, this.getScriptContext());
        this.setFilter(false, showAncestors, showDescendants, condition);
    }

    public void setFilter(boolean showAncestors, boolean showDescendants, Closure<Boolean> closure) {
        ICondition condition = ProxyUtils.createCondition(closure, this.getScriptContext());
        this.setFilter(false, showAncestors, showDescendants, condition);
    }

    public void hide(boolean showAncestors, boolean showDescendants, NodeCondition nc) {
        ICondition condition = ProxyUtils.createCondition(nc, this.getScriptContext());
        this.setFilter(true, showAncestors, showDescendants, condition);
    }

    public void hide(boolean showAncestors, boolean showDescendants, Closure<Boolean> closure) {
        ICondition condition = ProxyUtils.createCondition(closure, this.getScriptContext());
        this.setFilter(true, showAncestors, showDescendants, condition);
    }

    private void setFilter(boolean hideMatches, boolean showAncestors, boolean showDescendants, ICondition condition) {
        FilterController filterController = FilterController.getCurrentFilterController();
        if (condition == null) {
            filterController.applyNoFiltering((MapModel)this.getDelegate());
        } else {
            Filter filter = new Filter(condition, hideMatches, showAncestors, showDescendants, false, null);
            filterController.applyFilter((MapModel)this.getDelegate(), true, filter);
        }
    }

    public void filter(boolean showAncestors, boolean showDescendants, Closure<Boolean> closure) {
        this.setFilter(showAncestors, showDescendants, closure);
    }

    public void redoFilter() {
        FilterController.getCurrentFilterController().redo();
    }

    public void undoFilter() {
        FilterController.getCurrentFilterController().undo();
    }

    public Proxy.Properties getStorage() {
        return new PropertiesProxy((MapModel)this.getDelegate(), this.getScriptContext());
    }

    public void evaluateAllFormulas() {
        FormulaUtils.evaluateAllFormulas((MapModel)this.getDelegate());
    }

    public void evaluateOutdatedFormulas() {
        FormulaUtils.evaluateOutdatedFormulas((MapModel)this.getDelegate());
    }

    public void addListener(NodeChangeListener listener) {
        NodeChangeListeners.of(Controller.getCurrentModeController(), (MapModel)this.getDelegate()).add(this.getScriptContext(), listener);
    }

    public void removeListener(NodeChangeListener listener) {
        NodeChangeListeners.of(Controller.getCurrentModeController(), (MapModel)this.getDelegate()).remove(listener);
    }

    public List<NodeChangeListener> getListeners() {
        return NodeChangeListeners.of(Controller.getCurrentModeController(), (MapModel)this.getDelegate()).getListeners();
    }

    public void copyStyleFrom(MindMap source, String styleName) {
        IStyle style = NodeStyleProxy.styleByName(source, styleName);
        if (style == null) {
            throw new IllegalArgumentException("Style " + styleName + " not found");
        }
        MapStyleModel sourceStyleModel = MapStyleModel.getExtension((MapModel)((MapModel)((MapProxy)source).getDelegate()));
        NodeModel sourceNode = sourceStyleModel.getStyleNode(style);
        MapStyle styles = (MapStyle)this.getModeController().getExtension(MapStyle.class);
        styles.undoableCopyStyle(style, sourceNode, (MapModel)this.getDelegate());
    }

    public void copyConditionalStylesFrom(MindMap source, String styleName) {
        IStyle style = NodeStyleProxy.styleByName(source, styleName);
        if (style == null) {
            throw new IllegalArgumentException("Style " + styleName + " not found");
        }
        IStyle ownStyle = NodeStyleProxy.styleByName((MapModel)this.getDelegate(), styleName);
        if (ownStyle == null) {
            this.copyStyleFrom(source, styleName);
        }
        MapStyleModel ownStyleModel = MapStyleModel.getExtension((MapModel)((MapModel)this.getDelegate()));
        ConditionalStyleModel ownConditionalStyleModel = ownStyleModel.getConditionalStyleModel();
        MLogicalStyleController controller = (MLogicalStyleController)this.getModeController().getExtension(LogicalStyleController.class);
        List ownConditionalStyles = ownConditionalStyleModel.getStyles();
        for (int i = ownConditionalStyles.size() - 1; i >= 0; --i) {
            ConditionalStyleModel.Item item = (ConditionalStyleModel.Item)ownConditionalStyles.get(i);
            if (!item.getStyle().equals(style)) continue;
            controller.removeConditionalStyle((MapModel)this.getDelegate(), ownConditionalStyleModel, i);
        }
        MapStyleModel sourceStyleModel = MapStyleModel.getExtension((MapModel)((MapModel)((MapProxy)source).getDelegate()));
        ConditionalStyleModel sourceConditionalStyleModel = sourceStyleModel.getConditionalStyleModel();
        List sourceConditionalStyles = sourceConditionalStyleModel.getStyles();
        for (int i = 0; i < sourceConditionalStyles.size(); ++i) {
            ConditionalStyleModel.Item item = (ConditionalStyleModel.Item)sourceConditionalStyles.get(i);
            if (!item.getStyle().equals(style)) continue;
            controller.addConditionalStyle((MapModel)this.getDelegate(), ownConditionalStyleModel, item.isActive(), item.getCondition(), style, item.isLast());
        }
        controller.refreshMapLaterUndoable((MapModel)this.getDelegate());
    }

    public List<String> copyUserStylesFrom(MindMap source, boolean includeConditionalRules, String ... styleNameFilters) {
        List styleNames = source.getUserDefinedStylesNames();
        ArrayList<String> styleNamesToImport = new ArrayList<String>();
        block0: for (String name : styleNames) {
            for (String filter : styleNameFilters) {
                if (!name.matches(filter)) continue;
                styleNamesToImport.add(name);
                this.copyStyleFrom(source, name);
                if (!includeConditionalRules) continue block0;
                this.copyConditionalStylesFrom(source, name);
                continue block0;
            }
        }
        return styleNamesToImport;
    }

    public List<String> copyUserStylesFrom(MindMap source, boolean includeConditionalRules, ArrayList<String> styleNameFilters) {
        return this.copyUserStylesFrom(source, includeConditionalRules, styleNameFilters.toArray(new String[0]));
    }

    public List<String> copyUserStylesFrom(MindMap source) {
        return this.copyUserStylesFrom(source, true);
    }

    public List<String> copyUserStylesFrom(MindMap source, String ... styleNameFilters) {
        return this.copyUserStylesFrom(source, true, styleNameFilters);
    }

    public List<String> copyUserStylesFrom(MindMap source, ArrayList<String> styleNameFilters) {
        return this.copyUserStylesFrom(source, styleNameFilters.toArray(new String[0]));
    }

    public List<String> copyUserStylesFrom(MindMap source, boolean includeConditionalRules) {
        return this.copyUserStylesFrom(source, includeConditionalRules, ".*");
    }
}

