/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyStandardError;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.NameError;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ArraySupport;
import org.jruby.util.ByteList;
import org.jruby.util.Sprintf;
import org.jruby.util.TypeConverter;

@JRubyClass(name={"NameError"}, parent="StandardError")
public class RubyNameError
extends RubyStandardError {
    private IRubyObject name;
    private IRubyObject receiver;
    protected boolean privateCall;

    static RubyClass define(ThreadContext context, RubyClass StandardError2) {
        return (RubyClass)((RubyModule)Define.defineClass(context, "NameError", StandardError2, RubyNameError::new).reifiedClass(RubyNameError.class)).defineMethods(context, RubyNameError.class);
    }

    protected RubyNameError(Ruby runtime2, RubyClass exceptionClass) {
        this(runtime2, exceptionClass, exceptionClass.getName(runtime2.getCurrentContext()));
    }

    public RubyNameError(Ruby runtime2, RubyClass exceptionClass, String message2) {
        this(runtime2, exceptionClass, message2, (String)null);
    }

    public RubyNameError(Ruby runtime2, RubyClass exceptionClass, String message2, String name2) {
        super(runtime2, exceptionClass, message2);
        this.name = name2 == null ? runtime2.getNil() : RubySymbol.newSymbol(runtime2, name2);
    }

    public RubyNameError(Ruby runtime2, RubyClass exceptionClass, String message2, IRubyObject name2) {
        super(runtime2, exceptionClass, message2);
        this.name = name2;
    }

    @Override
    protected RaiseException constructThrowable(String message2) {
        return new NameError(message2, this);
    }

    @JRubyMethod(name={"exception"}, meta=true)
    public static IRubyObject exception(ThreadContext context, IRubyObject recv2) {
        return RubyNameError.newNameError(context, recv2, NULL_ARRAY);
    }

    @JRubyMethod(name={"exception"}, meta=true)
    public static RubyException exception(ThreadContext context, IRubyObject recv2, IRubyObject message2) {
        return RubyNameError.newNameError(context, recv2, new IRubyObject[]{message2});
    }

    @JRubyMethod(name={"exception"}, meta=true)
    public static RubyException exception(ThreadContext context, IRubyObject recv2, IRubyObject message2, IRubyObject name2) {
        return RubyNameError.newNameError(context, recv2, message2, name2, false);
    }

    private static RubyException newNameError(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        RubyClass klass = (RubyClass)recv2;
        RubyException newError = (RubyException)klass.allocate(context);
        newError.callInit(args2, Block.NULL_BLOCK);
        return newError;
    }

    static RubyException newNameError(ThreadContext context, IRubyObject recv2, IRubyObject message2, IRubyObject name2, boolean privateCall) {
        RubyClass klass = (RubyClass)recv2;
        RubyNameError newError = (RubyNameError)klass.allocate(context);
        newError.callInit(message2, name2, Block.NULL_BLOCK);
        newError.privateCall = privateCall;
        return newError;
    }

    @Override
    @JRubyMethod(rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        RubyHash options2 = null;
        if (args2.length > 0 && args2[args2.length - 1] != null && args2[args2.length - 1] instanceof RubyHash) {
            options2 = (RubyHash)args2[args2.length - 1];
            args2 = ArraySupport.newCopy(args2, args2.length - 1);
        }
        return this.initializeOptions(args2, options2, block);
    }

    public IRubyObject initializeOptions(IRubyObject[] args2, RubyHash options2, Block block) {
        IRubyObject[] values2;
        String[] keywords = new String[]{"receiver"};
        if (args2.length > 0) {
            this.message = args2[0];
        }
        if (this.message instanceof RubyNameErrorMessage) {
            this.receiver = ((RubyNameErrorMessage)this.message).object;
        }
        IRubyObject iRubyObject = this.name = args2.length > 1 ? args2[1] : this.getRuntime().getNil();
        if (options2 != null && (values2 = ArgsUtil.extractKeywordArgs(this.getRuntime().getCurrentContext(), options2, keywords)) != null && values2.length == 1 && values2[0] != null) {
            this.receiver = values2[0];
        }
        return super.initialize(NULL_ARRAY, block);
    }

    @Override
    @JRubyMethod
    public IRubyObject to_s(ThreadContext context) {
        if (this.message == context.nil) {
            return Create.newString(context, this.getMetaClass().getRealClass().getName(context));
        }
        RubyString str = this.message.convertToString();
        if (str != this.message) {
            this.message = str;
        }
        return this.message;
    }

    @JRubyMethod
    public IRubyObject name() {
        return this.name;
    }

    @JRubyMethod
    public IRubyObject receiver(ThreadContext context) {
        if (this.receiver == null) {
            throw Error.argumentError(context, "no receiver is available");
        }
        return this.receiver;
    }

    @JRubyMethod(name={"private_call?"})
    public IRubyObject private_call_p(ThreadContext context) {
        return Convert.asBoolean(context, this.isPrivateCall());
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone2) {
        super.copySpecialInstanceVariables(clone2);
        RubyNameError exception2 = (RubyNameError)clone2;
        exception2.receiver = this.receiver;
        exception2.name = this.name;
    }

    public boolean isPrivateCall() {
        return this.privateCall;
    }

    @JRubyClass(name={"NameError::Message"}, parent="Object")
    public static final class RubyNameErrorMessage
    extends RubyObject {
        private final String message;
        private final IRubyObject object;
        private final IRubyObject name;

        RubyNameErrorMessage(Ruby runtime2, RubyClass klazz) {
            super(runtime2, klazz);
            this.message = null;
            this.object = null;
            this.name = null;
        }

        RubyNameErrorMessage(Ruby runtime2, String message2, IRubyObject object, IRubyObject name2) {
            super(runtime2, runtime2.getNameErrorMessage(), false);
            this.message = message2;
            this.object = object;
            this.name = name2;
        }

        @JRubyMethod(name={"_load"}, meta=true)
        public static IRubyObject load(IRubyObject recv2, IRubyObject arg2) {
            return arg2;
        }

        static RubyClass define(ThreadContext context, RubyClass Object2, RubyClass NameError2) {
            return ((RubyModule)NameError2.defineClassUnder(context, "Message", Object2, RubyNameErrorMessage::new)).defineMethods(context, RubyNameErrorMessage.class).tap(c -> c.parent.setConstantVisibility(context, "Message", true));
        }

        @JRubyMethod(name={"_dump"})
        public IRubyObject dump(ThreadContext context, IRubyObject arg2) {
            return this.to_str(context);
        }

        @JRubyMethod
        public IRubyObject to_str(ThreadContext context) {
            RubyString emptyFrozenString;
            RubyString description;
            String message2 = this.message;
            if (message2 == null) {
                return context.nil;
            }
            Ruby runtime2 = context.runtime;
            RubyBasicObject object = (RubyBasicObject)this.object;
            RubyString separator = description = (emptyFrozenString = runtime2.getEmptyFrozenString());
            RubyString className = description;
            switch (object.getNativeClassIndex()) {
                case NIL: {
                    description = runtime2.getNilInspectString();
                    break;
                }
                case TRUE: {
                    description = runtime2.getTrueString();
                    break;
                }
                case FALSE: {
                    description = runtime2.getFalseString();
                    break;
                }
                default: {
                    if (message2.contains("%2$s")) {
                        description = RubyNameErrorMessage.getNameOrInspect(context, object);
                    }
                    RubyBasicObject classTmp = null;
                    if (!object.isSpecialConst()) {
                        switch (object.getNativeClassIndex()) {
                            case MODULE: {
                                separator = RubyString.newString(runtime2, "module ");
                                classTmp = object;
                                break;
                            }
                            case CLASS: {
                                separator = RubyString.newString(runtime2, "class ");
                                classTmp = object;
                            }
                        }
                    }
                    if (classTmp == null) {
                        RubyClass klass = object.getMetaClass();
                        if (klass.isSingleton()) {
                            separator = RubyString.newString(runtime2, "");
                            if (object == runtime2.getTopSelf()) {
                                className = RubyString.newString(runtime2, "main");
                                break;
                            }
                            className = (RubyString)object.anyToString();
                            break;
                        }
                        separator = RubyString.newString(runtime2, "an instance of ");
                        classTmp = klass.getRealClass();
                    }
                    className = RubyNameErrorMessage.getNameOrInspect(context, classTmp);
                }
            }
            RubyArray<?> arr = RubyArray.newArray(runtime2, this.name, description, separator, className);
            ByteList msgBytes = new ByteList(message2.length() + description.size() + separator.size() + className.size(), (Encoding)USASCIIEncoding.INSTANCE);
            Sprintf.sprintf(msgBytes, (CharSequence)message2, arr);
            return RubyString.newString(runtime2, msgBytes);
        }

        private static RubyString getNameOrInspect(ThreadContext context, IRubyObject object) {
            IRubyObject tmp = RubyNameErrorMessage.tryModuleName(context, object);
            if (tmp == UNDEF || tmp.isNil()) {
                tmp = RubyNameErrorMessage.tryInspect(context, object);
            }
            if (tmp == UNDEF) {
                context.clearErrorInfo();
            }
            if ((tmp = TypeConverter.checkStringType(context.runtime, tmp)).isNil()) {
                tmp = object.anyToString();
            }
            return (RubyString)tmp;
        }

        private static IRubyObject tryInspect(ThreadContext context, IRubyObject object) {
            try {
                return RubyObject.inspect(context, object);
            }
            catch (RaiseException raiseException) {
                return UNDEF;
            }
        }

        private static IRubyObject tryModuleName(ThreadContext context, IRubyObject obj) {
            if (!obj.isSpecialConst() && obj instanceof RubyModule) {
                try {
                    return Helpers.invokeChecked(context, obj, "name");
                }
                catch (RaiseException raiseException) {
                    // empty catch block
                }
            }
            return UNDEF;
        }
    }
}

