/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.cluster;

import org.opensearch.Version;

public class ADVersionUtil {
    public static final int VERSION_SEGMENTS = 3;

    public static Version fromString(String adVersion) {
        if ("NA".equals(adVersion)) {
            return Version.CURRENT;
        }
        return Version.fromString((String)ADVersionUtil.normalizeVersion(adVersion));
    }

    public static String normalizeVersion(String adVersion) {
        if (adVersion == null) {
            throw new IllegalArgumentException("AD version is null");
        }
        String[] versions = adVersion.split("\\.");
        if (versions.length < 3) {
            throw new IllegalArgumentException("Wrong AD version " + adVersion);
        }
        StringBuilder normalizedVersion = new StringBuilder();
        normalizedVersion.append(versions[0]);
        for (int i = 1; i < 3; ++i) {
            normalizedVersion.append(".");
            normalizedVersion.append(versions[i]);
        }
        return normalizedVersion.toString();
    }

    public static boolean compatibleWithVersionOnOrAfter1_1(Version adVersion) {
        return adVersion != null && adVersion.onOrAfter(Version.V_1_1_0);
    }
}

