/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.cluster.diskcleanup;

import java.time.Clock;
import java.time.Duration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ad.cluster.diskcleanup.IndexCleanup;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;

public class ModelCheckpointIndexRetention
implements Runnable {
    private static final Logger LOG = LogManager.getLogger(ModelCheckpointIndexRetention.class);
    private static final long MAX_SHARD_SIZE_IN_BYTE = 0xC80000000L;
    private static final Duration MINIMUM_CHECKPOINT_TTL = Duration.ofDays(1L);
    static final String CHECKPOINT_NOT_EXIST_MSG = "Checkpoint index does not exist.";
    private final Duration defaultCheckpointTtl;
    private final Clock clock;
    private final IndexCleanup indexCleanup;

    public ModelCheckpointIndexRetention(Duration defaultCheckpointTtl, Clock clock, IndexCleanup indexCleanup) {
        this.defaultCheckpointTtl = defaultCheckpointTtl;
        this.clock = clock;
        this.indexCleanup = indexCleanup;
    }

    @Override
    public void run() {
        this.indexCleanup.deleteDocsByQuery(".opendistro-anomaly-checkpoints", (QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp").lte((Object)(this.clock.millis() - this.defaultCheckpointTtl.toMillis())).format("epoch_millis")), (ActionListener<Long>)ActionListener.wrap(response -> this.cleanupBasedOnShardSize(this.defaultCheckpointTtl.minusDays(1L)), exception -> LOG.error("delete docs by query fails for checkpoint index", (Throwable)exception)));
    }

    private void cleanupBasedOnShardSize(Duration cleanUpTtl) {
        this.indexCleanup.deleteDocsBasedOnShardSize(".opendistro-anomaly-checkpoints", 0xC80000000L, (QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp").lte((Object)(this.clock.millis() - cleanUpTtl.toMillis())).format("epoch_millis")), (ActionListener<Boolean>)ActionListener.wrap(cleanupNeeded -> {
            if (cleanupNeeded.booleanValue()) {
                if (cleanUpTtl.equals(MINIMUM_CHECKPOINT_TTL)) {
                    return;
                }
                Duration nextCleanupTtl = cleanUpTtl.minusDays(1L);
                if (nextCleanupTtl.compareTo(MINIMUM_CHECKPOINT_TTL) < 0) {
                    nextCleanupTtl = MINIMUM_CHECKPOINT_TTL;
                }
                this.cleanupBasedOnShardSize(nextCleanupTtl);
            } else {
                LOG.debug("clean up not needed anymore for checkpoint index");
            }
        }, exception -> {
            if (exception instanceof IndexNotFoundException) {
                LOG.debug(CHECKPOINT_NOT_EXIST_MSG);
            } else {
                LOG.error("checkpoint index retention based on shard size fails", (Throwable)exception);
            }
        }));
    }
}

