/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.ad.constant.CommonErrorMessages;
import org.opensearch.ad.task.ADTaskCancellationState;
import org.opensearch.ad.task.ADTaskManager;
import org.opensearch.ad.transport.ADCancelTaskAction;
import org.opensearch.ad.transport.ADCancelTaskNodeRequest;
import org.opensearch.ad.transport.ADCancelTaskNodeResponse;
import org.opensearch.ad.transport.ADCancelTaskRequest;
import org.opensearch.ad.transport.ADCancelTaskResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class ADCancelTaskTransportAction
extends TransportNodesAction<ADCancelTaskRequest, ADCancelTaskResponse, ADCancelTaskNodeRequest, ADCancelTaskNodeResponse> {
    private final Logger logger = LogManager.getLogger(ADCancelTaskTransportAction.class);
    private ADTaskManager adTaskManager;

    @Inject
    public ADCancelTaskTransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, ADTaskManager adTaskManager) {
        super(ADCancelTaskAction.NAME, threadPool, clusterService, transportService, actionFilters, ADCancelTaskRequest::new, ADCancelTaskNodeRequest::new, "management", ADCancelTaskNodeResponse.class);
        this.adTaskManager = adTaskManager;
    }

    protected ADCancelTaskResponse newResponse(ADCancelTaskRequest request, List<ADCancelTaskNodeResponse> responses, List<FailedNodeException> failures) {
        return new ADCancelTaskResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected ADCancelTaskNodeRequest newNodeRequest(ADCancelTaskRequest request) {
        return new ADCancelTaskNodeRequest(request);
    }

    protected ADCancelTaskNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new ADCancelTaskNodeResponse(in);
    }

    protected ADCancelTaskNodeResponse nodeOperation(ADCancelTaskNodeRequest request) {
        String userName = request.getUserName();
        String detectorId = request.getDetectorId();
        String detectorTaskId = request.getDetectorTaskId();
        String reason = Optional.ofNullable(request.getReason()).orElse(CommonErrorMessages.HISTORICAL_ANALYSIS_CANCELLED);
        ADTaskCancellationState state = this.adTaskManager.cancelLocalTaskByDetectorId(detectorId, detectorTaskId, reason, userName);
        this.logger.debug("Cancelled AD task for detector: {}", (Object)request.getDetectorId());
        return new ADCancelTaskNodeResponse(this.clusterService.localNode(), state);
    }
}

