/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import java.time.Clock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.tasks.Task;
import org.opensearch.timeseries.ExecuteResultResponseRecorder;
import org.opensearch.timeseries.indices.IndexManagement;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.DateRange;
import org.opensearch.timeseries.model.IndexableResult;
import org.opensearch.timeseries.model.TaskType;
import org.opensearch.timeseries.model.TimeSeriesTask;
import org.opensearch.timeseries.rest.handler.IndexJobActionHandler;
import org.opensearch.timeseries.task.TaskCacheManager;
import org.opensearch.timeseries.task.TaskManager;
import org.opensearch.timeseries.transport.JobRequest;
import org.opensearch.timeseries.transport.JobResponse;
import org.opensearch.timeseries.transport.ProfileResponse;
import org.opensearch.timeseries.util.ParseUtils;
import org.opensearch.timeseries.util.RestHandlerUtils;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public abstract class BaseJobTransportAction<IndexType extends Enum<IndexType>, IndexManagementType extends IndexManagement<IndexType>, TaskCacheManagerType extends TaskCacheManager, TaskTypeEnum extends TaskType, TaskClass extends TimeSeriesTask, TaskManagerType extends TaskManager<TaskCacheManagerType, TaskTypeEnum, TaskClass, IndexType, IndexManagementType>, IndexableResultType extends IndexableResult, ProfileActionType extends ActionType<ProfileResponse>, ExecuteResultResponseRecorderType extends ExecuteResultResponseRecorder<IndexType, IndexManagementType, TaskCacheManagerType, TaskTypeEnum, TaskClass, TaskManagerType, IndexableResultType, ProfileActionType>, IndexJobActionHandlerType extends IndexJobActionHandler<IndexType, IndexManagementType, TaskCacheManagerType, TaskTypeEnum, TaskClass, TaskManagerType, IndexableResultType, ProfileActionType, ExecuteResultResponseRecorderType>>
extends HandledTransportAction<JobRequest, JobResponse> {
    private final Logger logger = LogManager.getLogger(BaseJobTransportAction.class);
    private final Client client;
    private final ClusterService clusterService;
    private final Settings settings;
    private final NamedXContentRegistry xContentRegistry;
    private volatile Boolean filterByEnabled;
    private final TransportService transportService;
    private final Setting<TimeValue> requestTimeOutSetting;
    private final String failtoStartMsg;
    private final String failtoStopMsg;
    private final Class<? extends Config> configClass;
    private final IndexJobActionHandlerType indexJobActionHandlerType;
    private final String configIndexName;
    private final Clock clock;

    public BaseJobTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, ClusterService clusterService, Settings settings, NamedXContentRegistry xContentRegistry, Setting<Boolean> filterByBackendRoleSettng, String jobActionName, Setting<TimeValue> requestTimeOutSetting, String failtoStartMsg, String failtoStopMsg, Class<? extends Config> configClass, IndexJobActionHandlerType indexJobActionHandlerType, String configIndexName, Clock clock) {
        super(jobActionName, transportService, actionFilters, JobRequest::new);
        this.transportService = transportService;
        this.client = client;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)filterByBackendRoleSettng.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(filterByBackendRoleSettng, it -> {
            this.filterByEnabled = it;
        });
        this.requestTimeOutSetting = requestTimeOutSetting;
        this.failtoStartMsg = failtoStartMsg;
        this.failtoStopMsg = failtoStopMsg;
        this.configClass = configClass;
        this.indexJobActionHandlerType = indexJobActionHandlerType;
        this.configIndexName = configIndexName;
        this.clock = clock;
    }

    protected void doExecute(Task task, JobRequest request, ActionListener<JobResponse> actionListener) {
        String configId = request.getConfigID();
        DateRange dateRange = request.getDateRange();
        boolean historical = request.isHistorical();
        String rawPath = request.getRawPath();
        TimeValue requestTimeout = (TimeValue)this.requestTimeOutSetting.get(this.settings);
        String errorMessage = rawPath.endsWith("_start") ? this.failtoStartMsg : this.failtoStopMsg;
        ActionListener listener = RestHandlerUtils.wrapRestActionListener(actionListener, errorMessage);
        boolean shouldEvaluateWithNewAuthz = ParseUtils.shouldUseResourceAuthz(this.settings);
        User user = ParseUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ParseUtils.verifyResourceAccessAndProcessRequest(user, this.configIndexName, configId, shouldEvaluateWithNewAuthz, (ActionListener<? extends ActionResponse>)listener, args -> this.executeConfig((ActionListener<JobResponse>)listener, configId, dateRange, historical, rawPath, requestTimeout, user, context, this.clock), new Object[0], fallbackArgs -> ParseUtils.resolveUserAndExecute(user, configId, this.filterByEnabled, listener, config -> this.executeConfig((ActionListener<JobResponse>)listener, configId, dateRange, historical, rawPath, requestTimeout, user, context, this.clock), this.client, this.clusterService, this.xContentRegistry, this.configClass), new Object[0]);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            listener.onFailure(e);
        }
    }

    private void executeConfig(ActionListener<JobResponse> listener, String configId, DateRange dateRange, boolean historical, String rawPath, TimeValue requestTimeout, User user, ThreadContext.StoredContext context, Clock clock) {
        if (rawPath.endsWith("_start")) {
            ((IndexJobActionHandler)this.indexJobActionHandlerType).startConfig(configId, dateRange, user, this.transportService, context, clock, listener);
        } else if (rawPath.endsWith("_stop")) {
            ((IndexJobActionHandler)this.indexJobActionHandlerType).stopConfig(configId, historical, user, this.transportService, listener);
        }
    }
}

