/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.nativeindex;

import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;
import org.opensearch.knn.common.KNNVectorUtil;
import org.opensearch.knn.index.codec.nativeindex.IndexBuildSetup;
import org.opensearch.knn.index.codec.nativeindex.NativeIndexBuildStrategy;
import org.opensearch.knn.index.codec.nativeindex.QuantizationIndexUtils;
import org.opensearch.knn.index.codec.nativeindex.model.BuildIndexParams;
import org.opensearch.knn.index.codec.transfer.OffHeapVectorTransfer;
import org.opensearch.knn.index.codec.transfer.OffHeapVectorTransferFactory;
import org.opensearch.knn.index.codec.util.KNNCodecUtil;
import org.opensearch.knn.index.vectorvalues.KNNVectorValues;
import org.opensearch.knn.jni.JNIService;

final class DefaultIndexBuildStrategy
implements NativeIndexBuildStrategy {
    private static DefaultIndexBuildStrategy INSTANCE = new DefaultIndexBuildStrategy();

    public static DefaultIndexBuildStrategy getInstance() {
        return INSTANCE;
    }

    @Override
    public void buildAndWriteIndex(BuildIndexParams indexInfo) throws IOException {
        KNNVectorValues<?> knnVectorValues = indexInfo.getVectorValues();
        KNNCodecUtil.initializeVectorValues(knnVectorValues);
        IndexBuildSetup indexBuildSetup = QuantizationIndexUtils.prepareIndexBuild(knnVectorValues, indexInfo);
        try (OffHeapVectorTransfer<Object> vectorTransfer = OffHeapVectorTransferFactory.getVectorTransfer(indexInfo.getVectorDataType(), indexBuildSetup.getBytesPerVector(), indexInfo.getTotalLiveDocs());){
            ArrayList<Integer> transferredDocIds = new ArrayList<Integer>(indexInfo.getTotalLiveDocs());
            while (knnVectorValues.docId() != Integer.MAX_VALUE) {
                Object vector = QuantizationIndexUtils.processAndReturnVector(knnVectorValues, indexBuildSetup);
                vectorTransfer.transfer(vector, true);
                transferredDocIds.add(knnVectorValues.docId());
                knnVectorValues.nextDoc();
            }
            vectorTransfer.flush(true);
            Map<String, Object> params = indexInfo.getParameters();
            long vectorAddress = vectorTransfer.getVectorAddress();
            if (params.containsKey("model_id")) {
                AccessController.doPrivileged(() -> {
                    JNIService.createIndexFromTemplate(KNNVectorUtil.intListToArray(transferredDocIds), vectorAddress, indexBuildSetup.getDimensions(), indexInfo.getIndexOutputWithBuffer(), (byte[])params.get("model_blob"), params, indexInfo.getKnnEngine());
                    return null;
                });
            } else {
                AccessController.doPrivileged(() -> {
                    JNIService.createIndex(KNNVectorUtil.intListToArray(transferredDocIds), vectorAddress, indexBuildSetup.getDimensions(), indexInfo.getIndexOutputWithBuffer(), params, indexInfo.getKnnEngine());
                    return null;
                });
            }
            vectorTransfer.reset();
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to build index, field name " + indexInfo.getFieldName() + ", parameters " + String.valueOf(indexInfo), exception);
        }
    }

    @Generated
    private DefaultIndexBuildStrategy() {
    }
}

