/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.mcpserver;

import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.action.mcpserver.McpToolsHelper;
import org.opensearch.ml.cluster.DiscoveryNodeHelper;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.mcpserver.requests.register.McpToolRegisterInput;
import org.opensearch.ml.common.transport.mcpserver.responses.list.MLMcpToolsListResponse;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportMcpToolsListAction
extends HandledTransportAction<ActionRequest, MLMcpToolsListResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportMcpToolsListAction.class);
    private final McpToolsHelper mcpToolsHelper;
    TransportService transportService;
    ClusterService clusterService;
    NamedXContentRegistry xContentRegistry;
    DiscoveryNodeHelper nodeFilter;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public TransportMcpToolsListAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, NamedXContentRegistry xContentRegistry, DiscoveryNodeHelper nodeFilter, McpToolsHelper mcpToolsHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/mcp_tools/list", transportService, actionFilters, streamInput -> new ActionRequest(){

            public ActionRequestValidationException validate() {
                return null;
            }
        });
        this.xContentRegistry = xContentRegistry;
        this.nodeFilter = nodeFilter;
        this.mcpToolsHelper = mcpToolsHelper;
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLMcpToolsListResponse> listener) {
        if (!this.mlFeatureEnabledSetting.isMcpServerEnabled()) {
            listener.onFailure((Exception)new OpenSearchException(MLCommonsSettings.ML_COMMONS_MCP_SERVER_DISABLED_MESSAGE, new Object[0]));
            return;
        }
        ActionListener searchListener = ActionListener.wrap(r -> listener.onResponse((Object)new MLMcpToolsListResponse(r)), e -> {
            log.error("Failed to list MCP tools", (Throwable)e);
            listener.onFailure(e);
        });
        this.mcpToolsHelper.searchAllTools((ActionListener<List<McpToolRegisterInput>>)searchListener);
    }
}

