/*
 * Decompiled with CFR 0.152.
 */
package org.jooq;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum SQLDialect {
    DEFAULT("", false, false),
    CUBRID("CUBRID", false, true),
    DERBY("Derby", false, true),
    FIREBIRD("Firebird", false, true, new RequiredVersion(4, null, null)),
    H2("H2", false, true, new RequiredVersion(2, 0, 202)),
    HSQLDB("HSQLDB", false, true),
    IGNITE("Ignite", false, true),
    MARIADB("MariaDB", false, true, new RequiredVersion(10, 6, null)),
    MYSQL("MySQL", false, true, new RequiredVersion(8, 0, 19)),
    POSTGRES("Postgres", false, true, new RequiredVersion(14, null, null)),
    SQLITE("SQLite", false, true, new RequiredVersion(3, 30, null)),
    YUGABYTEDB("YugabyteDB", false, true, new RequiredVersion(2, 9, null));

    private static final SQLDialect[] FAMILIES;
    private final String name;
    private final boolean commercial;
    private final boolean supported;
    private final RequiredVersion requiredVersion;
    private final SQLDialect family;
    private SQLDialect predecessor;
    private transient EnumSet<SQLDialect> predecessors;
    private final ThirdParty thirdParty;
    private static final Pattern P_PATCH_VERSION_MYSQL;

    @NotNull
    public static final @NotNull SQLDialect @NotNull [] families() {
        return (SQLDialect[])FAMILIES.clone();
    }

    @NotNull
    public static final Set<SQLDialect> predecessors(SQLDialect ... dialects) {
        EnumSet<SQLDialect> result = EnumSet.noneOf(SQLDialect.class);
        for (SQLDialect dialect : dialects) {
            result.addAll(dialect.predecessors());
        }
        return Collections.unmodifiableSet(result);
    }

    @NotNull
    public static final Set<SQLDialect> supportedUntil(SQLDialect dialect) {
        return SQLDialect.predecessors(dialect);
    }

    @NotNull
    public static final Set<SQLDialect> supportedUntil(SQLDialect ... dialects) {
        return SQLDialect.predecessors(dialects);
    }

    @NotNull
    public static final Set<SQLDialect> supportedBy(SQLDialect dialect) {
        EnumSet<SQLDialect> result = EnumSet.noneOf(SQLDialect.class);
        SQLDialect.addSupportedBy(dialect, result);
        return Collections.unmodifiableSet(result);
    }

    @NotNull
    public static final Set<SQLDialect> supportedBy(SQLDialect ... dialects) {
        EnumSet<SQLDialect> result = EnumSet.noneOf(SQLDialect.class);
        for (SQLDialect dialect : dialects) {
            SQLDialect.addSupportedBy(dialect, result);
        }
        return Collections.unmodifiableSet(result);
    }

    private static final void addSupportedBy(SQLDialect dialect, EnumSet<SQLDialect> supported) {
        supported.add(dialect);
        if (dialect.isFamily()) {
            supported.addAll(dialect.predecessors());
        } else {
            for (SQLDialect candidate = dialect.family(); candidate != dialect; candidate = candidate.predecessor()) {
                supported.add(candidate);
            }
        }
    }

    private SQLDialect(String name, boolean commercial, boolean supported) {
        this(name, commercial, supported, null);
    }

    private SQLDialect(String name, boolean commercial, boolean supported, RequiredVersion requiredVersion) {
        this(name, commercial, supported, requiredVersion, null, null);
    }

    private SQLDialect(String name, boolean commercial, boolean supported, RequiredVersion requiredVersion, SQLDialect family) {
        this(name, commercial, supported, requiredVersion, family, null);
    }

    private SQLDialect(String name, boolean commercial, boolean supported, RequiredVersion requiredVersion, SQLDialect family, SQLDialect predecessor) {
        this.name = name;
        this.commercial = commercial;
        this.supported = supported;
        this.requiredVersion = requiredVersion;
        this.family = family == null ? this : family;
        SQLDialect sQLDialect = this.predecessor = predecessor == null ? this : predecessor;
        if (family != null) {
            family.predecessor = this;
        }
        this.thirdParty = new ThirdParty();
    }

    public final boolean commercial() {
        return this.commercial;
    }

    public final boolean supported() {
        return this.supported;
    }

    @NotNull
    public final SQLDialect family() {
        return this.family;
    }

    public final boolean isFamily() {
        return this == this.family;
    }

    public final boolean isVersioned() {
        return this.requiredVersion != null;
    }

    @NotNull
    public final SQLDialect predecessor() {
        return this.predecessor;
    }

    @NotNull
    public final Set<SQLDialect> predecessors() {
        if (this.predecessors == null) {
            SQLDialect curr = this;
            EnumSet<SQLDialect> result = EnumSet.of(curr);
            while (true) {
                SQLDialect pred = curr.predecessor();
                result.add(pred);
                if (curr == pred) break;
                curr = pred;
            }
            this.predecessors = result;
        }
        return Collections.unmodifiableSet(this.predecessors);
    }

    public final boolean precedes(SQLDialect other) {
        if (this.family != other.family) {
            return false;
        }
        return other.predecessors().contains((Object)this);
    }

    public final boolean supports(SQLDialect other) {
        if (this.family != other.family) {
            return false;
        }
        if (this.isFamily() || other.isFamily()) {
            return true;
        }
        return other.precedes(this);
    }

    @Deprecated(forRemoval=true, since="3.14")
    public final boolean supports(Collection<SQLDialect> other) {
        if (other.contains((Object)this.family)) {
            return true;
        }
        SQLDialect candidate = this.family.predecessor();
        boolean successor = this == this.family;
        do {
            boolean bl = successor = successor || this == candidate;
            if (!other.contains((Object)candidate)) continue;
            return successor;
        } while (candidate != (candidate = candidate.predecessor()));
        return false;
    }

    public final boolean supportsDatabaseVersion(int majorVersion, int minorVersion, String productVersion) {
        return this.requiredVersion == null || this.requiredVersion.major == null || this.requiredVersion.major < majorVersion || this.requiredVersion.major == majorVersion && (this.requiredVersion.minor == null || this.requiredVersion.minor < minorVersion || this.requiredVersion.minor == minorVersion && (this.requiredVersion.patch == null || this.requiredVersion.patch <= this.patchVersion(productVersion)));
    }

    private final int patchVersion(String productVersion) {
        if (productVersion == null) {
            return Integer.MAX_VALUE;
        }
        switch (this.family()) {
            case H2: {
                return Integer.parseInt(productVersion.split(" ")[0].split("\\.")[2]);
            }
            case MYSQL: {
                return Integer.parseInt(P_PATCH_VERSION_MYSQL.matcher(productVersion).replaceFirst("$1"));
            }
        }
        return Integer.MAX_VALUE;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getNameLC() {
        return this.name.toLowerCase();
    }

    @NotNull
    public final String getNameUC() {
        return this.name.toUpperCase();
    }

    @NotNull
    public final ThirdParty thirdParty() {
        return this.thirdParty;
    }

    static {
        EnumSet<SQLDialect> set = EnumSet.noneOf(SQLDialect.class);
        for (SQLDialect dialect : SQLDialect.values()) {
            set.add(dialect.family());
        }
        FAMILIES = set.toArray(new SQLDialect[0]);
        P_PATCH_VERSION_MYSQL = Pattern.compile("^\\d+\\.\\d+\\.(\\d+).*$");
    }

    static final class RequiredVersion {
        private final Integer major;
        private final Integer minor;
        private final Integer patch;

        public RequiredVersion(Integer major, Integer minor, Integer patch) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
        }

        public Integer major() {
            return this.major;
        }

        public Integer minor() {
            return this.minor;
        }

        public Integer patch() {
            return this.patch;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RequiredVersion)) {
                return false;
            }
            RequiredVersion other = (RequiredVersion)o;
            if (!Objects.equals(this.major, other.major)) {
                return false;
            }
            if (!Objects.equals(this.minor, other.minor)) {
                return false;
            }
            return Objects.equals(this.patch, other.patch);
        }

        public int hashCode() {
            return Objects.hash(this.major, this.minor, this.patch);
        }

        public String toString() {
            return "RequiredVersion[" + "major=" + this.major + ", minor=" + this.minor + ", patch=" + this.patch + "]";
        }
    }

    public final class ThirdParty {
        @NotNull
        public final String driver() {
            try {
                Class<?> utils = Class.forName("org.jooq.tools.jdbc.JDBCUtils");
                return (String)utils.getMethod("driver", SQLDialect.class).invoke(utils, new Object[]{SQLDialect.this});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Nullable
        public final String springDbName() {
            switch (SQLDialect.this.family) {
                case DERBY: {
                    return "Derby";
                }
                case H2: {
                    return "H2";
                }
                case HSQLDB: {
                    return "HSQL";
                }
                case MYSQL: 
                case MARIADB: {
                    return "MySQL";
                }
                case POSTGRES: 
                case YUGABYTEDB: {
                    return "PostgreSQL";
                }
            }
            return null;
        }

        @Nullable
        public final String hibernateDialect() {
            switch (SQLDialect.this) {
                case CUBRID: {
                    return "org.hibernate.dialect.CUBRIDDialect";
                }
                case DERBY: {
                    return "org.hibernate.dialect.DerbyTenSevenDialect";
                }
                case FIREBIRD: {
                    return "org.hibernate.dialect.FirebirdDialect";
                }
                case H2: {
                    return "org.hibernate.dialect.H2Dialect";
                }
                case HSQLDB: {
                    return "org.hibernate.dialect.HSQLDialect";
                }
                case MYSQL: 
                case MARIADB: {
                    return "org.hibernate.dialect.MySQL5Dialect";
                }
                case POSTGRES: 
                case YUGABYTEDB: {
                    return "org.hibernate.dialect.PostgreSQL94Dialect";
                }
                case SQLITE: {
                    return null;
                }
            }
            return null;
        }
    }
}

