/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.ExtendedBlockId;
import org.apache.hadoop.hdfs.server.datanode.DNConf;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.CacheStats;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.MappableBlock;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.MappableBlockLoader;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.PmemMappedBlock;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.PmemVolumeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class PmemMappableBlockLoader
extends MappableBlockLoader {
    private static final Logger LOG = LoggerFactory.getLogger(PmemMappableBlockLoader.class);
    private PmemVolumeManager pmemVolumeManager;
    private boolean cacheRecoveryEnabled;

    @Override
    CacheStats initialize(DNConf dnConf) throws IOException {
        LOG.info("Initializing cache loader: " + this.getClass().getName());
        PmemVolumeManager.init(dnConf.getPmemVolumes(), dnConf.getPmemCacheRecoveryEnabled());
        this.pmemVolumeManager = PmemVolumeManager.getInstance();
        this.cacheRecoveryEnabled = dnConf.getPmemCacheRecoveryEnabled();
        LOG.info("Persistent memory is used for caching data instead of DRAM. Max locked memory is set to zero to disable DRAM cache");
        return new CacheStats(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    MappableBlock load(long length, FileInputStream blockIn, FileInputStream metaIn, String blockFileName, ExtendedBlockId key) throws IOException {
        PmemMappedBlock mappableBlock = null;
        String cachePath = null;
        FileChannel blockChannel = null;
        RandomAccessFile cacheFile = null;
        try {
            blockChannel = blockIn.getChannel();
            if (blockChannel == null) {
                throw new IOException("Block InputStream has no FileChannel.");
            }
            cachePath = this.pmemVolumeManager.getCachePath(key);
            cacheFile = new RandomAccessFile(cachePath, "rw");
            blockChannel.transferTo(0L, length, cacheFile.getChannel());
            cacheFile.getChannel().position(0L);
            this.verifyChecksum(length, metaIn, cacheFile.getChannel(), blockFileName);
            mappableBlock = new PmemMappedBlock(length, key);
            LOG.info("Successfully cached one replica:{} into persistent memory, [cached path={}, length={}]", new Object[]{key, cachePath, length});
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Closeable)blockChannel);
            IOUtils.closeQuietly(cacheFile);
            if (mappableBlock == null) {
                LOG.debug("Delete {} due to unsuccessful mapping.", (Object)cachePath);
                FsDatasetUtil.deleteMappedFile(cachePath);
            }
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)blockChannel);
        IOUtils.closeQuietly((Closeable)cacheFile);
        if (mappableBlock == null) {
            LOG.debug("Delete {} due to unsuccessful mapping.", (Object)cachePath);
            FsDatasetUtil.deleteMappedFile(cachePath);
        }
        return mappableBlock;
    }

    @Override
    public long getCacheUsed() {
        return this.pmemVolumeManager.getCacheUsed();
    }

    @Override
    public long getCacheCapacity() {
        return this.pmemVolumeManager.getCacheCapacity();
    }

    @Override
    long reserve(ExtendedBlockId key, long bytesCount) {
        return this.pmemVolumeManager.reserve(key, bytesCount);
    }

    @Override
    long release(ExtendedBlockId key, long bytesCount) {
        return this.pmemVolumeManager.release(key, bytesCount);
    }

    @Override
    public boolean isTransientCache() {
        return false;
    }

    @Override
    public boolean isNativeLoader() {
        return false;
    }

    @Override
    public MappableBlock getRecoveredMappableBlock(File cacheFile, String bpid, byte volumeIndex) throws IOException {
        ExtendedBlockId key = new ExtendedBlockId(this.getBlockId(cacheFile), bpid);
        PmemMappedBlock mappableBlock = new PmemMappedBlock(cacheFile.length(), key);
        PmemVolumeManager.getInstance().recoverBlockKeyToVolume(key, volumeIndex);
        String path = PmemVolumeManager.getInstance().getCachePath(key);
        long length = mappableBlock.getLength();
        LOG.info("Recovering persistent memory cache for block {}, path = {}, length = {}", new Object[]{key, path, length});
        return mappableBlock;
    }

    public long getBlockId(File file) {
        return Long.parseLong(file.getName());
    }

    @Override
    void shutdown() {
        if (!this.cacheRecoveryEnabled) {
            LOG.info("Clean up cache on persistent memory during shutdown.");
            PmemVolumeManager.getInstance().cleanup();
        }
    }
}

