/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.util.Arrays;
import javax.measure.Quantity;
import org.apache.sis.internal.referencing.provider.DatumShiftGridFile;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.DecimalFunctions;

final class DatumShiftGridCompressed<C extends Quantity<C>, T extends Quantity<T>>
extends DatumShiftGridFile<C, T> {
    private static final long serialVersionUID = 1889111858140209014L;
    private final double[] averages;
    private final short[][] data;
    private final double scale;

    private DatumShiftGridCompressed(DatumShiftGridFile<C, T> datumShiftGridFile, double[] dArray, short[][] sArray, double d) {
        super(datumShiftGridFile);
        this.averages = dArray;
        this.data = sArray;
        this.scale = d;
    }

    static <C extends Quantity<C>, T extends Quantity<T>> DatumShiftGridFile<C, T> compress(DatumShiftGridFile.Float<C, T> float_, double[] dArray, double d) {
        boolean bl;
        short[][] sArrayArray = new short[float_.offsets.length][];
        boolean bl2 = bl = dArray == null;
        if (bl) {
            dArray = new double[sArrayArray.length];
        }
        for (int i = 0; i < sArrayArray.length; ++i) {
            double d2;
            if (bl) {
                d2 = Math.rint(float_.getCellMean(i) / d);
                dArray[i] = d2 * d;
            } else {
                d2 = dArray[i] / d;
            }
            float[] fArray = float_.offsets[i];
            short[] sArray = new short[fArray.length];
            for (int j = 0; j < fArray.length; ++j) {
                double d3 = DecimalFunctions.floatToDouble(fArray[j]);
                float f = Math.ulp((float)(d3 /= d));
                d3 -= d2;
                if (Math.abs(d3 -= (double)(sArray[j] = (short)Math.round(d3))) < (double)f) continue;
                return float_;
            }
            sArrayArray[i] = sArray;
        }
        return new DatumShiftGridCompressed<C, T>(float_, dArray, sArrayArray, d);
    }

    @Override
    protected final DatumShiftGridFile<C, T> setData(Object[] objectArray) {
        return new DatumShiftGridCompressed<C, T>(this, this.averages, (short[][])objectArray, this.scale);
    }

    @Override
    public double getCellPrecision() {
        return Math.min(super.getCellPrecision(), 5.0 * this.scale);
    }

    @Override
    protected final Object[] getData() {
        return this.data;
    }

    @Override
    public final int getTranslationDimensions() {
        return this.data.length;
    }

    @Override
    public double getCellMean(int n) {
        return this.averages[n];
    }

    @Override
    public double getCellValue(int n, int n2, int n3) {
        return (double)this.data[n][n2 + n3 * this.scanlineStride] * this.scale + this.averages[n];
    }

    @Override
    public void interpolateInCell(double d, double d2, double[] dArray) {
        boolean bl;
        boolean bl2;
        int n = this.getGridSize(0) - 2;
        int n2 = this.getGridSize(1) - 2;
        int n3 = (int)d;
        int n4 = (int)d2;
        if (n3 < 0 || n3 > n || n4 < 0 || n4 > n2) {
            double[] dArray2 = new double[]{d, d2};
            this.replaceOutsideGridCoordinates(dArray2);
            d = dArray2[0];
            d2 = dArray2[1];
            n3 = Math.max(0, Math.min(n, (int)d));
            n4 = Math.max(0, Math.min(n2, (int)d2));
        }
        d2 -= (double)n4;
        boolean bl3 = bl2 = (d -= (double)n3) < 0.0;
        if (bl2) {
            d = 0.0;
        }
        boolean bl4 = bl = d2 < 0.0;
        if (bl) {
            d2 = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
            bl2 = true;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
            bl = true;
        }
        int n5 = this.scanlineStride * n4 + n3;
        int n6 = this.scanlineStride + n5;
        int n7 = this.data.length;
        boolean bl5 = dArray.length >= n7 + 4;
        for (int i = 0; i < n7; ++i) {
            short[] sArray = this.data[i];
            double d3 = sArray[n5];
            double d4 = sArray[n5 + 1];
            double d5 = sArray[n6];
            double d6 = sArray[n6 + 1];
            double d7 = d4 - d3;
            double d8 = d3 + d * d7;
            double d9 = d6 - d5;
            double d10 = d5 + d * d9;
            dArray[i] = (d2 * (d10 - d8) + d8) * this.scale + this.averages[i];
            if (!bl5) continue;
            if (bl2) {
                d7 = 0.0;
            } else {
                d7 += (d9 - d7) * d;
                d7 *= this.scale;
            }
            if (bl) {
                d9 = 0.0;
            } else {
                d9 = d5 - d3;
                d9 += (d6 - d4 - d9) * d2;
                d9 *= this.scale;
            }
            int n8 = n7;
            if (i == 0) {
                d7 += 1.0;
            } else {
                d9 += 1.0;
                n8 += 2;
                bl5 = false;
            }
            dArray[n8] = d7;
            dArray[n8 + 1] = d9;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            DatumShiftGridCompressed datumShiftGridCompressed = (DatumShiftGridCompressed)object;
            return Numerics.equals(this.scale, datumShiftGridCompressed.scale) && Arrays.equals(this.averages, datumShiftGridCompressed.averages);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.averages);
    }
}

