/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v0;

import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.IValueReader;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.Offset;

final class CompositeReader
implements IValueReader {
    private final IValueReader[] readers;

    CompositeReader(IValueReader[] readers) {
        this.readers = readers;
    }

    @Override
    public Object readValue(byte[] bytes, Offset offset, long timestamp) throws InvalidJfrFileException {
        Object[] objects = new Object[this.readers.length];
        for (int n = 0; n < objects.length; ++n) {
            objects[n] = this.readers[n].readValue(bytes, offset, timestamp);
        }
        return objects;
    }

    @Override
    public ContentType<?> getValueType() {
        return UnitLookup.UNKNOWN;
    }
}

