/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.xml.XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtils {
    @NotNull
    public static Document parseDocument(@NotNull String fileName) throws XMLException {
        return XMLUtils.parseDocument(new File(fileName));
    }

    @NotNull
    public static Document parseDocument(@NotNull File file) throws XMLException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileInputStream is = new FileInputStream(file);){
                return XMLUtils.parseDocument(new InputSource(is));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new XMLException("Error opening file '" + String.valueOf(file) + "'", e);
        }
    }

    @NotNull
    public static Document parseDocument(@NotNull Path file) throws XMLException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                return XMLUtils.parseDocument(new InputSource(is));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new XMLException("Error opening file '" + String.valueOf(file) + "'", e);
        }
    }

    @NotNull
    public static Document parseDocument(@NotNull InputStream is) throws XMLException {
        return XMLUtils.parseDocument(new InputSource(is));
    }

    @NotNull
    public static Document parseDocument(@NotNull Reader is) throws XMLException {
        return XMLUtils.parseDocument(new InputSource(is));
    }

    @NotNull
    public static Document parseDocument(@NotNull InputSource source) throws XMLException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder xmlBuilder = dbf.newDocumentBuilder();
            return xmlBuilder.parse(source);
        }
        catch (Exception er) {
            throw new XMLException("Error parsing XML document", er);
        }
    }

    @NotNull
    public static Document createDocument() throws XMLException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder xmlBuilder = dbf.newDocumentBuilder();
            return xmlBuilder.newDocument();
        }
        catch (Exception er) {
            throw new XMLException("Error creating XML document", er);
        }
    }

    @Nullable
    public static Element getChildElement(@Nullable Element element, @NotNull String childName) {
        if (element == null) {
            return null;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 && ((Element)node).getTagName().equals(childName)) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    @Nullable
    public static String getChildElementBody(@Nullable Element element, @NotNull String childName) {
        if (element == null) {
            return null;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 && ((Element)node).getTagName().equals(childName)) {
                return XMLUtils.getElementBody((Element)node);
            }
            node = node.getNextSibling();
        }
        return null;
    }

    @Nullable
    public static String getElementBody(@NotNull Element element) {
        return element.getTextContent();
    }

    @NotNull
    public static List<Element> getChildElementList(Element parent, String nodeName) {
        ArrayList<Element> list = new ArrayList<Element>();
        if (parent != null) {
            Node node = parent.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1 && nodeName.equals(node.getNodeName())) {
                    list.add((Element)node);
                }
                node = node.getNextSibling();
            }
        }
        return list;
    }

    @NotNull
    public static Collection<Element> getChildElementListNS(Element parent, String nsURI) {
        ArrayList<Element> list = new ArrayList<Element>();
        if (parent != null) {
            Node node = parent.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1 && node.getNamespaceURI().equals(nsURI)) {
                    list.add((Element)node);
                }
                node = node.getNextSibling();
            }
        }
        return list;
    }

    @NotNull
    public static Collection<Element> getChildElementListNS(Element parent, String nodeName, String nsURI) {
        ArrayList<Element> list = new ArrayList<Element>();
        Node node = parent.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 && node.getLocalName().equals(nodeName) && node.getNamespaceURI().equals(nsURI)) {
                list.add((Element)node);
            }
            node = node.getNextSibling();
        }
        return list;
    }

    @NotNull
    public static Collection<Element> getChildElementList(@NotNull Element parent, @NotNull String[] nodeNameList) {
        ArrayList<Element> list = new ArrayList<Element>();
        Node node = parent.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                String[] stringArray = nodeNameList;
                int n = nodeNameList.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (node.getNodeName().equals(s)) {
                        list.add((Element)node);
                    }
                    ++n2;
                }
            }
            node = node.getNextSibling();
        }
        return list;
    }

    @Nullable
    public static Element findChildElement(@NotNull Element parent) {
        Node node = parent.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    @Nullable
    public static Object escapeXml(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof CharSequence) {
            return XMLUtils.escapeXml((CharSequence)obj);
        }
        return obj;
    }

    @Nullable
    public static String escapeXml(@Nullable CharSequence str) {
        if (str == null) {
            return null;
        }
        StringBuilder res = null;
        int strLength = str.length();
        int i = 0;
        while (i < strLength) {
            char c = str.charAt(i);
            String repl = XMLUtils.encodeXMLChar(c);
            if (repl == null) {
                if (res != null) {
                    res.append(c);
                }
            } else {
                if (res == null) {
                    res = new StringBuilder(str.length() + 5);
                    int k = 0;
                    while (k < i) {
                        res.append(str.charAt(k));
                        ++k;
                    }
                }
                res.append(repl);
            }
            ++i;
        }
        return res == null ? str.toString() : res.toString();
    }

    public static boolean isValidXMLChar(char c) {
        return c >= ' ' || c == '\n' || c == '\r' || c == '\t';
    }

    @Nullable
    public static String encodeXMLChar(char ch) {
        switch (ch) {
            case '&': {
                return "&amp;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&#39;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
        }
        return null;
    }

    @NotNull
    public static XMLException adaptSAXException(@NotNull Exception toCatch) {
        if (toCatch instanceof XMLException) {
            return (XMLException)toCatch;
        }
        if (toCatch instanceof SAXException) {
            String message = toCatch.getMessage();
            Exception embedded = ((SAXException)toCatch).getException();
            if (embedded != null && embedded.getMessage() != null && embedded.getMessage().equals(message)) {
                return XMLUtils.adaptSAXException(embedded);
            }
            return new XMLException(message, embedded != null ? XMLUtils.adaptSAXException(embedded) : null);
        }
        return new XMLException(toCatch.getMessage(), toCatch);
    }

    @NotNull
    public static Collection<Element> getChildElementList(@Nullable Element element) {
        ArrayList<Element> children = new ArrayList<Element>();
        if (element != null) {
            Node node = element.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1) {
                    children.add((Element)node);
                }
                node = node.getNextSibling();
            }
        }
        return children;
    }
}

