/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.infonode.docking.AbstractTabWindow;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.SplitWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.WindowBar;
import net.infonode.docking.WindowPopupMenuFactory;
import net.infonode.docking.action.CloseOthersWindowAction;
import net.infonode.docking.action.CloseWithAbortWindowAction;
import net.infonode.docking.action.DockWithAbortWindowAction;
import net.infonode.docking.action.MaximizeWithAbortWindowAction;
import net.infonode.docking.action.MinimizeWithAbortWindowAction;
import net.infonode.docking.action.RestoreWithAbortWindowAction;
import net.infonode.docking.action.UndockWithAbortWindowAction;
import net.infonode.docking.util.DockingUtil;
import net.infonode.docking.util.ViewFactory;
import net.infonode.docking.util.ViewFactoryManager;
import net.infonode.gui.icon.button.ArrowIcon;
import net.infonode.gui.menu.MenuUtil;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.titledtab.TitledTabProperties;
import net.infonode.util.Direction;

public final class WindowMenuUtil {
    private static final Icon[] ARROW_ICONS = new Icon[4];

    static {
        Direction[] directions = Direction.getDirections();
        int i = 0;
        while (i < directions.length) {
            WindowMenuUtil.ARROW_ICONS[i] = new ArrowIcon(11, directions[i]);
            ++i;
        }
    }

    private WindowMenuUtil() {
    }

    private static AbstractTabWindow getTabWindowFor(DockingWindow window) {
        return (AbstractTabWindow)(window instanceof AbstractTabWindow ? window : (window.getWindowParent() != null && window.getWindowParent() instanceof AbstractTabWindow ? window.getWindowParent() : null));
    }

    private static JMenu getMoveToMenuItems(final DockingWindow window) {
        JMenu moveToMenu = new JMenu("Move to Window Bar");
        if (window.isMinimizable()) {
            final RootWindow root = window.getRootWindow();
            Direction[] directions = Direction.getDirections();
            int i = 0;
            while (i < 4) {
                final Direction dir = directions[i];
                if (!DockingUtil.isAncestor(root.getWindowBar(dir), window) && root.getWindowBar(dir).isEnabled()) {
                    moveToMenu.add(new JMenuItem(dir.getName(), ARROW_ICONS[i])).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            root.getWindowBar(dir).addTab(window);
                        }
                    });
                }
                ++i;
            }
        }
        return moveToMenu;
    }

    private static void addWindowMenuItems(JPopupMenu menu, DockingWindow window) {
        JMenu moveToMenu;
        menu.add(UndockWithAbortWindowAction.INSTANCE.getAction(window).toSwingAction());
        menu.add(DockWithAbortWindowAction.INSTANCE.getAction(window).toSwingAction());
        menu.add(RestoreWithAbortWindowAction.INSTANCE.getAction(window).toSwingAction());
        menu.add(MinimizeWithAbortWindowAction.INSTANCE.getAction(window).toSwingAction());
        if (window instanceof TabWindow) {
            menu.add(MaximizeWithAbortWindowAction.INSTANCE.getAction(window).toSwingAction());
        }
        menu.add(CloseWithAbortWindowAction.INSTANCE.getAction(window).toSwingAction());
        if (window.getWindowParent() instanceof AbstractTabWindow) {
            menu.add(CloseOthersWindowAction.INSTANCE.getAction(window).toSwingAction());
        }
        if ((moveToMenu = WindowMenuUtil.getMoveToMenuItems(window)).getItemCount() > 0) {
            menu.add(moveToMenu);
        }
    }

    private static void addNewViewMenuItems(JPopupMenu menu, final DockingWindow window, ViewFactoryManager viewManager) {
        ViewFactory[] viewFactories = viewManager.getViewFactories();
        if (viewFactories.length == 0) {
            return;
        }
        JMenu viewsPopup = new JMenu("Show View");
        int i = 0;
        while (i < viewFactories.length) {
            final ViewFactory vf = viewFactories[i];
            viewsPopup.add(new JMenuItem(vf.getTitle(), vf.getIcon())).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    View view = vf.createView();
                    if (view.getRootWindow() == window.getRootWindow()) {
                        return;
                    }
                    view.restore();
                    if (view.getRootWindow() == window.getRootWindow()) {
                        return;
                    }
                    if (window instanceof RootWindow) {
                        ((RootWindow)window).setWindow(view);
                    } else {
                        AbstractTabWindow tabWindow = WindowMenuUtil.getTabWindowFor(window);
                        if (tabWindow != null) {
                            tabWindow.addTab(view);
                        }
                    }
                }
            });
            ++i;
        }
        menu.add(viewsPopup);
    }

    private static void addTabOrientationMenuItems(JPopupMenu menu, DockingWindow window) {
        final AbstractTabWindow tabWindow = WindowMenuUtil.getTabWindowFor(window);
        if (tabWindow == null || tabWindow instanceof WindowBar) {
            return;
        }
        JMenu orientationMenu = new JMenu("Tab Orientation");
        TabbedPanelProperties properties = tabWindow.getTabWindowProperties().getTabbedPanelProperties();
        Direction[] directions = Direction.getDirections();
        int i = 0;
        while (i < directions.length) {
            final Direction dir = directions[i];
            JMenuItem item = orientationMenu.add(new JMenuItem(dir.getName(), ARROW_ICONS[i]));
            item.setEnabled(dir != properties.getTabAreaOrientation());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    tabWindow.getTabWindowProperties().getTabbedPanelProperties().setTabAreaOrientation(dir);
                }
            });
            ++i;
        }
        menu.add(orientationMenu);
    }

    private static void addTabDirectionMenuItems(JPopupMenu menu, DockingWindow window) {
        final AbstractTabWindow tabWindow = WindowMenuUtil.getTabWindowFor(window);
        if (tabWindow == null) {
            return;
        }
        JMenu directionMenu = new JMenu("Tab Direction");
        TitledTabProperties properties = TitledTabProperties.getDefaultProperties();
        properties.addSuperObject(tabWindow.getTabWindowProperties().getTabProperties().getTitledTabProperties());
        Direction[] directions = Direction.getDirections();
        int i = 0;
        while (i < directions.length) {
            final Direction dir = directions[i];
            if (dir != Direction.LEFT) {
                JMenuItem item = directionMenu.add(new JMenuItem(dir.getName(), ARROW_ICONS[i]));
                item.setEnabled(dir != properties.getNormalProperties().getDirection());
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        tabWindow.getTabWindowProperties().getTabProperties().getTitledTabProperties().getNormalProperties().setDirection(dir);
                    }
                });
            }
            ++i;
        }
        menu.add(directionMenu);
    }

    private static void addSplitWindowMenuItems(JPopupMenu menu, final DockingWindow window) {
        if (window instanceof SplitWindow) {
            JMenu splitMenu = new JMenu("Split Window");
            splitMenu.add("25%").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((SplitWindow)window).setDividerLocation(0.25f);
                }
            });
            splitMenu.add("50%").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((SplitWindow)window).setDividerLocation(0.5f);
                }
            });
            splitMenu.add("75%").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((SplitWindow)window).setDividerLocation(0.75f);
                }
            });
            splitMenu.addSeparator();
            splitMenu.add("Flip Orientation").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((SplitWindow)window).setHorizontal(!((SplitWindow)window).isHorizontal());
                }
            });
            splitMenu.add("Mirror").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SplitWindow sw = (SplitWindow)window;
                    sw.setWindows(window.getChildWindow(1), window.getChildWindow(0));
                    sw.setDividerLocation(1.0f - sw.getDividerLocation());
                }
            });
            menu.add(splitMenu);
        }
    }

    public static WindowPopupMenuFactory createWindowMenuFactory(ViewFactoryManager viewFactoryManager, boolean addTabItems) {
        return WindowMenuUtil.createWindowMenuFactory(viewFactoryManager, addTabItems, true);
    }

    public static WindowPopupMenuFactory createWindowMenuFactory(final ViewFactoryManager viewFactoryManager, final boolean addTabItems, final boolean addSplitWindowItems) {
        return new WindowPopupMenuFactory(){

            @Override
            public JPopupMenu createPopupMenu(DockingWindow window) {
                JPopupMenu menu = new JPopupMenu(window.getTitle());
                if (!(window instanceof RootWindow)) {
                    if (!(window instanceof WindowBar)) {
                        WindowMenuUtil.addWindowMenuItems(menu, window);
                        menu.addSeparator();
                    }
                    if (addTabItems) {
                        WindowMenuUtil.addTabOrientationMenuItems(menu, window);
                        WindowMenuUtil.addTabDirectionMenuItems(menu, window);
                        menu.addSeparator();
                    }
                    if (addSplitWindowItems) {
                        WindowMenuUtil.addSplitWindowMenuItems(menu, window);
                        menu.addSeparator();
                    }
                }
                WindowMenuUtil.addNewViewMenuItems(menu, window, viewFactoryManager);
                MenuUtil.optimizeSeparators(menu);
                MenuUtil.align(menu);
                return menu;
            }
        };
    }
}

