/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import generic.NestedIterator;
import generic.util.PeekableIterator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.EmptyAddressIterator;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Library;
import ghidra.program.model.symbol.LabelHistory;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolIteratorAdapter;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.database.symbol.AbstractDBTraceSymbol;
import ghidra.trace.database.symbol.DBTraceClassSymbol;
import ghidra.trace.database.symbol.DBTraceNamespaceSymbol;
import ghidra.trace.database.symbol.DBTraceSymbolManager;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.symbol.TraceLabelSymbol;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.trace.model.symbol.TraceSymbol;
import ghidra.trace.model.symbol.TraceSymbolWithLifespan;
import ghidra.trace.model.symbol.TraceSymbolWithLocationView;
import ghidra.util.AbstractPeekableIterator;
import ghidra.util.LockHold;
import ghidra.util.PeekableIterators;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.StreamSupport;

public class DBTraceProgramViewSymbolTable
implements SymbolTable {
    protected final DBTraceProgramView program;
    protected final DBTraceSymbolManager symbolManager;
    protected final DBTraceNamespaceSymbol global;

    public DBTraceProgramViewSymbolTable(DBTraceProgramView program) {
        this.program = program;
        this.symbolManager = program.trace.getSymbolManager();
        this.global = this.symbolManager.getGlobalNamespace();
    }

    protected TraceNamespaceSymbol assertTraceNamespace(Namespace ns) {
        if (ns == null) {
            return this.symbolManager.getGlobalNamespace();
        }
        if (!(ns instanceof TraceNamespaceSymbol)) {
            throw new IllegalArgumentException("Given namespace is not part of this trace");
        }
        return (TraceNamespaceSymbol)ns;
    }

    public Symbol createLabel(Address addr, String name, SourceType source) throws InvalidInputException {
        return this.symbolManager.labels().create(this.program.snap, null, addr, name, this.global, source);
    }

    public Symbol createLabel(Address addr, String name, Namespace namespace, SourceType source) throws InvalidInputException {
        return this.symbolManager.labels().create(this.program.snap, null, addr, name, this.assertTraceNamespace(namespace), source);
    }

    public boolean removeSymbolSpecial(Symbol sym) {
        try (LockHold hold = this.program.trace.lockWrite();){
            SourceType source;
            TraceNamespaceSymbol parent;
            String name;
            AbstractDBTraceSymbol dbSym = this.symbolManager.getSymbolByID(sym.getID());
            if (sym != dbSym) {
                throw new IllegalArgumentException("The given symbol is not part of this trace");
            }
            if (dbSym.getSymbolType() != SymbolType.FUNCTION) {
                boolean bl = dbSym.delete();
                return bl;
            }
            Address address = dbSym.getAddress();
            Collection at = this.symbolManager.labels().getAt(this.program.snap, null, address, false);
            if (at.isEmpty()) {
                if (dbSym.getSource() == SourceType.DEFAULT) {
                    boolean bl = false;
                    return bl;
                }
                name = SymbolUtilities.getDefaultFunctionName((Address)address);
                parent = this.global;
                source = SourceType.DEFAULT;
            } else {
                TraceLabelSymbol primary = (TraceLabelSymbol)at.iterator().next();
                name = primary.getName();
                parent = primary.getParentNamespace();
                source = primary.getSource();
                primary.delete();
            }
            try {
                dbSym.setNameAndNamespace(name, parent, source);
                boolean primary = true;
                return primary;
            }
            catch (CircularDependencyException | DuplicateNameException | InvalidInputException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    protected <T extends TraceSymbol> T requireVisible(T sym) {
        if (!(sym instanceof TraceSymbolWithLifespan)) {
            return sym;
        }
        TraceSymbolWithLifespan wl = (TraceSymbolWithLifespan)sym;
        if (this.program.viewport.containsAnyUpper(wl.getLifespan())) {
            return sym;
        }
        return null;
    }

    public Symbol getSymbol(long symbolID) {
        return this.requireVisible(this.symbolManager.getSymbolByID(symbolID));
    }

    public Symbol getSymbol(String name, Address addr, Namespace namespace) {
        try (LockHold hold = this.program.trace.lockRead();){
            for (TraceSymbol traceSymbol : this.symbolManager.allSymbols().getChildrenNamed(name, this.assertTraceNamespace(namespace))) {
                if (!addr.equals((Object)traceSymbol.getAddress()) || this.requireVisible(traceSymbol) == null) continue;
                TraceSymbol traceSymbol2 = traceSymbol;
                return traceSymbol2;
            }
            Iterator<? extends AbstractDBTraceSymbol> iterator = null;
            return iterator;
        }
    }

    public Symbol getGlobalSymbol(String name, Address addr) {
        return this.getSymbol(name, addr, this.global);
    }

    public List<Symbol> getSymbols(String name, Namespace namespace) {
        TraceNamespaceSymbol parent = this.assertTraceNamespace(namespace);
        try (LockHold hold = this.program.trace.lockRead();){
            ArrayList<TraceSymbol> result = new ArrayList<TraceSymbol>();
            for (TraceSymbol traceSymbol : this.symbolManager.allSymbols().getChildrenNamed(name, parent)) {
                if (this.requireVisible(traceSymbol) == null) continue;
                result.add(traceSymbol);
            }
            ArrayList<TraceSymbol> arrayList = result;
            return arrayList;
        }
    }

    public List<Symbol> getGlobalSymbols(String name) {
        return this.getSymbols(name, this.global);
    }

    public List<Symbol> getLabelOrFunctionSymbols(String name, Namespace namespace) {
        TraceNamespaceSymbol parent = this.assertTraceNamespace(namespace);
        try (LockHold hold = this.program.trace.lockRead();){
            ArrayList<TraceSymbol> result = new ArrayList<TraceSymbol>();
            for (TraceSymbol sym : this.symbolManager.labels().getChildrenNamed(name, parent)) {
                if (this.requireVisible(sym) == null) continue;
                result.add(sym);
            }
            ArrayList<TraceSymbol> arrayList = result;
            return arrayList;
        }
    }

    public Symbol getNamespaceSymbol(String name, Namespace namespace) {
        return this.symbolManager.namespaces().getChildNamed(name, this.assertTraceNamespace(namespace));
    }

    public Symbol getLibrarySymbol(String name) {
        return null;
    }

    public Symbol getClassSymbol(String name, Namespace namespace) {
        return this.symbolManager.classes().getChildNamed(name, this.assertTraceNamespace(namespace));
    }

    public Symbol getParameterSymbol(String name, Namespace namespace) {
        return null;
    }

    public Symbol getLocalVariableSymbol(String name, Namespace namespace) {
        return null;
    }

    public Symbol getVariableSymbol(String name, Function function) {
        return null;
    }

    public Namespace getNamespace(String name, Namespace namespace) {
        return this.symbolManager.uniqueNamespaces().getChildNamed(name, this.assertTraceNamespace(namespace));
    }

    public SymbolIterator getSymbols(String name) {
        return new SymbolIteratorAdapter(this.symbolManager.allSymbols().getNamed(name).iterator());
    }

    public SymbolIterator getAllSymbols(boolean includeDynamicSymbols) {
        return new SymbolIteratorAdapter(this.symbolManager.allSymbols().getAll(includeDynamicSymbols).iterator());
    }

    public Symbol getSymbol(Reference ref) {
        return this.symbolManager.getSymbolByID(ref.getSymbolID());
    }

    public Symbol getPrimarySymbol(Address addr) {
        try (LockHold hold = this.program.trace.lockRead();){
            Collection at = this.symbolManager.labels().getAt(this.program.snap, null, addr, true);
            if (at.isEmpty()) {
                Symbol symbol = null;
                return symbol;
            }
            Symbol symbol = (Symbol)at.iterator().next();
            return symbol;
        }
    }

    public Symbol[] getSymbols(Address addr) {
        try (LockHold hold = this.program.trace.lockRead();){
            Collection<Symbol> at = this.symbolManager.labels().getAt(this.program.snap, null, addr, true);
            Symbol[] symbolArray = at.toArray(new Symbol[at.size()]);
            return symbolArray;
        }
    }

    public SymbolIterator getSymbolsAsIterator(Address addr) {
        Symbol[] symbols = this.getSymbols(addr);
        List<Symbol> list = Arrays.asList(symbols);
        return new SymbolIteratorAdapter(list.iterator());
    }

    public Symbol[] getUserSymbols(Address addr) {
        try (LockHold hold = this.program.trace.lockRead();){
            Collection<Symbol> at = this.symbolManager.labels().getAt(this.program.snap, null, addr, false);
            Symbol[] symbolArray = at.toArray(new Symbol[at.size()]);
            return symbolArray;
        }
    }

    public SymbolIterator getSymbols(Namespace namespace) {
        return new SymbolIteratorAdapter(this.symbolManager.allSymbols().getChildren(this.assertTraceNamespace(namespace)).iterator());
    }

    public SymbolIterator getSymbols(long namespaceID) {
        AbstractDBTraceSymbol sym = this.symbolManager.getSymbolByID(namespaceID);
        if (!(sym instanceof DBTraceNamespaceSymbol)) {
            return new SymbolIteratorAdapter(Collections.emptyIterator());
        }
        DBTraceNamespaceSymbol ns = (DBTraceNamespaceSymbol)sym;
        return new SymbolIteratorAdapter(this.symbolManager.allSymbols().getChildren(ns).iterator());
    }

    public boolean hasSymbol(Address addr) {
        if (addr.isMemoryAddress()) {
            return this.symbolManager.labels().hasAt(this.program.snap, null, addr, true);
        }
        return false;
    }

    public long getDynamicSymbolID(Address addr) {
        return 0L;
    }

    public SymbolIterator getSymbolIterator(String searchStr, boolean caseSensitive) {
        return new SymbolIteratorAdapter(this.symbolManager.allSymbols().getWithMatchingName(searchStr, caseSensitive).iterator());
    }

    public SymbolIterator getSymbols(AddressSetView set, SymbolType type, boolean forward) {
        return new SymbolIteratorAdapter(NestedIterator.start((Iterator)set.iterator(), range -> {
            if (range.getAddressSpace().isMemorySpace() && type == SymbolType.LABEL) {
                return this.symbolManager.labels().getIntersecting(Lifespan.at(this.program.snap), null, (AddressRange)range, true, forward).iterator();
            }
            return Collections.emptyIterator();
        }));
    }

    public SymbolIterator scanSymbolsByName(String startName) {
        return new SymbolIteratorAdapter(this.symbolManager.allSymbols().scanByName(startName));
    }

    public int getNumSymbols() {
        return this.symbolManager.allSymbols().size(true);
    }

    protected Iterator<? extends Symbol> getSymbolIteratorAtMySnap(TraceSymbolWithLocationView<? extends TraceSymbol> view, AddressSetView asv, boolean includeDynamicSymbols, boolean forward) {
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(asv.iterator(forward), 0);
        return StreamSupport.stream(spliterator, false).flatMap(range -> view.getIntersecting(Lifespan.at(this.program.snap), null, (AddressRange)range, includeDynamicSymbols, forward).stream()).iterator();
    }

    public SymbolIterator getSymbolIterator() {
        return new SymbolIteratorAdapter(this.getSymbolIteratorAtMySnap(this.symbolManager.labels(), (AddressSetView)this.program.language.getAddressFactory().getAddressSet(), true, true));
    }

    public SymbolIterator getDefinedSymbols() {
        return new SymbolIteratorAdapter(this.symbolManager.allSymbols().getAll(false).iterator());
    }

    public Symbol getExternalSymbol(String name) {
        return null;
    }

    public SymbolIterator getExternalSymbols(String name) {
        return new SymbolIteratorAdapter(Collections.emptyIterator());
    }

    public SymbolIterator getExternalSymbols() {
        return new SymbolIteratorAdapter(Collections.emptyIterator());
    }

    public SymbolIterator getSymbolIterator(boolean forward) {
        return new SymbolIteratorAdapter(this.getSymbolIteratorAtMySnap(this.symbolManager.labels(), (AddressSetView)this.program.language.getAddressFactory().getAddressSet(), true, forward));
    }

    public SymbolIterator getSymbolIterator(Address startAddr, boolean forward) {
        return new SymbolIteratorAdapter(this.getSymbolIteratorAtMySnap(this.symbolManager.labels(), DBTraceUtils.getAddressSet(this.program.language.getAddressFactory(), startAddr, forward), true, forward));
    }

    public SymbolIterator getPrimarySymbolIterator(boolean forward) {
        return new PrimarySymbolIterator((Iterator<Symbol>)this.getSymbolIterator(forward));
    }

    public SymbolIterator getPrimarySymbolIterator(Address startAddr, boolean forward) {
        return new PrimarySymbolIterator((Iterator<Symbol>)this.getSymbolIterator(startAddr, forward));
    }

    public SymbolIterator getPrimarySymbolIterator(AddressSetView asv, boolean forward) {
        return new PrimarySymbolIterator(NestedIterator.start((Iterator)asv.iterator(forward), range -> this.symbolManager.labels().getIntersecting(Lifespan.at(this.program.snap), null, (AddressRange)range, true, forward).iterator()));
    }

    public void addExternalEntryPoint(Address addr) {
        throw new UnsupportedOperationException();
    }

    public void removeExternalEntryPoint(Address addr) {
    }

    public boolean isExternalEntryPoint(Address addr) {
        return false;
    }

    public AddressIterator getExternalEntryPointIterator() {
        return new EmptyAddressIterator();
    }

    public LabelHistory[] getLabelHistory(Address addr) {
        return new LabelHistory[0];
    }

    public Iterator<LabelHistory> getLabelHistory() {
        return Collections.emptyIterator();
    }

    public boolean hasLabelHistory(Address addr) {
        return false;
    }

    public Namespace getNamespace(Address addr) {
        Iterator iterator;
        if (addr.isMemoryAddress() && (iterator = this.symbolManager.labels().getAt(this.program.snap, null, addr, true).iterator()).hasNext()) {
            TraceSymbol sym = (TraceSymbol)iterator.next();
            if (sym instanceof TraceNamespaceSymbol) {
                return (TraceNamespaceSymbol)sym;
            }
            return sym.getParentNamespace();
        }
        return this.symbolManager.getGlobalNamespace();
    }

    public Iterator<GhidraClass> getClassNamespaces() {
        return DBTraceUtils.covariantIterator(this.symbolManager.classes().getAll(true).iterator());
    }

    public GhidraClass createClass(Namespace parent, String name, SourceType source) throws DuplicateNameException, InvalidInputException {
        return this.symbolManager.classes().add(name, this.assertTraceNamespace(parent), source);
    }

    public SymbolIterator getChildren(Symbol parentSymbol) {
        if (!(parentSymbol instanceof TraceSymbol)) {
            throw new IllegalArgumentException("Given symbol is not part of this trace");
        }
        if (!(parentSymbol instanceof TraceNamespaceSymbol)) {
            return new SymbolIteratorAdapter(Collections.emptyIterator());
        }
        TraceNamespaceSymbol parent = (TraceNamespaceSymbol)parentSymbol;
        return new SymbolIteratorAdapter(this.symbolManager.allSymbols().getChildren(parent).iterator());
    }

    public Library createExternalLibrary(String name, SourceType source) throws DuplicateNameException, InvalidInputException {
        throw new UnsupportedOperationException();
    }

    public Namespace createNameSpace(Namespace parent, String name, SourceType source) throws DuplicateNameException, InvalidInputException {
        return this.symbolManager.namespaces().add(name, this.assertTraceNamespace(parent), source);
    }

    public Namespace getOrCreateNameSpace(Namespace parent, String name, SourceType source) throws DuplicateNameException, InvalidInputException {
        try (LockHold hold = this.program.trace.lockWrite();){
            Collection exist = this.symbolManager.namespaces().getNamed(name);
            if (!exist.isEmpty()) {
                Namespace namespace = (Namespace)exist.iterator().next();
                return namespace;
            }
            Namespace namespace = this.createNameSpace(parent, name, source);
            return namespace;
        }
    }

    public GhidraClass convertNamespaceToClass(Namespace namespace) {
        DBTraceClassSymbol dBTraceClassSymbol;
        block10: {
            if (namespace instanceof GhidraClass) {
                return (GhidraClass)namespace;
            }
            LockHold hold = this.program.trace.lockWrite();
            try {
                DBTraceNamespaceSymbol dbNamespace = this.symbolManager.assertIsMine(namespace);
                String origName = dbNamespace.getName();
                SourceType origSource = dbNamespace.getSource();
                String tempName = origName + System.nanoTime();
                DBTraceClassSymbol dbClass = this.symbolManager.classes().add(tempName, dbNamespace.getParentNamespace(), origSource);
                for (AbstractDBTraceSymbol abstractDBTraceSymbol : dbNamespace.getChildren()) {
                    abstractDBTraceSymbol.setNamespace(dbClass);
                }
                dbNamespace.delete();
                dbClass.setName(origName, origSource);
                dBTraceClassSymbol = dbClass;
                if (hold == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (hold != null) {
                        try {
                            hold.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CircularDependencyException | DuplicateNameException | InvalidInputException | IllegalArgumentException e) {
                    throw new AssertException("Unexpected exception creating class from namespace", e);
                }
            }
            hold.close();
        }
        return dBTraceClassSymbol;
    }

    protected static class PrimarySymbolIterator
    extends AbstractPeekableIterator<Symbol>
    implements SymbolIterator {
        private final PeekableIterator<Symbol> it;

        public PrimarySymbolIterator(Iterator<Symbol> it) {
            this.it = PeekableIterators.castOrWrap(it);
        }

        public Iterator<Symbol> iterator() {
            return this;
        }

        protected Symbol seekNext() {
            if (!this.it.hasNext()) {
                return null;
            }
            Symbol primary = (Symbol)this.it.next();
            while (this.it.hasNext() && primary.getAddress().equals((Object)((Symbol)this.it.peek()).getAddress())) {
                Symbol candidate = (Symbol)this.it.next();
                if (!candidate.isPrimary()) continue;
                primary = candidate;
            }
            return primary;
        }
    }
}

