/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import ghidra.pcode.utils.SlaFormat;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.program.model.pcode.Encoder;
import ghidra.sleigh.grammar.Location;
import java.io.IOException;

public class SleighSymbol
implements Comparable<SleighSymbol> {
    private String name;
    int id;
    int scopeid;
    private boolean wasSought = false;
    public final Location location;

    public String toString() {
        return this.name;
    }

    public String toDetailedString() {
        return this.name + "-" + this.scopeid + ":" + this.id;
    }

    public void setWasSought(boolean wasSought) {
        this.wasSought = wasSought;
    }

    public boolean wasSought() {
        return this.wasSought;
    }

    public SleighSymbol(Location location) {
        this.location = location;
    }

    public SleighSymbol(Location location, String nm) {
        this.location = location;
        this.name = nm;
        this.id = 0;
    }

    public void dispose() {
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public symbol_type getType() {
        return symbol_type.dummy_symbol;
    }

    public void encode(Encoder encoder) throws IOException {
        throw new IOException("Symbol " + this.name + " cannot be encoded directly");
    }

    protected final void encodeSleighSymbolHeader(Encoder encoder) throws IOException {
        encoder.writeString(SlaFormat.ATTRIB_NAME, this.name);
        encoder.writeUnsignedInteger(SlaFormat.ATTRIB_ID, this.id);
        encoder.writeUnsignedInteger(SlaFormat.ATTRIB_SCOPE, this.scopeid);
    }

    protected void encodeHeader(Encoder encoder) throws IOException {
        this.encodeSleighSymbolHeader(encoder);
    }

    @Override
    public int compareTo(SleighSymbol o) {
        return this.id - o.id;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
    }
}

