/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import ghidra.framework.options.XmlProperties;
import java.io.File;
import java.io.IOException;
import org.jdom.Content;
import org.jdom.Element;

public class SaveState
extends XmlProperties {
    private static final String SAVE_STATE = "SAVE_STATE";

    public SaveState(String name) {
        super(name);
    }

    public SaveState() {
        this(SAVE_STATE);
    }

    public SaveState(File file) throws IOException {
        super(file);
    }

    public SaveState(Element element) {
        super(element);
    }

    public void saveToFile(File file) throws IOException {
        this.saveToXmlFile(file);
    }

    public void putSaveState(String name, SaveState value) {
        this.map.put(name, value);
    }

    public SaveState getSaveState(String name) {
        return this.getAsType(name, null, SaveState.class);
    }

    @Override
    protected void processElement(Element element) {
        Element child;
        String tag = element.getName();
        if (tag.equals(SAVE_STATE) && (child = (Element)element.getChildren().get(0)) != null) {
            String name = element.getAttributeValue("NAME");
            this.map.put(name, new SaveState(child));
            return;
        }
        super.processElement(element);
    }

    @Override
    protected Element createElement(String key, Object value) {
        if (value instanceof SaveState) {
            SaveState saveState = (SaveState)value;
            Element savedElement = saveState.saveToXml();
            Element element = new Element(SAVE_STATE);
            element.setAttribute("NAME", key);
            element.setAttribute("TYPE", "SaveState");
            element.addContent((Content)savedElement);
            return element;
        }
        return super.createElement(key, value);
    }
}

