/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.clear;

import ghidra.app.plugin.core.clear.ClearOptions;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeChunker;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateReference;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Iterator;
import java.util.Set;

public class ClearCmd
extends BackgroundCommand<Program> {
    private static final int EVENT_LIMIT = 1000;
    private AddressSetView view;
    private ClearOptions options;
    private boolean sendIndividualEvents = false;
    private TaskMonitor monitor;
    private Program program;

    public ClearCmd(CodeUnit cu, ClearOptions options) {
        this((AddressSetView)new AddressSet((AddressRange)new AddressRangeImpl(cu.getMinAddress(), cu.getMaxAddress())), options, true);
    }

    public ClearCmd(AddressSetView view, ClearOptions options) {
        this(view, options, view.getNumAddresses() < 1000L);
    }

    public ClearCmd(AddressSetView view) {
        this(view, null, view.getNumAddresses() < 1000L);
    }

    protected ClearCmd(AddressSetView view, ClearOptions options, boolean sendIndividualEvents) {
        super(options != null ? "Clear with Options" : "Clear code", true, true, true);
        this.view = view;
        this.options = options;
        this.sendIndividualEvents = sendIndividualEvents;
        if (this.options == null) {
            this.options = new ClearOptions(false);
            this.options.setShouldClear(ClearOptions.ClearType.INSTRUCTIONS, true);
            this.options.setShouldClear(ClearOptions.ClearType.DATA, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyTo(Program p, TaskMonitor taskMonitor) {
        this.monitor = taskMonitor;
        this.program = p;
        boolean wasEabled = this.program.isSendingEvents();
        try {
            this.program.setEventsEnabled(this.sendIndividualEvents);
            boolean bl = this.doApplyTo();
            return bl;
        }
        finally {
            this.program.setEventsEnabled(wasEabled);
            this.program = null;
            this.monitor = null;
        }
    }

    private boolean doApplyTo() {
        try {
            this.doApplyWithCancel();
            this.monitor.setMessage("Clear completed");
            return true;
        }
        catch (CancelledException e) {
            return true;
        }
    }

    private boolean doApplyWithCancel() throws CancelledException {
        if (this.monitor == null) {
            this.monitor = TaskMonitor.DUMMY;
        }
        if (this.options.shouldClear(ClearOptions.ClearType.EQUATES)) {
            this.clearEquates(this.view);
        }
        if (this.options.shouldClear(ClearOptions.ClearType.INSTRUCTIONS) || this.options.shouldClear(ClearOptions.ClearType.DATA)) {
            this.clearInstructionsAndOrData(this.view);
        }
        if (this.options.shouldClear(ClearOptions.ClearType.COMMENTS)) {
            this.clearComments(this.view);
        }
        if (this.options.shouldClear(ClearOptions.ClearType.FUNCTIONS)) {
            this.clearFunctions(this.view);
        }
        if (this.options.shouldClear(ClearOptions.ClearType.SYMBOLS)) {
            this.clearSymbols(this.view);
        }
        if (this.options.shouldClear(ClearOptions.ClearType.PROPERTIES)) {
            this.clearProperties(this.view);
        }
        if (this.options.shouldClear(ClearOptions.ClearType.REGISTERS)) {
            this.clearRegisters(this.view);
        }
        if (this.options.shouldClear(ClearOptions.ClearType.BOOKMARKS)) {
            this.clearBookmarks(this.view);
        }
        if (this.options.shouldClear(ClearOptions.ClearType.INSTRUCTIONS) && this.options.shouldClear(ClearOptions.ClearType.DATA)) {
            return true;
        }
        Set<SourceType> referenceSourceTypesToClear = this.options.getReferenceSourceTypesToClear();
        if (!referenceSourceTypesToClear.isEmpty()) {
            this.clearReferences(this.view, referenceSourceTypesToClear);
        }
        return true;
    }

    private void clearSymbols(AddressSetView clearView) throws CancelledException {
        if (clearView.isEmpty()) {
            return;
        }
        this.monitor.initialize(clearView.getNumAddresses());
        this.monitor.setMessage("Clearing symbols...");
        SymbolTable symbolTable = this.program.getSymbolTable();
        int numDone = 0;
        int previousRangeAddrCnt = 0;
        for (AddressRange range : clearView.getAddressRanges()) {
            Address rangeMin = range.getMinAddress();
            SymbolIterator symbolIter = symbolTable.getSymbolIterator(rangeMin, true);
            while (symbolIter.hasNext()) {
                this.monitor.checkCancelled();
                Symbol s = symbolIter.next();
                if (s.getAddress().compareTo((Object)range.getMaxAddress()) > 0) break;
                if (s.getSymbolType() != SymbolType.LABEL || s.isPinned()) continue;
                s.delete();
                if (++numDone % 10000 != 0) continue;
                int progress = previousRangeAddrCnt + (int)s.getAddress().subtract(rangeMin);
                this.monitor.setProgress((long)progress);
                Swing.allowSwingToProcessEvents();
            }
            previousRangeAddrCnt = (int)((long)previousRangeAddrCnt + range.getLength());
        }
    }

    private void clearComments(AddressSetView clearView) throws CancelledException {
        this.monitor.initialize(clearView.getNumAddresses());
        this.monitor.setMessage("Starting to clear comments...");
        Listing listing = this.program.getListing();
        AddressRangeIterator iter = clearView.getAddressRanges();
        int progress = 0;
        while (iter.hasNext()) {
            this.monitor.checkCancelled();
            AddressRange range = (AddressRange)iter.next();
            listing.clearComments(range.getMinAddress(), range.getMaxAddress());
            progress = (int)((long)progress + range.getLength());
            this.monitor.setProgress((long)progress);
        }
    }

    private void clearProperties(AddressSetView clearView) throws CancelledException {
        this.monitor.initialize(clearView.getNumAddresses());
        this.monitor.setMessage("Starting to clear properties...");
        Listing listing = this.program.getListing();
        AddressRangeIterator iter = clearView.getAddressRanges();
        int progress = 0;
        while (iter.hasNext()) {
            AddressRange range = (AddressRange)iter.next();
            listing.clearProperties(range.getMinAddress(), range.getMaxAddress(), this.monitor);
            progress = (int)((long)progress + range.getLength());
            this.monitor.setProgress((long)progress);
        }
    }

    private void clearFunctions(AddressSetView clearView) throws CancelledException {
        FunctionManager manager = this.program.getFunctionManager();
        int count = manager.getFunctionCount();
        this.monitor.setMessage("Clearing functions...");
        this.monitor.initialize((long)count);
        FunctionIterator iter = manager.getFunctions(clearView, true);
        while (iter.hasNext()) {
            this.monitor.checkCancelled();
            Function func = (Function)iter.next();
            this.monitor.incrementProgress(1L);
            manager.removeFunction(func.getEntryPoint());
        }
    }

    private void clearRegisters(AddressSetView clearView) throws CancelledException {
        this.monitor.initialize(clearView.getNumAddresses());
        this.monitor.setMessage("Starting to clear registers...");
        ProgramContext pc = this.program.getProgramContext();
        AddressRangeIterator iter = clearView.getAddressRanges();
        while (iter.hasNext()) {
            AddressRange range = (AddressRange)iter.next();
            this.removeRegisters(pc, range);
        }
    }

    private void clearEquates(AddressSetView clearView) throws CancelledException {
        this.monitor.initialize(100L);
        this.monitor.setMessage("Starting to clear equates...");
        EquateTable eqtbl = this.program.getEquateTable();
        Iterator iter = eqtbl.getEquates();
        while (iter.hasNext()) {
            EquateReference[] refs;
            this.monitor.checkCancelled();
            Equate eq = (Equate)iter.next();
            for (EquateReference ref : refs = eq.getReferences()) {
                if (!clearView.contains(ref.getAddress())) continue;
                eq.removeReference(ref.getAddress(), (int)ref.getOpIndex());
            }
            if (eq.getReferences().length == 0) {
                eqtbl.removeEquate(eq.getName());
            }
            this.monitor.incrementProgress(1L);
        }
    }

    private void clearInstructionsAndOrData(AddressSetView clearView) throws CancelledException {
        boolean clearInstructions = this.options.shouldClear(ClearOptions.ClearType.INSTRUCTIONS);
        boolean clearData = this.options.shouldClear(ClearOptions.ClearType.DATA);
        this.monitor.initialize(clearView.getNumAddresses());
        this.monitor.setMessage(this.getMessage(clearInstructions, clearData));
        for (AddressRange range : clearView.getAddressRanges()) {
            this.clearCode(range, clearInstructions, clearData);
        }
    }

    private void clearCode(AddressRange range, boolean clearInstructions, boolean clearData) throws CancelledException {
        if (clearData && clearInstructions) {
            this.clearCodeUnits(range);
            return;
        }
        AddressSet set = clearInstructions ? this.getInstructionRanges(range) : this.getDataRanges(range);
        for (AddressRange r : set.getAddressRanges()) {
            this.clearCodeUnits(r);
        }
        this.monitor.incrementProgress(range.getLength() - set.getNumAddresses());
    }

    private AddressSet getInstructionRanges(AddressRange range) {
        Instruction inst;
        AddressSet addresses = new AddressSet();
        Listing listing = this.program.getListing();
        Address end = range.getMaxAddress();
        Iterator iterator = listing.getInstructions(range.getMinAddress(), true).iterator();
        while (iterator.hasNext() && (inst = (Instruction)iterator.next()).getMinAddress().compareTo((Object)end) <= 0) {
            addresses.add(inst.getMinAddress(), inst.getMaxAddress());
        }
        return addresses;
    }

    private AddressSet getDataRanges(AddressRange range) {
        Data data;
        AddressSet addresses = new AddressSet();
        Listing listing = this.program.getListing();
        Address end = range.getMaxAddress();
        Iterator iterator = listing.getDefinedData(range.getMinAddress(), true).iterator();
        while (iterator.hasNext() && (data = (Data)iterator.next()).getMinAddress().compareTo((Object)end) <= 0) {
            addresses.add(data.getMinAddress(), data.getMaxAddress());
        }
        return addresses;
    }

    private void clearCodeUnits(AddressRange range) throws CancelledException {
        Listing listing = this.program.getListing();
        boolean clearContext = this.options.shouldClear(ClearOptions.ClearType.REGISTERS);
        AddressRangeChunker chunker = new AddressRangeChunker(range, 10000);
        for (AddressRange chunk : chunker) {
            Address min = chunk.getMinAddress();
            Address max = chunk.getMaxAddress();
            this.monitor.setMessage("Clearing code at " + String.valueOf(min));
            listing.clearCodeUnits(min, max, clearContext, this.monitor);
            int numDone = (int)(max.subtract(min) + 1L);
            this.monitor.incrementProgress((long)numDone);
            Swing.allowSwingToProcessEvents();
        }
    }

    private void clearReferences(AddressSetView clearView, Set<SourceType> sourceTypesToClear) throws CancelledException {
        if (clearView.isEmpty()) {
            return;
        }
        this.monitor.initialize(clearView.getNumAddresses());
        this.monitor.setMessage("Clearing references...");
        ReferenceManager referenceManager = this.program.getReferenceManager();
        AddressIterator it = referenceManager.getReferenceSourceIterator(clearView, true);
        this.removeRefs(it, sourceTypesToClear);
    }

    private void clearBookmarks(AddressSetView clearView) throws CancelledException {
        if (clearView.isEmpty()) {
            return;
        }
        this.monitor.initialize(clearView.getNumAddresses());
        this.monitor.setMessage("Clearing bookmarks...");
        BookmarkManager bookmarkMgr = this.program.getBookmarkManager();
        bookmarkMgr.removeBookmarks(clearView, this.monitor);
    }

    private void removeRegisters(ProgramContext pc, AddressRange range) throws CancelledException {
        for (Register reg : pc.getRegistersWithValues()) {
            this.monitor.checkCancelled();
            if (reg.isProcessorContext()) continue;
            try {
                pc.remove(range.getMinAddress(), range.getMaxAddress(), reg);
            }
            catch (ContextChangeException e) {
                Msg.error((Object)((Object)this), (Object)(e.getMessage() + " in range " + String.valueOf(range)), (Throwable)e);
            }
        }
    }

    private void removeRefs(AddressIterator iter, Set<SourceType> sourceTypesToClear) throws CancelledException {
        ReferenceManager referenceManager = this.program.getReferenceManager();
        while (iter.hasNext()) {
            Reference[] refs;
            this.monitor.checkCancelled();
            Address addr = iter.next();
            for (Reference ref : refs = referenceManager.getReferencesFrom(addr)) {
                if (this.monitor.isCancelled()) break;
                SourceType source = ref.getSource();
                if (!sourceTypesToClear.contains(source)) continue;
                referenceManager.delete(ref);
            }
            this.monitor.incrementProgress(1L);
        }
    }

    private String getMessage(boolean clearInstructions, boolean clearData) {
        if (!clearData) {
            return "Clearing Instructions...";
        }
        if (!clearInstructions) {
            return "Clearing Data...";
        }
        return "Clearing Instructions and Data...";
    }
}

