/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.editor;

import docking.widgets.OptionDialog;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.GTableTextCellEditor;
import docking.widgets.textfield.GValidatedTextField;
import ghidra.app.plugin.core.datamgr.editor.EnumEditorProvider;
import ghidra.app.plugin.core.datamgr.editor.EnumEntry;
import ghidra.app.plugin.core.datamgr.editor.EnumTableModel;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.Swing;
import ghidra.util.table.GhidraTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

class EnumEditorPanel
extends JPanel {
    private JTable table;
    private JTextField nameField;
    private JTextField descField;
    private JLabel descLabel;
    private JTextField categoryField;
    private GhidraComboBox<?> sizeComboBox;
    private EnumTableModel tableModel;
    private EnumEditorProvider provider;
    private DocumentListener docListener;
    private EnumDataType originalEnumDT;
    private EnumDataType editedEnumDT;
    boolean showValuesAsHex = true;

    EnumEditorPanel(EnumDataType enumDT, EnumEditorProvider provider) {
        super(new BorderLayout());
        this.originalEnumDT = enumDT;
        this.editedEnumDT = (EnumDataType)enumDT.copy(enumDT.getDataTypeManager());
        this.provider = provider;
        this.create(this.editedEnumDT);
        this.setFieldInfo(this.editedEnumDT);
        this.createDocumentListener();
        this.nameField.getDocument().addDocumentListener(this.docListener);
        this.descField.getDocument().addDocumentListener(this.docListener);
    }

    EnumDataType getEnum() {
        return this.editedEnumDT;
    }

    Class<?> getTableClass() {
        return EnumTable.class;
    }

    JTable getTable() {
        return this.table;
    }

    int[] getSelectedRows() {
        return this.table.getSelectedRows();
    }

    boolean needsSave() {
        return this.originalEnumDT.getDataTypeManager() != this.editedEnumDT.getDataTypeManager() || !this.editedEnumDT.getCategoryPath().equals((Object)this.originalEnumDT.getCategoryPath()) || !this.editedEnumDT.getName().equals(this.originalEnumDT.getName()) || !this.editedEnumDT.isEquivalent((DataType)this.originalEnumDT) || !this.editedEnumDT.getDescription().equals(this.originalEnumDT.getDescription());
    }

    void restoreSelection(String name, boolean modelChanged) {
        if (modelChanged) {
            this.tableModel.fireTableDataChanged();
        }
        Swing.runLater(() -> {
            if (this.table.isEditing()) {
                return;
            }
            int row = this.tableModel.getRow(name);
            if (row >= 0 && row < this.tableModel.getRowCount()) {
                this.table.setRowSelectionInterval(row, row);
                Rectangle rect = this.table.getCellRect(row, 0, false);
                this.table.scrollRectToVisible(rect);
            }
        });
    }

    void domainObjectRestored(EnumDataType enuum, boolean exists) {
        this.stopCellEditing();
        DataTypeManager enumDtMgr = enuum.getDataTypeManager();
        String objectType = "domain object";
        objectType = enumDtMgr instanceof ProgramBasedDataTypeManager ? "program" : "data type archive";
        String archiveName = enumDtMgr.getName();
        this.originalEnumDT = enuum;
        if (!exists) {
            if (OptionDialog.showOptionNoCancelDialog((Component)this, (String)"Close Enum Editor?", (String)("The " + objectType + " \"" + archiveName + "\" has been restored.\n\"" + enuum.getDisplayName() + "\" may no longer exist outside the editor.\nDo you want to close editor?"), (String)"Close", (String)"Continue Edit", (int)2) == 1) {
                this.provider.dispose();
            } else {
                this.provider.stateChanged(null);
            }
            return;
        }
        if (exists && this.tableModel.hasChanges() && OptionDialog.showYesNoDialogWithNoAsDefaultButton((Component)this, (String)"Reload Enum Editor?", (String)("The " + objectType + " \"" + archiveName + "\" has been restored.\n\"" + enuum.getDisplayName() + "\" may have changed outside this editor.\nDo you want to discard edits and reload the Enum?")) == 2) {
            this.categoryField.setText(this.provider.getCategoryText());
            return;
        }
        this.editedEnumDT = (EnumDataType)enuum.copy(enuum.getDataTypeManager());
        this.setFieldInfo(this.editedEnumDT);
        this.tableModel.setEnum(this.editedEnumDT, false);
    }

    String getDescription() {
        String desc = this.descField.getText();
        if (desc.length() == 0) {
            desc = null;
        }
        return desc;
    }

    String getEnumName() {
        return this.nameField.getText();
    }

    void stateChanged(ChangeEvent e) {
        this.provider.stateChanged(e);
    }

    void setStatusMessage(String msg) {
        this.provider.setStatusMessage(msg);
    }

    void setEnum(EnumDataType enumDT) {
        this.originalEnumDT = enumDT;
        this.editedEnumDT = (EnumDataType)enumDT.copy(enumDT.getDataTypeManager());
        this.tableModel.setEnum(this.editedEnumDT, false);
    }

    void enumChanged(EnumDataType enuum) {
        this.originalEnumDT = enuum;
        EnumDataType myEnum = this.editedEnumDT;
        if (!enuum.getName().equals(myEnum.getName())) {
            this.updateNameField(enuum.getName());
        }
        this.updateDescription(enuum);
        this.sizeComboBox.setSelectedItem((Object)enuum.getLength());
        if (!enuum.isEquivalent((DataType)myEnum)) {
            myEnum.replaceWith((DataType)enuum);
            this.tableModel.setEnum(myEnum, true);
        }
    }

    private void updateDescription(EnumDataType enuum) {
        String descr = this.editedEnumDT.getDescription();
        String otherDesc = enuum.getDescription();
        boolean doUpdate = false;
        if (descr != null && !descr.equals(otherDesc)) {
            doUpdate = true;
        } else if (otherDesc != null && !otherDesc.equals(descr)) {
            doUpdate = true;
        }
        if (doUpdate) {
            this.editedEnumDT.setDescription(otherDesc);
            this.descField.getDocument().removeDocumentListener(this.docListener);
            this.descField.setText(otherDesc != null ? otherDesc : "");
            this.descField.getDocument().addDocumentListener(this.docListener);
        }
    }

    void deleteSelectedEntries() {
        int[] rows;
        EnumDataType enuum = this.getEnum();
        for (int row : rows = this.getSelectedRows()) {
            String name = this.tableModel.getNameAt(row);
            enuum.remove(name);
        }
        this.tableModel.setEnum(enuum, true);
        this.provider.stateChanged(null);
        Arrays.sort(rows);
        int row = rows[rows.length - 1] + 1 - rows.length;
        int count = enuum.getCount();
        if (row >= count) {
            row = count - 1;
        }
        if (row >= 0) {
            this.table.setRowSelectionInterval(row, row);
        }
    }

    void addEntry() {
        this.stopCellEditing();
        int newRow = this.tableModel.addEntry(this.table.getSelectedRow());
        if (newRow < 0) {
            Msg.showError((Object)this, (Component)this, (String)"Enum is full", (Object)"All possible Enum values have already been used");
            return;
        }
        Swing.runLater(() -> {
            this.table.setRowSelectionInterval(newRow, newRow);
            this.table.editCellAt(newRow, 0);
            Rectangle r = this.table.getCellRect(newRow, 0, true);
            this.table.scrollRectToVisible(r);
            this.provider.stateChanged(null);
        });
    }

    void dispose() {
        this.tableModel.dispose();
    }

    void updateNameField(String newName) {
        try {
            this.originalEnumDT.setName(newName);
            this.editedEnumDT.setName(newName);
            this.provider.setTitle(newName);
            this.nameField.getDocument().removeDocumentListener(this.docListener);
            this.nameField.setText(newName);
            this.nameField.getDocument().addDocumentListener(this.docListener);
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
    }

    void updateCategoryField(String categoryPath) {
        this.categoryField.setText(categoryPath);
    }

    void stopCellEditing() {
        TableCellEditor cellEditor = this.table.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }

    private void create(EnumDataType enumDT) {
        this.tableModel = new EnumTableModel(enumDT, this);
        this.table = new EnumTable((TableModel)((Object)this.tableModel));
        JScrollPane sp = new JScrollPane(this.table);
        this.table.setPreferredScrollableViewportSize(new Dimension(300, 120));
        this.table.setSelectionMode(2);
        this.add((Component)sp, "Center");
        this.table.setRowHeight(this.table.getRowHeight() + 4);
        this.table.setDefaultEditor(String.class, (TableCellEditor)((Object)new EnumStringCellEditor()));
        this.table.getColumnModel().getColumn(1).setCellEditor((TableCellEditor)((Object)new EnumLongCellEditor()));
        this.table.setDefaultRenderer(String.class, (TableCellRenderer)new GTableCellRenderer());
        this.table.setDefaultRenderer(Long.class, (TableCellRenderer)((Object)new EnumValueRenderer()));
        this.add((Component)this.createInfoPanel(), "South");
    }

    private String getValueAsString(long value) {
        if (this.showValuesAsHex) {
            int length = this.editedEnumDT.getLength();
            if (this.editedEnumDT.isSigned()) {
                return NumericUtilities.toSignedHexString((long)value);
            }
            return NumericUtilities.toHexString((long)value, (int)length);
        }
        return Long.toString(value);
    }

    private void createDocumentListener() {
        this.docListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changed();
            }

            private void changed() {
                String description;
                String name = EnumEditorPanel.this.nameField.getText().trim();
                if (name.length() == 0) {
                    return;
                }
                if (!name.equals(EnumEditorPanel.this.editedEnumDT.getName())) {
                    try {
                        EnumEditorPanel.this.editedEnumDT.setName(name);
                    }
                    catch (InvalidNameException e) {
                        EnumEditorPanel.this.setStatusMessage("'" + name + "' is not a valid name");
                    }
                }
                if (!(description = EnumEditorPanel.this.descField.getText()).equals(EnumEditorPanel.this.editedEnumDT.getDescription())) {
                    EnumEditorPanel.this.editedEnumDT.setDescription(description);
                }
                EnumEditorPanel.this.provider.stateChanged(null);
            }
        };
    }

    private JPanel createInfoPanel() {
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new BoxLayout(outerPanel, 1));
        outerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel descPanel = this.createDescriptionPanel();
        outerPanel.add(this.createNamePanel());
        outerPanel.add(Box.createVerticalStrut(2));
        outerPanel.add(descPanel);
        outerPanel.add(Box.createVerticalStrut(2));
        outerPanel.add(this.createCategoryPanel());
        return outerPanel;
    }

    private JPanel createNamePanel() {
        this.nameField = new JTextField(20);
        this.nameField.setName("Name");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        GLabel label = new GLabel("Name:", 4);
        label.setPreferredSize(new Dimension(this.descLabel.getPreferredSize()));
        panel.add((Component)label);
        panel.add(Box.createHorizontalStrut(2));
        panel.add(this.nameField);
        return panel;
    }

    private JPanel createDescriptionPanel() {
        this.descField = new JTextField(20);
        this.descField.setName("Description");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.descLabel = new GDLabel("Description:", 4);
        panel.add(this.descLabel);
        panel.add(Box.createHorizontalStrut(2));
        panel.add(this.descField);
        return panel;
    }

    private JPanel createCategoryPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.categoryField = new JTextField(24);
        this.categoryField.setEditable(false);
        this.categoryField.setName("Category");
        this.sizeComboBox = new GhidraComboBox((Object[])new Integer[]{1, 2, 4, 8});
        this.sizeComboBox.setName("Size");
        this.sizeComboBox.addItemListener(e -> {
            Integer length = (Integer)this.sizeComboBox.getSelectedItem();
            if (!this.validateNewLength(length)) {
                return;
            }
            this.setStatusMessage("");
            this.tableModel.setLength(length);
            this.provider.stateChanged(null);
        });
        GLabel label = new GLabel("Category:", 4);
        label.setPreferredSize(new Dimension(this.descLabel.getPreferredSize()));
        panel.add((Component)label);
        panel.add(Box.createHorizontalStrut(2));
        panel.add(this.categoryField);
        panel.add(Box.createHorizontalStrut(20));
        panel.add((Component)new GLabel("Size:"));
        panel.add(Box.createHorizontalStrut(5));
        panel.add((Component)this.sizeComboBox);
        return panel;
    }

    private boolean validateNewLength(Integer length) {
        EnumDataType enuum = this.tableModel.getEnum();
        int minLength = enuum.getMinimumPossibleLength();
        if (length < minLength) {
            this.vetoSizeChange(length, minLength, enuum.getLength());
            return false;
        }
        return true;
    }

    private void vetoSizeChange(int newLength, int minLength, int currentLength) {
        Swing.runLater(() -> {
            this.setStatusMessage("Enum size of " + newLength + " is smaller than minimum enum size of " + minLength);
            this.sizeComboBox.setSelectedItem((Object)currentLength);
        });
    }

    private void setFieldInfo(EnumDataType enuum) {
        this.nameField.setText(enuum.getDisplayName());
        this.sizeComboBox.setSelectedItem((Object)enuum.getLength());
        String description = enuum.getDescription();
        if (description == null) {
            description = "";
        }
        this.descField.setText(description);
        this.categoryField.setText(this.provider.getCategoryText());
    }

    private void focus(JTextField field) {
        Swing.runLater(() -> {
            field.requestFocusInWindow();
            field.selectAll();
        });
    }

    void setHexDisplayMode(boolean showHex) {
        this.showValuesAsHex = showHex;
        this.tableModel.fireTableDataChanged();
    }

    String getSelectedFieldName() {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return null;
        }
        EnumEntry enumEntry = (EnumEntry)this.tableModel.getRowObject(row);
        return enumEntry.getName();
    }

    private void edit(int row, int col) {
        this.scrollToCell(row, col);
        this.table.setRowSelectionInterval(row, row);
        this.table.editCellAt(row, col);
    }

    private void scrollToCell(int row, int col) {
        Rectangle cellRect;
        if (this.table.getAutoscrolls() && (cellRect = this.table.getCellRect(row, col, false)) != null) {
            this.table.scrollRectToVisible(cellRect);
        }
    }

    private int getRow(EnumEntry entry) {
        return this.tableModel.getRowIndex(entry);
    }

    private class EnumTable
    extends GhidraTable {
        EnumTable(TableModel model) {
            super(model);
            this.setAutoEditEnabled(true);
        }
    }

    private class EnumStringCellEditor
    extends EnumCellEditor {
        public EnumStringCellEditor() {
            super(new JTextField());
        }
    }

    private class EnumLongCellEditor
    extends EnumCellEditor {
        private RangeValidator validator;

        public EnumLongCellEditor() {
            super((JTextField)new GValidatedTextField.LongField(8));
            GValidatedTextField f = (GValidatedTextField)this.getComponent();
            this.validator = new RangeValidator();
            f.addValidator((GValidatedTextField.TextValidator)this.validator);
            f.addValidationMessageListener((GValidatedTextField.ValidationMessageListener)new StatusBarValidationMessageListener());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table1, Object value, boolean isSelected, int row, int column) {
            Long longValue = (Long)value;
            this.validator.setOriginalValue(longValue);
            String s = EnumEditorPanel.this.getValueAsString(longValue);
            return super.getTableCellEditorComponent(table1, s, isSelected, row, column);
        }
    }

    private class EnumValueRenderer
    extends GTableCellRenderer {
        EnumValueRenderer() {
            this.setFont(this.getFixedWidthFont());
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
            renderer.setHorizontalAlignment(4);
            return renderer;
        }

        protected String formatNumber(Number value, Settings settings) {
            if (value instanceof Long) {
                Long longValue = (Long)value;
                return EnumEditorPanel.this.getValueAsString(longValue);
            }
            return "";
        }
    }

    private abstract class EnumCellEditor
    extends GTableTextCellEditor {
        private KeyListener editingKeyListener;

        public EnumCellEditor(JTextField textField) {
            super(textField);
            this.editingKeyListener = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    boolean moveEdit;
                    if (!EnumEditorPanel.this.table.isEditing()) {
                        return;
                    }
                    int code = e.getKeyCode();
                    boolean bl = moveEdit = code == 9 || code == 38 || code == 40;
                    if (!moveEdit) {
                        return;
                    }
                    e.consume();
                    int row = EnumEditorPanel.this.table.getEditingRow();
                    int col = EnumEditorPanel.this.table.getEditingColumn();
                    EnumEntry editedEntry = (EnumEntry)EnumEditorPanel.this.tableModel.getRowObject(row);
                    TableCellEditor editor = EnumEditorPanel.this.table.getCellEditor();
                    editor.stopCellEditing();
                    CellEditRequest cellEditRequest = new CellEditRequest(EnumEditorPanel.this, editedEntry, col, e);
                    Swing.runLater((Runnable)cellEditRequest);
                }
            };
            textField.addKeyListener(this.editingKeyListener);
            textField.addActionListener(e -> EnumEditorPanel.this.table.editingStopped(null));
        }

        public Component getTableCellEditorComponent(JTable table1, Object value, boolean isSelected, int row, int column) {
            EnumEditorPanel.this.setStatusMessage("");
            EnumEditorPanel.this.focus((JTextField)this.getComponent());
            return super.getTableCellEditorComponent(table1, value, isSelected, row, column);
        }

        public boolean isCellEditable(EventObject e) {
            KeyEvent ke;
            if (e instanceof KeyEvent && (ke = (KeyEvent)e).getKeyCode() == 113) {
                return true;
            }
            return super.isCellEditable(e);
        }

        private record CellEditRequest(EnumEditorPanel editorPanel, EnumEntry editedEntry, int editCol, KeyEvent e) implements Runnable
        {
            @Override
            public void run() {
                JTable table = this.editorPanel.table;
                int row = this.editorPanel.getRow(this.editedEntry);
                int col = this.editCol;
                int rowCount = table.getRowCount();
                switch (this.e.getKeyCode()) {
                    case 9: {
                        boolean forward = !this.e.isShiftDown();
                        this.editNextCell(table, forward, row, col);
                        return;
                    }
                    case 40: {
                        if (++row == rowCount) {
                            row = 0;
                        }
                        this.editorPanel.edit(row, col);
                        return;
                    }
                    case 38: {
                        if (--row < 0) {
                            row = rowCount - 1;
                        }
                        this.editorPanel.edit(row, col);
                        return;
                    }
                }
            }

            private void editNextCell(JTable table, boolean forward, int row, int col) {
                int columnCount = table.getColumnCount();
                int rowCount = table.getRowCount();
                if (forward) {
                    int nextRow = row;
                    int nextCol = col + 1;
                    if (nextCol == columnCount) {
                        nextCol = 0;
                        if (++nextRow == rowCount) {
                            nextRow = 0;
                        }
                    }
                    this.editorPanel.edit(nextRow, nextCol);
                    return;
                }
                int nextRow = row;
                int nextCol = col - 1;
                if (nextCol < 0) {
                    nextCol = columnCount - 1;
                    if (--nextRow < 0) {
                        nextRow = rowCount - 1;
                        nextCol = columnCount - 1;
                    }
                }
                this.editorPanel.edit(nextRow, nextCol);
            }
        }
    }

    public class StatusBarValidationMessageListener
    implements GValidatedTextField.ValidationMessageListener {
        public void message(String msg) {
            EnumEditorPanel.this.setStatusMessage(msg);
        }
    }

    public class RangeValidator
    extends GValidatedTextField.LongField.LongValidator {
        private long min;
        private long max;

        public void setOriginalValue(long originalLong) {
            EnumDataType enuum = EnumEditorPanel.this.tableModel.getEnum();
            EnumDataType copy = (EnumDataType)enuum.copy(enuum.getDataTypeManager());
            String name = copy.getName(originalLong);
            copy.remove(name);
            this.min = copy.getMinPossibleValue();
            this.max = copy.getMaxPossibleValue();
        }

        public void validateLong(long oldValue, long newValue) throws GValidatedTextField.ValidationFailedException {
            if (newValue < this.min || newValue > this.max) {
                String minValue = EnumEditorPanel.this.getValueAsString(this.min);
                String maxValue = EnumEditorPanel.this.getValueAsString(this.max);
                String message = "Valid values are in the range (" + minValue + ", " + maxValue + ")";
                throw new GValidatedTextField.ValidationFailedException(message);
            }
        }
    }
}

