/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.nodes;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeTask;
import docking.widgets.tree.tasks.GTreeCollapseAllTask;
import ghidra.app.plugin.core.symboltree.SymbolCategory;
import ghidra.app.plugin.core.symboltree.nodes.ClassSymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.CodeSymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.FunctionSymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.NamespaceSymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.OrganizationNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolTreeNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolTreeRootNode;
import ghidra.program.model.address.GlobalNamespace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class SymbolCategoryNode
extends SymbolTreeNode {
    protected SymbolCategory symbolCategory;
    protected SymbolTable symbolTable;
    protected GlobalNamespace globalNamespace;
    protected Program program;
    protected boolean isEnabled = true;

    public SymbolCategoryNode(SymbolCategory symbolCategory, Program p) {
        this.symbolCategory = symbolCategory;
        this.program = p;
        this.symbolTable = p == null ? null : p.getSymbolTable();
        this.globalNamespace = p == null ? null : (GlobalNamespace)p.getGlobalNamespace();
    }

    public void setEnabled(boolean enabled) {
        SymbolCategoryNode modelNode;
        if (this.isEnabled == enabled) {
            return;
        }
        this.isEnabled = enabled;
        this.unloadChildren();
        GTree gTree = this.getTree();
        if (gTree != null && this != (modelNode = (SymbolCategoryNode)gTree.getModelNode((GTreeNode)this))) {
            modelNode.setEnabled(enabled);
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public List<GTreeNode> generateChildren(TaskMonitor monitor) throws CancelledException {
        if (!this.isEnabled) {
            return Collections.emptyList();
        }
        SymbolType symbolType = this.symbolCategory.getSymbolType();
        List<GTreeNode> list = this.getSymbols(symbolType, monitor);
        monitor.checkCancelled();
        SymbolTreeRootNode root = (SymbolTreeRootNode)this.getRoot();
        int groupThreshold = root.getNodeGroupThreshold();
        return OrganizationNode.organize(list, groupThreshold, monitor);
    }

    public Program getProgram() {
        return this.program;
    }

    protected List<GTreeNode> getSymbols(SymbolType type, TaskMonitor monitor) throws CancelledException {
        return this.getSymbols(type, true, monitor);
    }

    protected List<GTreeNode> getSymbols(SymbolType type, boolean globalOnly, TaskMonitor monitor) throws CancelledException {
        SymbolIterator it;
        ArrayList<GTreeNode> list = new ArrayList<GTreeNode>();
        SymbolType symbolType = this.symbolCategory.getSymbolType();
        monitor.initialize((long)this.symbolTable.getNumSymbols());
        SymbolIterator symbolIterator = it = globalOnly ? this.symbolTable.getSymbols((Namespace)this.globalNamespace) : this.symbolTable.getSymbolIterator();
        while (it.hasNext()) {
            Symbol s = it.next();
            monitor.incrementProgress(1L);
            monitor.checkCancelled();
            if (s == null || s.getSymbolType() != symbolType) continue;
            list.add((GTreeNode)SymbolNode.createNode(s, this.program));
        }
        Collections.sort(list, this.getChildrenComparator());
        return list;
    }

    @Override
    public boolean canCut() {
        return false;
    }

    @Override
    public boolean canPaste(List<GTreeNode> pastedNodes) {
        return false;
    }

    @Override
    public boolean isCut() {
        return false;
    }

    public boolean isModifiable() {
        return false;
    }

    @Override
    public void setNodeCut(boolean isCut) {
        throw new UnsupportedOperationException("Cannot cut a Category node");
    }

    public SymbolCategory getSymbolCategory() {
        return this.symbolCategory;
    }

    public String getName() {
        return this.symbolCategory.getName();
    }

    public String getToolTip() {
        return "SymbolCategory: " + this.getName();
    }

    public boolean isLeaf() {
        return false;
    }

    @Override
    public DataFlavor getNodeDataFlavor() {
        return null;
    }

    @Override
    public boolean supportsDataFlavors(DataFlavor[] dataFlavors) {
        for (DataFlavor flavor : dataFlavors) {
            if (!this.isLocalDataFlavor(flavor)) continue;
            return true;
        }
        return false;
    }

    protected boolean isLocalDataFlavor(DataFlavor dataFlavor) {
        return dataFlavor == CodeSymbolNode.LOCAL_DATA_FLAVOR || dataFlavor == FunctionSymbolNode.LOCAL_DATA_FLAVOR || dataFlavor == NamespaceSymbolNode.LOCAL_DATA_FLAVOR || dataFlavor == ClassSymbolNode.LOCAL_DATA_FLAVOR;
    }

    protected abstract boolean supportsSymbol(Symbol var1);

    public SymbolNode symbolAdded(Symbol symbol, TaskMonitor monitor) {
        if (!this.isLoaded()) {
            return null;
        }
        if (!this.supportsSymbol(symbol)) {
            return null;
        }
        SymbolCategoryNode parentNode = this;
        if (symbol.isGlobal()) {
            return this.doAddSymbol(symbol, (GTreeNode)parentNode);
        }
        Namespace parentNamespace = symbol.getParentNamespace();
        Symbol namespaceSymbol = parentNamespace.getSymbol();
        SymbolNode key = SymbolNode.createNode(namespaceSymbol, this.program);
        parentNode = this.findSymbolTreeNode(key, false, monitor);
        if (parentNode == null) {
            return null;
        }
        return this.doAddSymbol(symbol, (GTreeNode)parentNode);
    }

    protected SymbolNode doAddSymbol(Symbol symbol, GTreeNode parentNode) {
        if (!parentNode.isLoaded()) {
            return null;
        }
        SymbolNode newNode = SymbolNode.createNode(symbol, this.program);
        this.doAddNode(parentNode, (GTreeNode)newNode);
        return newNode;
    }

    protected void doAddNode(GTreeNode parentNode, GTreeNode newNode) {
        SymbolTreeNode symbolTreeNode = (SymbolTreeNode)parentNode;
        Comparator<GTreeNode> comparator = symbolTreeNode.getChildrenComparator();
        List children = parentNode.getChildren();
        int index = Collections.binarySearch(children, newNode, comparator);
        if (index >= 0) {
            GTreeNode matchingNode = parentNode.getChild(index);
            if (matchingNode instanceof OrganizationNode) {
                OrganizationNode orgNode = (OrganizationNode)matchingNode;
                orgNode.insertNode(newNode);
                return;
            }
        } else {
            index = -index - 1;
        }
        parentNode.addNode(index, newNode);
        if (!parentNode.isLoaded()) {
            return;
        }
        SymbolTreeRootNode root = (SymbolTreeRootNode)this.getRoot();
        int reOrgLimit = root.getReorganizeLimit();
        if (parentNode.getChildCount() > reOrgLimit) {
            GTree tree = parentNode.getTree();
            tree.clearSelectionPaths();
            tree.runTask((GTreeTask)new GTreeCollapseAllTask(tree, parentNode));
        }
    }

    public void symbolRemoved(Symbol symbol, TaskMonitor monitor) {
        this.symbolRemoved(symbol, symbol.getName(), monitor);
    }

    public void symbolRemoved(Symbol symbol, String oldName, TaskMonitor monitor) {
        if (!this.isLoaded()) {
            return;
        }
        if (!this.supportsSymbol(symbol)) {
            return;
        }
        SymbolNode key = SymbolNode.createKeyNode(symbol, oldName, this.program);
        GTreeNode foundNode = this.findSymbolTreeNode(key, false, monitor);
        if (foundNode == null) {
            return;
        }
        GTreeNode foundParent = foundNode.getParent();
        foundParent.removeNode(foundNode);
    }

    public void symbolRemoved(Symbol symbol, Namespace oldNamespace, TaskMonitor monitor) {
        this.symbolRemoved(symbol, monitor);
    }

    protected GTreeNode getNamespaceNode(GTreeNode parentNode, List<Namespace> namespaces, boolean loadChildren, TaskMonitor monitor) {
        if (!loadChildren && !parentNode.isLoaded() || monitor.isCancelled()) {
            return null;
        }
        if (namespaces.isEmpty()) {
            return null;
        }
        Namespace namespace = namespaces.remove(0);
        Symbol nsSymbol = namespace.getSymbol();
        SymbolNode key = SymbolNode.createKeyNode(nsSymbol, nsSymbol.getName(), this.program);
        GTreeNode namespaceNode = this.findNode(parentNode, key, loadChildren, monitor);
        if (namespaceNode == null || namespaces.isEmpty()) {
            return namespaceNode;
        }
        return this.getNamespaceNode(namespaceNode, namespaces, loadChildren, monitor);
    }

    @Override
    public Namespace getNamespace() {
        return this.program.getGlobalNamespace();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SymbolCategoryNode node = (SymbolCategoryNode)((Object)o);
        return this.getName().equals(node.getName());
    }
}

