/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang;

import generic.jar.ResourceFile;
import ghidra.app.util.bin.format.dwarf.DWARFUtil;
import ghidra.app.util.bin.format.golang.GoRegisterInfo;
import ghidra.app.util.bin.format.golang.GoVer;
import ghidra.app.util.bin.format.golang.GoVerSet;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.util.Msg;
import ghidra.util.xml.XmlUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class GoRegisterInfoManager {
    private static final String REGISTER_INFO_EXTERNAL_NAME = "Golang.register.info.file";

    public static GoRegisterInfoManager getInstance() {
        return SingletonHolder.instance;
    }

    public synchronized GoRegisterInfo getRegisterInfoForLang(Language lang, GoVer goVer) {
        List<GoRegisterInfo> registerInfos = this.loadRegisterInfo(lang);
        for (GoRegisterInfo registerInfo : registerInfos) {
            if (!registerInfo.getValidVersions().contains(goVer)) continue;
            return registerInfo;
        }
        int goSize = lang.getInstructionAlignment();
        Msg.warn((Object)this, (Object)"Missing Golang register info for: %s, defaulting to abi0, size=%d".formatted(lang.getLanguageID(), goSize));
        return this.getDefault(lang);
    }

    private List<GoRegisterInfo> loadRegisterInfo(Language lang) {
        try {
            ResourceFile f = DWARFUtil.getLanguageExternalFile(lang, REGISTER_INFO_EXTERNAL_NAME);
            if (f != null) {
                return this.read(f, lang);
            }
            Msg.warn(GoRegisterInfoManager.class, (Object)"Missing Golang register info file for: %s".formatted(lang.getLanguageID()));
        }
        catch (IOException e) {
            Msg.warn(GoRegisterInfoManager.class, (Object)"Failed to read Golang register info file", (Throwable)e);
        }
        return List.of();
    }

    private List<GoRegisterInfo> read(ResourceFile f, Language lang) throws IOException {
        List<GoRegisterInfo> list;
        block8: {
            SAXBuilder sax = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
            InputStream fis = f.getInputStream();
            try {
                Document doc = sax.build(fis);
                Element rootElem = doc.getRootElement();
                list = this.readFrom(rootElem, lang);
                if (fis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | JDOMException e) {
                    Msg.error(GoRegisterInfo.class, (Object)("Bad Golang register info file " + String.valueOf(f)), (Throwable)e);
                    throw new IOException("Failed to read Golang register info file " + String.valueOf(f), e);
                }
            }
            fis.close();
        }
        return list;
    }

    private List<GoRegisterInfo> readFrom(Element rootElem, Language lang) throws IOException {
        ArrayList<GoRegisterInfo> result = new ArrayList<GoRegisterInfo>();
        for (Element regInfoElem : rootElem.getChildren("register_info")) {
            GoRegisterInfo registerInfo = this.readRegInfoElement(regInfoElem, lang);
            result.add(registerInfo);
        }
        return result;
    }

    private GoRegisterInfo readRegInfoElement(Element regInfoElem, Language lang) throws IOException {
        GoVerSet validGoVersions = GoVerSet.parse(XmlUtilities.requireStringAttr((Element)regInfoElem, (String)"versions"));
        Element intRegsElem = regInfoElem.getChild("int_registers");
        Element floatRegsElem = regInfoElem.getChild("float_registers");
        Element stackElem = regInfoElem.getChild("stack");
        Element goRoutineElem = regInfoElem.getChild("current_goroutine");
        Element zeroRegElem = regInfoElem.getChild("zero_register");
        Element duffZeroElem = regInfoElem.getChild("duffzero");
        Element closureContextElem = regInfoElem.getChild("closurecontext");
        if (intRegsElem == null || floatRegsElem == null || stackElem == null || goRoutineElem == null || zeroRegElem == null || duffZeroElem == null || closureContextElem == null) {
            throw new IOException("Bad format");
        }
        List<Register> intRegs = this.parseRegListStr(intRegsElem.getAttributeValue("list"), lang);
        List<Register> floatRegs = this.parseRegListStr(floatRegsElem.getAttributeValue("list"), lang);
        int stackInitialOffset = XmlUtilities.parseBoundedIntAttr((Element)stackElem, (String)"initialoffset", (int)0, (int)Integer.MAX_VALUE);
        int maxAlign = XmlUtilities.parseBoundedIntAttr((Element)stackElem, (String)"maxalign", (int)1, (int)Integer.MAX_VALUE);
        Register currentGoRoutineReg = this.parseRegStr(goRoutineElem.getAttributeValue("register"), lang);
        Register zeroReg = this.parseRegStr(zeroRegElem.getAttributeValue("register"), lang);
        boolean zeroRegIsBuiltin = XmlUtilities.parseOptionalBooleanAttr((Element)zeroRegElem, (String)"builtin", (boolean)false);
        Register duffzeroDest = this.parseRegStr(duffZeroElem.getAttributeValue("dest"), lang);
        Register duffzeroZero = this.parseRegStr(duffZeroElem.getAttributeValue("zero_arg"), lang);
        GoRegisterInfo.RegType duffzeroZeroType = this.parseRegTypeStr(duffZeroElem.getAttributeValue("zero_type"));
        Register closureContextReg = this.parseRegStr(closureContextElem.getAttributeValue("register"), lang);
        GoRegisterInfo registerInfo = new GoRegisterInfo(intRegs, floatRegs, stackInitialOffset, maxAlign, currentGoRoutineReg, zeroReg, zeroRegIsBuiltin, duffzeroDest, duffzeroZero, duffzeroZeroType, closureContextReg, validGoVersions);
        return registerInfo;
    }

    private GoRegisterInfo getDefault(Language lang) {
        int goSize = lang.getInstructionAlignment();
        return new GoRegisterInfo(List.of(), List.of(), goSize, goSize, null, null, false, null, null, GoRegisterInfo.RegType.INT, null, GoVerSet.ALL);
    }

    private List<Register> parseRegListStr(String s, Language lang) throws IOException {
        ArrayList<Register> result = new ArrayList<Register>();
        for (String regName : s.split(",")) {
            Register register;
            if ((regName = regName.trim()).isEmpty() || (register = this.parseRegStr(regName, lang)) == null) continue;
            result.add(register);
        }
        return result;
    }

    private Register parseRegStr(String regName, Language lang) throws IOException {
        if (regName == null || regName.isBlank()) {
            return null;
        }
        Register register = lang.getRegister(regName);
        if (register == null) {
            throw new IOException("Unknown register: " + regName);
        }
        return register;
    }

    private GoRegisterInfo.RegType parseRegTypeStr(String s) {
        return switch (Objects.requireNonNullElse(s, "int").toLowerCase()) {
            default -> GoRegisterInfo.RegType.INT;
            case "float" -> GoRegisterInfo.RegType.FLOAT;
        };
    }

    private static class SingletonHolder {
        private static GoRegisterInfoManager instance = new GoRegisterInfoManager();

        private SingletonHolder() {
        }
    }
}

