/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlobMarshalSpec;
import ghidra.app.util.bin.format.pe.cli.streams.CliAbstractStream;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.indexes.CliIndexHasFieldMarshall;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class CliTableFieldMarshall
extends CliAbstractTable {
    public CliTableFieldMarshall(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            CliFieldMarshallRow row = new CliFieldMarshallRow(CliIndexHasFieldMarshall.readCodedIndex(reader, stream), this.readBlobIndex(reader));
            this.rows.add(row);
        }
        reader.setPointerIndex(this.readerOffset);
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "FieldMarshall Row", 0);
        rowDt.add(CliIndexHasFieldMarshall.toDataType(this.metadataStream), "Parent", null);
        rowDt.add(this.metadataStream.getBlobIndexDataType(), "NativeType", null);
        return rowDt;
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader ntHeader) throws DuplicateNameException, CodeUnitInsertionException, IOException {
        for (CliAbstractTableRow row : this.rows) {
            Integer nativeTypeIndex = ((CliFieldMarshallRow)row).nativeTypeIndex;
            Address addr = CliAbstractStream.getStreamMarkupAddress(program, isBinary, monitor, log, ntHeader, this.metadataStream.getBlobStream(), nativeTypeIndex);
            CliBlobMarshalSpec blob = new CliBlobMarshalSpec(this.metadataStream.getBlobStream().getBlob(nativeTypeIndex));
            this.metadataStream.getBlobStream().updateBlob(blob, addr, program);
        }
    }

    public class CliFieldMarshallRow
    extends CliAbstractTableRow {
        public int parentIndex;
        public int nativeTypeIndex;

        public CliFieldMarshallRow(int parentIndex, int nativeTypeIndex) {
            this.parentIndex = parentIndex;
            this.nativeTypeIndex = nativeTypeIndex;
        }

        @Override
        public String getRepresentation() {
            String parentRep;
            try {
                parentRep = CliTableFieldMarshall.this.getRowRepresentationSafe(CliIndexHasFieldMarshall.getTableName(this.parentIndex), CliIndexHasFieldMarshall.getRowIndex(this.parentIndex));
            }
            catch (InvalidInputException e) {
                parentRep = Integer.toHexString(this.parentIndex);
            }
            String nativeTypeRep = Integer.toHexString(this.nativeTypeIndex);
            return String.format("Parent %s Native Type %s", parentRep, nativeTypeRep);
        }
    }
}

