/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.task;

import docking.widgets.OptionDialog;
import ghidra.app.plugin.core.progmgr.ProgramLocator;
import ghidra.app.util.dialog.CheckoutDialog;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.AppInfo;
import ghidra.framework.model.DomainFile;
import ghidra.framework.protocol.ghidra.GhidraURLQuery;
import ghidra.framework.protocol.ghidra.GhidraURLResultHandler;
import ghidra.framework.protocol.ghidra.GhidraURLResultHandlerAdapter;
import ghidra.framework.remote.User;
import ghidra.framework.store.ExclusiveCheckoutException;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import ghidra.util.VersionExceptionHandler;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;

public class ProgramOpener {
    private final Object consumer;
    private String openPromptText = "Open";
    private boolean silent = SystemUtilities.isInHeadlessMode();
    private boolean noCheckout = false;

    public ProgramOpener(Object consumer) {
        this.consumer = consumer;
    }

    public void setPromptText(String text) {
        this.openPromptText = text;
    }

    public void setSilent() {
        this.silent = true;
    }

    public void setNoCheckout() {
        this.noCheckout = true;
    }

    public Program openProgram(ProgramLocator locator, TaskMonitor monitor) {
        if (locator.isURL()) {
            return this.openURL(locator, monitor);
        }
        return this.openProgram(locator, locator.getDomainFile(), monitor);
    }

    private Program openURL(final ProgramLocator locator, TaskMonitor monitor) {
        URL ghidraUrl = locator.getURL();
        final AtomicReference openedProgram = new AtomicReference();
        try {
            GhidraURLQuery.queryUrl((URL)ghidraUrl, (GhidraURLResultHandler)new GhidraURLResultHandlerAdapter(){

                public void processResult(DomainFile domainFile, URL url, TaskMonitor m) {
                    Program p = ProgramOpener.this.openProgram(locator, domainFile, m);
                    openedProgram.set(p);
                }
            }, (TaskMonitor)monitor);
        }
        catch (CancelledException | IOException e) {
            return null;
        }
        return (Program)openedProgram.get();
    }

    private Program openProgram(ProgramLocator locator, DomainFile domainFile, TaskMonitor monitor) {
        if (!Program.class.isAssignableFrom(domainFile.getDomainObjectClass())) {
            Msg.showError((Object)this, null, (String)"Error Opening Program", (Object)("File does not correspond to a Ghidra Program: " + String.valueOf(locator)));
            return null;
        }
        int version = locator.getVersion();
        if (version != -1) {
            monitor.setMessage("Getting Version " + version + " for " + domainFile.getName());
            return this.openReadOnly(locator, domainFile, monitor);
        }
        monitor.setMessage("Opening " + String.valueOf(locator));
        if (locator.isURL()) {
            return this.openReadOnly(locator, domainFile, monitor);
        }
        return this.openNormal(domainFile, monitor);
    }

    private Program openNormal(DomainFile domainFile, TaskMonitor monitor) {
        String filename = domainFile.getName();
        this.performOptionalCheckout(domainFile, monitor);
        try {
            return this.openFileMaybeUgrade(domainFile, monitor);
        }
        catch (VersionException e) {
            String contentType = domainFile.getContentType();
            VersionExceptionHandler.showVersionError(null, (String)filename, (String)contentType, (String)"Open", (VersionException)e);
        }
        catch (CancelledException e) {
        }
        catch (LanguageNotFoundException e) {
            Msg.showError((Object)this, null, (String)("Error Opening " + filename), (Object)(e.getMessage() + "\nPlease contact the Ghidra team for assistance."));
        }
        catch (Exception e) {
            if (domainFile.isInWritableProject() && e instanceof IOException) {
                RepositoryAdapter repo = domainFile.getParent().getProjectData().getRepository();
                ClientUtil.handleException((RepositoryAdapter)repo, (Exception)e, (String)"Open File", null);
            }
            Msg.showError((Object)this, null, (String)("Error Opening " + filename), (Object)("Getting domain object failed.\n" + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    private Program openReadOnly(ProgramLocator locator, DomainFile domainFile, TaskMonitor monitor) {
        String contentType = domainFile.getContentType();
        String path = locator.toString();
        try {
            return (Program)domainFile.getReadOnlyDomainObject(this.consumer, locator.getVersion(), monitor);
        }
        catch (CancelledException cancelledException) {
        }
        catch (IOException e) {
            if (locator.isDomainFile() && domainFile.isInWritableProject()) {
                ClientUtil.handleException((RepositoryAdapter)AppInfo.getActiveProject().getRepository(), (Exception)e, (String)("Get " + contentType), null);
            } else if (locator.getVersion() != -1) {
                Msg.showError((Object)this, null, (String)"Error Getting Versioned Program", (Object)("Could not get version " + locator.getVersion() + " for " + path), (Throwable)e);
            } else {
                Msg.showError((Object)this, null, (String)"Error Getting Program", (Object)("Open program failed for " + path), (Throwable)e);
            }
        }
        catch (VersionException e) {
            VersionExceptionHandler.showVersionError(null, (String)domainFile.getName(), (String)contentType, (String)"Open", (VersionException)e);
        }
        return null;
    }

    private void performOptionalCheckout(DomainFile domainFile, TaskMonitor monitor) {
        if (this.silent || this.noCheckout || !domainFile.canCheckout()) {
            return;
        }
        User user = domainFile.getParent().getProjectData().getUser();
        CheckoutDialog dialog = (CheckoutDialog)((Object)Swing.runNow(() -> new CheckoutDialog(domainFile, user)));
        if (dialog.showDialog() == 0) {
            try {
                monitor.setMessage("Checking Out " + domainFile.getName());
                if (domainFile.checkout(dialog.exclusiveCheckout(), monitor)) {
                    return;
                }
                Msg.showError((Object)this, null, (String)"Checkout Failed", (Object)("Exclusive checkout failed for: " + domainFile.getName() + "\nOne or more users have file checked out!"));
            }
            catch (CancelledException cancelledException) {
            }
            catch (ExclusiveCheckoutException e) {
                Msg.showError((Object)this, null, (String)"Checkout Failed", (Object)e.getMessage());
            }
            catch (IOException e) {
                Msg.showError((Object)this, null, (String)"Error on Check Out", (Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private Program openFileMaybeUgrade(DomainFile domainFile, TaskMonitor monitor) throws IOException, CancelledException, VersionException {
        Program program;
        block3: {
            boolean recoverFile = false;
            if (!this.silent && domainFile.isInWritableProject() && domainFile.canRecover()) {
                recoverFile = this.askRecoverFile(domainFile.getName());
            }
            program = null;
            try {
                program = (Program)domainFile.getDomainObject(this.consumer, false, recoverFile, monitor);
            }
            catch (VersionException e) {
                if (!VersionExceptionHandler.isUpgradeOK(null, (DomainFile)domainFile, (String)this.openPromptText, (VersionException)e)) break block3;
                program = (Program)domainFile.getDomainObject(this.consumer, true, recoverFile, monitor);
            }
        }
        return program;
    }

    private boolean askRecoverFile(String filename) {
        int option = OptionDialog.showYesNoDialog(null, (String)"Crash Recovery Data Found", (String)("<html>" + HTMLUtilities.escapeHTML((String)filename) + " has crash data.<br>Would you like to recover unsaved changes?"));
        return option == 1;
    }
}

