/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import ghidra.app.nav.Navigatable;
import ghidra.app.services.GoToService;
import ghidra.app.services.QueryData;
import ghidra.app.util.viewer.field.FieldMouseHandlerExtension;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.util.PcodeFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.StringUtilities;
import java.awt.event.MouseEvent;
import java.util.List;

public class PcodeFieldMouseHandler
implements FieldMouseHandlerExtension {
    private static final Class<?>[] SUPPORTED_CLASSES = new Class[]{PcodeFieldLocation.class};

    @Override
    public boolean fieldElementClicked(Object clickedObject, Navigatable sourceNavigatable, ProgramLocation programLocation, MouseEvent mouseEvent, ServiceProvider serviceProvider) {
        if (mouseEvent.getClickCount() != 2 || mouseEvent.getButton() != 1) {
            return false;
        }
        PcodeFieldLocation pcodeLocation = (PcodeFieldLocation)programLocation;
        List pcodeStrings = pcodeLocation.getPcodeStrings();
        int row = pcodeLocation.getRow();
        String pcodeString = (String)pcodeStrings.get(row);
        int column = pcodeLocation.getCharOffset();
        String word = StringUtilities.findWord((String)pcodeString, (int)column);
        return this.checkWord(word, serviceProvider, sourceNavigatable);
    }

    protected boolean checkWord(String wordString, ServiceProvider serviceProvider, Navigatable sourceNavigatable) {
        if (wordString == null) {
            return false;
        }
        ProgramLocation location = sourceNavigatable.getLocation();
        GoToService goToService = (GoToService)serviceProvider.getService(GoToService.class);
        if (goToService == null) {
            return false;
        }
        QueryData queryData = new QueryData(wordString, false);
        return goToService.goToQuery(sourceNavigatable, location.getAddress(), queryData, null, null);
    }

    @Override
    public Class<?>[] getSupportedProgramLocations() {
        return SUPPORTED_CLASSES;
    }
}

