/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import ghidra.app.nav.Navigatable;
import ghidra.app.services.GoToService;
import ghidra.app.services.ProgramManager;
import ghidra.app.services.QueryData;
import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.SymbolPath;
import ghidra.app.util.viewer.field.AnnotatedStringHandler;
import ghidra.app.util.viewer.field.AnnotationException;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.ProjectData;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.project.ProjectDataService;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class ProgramAnnotatedStringHandler
implements AnnotatedStringHandler {
    private static final String INVALID_SYMBOL_TEXT = "@program annotation must have a program name";
    private static final String[] SUPPORTED_ANNOTATIONS = new String[]{"program"};

    @Override
    public AttributedString createAnnotatedString(AttributedString prototypeString, String[] text, Program program) throws AnnotationException {
        if (text.length <= 1) {
            throw new AnnotationException(INVALID_SYMBOL_TEXT);
        }
        String displayText = this.getDisplayText(text);
        if (displayText == null) {
            throw new AnnotationException(INVALID_SYMBOL_TEXT);
        }
        return new AttributedString(displayText, prototypeString.getColor(0), prototypeString.getFontMetrics(0), true, prototypeString.getColor(0));
    }

    private String getDisplayText(String[] text) {
        if (text.length > 2) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 2; i < text.length; ++i) {
                buffer.append(text[i]).append(" ");
            }
            buffer.deleteCharAt(buffer.length() - 1);
            return buffer.toString();
        }
        String symbolText = this.getUnvalidatedDisplayText(text);
        if (symbolText != null) {
            String programName = this.getProgramText(text);
            return programName + "@" + symbolText;
        }
        return text[1];
    }

    private String getUnvalidatedDisplayText(String[] text) {
        SymbolPath symbolPath = this.getSymbolPath(text);
        return symbolPath == null ? null : symbolPath.getName();
    }

    private SymbolPath getSymbolPath(String[] text) {
        String rawText = text[1];
        int atIndex = rawText.indexOf(64);
        if (atIndex < 0) {
            return null;
        }
        rawText = rawText.substring(atIndex + 1);
        return new SymbolPath(rawText);
    }

    private String getProgramText(String[] text) {
        String rawText = text[1];
        int atIndex = rawText.indexOf(64);
        if (atIndex < 0) {
            return rawText;
        }
        return rawText.substring(0, atIndex);
    }

    @Override
    public String[] getSupportedAnnotations() {
        return SUPPORTED_ANNOTATIONS;
    }

    @Override
    public boolean handleMouseClick(String[] annotationParts, Navigatable navigatable, ServiceProvider serviceProvider) {
        ProjectDataService projectDataService = (ProjectDataService)serviceProvider.getService(ProjectDataService.class);
        ProjectData projectData = projectDataService.getProjectData();
        DomainFolder folder = projectData.getRootFolder();
        String programText = this.getProgramText(annotationParts);
        String programName = FilenameUtils.getName((String)programText);
        String path = FilenameUtils.getFullPathNoEndSeparator((String)programText);
        if (path.length() > 0) {
            path = StringUtils.prependIfMissing((String)FilenameUtils.separatorsToUnix((String)path), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            folder = projectData.getFolder(path);
        }
        if (folder == null) {
            Msg.showInfo(this.getClass(), null, (String)("No Folder: " + path), (Object)("Unable to locate folder by the name \"" + path));
            return true;
        }
        DomainFile programFile = this.findProgramByName(programName, folder);
        if (programFile == null) {
            Msg.showInfo(this.getClass(), null, (String)("No Program: " + programName), (Object)("Unable to locate a program by the name \"" + programName + "\".\nNOTE: Program name is case-sensitive. "));
            return true;
        }
        SymbolPath symbolPath = this.getSymbolPath(annotationParts);
        this.navigate(programFile, symbolPath, navigatable, serviceProvider);
        return true;
    }

    private void navigate(DomainFile programFile, SymbolPath symbolPath, Navigatable navigatable, ServiceProvider serviceProvider) {
        GoToService goToService = (GoToService)serviceProvider.getService(GoToService.class);
        if (goToService == null) {
            Msg.showWarn((Object)this, null, (String)"Service Missing", (Object)"This annotation requires the GoToService to be enabled");
            return;
        }
        ProgramManager programManager = (ProgramManager)serviceProvider.getService(ProgramManager.class);
        Program program = programManager.openProgram(programFile, -1, 0);
        if (program == null) {
            return;
        }
        if (symbolPath == null) {
            Address start = program.getMemory().getMinAddress();
            goToService.goTo(navigatable, new ProgramLocation(program, start), program);
            return;
        }
        List symbols = NamespaceUtils.getSymbols((String)symbolPath.getPath(), (Program)program);
        if (this.goToSymbol(symbols, navigatable, program, goToService)) {
            return;
        }
        String symbolName = symbolPath.getName();
        Address address = this.getAddress(symbolName, program);
        if (this.goToAddress(address, program, navigatable, goToService)) {
            return;
        }
        Msg.showInfo(this.getClass(), null, (String)("No Symbol: " + symbolName), (Object)("Unable to navigate to '" + symbolName + "' in the program '" + programFile.getName() + "'.\nMake sure that the given symbol/address exists."));
        if (!programManager.isVisible(program)) {
            programManager.closeProgram(program, true);
        }
    }

    private boolean goToAddress(Address address, Program program, Navigatable navigatable, GoToService goToService) {
        if (address == null) {
            return false;
        }
        return goToService.goTo(navigatable, new ProgramLocation(program, address), program);
    }

    private boolean goToSymbol(List<Symbol> symbols, Navigatable navigatable, Program program, GoToService goToService) {
        if (symbols.isEmpty()) {
            return false;
        }
        Symbol symbol = symbols.get(0);
        if (symbols.size() == 1) {
            return goToService.goTo(navigatable, symbol.getProgramLocation(), program);
        }
        Address addr = navigatable.getLocation().getAddress();
        QueryData data = new QueryData(symbol.getName(), true);
        return goToService.goToQuery(navigatable, addr, data, null, null);
    }

    private Address getAddress(String addressText, Program program) {
        if (addressText == null) {
            return null;
        }
        AddressFactory addressFactory = program.getAddressFactory();
        Address address = addressFactory.getAddress(addressText);
        return address;
    }

    private DomainFile findProgramByName(String programText, DomainFolder folder) {
        DomainFolder[] folders;
        DomainFile[] files;
        for (DomainFile file : files = folder.getFiles()) {
            if (!file.getName().equals(programText)) continue;
            return file;
        }
        for (DomainFolder subFolder : folders = folder.getFolders()) {
            DomainFile domainFile = this.findProgramByName(programText, subFolder);
            if (domainFile == null) continue;
            return domainFile;
        }
        return null;
    }

    @Override
    public String getDisplayString() {
        return "Program";
    }

    @Override
    public String getPrototypeString() {
        return "{@program program_name.exe@symbol_name}";
    }

    @Override
    public String getPrototypeString(String displayText) {
        return "{@program " + displayText.trim() + "}";
    }
}

