/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.DockingActionInputBindingListener;
import docking.KeyEntryPanel;
import docking.MouseEntryTextField;
import docking.widgets.checkbox.GCheckBox;
import gui.event.MouseBinding;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class ActionBindingPanel
extends JPanel {
    private static final String DISABLED_HINT = "Select an action";
    private KeyEntryPanel keyEntryPanel;
    private JCheckBox useMouseBindingCheckBox;
    private MouseEntryTextField mouseEntryField;
    private JPanel textFieldPanel;
    private DockingActionInputBindingListener listener;

    public ActionBindingPanel(DockingActionInputBindingListener listener) {
        this.listener = Objects.requireNonNull(listener);
        this.build();
    }

    private void build() {
        this.setLayout(new BoxLayout(this, 2));
        this.textFieldPanel = new JPanel(new BorderLayout());
        this.keyEntryPanel = new KeyEntryPanel(20, ks -> this.listener.keyStrokeChanged(ks));
        this.keyEntryPanel.setDisabledHint(DISABLED_HINT);
        this.keyEntryPanel.setEnabled(false);
        this.mouseEntryField = new MouseEntryTextField(20, mb -> this.listener.mouseBindingChanged((MouseBinding)mb));
        this.mouseEntryField.setDisabledHint(DISABLED_HINT);
        this.mouseEntryField.setEnabled(false);
        this.textFieldPanel.add((Component)this.keyEntryPanel, "North");
        String checkBoxText = "Enter Mouse Binding";
        this.useMouseBindingCheckBox = new GCheckBox(checkBoxText);
        this.useMouseBindingCheckBox.setToolTipText("When checked, the text field accepts mouse buttons");
        this.useMouseBindingCheckBox.setName(checkBoxText);
        this.useMouseBindingCheckBox.addItemListener(e -> this.updateTextField());
        this.add(this.textFieldPanel);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.useMouseBindingCheckBox);
    }

    private void updateTextField() {
        if (this.useMouseBindingCheckBox.isSelected()) {
            this.textFieldPanel.remove(this.keyEntryPanel);
            this.textFieldPanel.add((Component)this.mouseEntryField, "North");
        } else {
            this.textFieldPanel.remove(this.mouseEntryField);
            this.textFieldPanel.add((Component)this.keyEntryPanel, "North");
        }
        this.validate();
        this.repaint();
    }

    public void setKeyBindingData(KeyStroke ks, MouseBinding mb) {
        this.keyEntryPanel.setKeyStroke(ks);
        this.mouseEntryField.setMouseBinding(mb);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.keyEntryPanel.clearField();
        this.mouseEntryField.clearField();
        this.keyEntryPanel.setEnabled(enabled);
        this.mouseEntryField.setEnabled(enabled);
    }

    public void clearKeyStroke() {
        this.keyEntryPanel.clearField();
    }

    public KeyStroke getKeyStroke() {
        return this.keyEntryPanel.getKeyStroke();
    }

    public MouseBinding getMouseBinding() {
        return this.mouseEntryField.getMouseBinding();
    }

    public void clearMouseBinding() {
        this.mouseEntryField.clearField();
    }

    public boolean isMouseBinding() {
        return this.useMouseBindingCheckBox.isSelected();
    }
}

