/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.DockingActionProxy;
import docking.DockingWindowManager;
import docking.WindowNode;
import docking.action.DockingActionIf;
import docking.menu.MenuBarManager;
import docking.menu.MenuGroupMap;
import docking.menu.MenuHandler;
import docking.menu.ToolBarManager;
import generic.concurrent.ReentryGuard;
import ghidra.util.Msg;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuBar;

public class WindowActionManager {
    private Map<DockingActionIf, DockingActionProxy> actionToProxyMap;
    private MenuBarManager menuBarMgr;
    private ToolBarManager toolBarMgr;
    private final WindowNode node;
    private boolean disposed;
    private ReentryGuard<Throwable> reentryGuard = new ReentryGuard<Throwable>(){

        protected Throwable violated(boolean nested, Throwable previous) {
            if (previous != null) {
                return previous;
            }
            Throwable t = new Throwable();
            Msg.error((Object)WindowActionManager.this, (Object)"Modified action list during context change update", (Throwable)t);
            return t;
        }
    };

    WindowActionManager(WindowNode node, MenuHandler menuBarHandler, DockingWindowManager winMgr, MenuGroupMap menuGroupMap) {
        this.node = node;
        this.actionToProxyMap = new HashMap<DockingActionIf, DockingActionProxy>();
        this.menuBarMgr = new MenuBarManager(menuBarHandler, menuGroupMap);
        this.toolBarMgr = new ToolBarManager(winMgr);
    }

    void setActions(List<DockingActionIf> actionList) {
        this.reentryGuard.checkAccess();
        this.menuBarMgr.clearActions();
        this.toolBarMgr.clearActions();
        this.actionToProxyMap.clear();
        for (DockingActionIf action : actionList) {
            this.addAction(action);
        }
    }

    void addAction(DockingActionIf action) {
        this.reentryGuard.checkAccess();
        if (action.getMenuBarData() != null || action.getToolBarData() != null) {
            DockingActionProxy proxyAction = new DockingActionProxy(action);
            this.actionToProxyMap.put(action, proxyAction);
            this.menuBarMgr.addAction(proxyAction);
            this.toolBarMgr.addAction(proxyAction);
        }
    }

    void removeAction(DockingActionIf action) {
        this.reentryGuard.checkAccess();
        DockingActionProxy proxyAction = this.actionToProxyMap.remove(action);
        if (proxyAction != null) {
            this.menuBarMgr.removeAction(proxyAction);
            this.toolBarMgr.removeAction(proxyAction);
        }
    }

    DockingActionIf getToolbarAction(String actionName) {
        return this.toolBarMgr.getAction(actionName);
    }

    void update() {
        JMenuBar menuBar = this.menuBarMgr.getMenuBar();
        if (menuBar.getMenuCount() > 0) {
            this.node.setMenuBar(menuBar);
        }
        this.node.setToolBar(this.toolBarMgr.getToolBar());
        this.node.validate();
    }

    void dispose() {
        this.reentryGuard.checkAccess();
        this.disposed = true;
        this.node.setToolBar(null);
        this.node.setMenuBar(null);
        this.actionToProxyMap.clear();
        this.menuBarMgr.dispose();
        this.toolBarMgr.dispose();
    }

    void contextChanged(Map<Class<? extends ActionContext>, ActionContext> defaultContextMap, ActionContext localContext, Set<DockingActionIf> excluded) {
        try (ReentryGuard.Guarded guarded = this.reentryGuard.enter();){
            if (!this.node.isVisible() || this.disposed) {
                return;
            }
            for (Map.Entry<DockingActionIf, DockingActionProxy> ent : this.actionToProxyMap.entrySet()) {
                DockingActionIf action = ent.getKey();
                DockingActionIf proxyAction = ent.getValue();
                if (excluded.contains(action)) continue;
                ActionContext context = this.getContextForAction(action, localContext, defaultContextMap);
                boolean enabled = context == null ? false : proxyAction.isEnabledForContext(context);
                proxyAction.setEnabled(enabled);
                if (!this.reentryGuard.isViolated()) continue;
                break;
            }
        }
    }

    private ActionContext getContextForAction(DockingActionIf action, ActionContext localContext, Map<Class<? extends ActionContext>, ActionContext> defaultContextMap) {
        ActionContext context;
        if (action.isValidContext(localContext)) {
            return localContext;
        }
        if (action.supportsDefaultContext() && (context = defaultContextMap.get(action.getContextClass())) != null && action.isValidContext(context)) {
            return context;
        }
        return null;
    }

    Set<DockingActionIf> getOriginalActions() {
        return new HashSet<DockingActionIf>(this.actionToProxyMap.keySet());
    }
}

