/*
 * Decompiled with CFR 0.152.
 */
package docking.action;

import docking.ComponentProvider;
import docking.DockingKeyBindingAction;
import docking.DockingMouseBindingAction;
import docking.Tool;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MultipleKeyAction;
import docking.action.SystemKeyBindingAction;
import docking.actions.KeyBindingUtils;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import gui.event.MouseBinding;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Action;
import javax.swing.KeyStroke;

public class KeyBindingsManager
implements PropertyChangeListener {
    private Map<DockingActionIf, ComponentProvider> actionToProviderMap = new HashMap<DockingActionIf, ComponentProvider>();
    private Map<KeyStroke, DockingKeyBindingAction> dockingKeyMap = new HashMap<KeyStroke, DockingKeyBindingAction>();
    private Map<MouseBinding, DockingMouseBindingAction> dockingMouseMap = new HashMap<MouseBinding, DockingMouseBindingAction>();
    private Map<String, DockingActionIf> systemActionsByFullName = new HashMap<String, DockingActionIf>();
    private Tool tool;

    public KeyBindingsManager(Tool tool) {
        this.tool = tool;
    }

    public void addAction(ComponentProvider optionalProvider, DockingActionIf action) {
        MouseBinding mouseBinding;
        KeyBindingData kbData;
        action.addPropertyChangeListener(this);
        if (optionalProvider != null) {
            this.actionToProviderMap.put(action, optionalProvider);
        }
        if ((kbData = action.getKeyBindingData()) == null) {
            return;
        }
        KeyStroke keyBinding = kbData.getKeyBinding();
        if (keyBinding != null) {
            this.addKeyBinding(optionalProvider, action, keyBinding);
        }
        if ((mouseBinding = kbData.getMouseBinding()) != null) {
            this.doAddMouseBinding(action, mouseBinding);
        }
    }

    public void addSystemAction(DockingActionIf action) {
        KeyStroke keyStroke = action.getKeyBinding();
        Objects.requireNonNull(keyStroke);
        DockingKeyBindingAction existingAction = this.dockingKeyMap.get(keyStroke);
        if (existingAction != null) {
            throw new AssertException("Attempting to add more than one reserved action to a given keystroke: " + String.valueOf(keyStroke));
        }
        this.addSystemKeyBinding(action, keyStroke);
        action.addPropertyChangeListener(this);
    }

    public void removeAction(DockingActionIf action) {
        action.removePropertyChangeListener(this);
        this.actionToProviderMap.remove(action);
        this.removeKeyBinding(action.getKeyBinding(), action);
    }

    private void addKeyBinding(ComponentProvider provider, DockingActionIf action, KeyStroke keyStroke) {
        String errorMessage = this.validateActionKeyBinding(action, keyStroke);
        if (errorMessage != null) {
            Msg.error((Object)this, (Object)errorMessage);
            return;
        }
        this.doAddKeyBinding(provider, action, keyStroke);
        this.fixupAltGraphKeyStrokeMapping(provider, action, keyStroke);
    }

    public String validateActionKeyBinding(DockingActionIf dockingAction, KeyStroke ks) {
        if (ks == null) {
            return null;
        }
        Action existingAction = this.dockingKeyMap.get(ks);
        if (existingAction instanceof SystemKeyBindingAction) {
            SystemKeyBindingAction systemAction = (SystemKeyBindingAction)existingAction;
            DockingActionIf systemDockingAction = systemAction.getAction();
            if (dockingAction == systemDockingAction) {
                return null;
            }
            String ksString = KeyBindingUtils.parseKeyStroke(ks);
            return ksString + " in use by System action '" + systemDockingAction.getName() + "'";
        }
        if (dockingAction == null) {
            return null;
        }
        boolean hasSystemAction = this.systemActionsByFullName.containsKey(dockingAction.getFullName());
        if (hasSystemAction && existingAction != null) {
            return "System action cannot be set to in-use key stroke";
        }
        return null;
    }

    private void fixupAltGraphKeyStrokeMapping(ComponentProvider provider, DockingActionIf action, KeyStroke keyStroke) {
        int modifiers = keyStroke.getModifiers();
        if ((modifiers & 0x200) == 512) {
            KeyStroke updateKeyStroke = KeyStroke.getKeyStroke(keyStroke.getKeyCode(), modifiers |= 0x2000, false);
            this.doAddKeyBinding(provider, action, updateKeyStroke, keyStroke);
        }
    }

    private void doAddKeyBinding(ComponentProvider provider, DockingActionIf action, KeyStroke keyStroke) {
        this.doAddKeyBinding(provider, action, keyStroke, keyStroke);
    }

    private void doAddKeyBinding(ComponentProvider provider, DockingActionIf action, KeyStroke mappingKeyStroke, KeyStroke actionKeyStroke) {
        DockingKeyBindingAction existingAction = this.dockingKeyMap.get(mappingKeyStroke);
        if (existingAction instanceof MultipleKeyAction) {
            MultipleKeyAction multipleKeyction = (MultipleKeyAction)existingAction;
            multipleKeyction.addAction(provider, action);
            return;
        }
        if (existingAction instanceof SystemKeyBindingAction) {
            Msg.error((Object)this, (Object)("Attempted to use the same keybinding for an existing System action: " + String.valueOf(existingAction) + ".  Keystroke: " + String.valueOf(mappingKeyStroke)));
            return;
        }
        if (this.systemActionsByFullName.containsKey(action.getFullName())) {
            this.registerSystemKeyBinding(action, mappingKeyStroke);
            return;
        }
        this.dockingKeyMap.put(mappingKeyStroke, new MultipleKeyAction(this.tool, provider, action, actionKeyStroke));
    }

    private void doAddMouseBinding(DockingActionIf action, MouseBinding mouseBinding) {
        DockingMouseBindingAction mouseBindingAction = this.dockingMouseMap.get(mouseBinding);
        if (mouseBindingAction != null) {
            String existingName = mouseBindingAction.getFullActionName();
            String message = "Attempted to use the same mouse binding for multiple actions. Multiple mouse bindings are not supported. Binding: %s New action: %s; existing action: %s\n".formatted(mouseBinding, action.getFullName(), existingName);
            Msg.error((Object)this, (Object)message);
            return;
        }
        this.dockingMouseMap.put(mouseBinding, new DockingMouseBindingAction(action, mouseBinding));
    }

    private void addSystemKeyBinding(DockingActionIf action, KeyStroke keyStroke) {
        KeyBindingData binding = KeyBindingData.createSystemKeyBindingData(keyStroke);
        action.setKeyBindingData(binding);
        this.registerSystemKeyBinding(action, keyStroke);
    }

    private void registerSystemKeyBinding(DockingActionIf action, KeyStroke keyStroke) {
        SystemKeyBindingAction systemAction = new SystemKeyBindingAction(this.tool, action, keyStroke);
        this.dockingKeyMap.put(keyStroke, systemAction);
        this.systemActionsByFullName.put(action.getFullName(), action);
    }

    private void removeKeyBinding(KeyStroke keyStroke, DockingActionIf action) {
        if (keyStroke == null) {
            return;
        }
        DockingKeyBindingAction existingAction = this.dockingKeyMap.get(keyStroke);
        if (existingAction == null) {
            return;
        }
        if (existingAction instanceof SystemKeyBindingAction) {
            this.dockingKeyMap.remove(keyStroke);
        } else if (existingAction instanceof MultipleKeyAction) {
            MultipleKeyAction mkAction = (MultipleKeyAction)existingAction;
            mkAction.removeAction(action);
            if (mkAction.isEmpty()) {
                this.dockingKeyMap.remove(keyStroke);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        KeyStroke ks;
        KeyBindingData newKeyData;
        KeyStroke ks2;
        String name = evt.getPropertyName();
        DockingActionIf action = (DockingActionIf)evt.getSource();
        if (!name.equals("KeyBindings")) {
            return;
        }
        KeyBindingData keyData = (KeyBindingData)evt.getOldValue();
        if (keyData != null && (ks2 = keyData.getKeyBinding()) != null) {
            this.removeKeyBinding(ks2, action);
        }
        if ((newKeyData = (KeyBindingData)evt.getNewValue()) != null && (ks = newKeyData.getKeyBinding()) != null) {
            this.addKeyBinding(this.actionToProviderMap.get(action), action, ks);
        }
    }

    public Action getDockingAction(KeyStroke keyStroke) {
        return this.dockingKeyMap.get(keyStroke);
    }

    public Action getDockingAction(MouseBinding mouseBinding) {
        return this.dockingMouseMap.get(mouseBinding);
    }

    public boolean isSystemAction(DockingActionIf action) {
        return this.systemActionsByFullName.containsKey(action.getFullName());
    }

    public DockingActionIf getSystemAction(String fullName) {
        return this.systemActionsByFullName.get(fullName);
    }

    public Set<DockingActionIf> getSystemActions() {
        return new HashSet<DockingActionIf>(this.systemActionsByFullName.values());
    }

    public void dispose() {
        this.dockingKeyMap.clear();
        this.dockingMouseMap.clear();
        this.actionToProviderMap.clear();
        this.systemActionsByFullName.clear();
    }
}

