/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constraint;

import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.ColumnData;
import docking.widgets.table.constraint.ColumnTypeMapper;
import docking.widgets.table.constraint.TableFilterContext;
import docking.widgets.table.constrainteditor.ColumnConstraintEditor;
import docking.widgets.table.constrainteditor.MappedColumnConstraintEditor;
import generic.json.Json;
import ghidra.util.SystemUtilities;

public class MappedColumnConstraint<T, M>
implements ColumnConstraint<T> {
    private ColumnTypeMapper<T, M> mapper;
    private ColumnConstraint<M> delegate;

    public MappedColumnConstraint(ColumnTypeMapper<T, M> mapper, ColumnConstraint<M> delegate) {
        this.mapper = mapper;
        this.delegate = delegate;
    }

    @Override
    public boolean accepts(T value, TableFilterContext context) {
        M mappedValue = this.mapper.convert(value);
        return this.delegate.accepts(mappedValue, context);
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public Class<T> getColumnType() {
        return this.mapper.getSourceType();
    }

    @Override
    public ColumnConstraintEditor<T> getEditor(ColumnData<T> columnDataSource) {
        DelegateColumnData delegateSource = new DelegateColumnData(columnDataSource);
        ColumnConstraintEditor<M> delegateEditor = this.delegate.getEditor(delegateSource);
        return new MappedColumnConstraintEditor(this, delegateEditor);
    }

    @Override
    public String getGroup() {
        return this.delegate.getGroup();
    }

    @Override
    public String getConstraintValueString() {
        return this.delegate.getConstraintValueString();
    }

    @Override
    public ColumnConstraint<T> parseConstraintValue(String valueString, Object dataSource) {
        ColumnConstraint<M> newConstraint = this.delegate.parseConstraintValue(valueString, dataSource);
        return this.copy(newConstraint);
    }

    public ColumnConstraint<T> copy(ColumnConstraint<M> newDelegate) {
        return new MappedColumnConstraint<T, M>(this.mapper, newDelegate);
    }

    public ColumnConstraint<M> getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return Json.toString((Object)this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        result = 31 * result + (this.mapper == null ? 0 : this.mapper.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MappedColumnConstraint other = (MappedColumnConstraint)obj;
        if (!SystemUtilities.isEqual(this.delegate, other.delegate)) {
            return false;
        }
        return this.mapper.equals(other.mapper);
    }

    protected class DelegateColumnData
    implements ColumnData<M> {
        private ColumnData<T> columnDataSource;

        public DelegateColumnData(ColumnData<T> columnDataSource) {
            this.columnDataSource = columnDataSource;
        }

        @Override
        public String getColumnName() {
            return this.columnDataSource.getColumnName();
        }

        @Override
        public int getCount() {
            return this.columnDataSource.getCount();
        }

        @Override
        public M getColumnValue(int row) {
            return MappedColumnConstraint.this.mapper.convert(this.columnDataSource.getColumnValue(row));
        }

        @Override
        public Object getTableDataSource() {
            return this.columnDataSource.getTableDataSource();
        }
    }
}

