/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.diff;

import ghidra.app.plugin.core.diff.DiffApplySettingsProvider;
import ghidra.app.plugin.core.diff.DiffController;
import ghidra.app.plugin.core.diff.ProgramDiffPlugin;
import ghidra.framework.model.DomainObjectException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramConflictException;
import ghidra.program.util.ProgramDiffFilter;
import ghidra.program.util.ProgramMemoryComparator;
import ghidra.program.util.ProgramMergeFilter;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.ClosedException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import javax.swing.SwingUtilities;

class CreateDiffTask
extends Task {
    private ProgramDiffPlugin plugin;
    private Program program1;
    private Program program2;
    private AddressSetView limitedAddressSet;
    private ProgramDiffFilter diffFilter;
    private ProgramMergeFilter applyFilter;
    private DiffApplySettingsProvider diffApplySettingsProvider;
    private boolean isLimitedToSelection;

    CreateDiffTask(ProgramDiffPlugin plugin, Program program1, Program program2, AddressSetView limitedAddressSet, boolean isLimitedToSelection, ProgramDiffFilter diffFilter, ProgramMergeFilter applyFilter) {
        super("Checking Program Differences", true, false, true);
        this.plugin = plugin;
        this.program1 = program1;
        this.program2 = program2;
        this.limitedAddressSet = limitedAddressSet;
        this.isLimitedToSelection = isLimitedToSelection;
        this.diffFilter = diffFilter;
        this.applyFilter = applyFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor) {
        block10: {
            if (this.plugin.isTaskInProgress()) {
                return;
            }
            try {
                DiffController dc = null;
                this.plugin.setTaskInProgress(true);
                monitor.setIndeterminate(true);
                monitor.setMessage("Checking Program Differences");
                try {
                    dc = new DiffController(this.program1, this.program2, this.limitedAddressSet, this.diffFilter, this.applyFilter);
                    AddressSetView filteredDifferences = dc.getFilteredDifferences(monitor);
                    boolean noFilteredDifferencesFound = filteredDifferences.isEmpty();
                    this.plugin.setDiffController(dc);
                    dc.differencesChanged();
                    dc.setLocation(this.plugin.getCurrentAddress());
                    monitor.setMessage("Done");
                    Runnable r = () -> this.displayDifferencesMessageIfNecessary(noFilteredDifferencesFound);
                    SwingUtilities.invokeLater(r);
                }
                catch (DomainObjectException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof ClosedException) {
                        break block10;
                    }
                    throw e;
                }
                catch (ProgramConflictException e) {
                    this.showErrorMessage(e.getMessage());
                    this.completed();
                    return;
                }
                catch (CancelledException e) {
                    this.plugin.setDiffController(dc);
                }
            }
            finally {
                this.completed();
            }
        }
    }

    private void displayDifferencesMessageIfNecessary(boolean noFilteredDifferencesFound) {
        try {
            ProgramMemoryComparator programMemoryComparator = new ProgramMemoryComparator(this.program1, this.program2);
            boolean hasMemoryDifferences = programMemoryComparator.hasMemoryDifferences();
            String title = null;
            String message = null;
            if (this.isLimitedToSelection) {
                if (noFilteredDifferencesFound) {
                    title = "No Differences In Selection";
                    message = "No differences were found for the addresses in the selection\nand for the types of program information being compared by this Diff.";
                }
            } else if (hasMemoryDifferences) {
                title = "Memory Differs";
                message = this.getMemoryDifferenceMessage(noFilteredDifferencesFound, programMemoryComparator);
            } else if (noFilteredDifferencesFound) {
                title = "No Differences";
                message = "No differences were found for the addresses that are compatible between the two\nprograms for the types of program information being compared by this Diff.";
            }
            if (title != null) {
                String note = "\n \nNote: Some parts of the program are not handled by Diff (for example:\n         Markup where only one program has that memory address,\n         Registers that are not common to both programs' languages,\n         Program Trees, Data Types that haven't been applied to memory, etc.)";
                Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.plugin.getListingPanel(), (String)title, (Object)(message + note));
            }
        }
        catch (ProgramConflictException e) {
            Msg.showError(((Object)((Object)this)).getClass(), (Component)this.plugin.getListingPanel(), (String)"Can't Compare Memory", (Object)("Diff can't compare the two programs memory. " + e.getMessage()));
            return;
        }
    }

    private String getMemoryDifferenceMessage(boolean noFilteredDifferencesFound, ProgramMemoryComparator programMemoryComparator) {
        AddressSet addressesOnlyInTwo;
        String message = "The memory addresses defined by the two programs are not the same.\n \n" + (noFilteredDifferencesFound ? "However, no differences were found " : "Differences are highlighted ") + "for the addresses that are compatible between\nthe two programs for the types of program information being compared by this Diff.";
        AddressSet addressesOnlyInOne = programMemoryComparator.getAddressesOnlyInOne();
        if (!addressesOnlyInOne.isEmpty()) {
            message = message + "\n \nSome addresses are only in program 1 : " + addressesOnlyInOne.toString();
        }
        if (!(addressesOnlyInTwo = programMemoryComparator.getAddressesOnlyInTwo()).isEmpty()) {
            message = message + "\n \nSome addresses are only in program 2 : " + addressesOnlyInTwo.toString();
        }
        return message;
    }

    private void showErrorMessage(String message) {
        SystemUtilities.runSwingLater(() -> Msg.showError(((Object)((Object)this)).getClass(), (Component)this.plugin.getTool().getToolFrame(), (String)"Can't Perform Diff", (Object)message));
    }

    private void completed() {
        if (this.plugin.isDisposed()) {
            return;
        }
        if (this.plugin.getCurrentProgram() == null || this.plugin.getSecondProgram() == null) {
            return;
        }
        SystemUtilities.runSwingLater(() -> {
            this.diffApplySettingsProvider = this.plugin.getDiffApplySettingsProvider();
            this.diffApplySettingsProvider.configure(this.applyFilter);
            this.plugin.adjustDiffDisplay();
        });
        this.plugin.setTaskInProgress(false);
    }
}

