/*
 * Decompiled with CFR 0.152.
 */
package help.validator.model;

import ghidra.util.exception.AssertException;
import help.HelpBuildUtils;
import help.PathKey;
import help.validator.AnchorManager;
import help.validator.HTMLFileParser;
import help.validator.ReferenceTagProcessor;
import help.validator.TagProcessor;
import help.validator.location.HelpModuleLocation;
import help.validator.model.AnchorDefinition;
import help.validator.model.HREF;
import help.validator.model.IMG;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class HelpFile {
    private final Path helpFile;
    private final HelpModuleLocation help;
    private final Path relativePath;
    private AnchorManager anchorManager;

    HelpFile(HelpModuleLocation help, Path file) {
        this.help = help;
        this.helpFile = file;
        this.anchorManager = new AnchorManager();
        this.relativePath = HelpBuildUtils.relativizeWithHelpTopics(file);
        this.cleanupHelpFile();
        this.parseLinks();
    }

    private void cleanupHelpFile() {
        try {
            HelpBuildUtils.cleanupHelpFileLinks(this.helpFile);
        }
        catch (IOException e) {
            System.err.println("Unexpected exception fixing help file links: " + e.getMessage());
            e.printStackTrace();
        }
    }

    Collection<HREF> getAllHREFs() {
        return this.anchorManager.getAnchorRefs();
    }

    Collection<IMG> getAllIMGs() {
        return this.anchorManager.getImageRefs();
    }

    public Path getRelativePath() {
        return this.relativePath;
    }

    public boolean containsAnchor(String anchorName) {
        AnchorDefinition anchor = this.anchorManager.getAnchorForName(anchorName);
        return anchor != null;
    }

    public Map<String, List<AnchorDefinition>> getDuplicateAnchorsByID() {
        return this.anchorManager.getDuplicateAnchorsByID();
    }

    public AnchorDefinition getAnchorDefinition(Path helpPath) {
        Map<PathKey, AnchorDefinition> anchorsByHelpPath = this.anchorManager.getAnchorsByHelpPath();
        AnchorDefinition def = anchorsByHelpPath.get(new PathKey(helpPath));
        return def;
    }

    public Collection<AnchorDefinition> getAllAnchorDefinitions() {
        return this.anchorManager.getAnchorsByHelpPath().values();
    }

    public Path getFile() {
        return this.helpFile;
    }

    public String toString() {
        return this.helpFile.toUri().toString();
    }

    private void parseLinks() {
        ReferenceTagProcessor tagProcessor = new ReferenceTagProcessor(this.help, this.anchorManager);
        HelpFile.processHelpFile(this.helpFile, this.anchorManager, tagProcessor);
        if (tagProcessor.getErrorCount() > 0) {
            String errorText = tagProcessor.getErrorText();
            throw new AssertException("Errors parsing HTML file: " + String.valueOf(this.helpFile.getFileName()) + "\n" + errorText);
        }
    }

    private static void processHelpFile(Path file, AnchorManager anchorManager, TagProcessor tagProcessor) {
        String fname = file.getFileName().toString().toLowerCase();
        if (fname.endsWith(".htm") || fname.endsWith(".html")) {
            try {
                anchorManager.addAnchor(file, null, -1);
                HTMLFileParser.scanHtmlFile(file, tagProcessor);
            }
            catch (IOException e) {
                System.err.println("Exception parsing file: " + String.valueOf(file.toUri()) + "\n");
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
        } else {
            throw new RuntimeException("Internal error");
        }
    }
}

