/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class DebugHeader {
    private long headerVersion;
    private long headerLength;
    private long dataLength;

    public long getHeaderVersion() {
        return this.headerVersion;
    }

    public long getHeaderLength() {
        return this.headerLength;
    }

    public long getDataLength() {
        return this.dataLength;
    }

    public void deserialize(PdbByteReader reader) throws PdbException {
        this.headerVersion = reader.parseUnsignedIntVal();
        this.headerLength = reader.parseUnsignedIntVal();
        this.dataLength = reader.parseUnsignedIntVal();
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            this.dump(writer);
            return writer.toString();
        }
        catch (IOException e) {
            return "Issue in " + this.getClass().getSimpleName() + " toString(): " + e.getMessage();
        }
    }

    void dump(Writer writer) throws IOException {
        PdbReaderUtils.dumpHead(writer, this);
        this.dumpInternal(writer);
        PdbReaderUtils.dumpTail(writer, this);
    }

    protected void dumpInternal(Writer writer) throws IOException {
        writer.write(String.format("headerVersion: 0X%08X\n", this.headerVersion));
        writer.write(String.format("headerLength: 0X%08X\n", this.headerLength));
        writer.write(String.format("dataLength: 0X%08X\n", this.dataLength));
    }
}

