/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.emulation;

import generic.ULongSpan;
import ghidra.app.plugin.core.debug.service.emulation.AbstractRWTargetPcodeExecutorStatePiece;
import ghidra.app.plugin.core.debug.service.emulation.Mode;
import ghidra.debug.api.emulation.PcodeDebuggerDataAccess;
import ghidra.debug.api.emulation.PcodeDebuggerMemoryAccess;
import ghidra.generic.util.datastruct.SemisparseByteArray;
import ghidra.pcode.exec.AbstractLongOffsetPcodeExecutorStatePiece;
import ghidra.pcode.exec.trace.BytesTracePcodeExecutorStatePiece;
import ghidra.pcode.exec.trace.data.PcodeTraceDataAccess;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import java.util.Map;

public class RWTargetMemoryPcodeExecutorStatePiece
extends AbstractRWTargetPcodeExecutorStatePiece {
    private final Mode mode;

    public RWTargetMemoryPcodeExecutorStatePiece(PcodeDebuggerMemoryAccess data, Mode mode) {
        super((PcodeDebuggerDataAccess)data);
        this.mode = mode;
    }

    protected AbstractLongOffsetPcodeExecutorStatePiece.AbstractSpaceMap<BytesTracePcodeExecutorStatePiece.CachedSpace> newSpaceMap() {
        return new WRTargetMemorySpaceMap();
    }

    class WRTargetMemorySpaceMap
    extends AbstractRWTargetPcodeExecutorStatePiece.TargetBackedSpaceMap {
        public WRTargetMemorySpaceMap() {
        }

        protected WRTargetMemorySpaceMap(Map<AddressSpace, BytesTracePcodeExecutorStatePiece.CachedSpace> spaceMap) {
            super(spaceMap);
        }

        public AbstractLongOffsetPcodeExecutorStatePiece.AbstractSpaceMap<BytesTracePcodeExecutorStatePiece.CachedSpace> fork() {
            return new WRTargetMemorySpaceMap((Map<AddressSpace, BytesTracePcodeExecutorStatePiece.CachedSpace>)this.fork(this.spaces));
        }

        protected BytesTracePcodeExecutorStatePiece.CachedSpace newSpace(AddressSpace space, PcodeDebuggerDataAccess data) {
            return new RWTargetMemoryCachedSpace(RWTargetMemoryPcodeExecutorStatePiece.this.language, space, (PcodeDebuggerMemoryAccess)data);
        }
    }

    protected class RWTargetMemoryCachedSpace
    extends AbstractRWTargetPcodeExecutorStatePiece.AbstractRWTargetCachedSpace {
        protected final PcodeDebuggerMemoryAccess backing;

        public RWTargetMemoryCachedSpace(Language language, AddressSpace space, PcodeDebuggerMemoryAccess backing) {
            super(RWTargetMemoryPcodeExecutorStatePiece.this, language, space, (PcodeDebuggerDataAccess)backing);
            this.backing = backing;
        }

        protected RWTargetMemoryCachedSpace(Language language, AddressSpace space, PcodeDebuggerMemoryAccess backing, SemisparseByteArray bytes, AddressSet written) {
            super(RWTargetMemoryPcodeExecutorStatePiece.this, language, space, (PcodeTraceDataAccess)backing, bytes, written);
            this.backing = backing;
        }

        public RWTargetMemoryCachedSpace fork() {
            return new RWTargetMemoryCachedSpace(this.language, this.space, this.backing, this.bytes.fork(), new AddressSet((AddressSetView)this.written));
        }

        @Override
        protected ULongSpan.ULongSpanSet readUninitializedFromTarget(ULongSpan.ULongSpanSet uninitialized) {
            if (this.space.isUniqueSpace()) {
                return uninitialized;
            }
            AddressSet addrsUninit = this.addrSet(uninitialized);
            AddressSetView unknown = this.backing.intersectUnknown((AddressSetView)addrsUninit);
            if (unknown.isEmpty()) {
                return uninitialized;
            }
            if (this.backing.isLive() && ((Boolean)this.waitTimeout(this.backing.readFromTargetMemory(unknown))).booleanValue() && (unknown = this.backing.intersectUnknown((AddressSetView)addrsUninit)).isEmpty()) {
                return uninitialized;
            }
            if (this.backing.readFromStaticImages(this.bytes, unknown)) {
                ULongSpan bound = (ULongSpan)uninitialized.bound();
                return this.bytes.getUninitialized(((Long)bound.min()).longValue(), ((Long)bound.max()).longValue());
            }
            return uninitialized;
        }

        public void write(long offset, byte[] val, int srcOffset, int length) {
            if (RWTargetMemoryPcodeExecutorStatePiece.this.mode.isWriteTarget() && !this.space.isUniqueSpace() && ((Boolean)this.waitTimeout(this.backing.writeTargetMemory(this.space.getAddress(offset), val))).booleanValue()) {
                return;
            }
            super.write(offset, val, srcOffset, length);
        }
    }
}

